/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WNNCONVERSION_H
#define WNNCONVERSION_H


#include <cstdio>
#include <cstdlib>
#include <vector>
#include <wnnproto.h>
#define Uses_SCIM_ICONV
#include <scim.h>
#include <scim_iconv.h>
#include <scim_attribute.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



using namespace scim;
using namespace std;


/**
@author TAM(Teppei Tamra)
*/
enum KouhoType { DEFAULT, IKEIJI, RENSOU, YOSOKU };
enum JServerType { Wnn4, Wnn6, Wnn7, Wnn8 };

class WnnConversionList{
public:
    WideString Yomi;
    int pos;
    int count;
    KouhoType kType;
    vector<WideString> kouho;
};


class WnnConversion{
public:
    WnnConversion();

    ~WnnConversion();
    bool isConnected();
    void reset();
    void setYomiText(WideString yomi);
    int ren_conversion();
    WideString getText();
    int setPos(int p);
    int getPos();
    WnnConversionList getConversionList(int p = -1 ,KouhoType kt = DEFAULT);
    WnnConversionList getYosokuList(const WideString &str);
    bool select(int p);
    AttributeList getAttributeList();
    bool resizeRegion(int w);
    void updateFrequency();
    bool wnnConnect(String name,String host,String rc,JServerType type,int timeout);
    void wnnDisconnect();
    int getCaretPos();

protected:
    void wstostr(unsigned char *e,w_char *u);
    void strtows(w_char *u,unsigned char *e);
    static int wnn_message (char *s);
    static int wnn_error (char *s);
    void createText();

protected:
    struct wnn_buf *wnn;
    String wnn_server;
    String wnn_rc;
    JServerType sType;
    int wnn_timeout;
    IConvert m_iconv;
    WideString yomiText;
    int pos;
    int bunsetu;
    int caretPos;
    WideString text;
    vector<WideString> bunList;
    vector<WideString> yomiList;
    AttributeList attr;
    WnnConversionList convList;

};

#endif
