/***************************************************************************
 *   Copyright (C) 2005 by TAM (Teppei Tamra)                              *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

  #define _(String) QString(i18n(String)).local8Bit().data()

#define Uses_SCIM_CONFIG_MODULE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_GLOBAL_CONFIG


#include <scim.h>
#include <scim_global_config.h>

using namespace scim;

class scimConfigPrivate {
public:
    scim::ConfigModule configModule;
    scim::ConfigPointer config;
};

#include <qlayout.h>

#include <klocale.h>
#include <kglobal.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <kparts/genericfactory.h>
#include <klocale.h>

#include "skim_scim_wnn.h"
#include <skim_scim_wnn_items.h>
#include "scim_wnn_def.h"

using namespace SkimScimWnnItems;


static SkimScimWnn *_setup;

typedef KGenericFactory<skim_scim_wnn, QWidget> skim_scim_wnnFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_skim_scim_wnn, skim_scim_wnnFactory("skim_scim_wnn"))

skim_scim_wnn::skim_scim_wnn(QWidget *parent, const char *name, const QStringList&)
    : KCModule(parent, name), myAboutData(0)
{
    KGlobal::locale()->insertCatalogue("skim-scim-wnn");
//    scim::String mod = scim::scim_global_config_read(scim::String("/DefaultConfigModule"),scim::String("simple"));
//    config.configModule.load(mod);
//    config.config = config.configModule.create_config();
    
    QGridLayout *grid = new QGridLayout(this,0,0,4);
    SkimScimWnn *setup = new SkimScimWnn("setup","","");
    SkimScimWnnPage *page;
    std::vector<scim::String> l;
    
    
    //
    // general setting 
    //
    
    page = new SkimScimWnnPage(_("Options"),"","");
    
    page->append(new SkimScimWnnEntryItem(
        _("_Server: "),
        SCIM_CONFIG_WNN_SERVER,
        _("input the server name to connect."),
        SCIM_DEFAULT_WNN_SERVER
    ));
    page->append(new SkimScimWnnFileItem(
        _("_wnnenvrc: "),
        SCIM_CONFIG_WNN_RC,
        _("input the path of wnnenvrc."),
        SCIM_DEFAULT_WNN_RC
    ));
    l.clear();
    l.push_back(String("Wnn4"));
    l.push_back(String("Wnn6"));
    l.push_back(String("Wnn7"));
    l.push_back(String("Wnn8"));
    page->append(new SkimScimWnnSelectItem(
        _("Server_type: "),
        SCIM_CONFIG_WNN_SERVERTYPE,
        _("select the server type from Wnn4 / Wnn6 / Wnn7."),
        SCIM_DEFAULT_WNN_SERVERTYPE,
        l
    ));
    l.clear();
    l.push_back(String("Romkan"));
    l.push_back(String("KanaInput"));
    page->append(new SkimScimWnnSelectItem(
        _("Default_PreEditor: "),
        SCIM_CONFIG_WNN_DEFAULT_PREEDITOR,
        _("select the default preeditor."),
        SCIM_DEFAULT_WNN_DEFAULT_PREEDITOR,
        l
    ));
    page->append(new SkimScimWnnIntItem(
        _("_Auto candidates popup: "),
        SCIM_CONFIG_WNN_ALP,
        _("set the count of conversion until displaying the list of lookup result automatically."),
        SCIM_DEFAULT_WNN_ALP,
        -1,10
    ));
    page->append(new SkimScimWnnBoolItem(
        _("_NumKey selection: "),
        SCIM_CONFIG_WNN_NUMKEY_SELECT,
        _("If you use the candidate selection by numkey, check this."),
        SCIM_DEFAULT_WNN_NUMKEY_SELECT
    ));
    page->append(new SkimScimWnnBoolItem(
        _("Auto _conversion: "),
        SCIM_CONFIG_WNN_AUTO_CONVERSION,
        _("If you set default to the auto conversion mode use, check this."),
        SCIM_DEFAULT_WNN_AUTO_CONVERSION
    ));
    page->append(new SkimScimWnnBoolItem(
        _("_YOSOKU-input: "),
        SCIM_CONFIG_WNN_YOSOKU,
        _("if you use YOSOKU-input , check this."),
        SCIM_DEFAULT_WNN_YOSOKU
    ));
    page->append(new SkimScimWnnFileItem(
        _("_Roma-Kana table: "),
        SCIM_CONFIG_WNN_ROMKAN_TABLE_FILE,
        _("input the path of Roma-Kana convert table file."),
        SCIM_DEFAULT_WNN_ROMKAN_TABLE_FILE
    ));

    setup->append(page);
    
    
    //
    // key setting
    //
    

    page = new SkimScimWnnPage(_("Common keys"),"","");
    page->append(new SkimScimWnnKeyItem(
        _("Commit keys:"),
        SCIM_CONFIG_WNN_KEY_COMMIT,
        _("The key events to commit the preedit string. "),
        SCIM_DEFAULT_WNN_KEY_COMMIT
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Convert keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_START,
        _("The key events to convert the preedit string to kanji. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_START
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Cancel keys:"),
        SCIM_CONFIG_WNN_KEY_CANCEL,
        _("The key events to cancel preediting or converting. "),
        SCIM_DEFAULT_WNN_KEY_CANCEL
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Backspace keys:"),
        SCIM_CONFIG_WNN_KEY_BACKSPACE,
        _("The key events to delete a character before caret. "),
        SCIM_DEFAULT_WNN_KEY_BACKSPACE
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Delete keys:"),
        SCIM_CONFIG_WNN_KEY_DELETE,
        _("The key events to delete a character after caret. "),
        SCIM_DEFAULT_WNN_KEY_DELETE
    ));
    setup->append(page);

    page = new SkimScimWnnPage(_("Preedit keys"),"","");
    page->append(new SkimScimWnnKeyItem(
        _("Move forward keys:"),
        SCIM_CONFIG_WNN_KEY_FORWARD,
        _("The key events to move the caret to forward. "),
        SCIM_DEFAULT_WNN_KEY_FORWARD
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Move backward keys:"),
        SCIM_CONFIG_WNN_KEY_BACKWARD,
        _("The key events to move the caret to backward. "),
        SCIM_DEFAULT_WNN_KEY_BACKWARD
    ));
    setup->append(page);

    page = new SkimScimWnnPage(_("Segment keys"),"","");
    page->append(new SkimScimWnnKeyItem(
        _("Next segment keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_FORWARD,
        _("The key events to select next segment. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_FORWARD
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Previous segment keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_BACKWARD,
        _("The key events to select previous segment. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_BACKWARD
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Shrink segment keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_SHRINK,
        _("The key events to shrink the selected segment. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_SHRINK
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Expand segment keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_EXPAND,
        _("The key events to expand the selected segment. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_EXPAND
    ));
    setup->append(page);

    page = new SkimScimWnnPage(_("Candidates keys"),"","");
    page->append(new SkimScimWnnKeyItem(
        _("Next keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_NEXT,
        _("The key events to select next candidate. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_NEXT
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Previous keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_PREV,
        _("The key events to select previous candidate. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_PREV
    ));
    page->append(new SkimScimWnnKeyItem(
        _("candidates list keys:"),
        SCIM_CONFIG_WNN_KEY_LOOKUPPOPUP,
        _("The key events to popup candidates list. "),
        SCIM_DEFAULT_WNN_KEY_LOOKUPPOPUP
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Page up keys:"),
        SCIM_CONFIG_WNN_KEY_LOOKUPPAGEUP,
        _("The key events to select page up candidates. "),
        SCIM_DEFAULT_WNN_KEY_LOOKUPPAGEUP
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Page down keys:"),
        SCIM_CONFIG_WNN_KEY_LOOKUPPAGEDOWN,
        _("The key events to select page down candidates. "),
        SCIM_DEFAULT_WNN_KEY_LOOKUPPAGEDOWN
    ));
    setup->append(page);

    page = new SkimScimWnnPage(_("Other function keys"),"","");
    page->append(new SkimScimWnnKeyItem(
        _("auto conversion mode keys:"),
        SCIM_CONFIG_WNN_KEY_AUTO_CONVERSION,
        _("The key events to change auto conversion mode. "),
        SCIM_DEFAULT_WNN_KEY_AUTO_CONVERSION
    ));
    page->append(new SkimScimWnnKeyItem(
        _("auto conversion mode keys:"),
        SCIM_CONFIG_WNN_KEY_SELECT_YOSOKU,
        _("The key events to select from completion list. "),
        SCIM_DEFAULT_WNN_KEY_SELECT_YOSOKU
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Convert to ikeiji keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_IKEIJI,
        _("The key events to convert the selected candidate to ikei-kanji. "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_IKEIJI
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Convert to rensou keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERSION_RENSOU,
        _("The key events to convert the selected candidate to the associated acceptation string.  "),
        SCIM_DEFAULT_WNN_KEY_CONVERSION_RENSOU
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Convert to HIRAGANA keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERT_HIRAGANA,
        _("The key events to convert the selected candidate or the preedit string to HIRAGANA. "),
        SCIM_DEFAULT_WNN_KEY_CONVERT_HIRAGANA
    ));
    page->append(new SkimScimWnnKeyItem(
        _("Convert to KATAKANA keys:"),
        SCIM_CONFIG_WNN_KEY_CONVERT_KATAKANA,
        _("The key events to convert the selected candidate or the preedit string to KATAKANA. "),
        SCIM_DEFAULT_WNN_KEY_CONVERT_KATAKANA
    ));
    setup->append(page);
    
    setup->getValueWidget()->reparent(this,QPoint());
    setup->getValueWidget()->show();
    grid->addWidget(setup->getValueWidget(),0,0);
    setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    
    //emit changed(true);
    connect(setup,SIGNAL(changed()),this,SLOT(configChanged()));
    _setup = setup;

    load();
    

};


skim_scim_wnn::~skim_scim_wnn()
{
}


void skim_scim_wnn::load()
{
    scimConfigPrivate config;
    if (!config.configModule.valid()) {
        scim::String mod = scim::scim_global_config_read(scim::String("/DefaultConfigModule"),scim::String("simple"));
        config.configModule.load(mod);
    }
    config.config = config.configModule.create_config();
    

    _setup->readConfig(config.config);
}


void skim_scim_wnn::defaults()
{
    // insert your default settings code here...
    emit changed(true);
}


void skim_scim_wnn::save()
{
    scimConfigPrivate config;
    if (!config.configModule.valid()) {
        scim::String mod = scim::scim_global_config_read(scim::String("/DefaultConfigModule"),scim::String("simple"));
        config.configModule.load(mod);
    }
    config.config = config.configModule.create_config();
    _setup->saveConfig(config.config);
    emit changed(true);
}


int skim_scim_wnn::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


void skim_scim_wnn::configChanged()
{
    // insert your saving code here...
    emit changed(true);
}


QString skim_scim_wnn::quickHelp() const
{
    return i18n("Helpful information about the skim_scim_wnn module.");
}


#include "skim_scim_wnn.moc"
