/***************************************************************************
 *   Copyright (C) 2005 by TAM (Teppei Tamra)   *
 *   tam-t@par.odn.ne.jp   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SKIM_SCIM_WNN_ITEMS_H
#define SKIM_SCIM_WNN_ITEMS_H

#define Uses_SCIM_CONFIG_MODULE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_GLOBAL_CONFIG
#include <scim.h>

#include <qobject.h>
#include <qwidget.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qvaluelist.h>
#include <qlayout.h>
#include <vector>

/**
@author TAM (Teppei Tamra)
*/
namespace SkimScimWnnItems {
class SkimScimWnnItem : public QObject {
Q_OBJECT
public:
    QWidget *getValueWidget();
    QWidget *getLabelWidget();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
    QString getLabel();
protected:
    SkimScimWnnItem(scim::String _label,scim::String _name,scim::String _tip);
    ~SkimScimWnnItem();
    virtual void createLabelWidget();
    virtual void createValueWidget();
    virtual void createTipWidget();
    //void createWidgets();
    QString label;
    QString name;
    QString tip;
    QWidget *valueWidget;
    QLabel *labelWidget;
signals:
    void changed();
};


class SkimScimWnnContainer {
protected:
    SkimScimWnnContainer();
    ~SkimScimWnnContainer();

    virtual void append(SkimScimWnnItem *item);
    QValueList<SkimScimWnnItem *> items;
};

class SkimScimWnnItem;
class SkimScimWnn: public SkimScimWnnItem ,public SkimScimWnnContainer {
Q_OBJECT
public:
    SkimScimWnn(scim::String _label,scim::String _name,scim::String _tip);
    ~SkimScimWnn();
    virtual void append(SkimScimWnnItem *page);
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
};

class SkimScimWnnPage: public SkimScimWnnItem ,public SkimScimWnnContainer {
public:
    SkimScimWnnPage(scim::String _label,scim::String _name,scim::String _tip);
    ~SkimScimWnnPage();
    virtual void append(SkimScimWnnItem *item);
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
protected:
    QGridLayout *table;
    QSpacerItem *spacer;
};


class SkimScimWnnEntryItem : public SkimScimWnnItem {
Q_OBJECT
public:
    SkimScimWnnEntryItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default);
    ~SkimScimWnnEntryItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
protected slots:
    void textChanged(const QString &text);
};

class SkimScimWnnBoolItem : public SkimScimWnnItem {
Q_OBJECT
public:
    SkimScimWnnBoolItem(scim::String _label,scim::String _name,scim::String _tip,bool _default);
    ~SkimScimWnnBoolItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    bool boolData;
protected slots:
    void clicked();
};

class SkimScimWnnFileItem : public SkimScimWnnItem {
Q_OBJECT
public:
    SkimScimWnnFileItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default);
    ~SkimScimWnnFileItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
    QLineEdit *le;
protected slots:
    void textChanged(const QString &text);
    void buttonClicked();
};

class SkimScimWnnKeyItem : public SkimScimWnnItem {
Q_OBJECT
public:
    SkimScimWnnKeyItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default);
    ~SkimScimWnnKeyItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
    QLineEdit *le;
protected slots:
    void textChanged(const QString &text);
    void buttonClicked();
};

class SkimScimWnnIntItem : public SkimScimWnnItem {
Q_OBJECT
public:
    SkimScimWnnIntItem(scim::String _label,scim::String _name,scim::String _tip,int _default,int lower,int upper);
    ~SkimScimWnnIntItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
    int intData;
    int upperValue;
    int lowerValue;
protected:
    virtual void createValueWidget();
protected slots:
    void valueChanged(int value);
};

class SkimScimWnnSelectItem : public SkimScimWnnItem {
Q_OBJECT
public:
    SkimScimWnnSelectItem(scim::String _label,scim::String _name,scim::String _tip,scim::String _default,std::vector<scim::String> _list);
    ~SkimScimWnnSelectItem();
    virtual void readConfig(scim::ConfigPointer cfg);
    virtual void saveConfig(scim::ConfigPointer cfg);
protected:
    virtual void createValueWidget();
    QString stringData;
    QStringList list;
protected slots:
    void activated(int pos);
};

}

#endif
