/*
 *  Copyright (C) 2006 Takashi Nakamoto <bluedwarf@bpost.plala.or.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SCIM_RUBY_INTERPRETER_H__
#define __SCIM_RUBY_INTERPRETER_H__

#include <stdio.h>
#include <list>
#include <scim.h>

using namespace std;
using namespace scim;

class RubyInterpreter
{
private:
    FILE *m_fp_input;
    FILE *m_fp_output;
    int child_write_fd;
    String m_irb_command;
    list<String> m_required_libs;

    list<WideString> m_history_list; // history list of executed codes
    int m_history_size; // max size of m_history_list

    bool m_can_predict;

public:
    RubyInterpreter(const String &irb_command,
		    const String &required_libs,
		    const String &pre_include_modules);
    ~RubyInterpreter();

    void get_methods(const WideString &wstr_object, list<WideString> &methods);
    void get_candidates(const WideString &wstr_code, list<WideString> &candidates);
    WideString execute_ruby_code(const WideString &wsrc,
				 const bool save_as_history = true);
    bool valid_syntax(const WideString &wsrc);

    void setHistorySize(int size);
    list<WideString> &get_history();

    bool canPredict() { return m_can_predict; };

private:
    void open_irb();
    void load_required_libraries(const String &required_libs);
    bool load_library(const String &library);
    void include_modules(const String &modules);
    void include_module(const String &module);
    String send_code_to_irb(const String &code);
    void exit_irb();
};

#endif // __SCIM_RUBY_INTERPRETER_H__
