/*
 *  Copyright (C) 2006 Takashi Nakamoto
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define Uses_SCIM_EVENT
#include "scim_ruby_keybind.h"

KeyBind::KeyBind (void)
{
}

KeyBind::~KeyBind (void)
{
}

void KeyBind::set_keys(const String &str, KeyEventCategory category)
{
    scim_string_to_key_list(m_key_events[category], str);
}

bool KeyBind::match_keys(const KeyEvent &key, KeyEventCategory category)
{
    KeyEventList::const_iterator it = std::find(m_key_events[category].begin(),
                                                m_key_events[category].end(),
						key);
    return it != m_key_events[category].end();
}
