#
#   irb/completor.rb - 
#   	$Release Version: 0.9$
#   	$Revision: 1.1.1.1 $
#   	$Date: 2006/08/08 05:26:56 $
#   	by Keiju ISHITSUKA(keiju@ishitsuka.com)
#       From Original Idea of shugo@ruby-lang.org
#

#
# This file is modified by Takashi Nakamoto (bluedwarf@bpost.plala.or.jp)
# for scim-ruby. You can find original code in Ruby's source tree
# (lib/irb/completion.rb). To get the original code, download Ruby's source
# from Ruby's Web site (http://www.ruby-lang.org/).
#

class ScimRuby
  ReservedWords = [
                   "BEGIN", "END",
                   "alias", "and", 
                   "begin", "break", 
                   "case", "class",
                   "def", "defined", "do",
                   "else", "elsif", "end", "ensure",
                   "false", "for", 
                   "if", "in", 
                   "module", 
                   "next", "nil", "not",
                   "or", 
                   "redo", "rescue", "retry", "return",
                   "self", "super",
                   "then", "true",
                   "undef", "unless", "until",
                   "when", "while",
                   "yield",
                  ]

  # Returns completion candidates as an Array object.
  # The first item is the string piece to be replaced by completion candidates.
  def ScimRuby.complete( input )
      bind = IRB.conf[:MAIN_CONTEXT].workspace.binding

#      puts "input: #{input}"

    case input
    when /^(\/[^\/]*\/)\.([^.]*)$/
      # Regexp
      receiver = $1
      piece = $2
      message = Regexp.quote($2)

      candidates = Regexp.instance_methods(true)
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    when /^([^\]]*\])\.([^.]*)$/
      # Array
      receiver = $1
      piece = $2
      message = Regexp.quote($2)

      candidates = Array.instance_methods(true)
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    when /^([^\}]*\})\.([^.]*)$/
      # Proc or Hash
      receiver = $1
      piece = $2
      message = Regexp.quote($2)

      candidates = Proc.instance_methods(true) | Hash.instance_methods(true)
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq
      
    when /^(:[^:.]*)$/
      # Symbol
      if Symbol.respond_to?(:all_symbols)
        sym = $1
        candidates = Symbol.all_symbols.collect{|s| ":" + s.id2name}
        candidates.grep(/^#{sym}/).sort.unshift(sym).uniq
      else
        []
      end

    when /^::([A-Z][^:\.\(]*)$/
      # Absolute Constant or class methods
      receiver = $1
      candidates = Object.constants
      candidates.grep(/^#{receiver}/).collect{|e| "::" + e}.sort.unshift(receiver).uniq

    when /^(((::)?[A-Z][^:.\(]*)+)::?([^:.]*)$/
      # Constant or class methods
      receiver = $1
      piece = $4
      message = Regexp.quote($4)
      begin
        candidates = eval("#{receiver}.constants | #{receiver}.methods", bind)
      rescue Exception
        candidates = []
      end
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    when /^(:[^:.]+)\.([^.]*)$/
      # Symbol
      receiver = $1
      piece = $2
      message = Regexp.quote($2)

      candidates = Symbol.instance_methods(true)
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    when /^([0-9_]+(\.[0-9_]+)?(e[0-9]+)?)\.([^.]*)$/
      # Numeric
      receiver = $1
      piece = $4
      message = Regexp.quote($4)

      begin
        candidates = eval(receiver, bind).methods
      rescue Exception
        candidates
      end
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    when /^(\$[^.]*)$/
      variable_name = "$#{$1}"
      candidates = global_variables.grep(Regexp.new(Regexp.quote($1)))
      candidates.sort.unshift(variable_name)

      #      when /^(\$?(\.?[^.]+)+)\.([^.]*)$/
    when /^((\.?[^.]+)+)\.([^.]*)$/
      # variable
      receiver = $1
      piece = $3
      message = Regexp.quote($3)

      gv = eval("global_variables", bind)
      lv = eval("local_variables", bind)
      cv = eval("self.class.constants", bind)
      
      if (gv | lv | cv).include?(receiver)
        # foo.func and foo is local var.
        candidates = eval("#{receiver}.methods", bind)
      elsif /^[A-Z]/ =~ receiver and /\./ !~ receiver
        # Foo::Bar.func
        begin
          candidates = eval("#{receiver}.methods", bind)
        rescue Exception
          candidates = []
        end
      else
        # func1.func2
        candidates = []
        ObjectSpace.each_object(Module){|m|
          next if m.name != "IRB::Context" and 
          /^(IRB|SLex|RubyLex|RubyToken)/ =~ m.name
          candidates.concat m.instance_methods(false)
        }
        candidates.sort!
        candidates.uniq!
      end
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    when /^\.([^.]*)$/
      # unknown(maybe String)

      receiver = ""
      piece = $1
a      message = Regexp.quote($1)

      candidates = String.instance_methods(true)
      candidates.grep(/^#{message}/).sort.unshift(piece).uniq

    else
      candidates = eval("methods | private_methods | local_variables | self.class.constants", bind)
      
      (candidates|ReservedWords).grep(/^#{Regexp.quote(input)}/).sort.unshift(input).uniq

    end
  end
end
