/* Generated By:JavaCC: Do not edit this line. Parser.java */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.util.*;
import java.net.*;
import java.io.File;
import java.io.Reader;
import java.util.StringTokenizer;
import java.lang.reflect.Constructor;

public class Parser implements ParserConstants {
    Loader      loader;
    int         lastLine = 0;
    Object[]    loaderParam;
    // these could be made static, if initialization performance is a problem
    Class[]     loaderClass;
    Hashtable   vrmlNodes = null;
    Hashtable   fieldTypeCodes = null;

    // For use with generated token manager (USER_TOKEN_MANAGER=false):
    Parser(Loader loader, java.io.Reader reader) {
        this(reader);
        this.loader = loader;
        initTables();
    }

    // For use with custom token manager (USER_TOKEN_MANAGER=true):
    //Parser(Loader loader, TokenManager tm) {
    //	this(tm);
    // 	this.loader = loader;
    //}

    int currentLine() {
            Token curToken = getToken(0);
        return curToken.endLine;
    }


    // setup code to: get the constructor Node(Loader) for each VRML node
    // type from the name of the node; determine if a node is a 
    // reusable node; convert a field type to a field constant
    void initTables() {
        // used to resolve the node class
        loaderClass = new Class[1];
        loaderClass[0] = loader.getClass();

        // used to create a new node instance
        loaderParam = new Object[1];
        loaderParam[0] = loader;

        // used to map between node names and node constructors
        vrmlNodes = new Hashtable();
        addVrmlNode("Anchor");
        addVrmlNode("Appearance");
        addVrmlNode("AudioClip");
        addVrmlNode("Background");
        addVrmlNode("Billboard");
        addVrmlNode("Box");
        addVrmlNode("Collision");
        addVrmlNode("Color");
        addVrmlNode("ColorInterpolator");
        addVrmlNode("Cone");
        addVrmlNode("Coordinate");
        addVrmlNode("CoordinateInterpolator");
        addVrmlNode("Cylinder");
        addVrmlNode("CylinderSensor");
        addVrmlNode("DirectionalLight");
        addVrmlNode("ElevationGrid");
        addVrmlNode("Extrusion");
        addVrmlNode("Fog");
        addVrmlNode("FontStyle");
        addVrmlNode("Group");
        addVrmlNode("ImageTexture");
        addVrmlNode("IndexedFaceSet");
        addVrmlNode("IndexedLineSet");
        addVrmlNode("Inline");
        addVrmlNode("LOD");
        addVrmlNode("Material");
        //addVrmlNode("MovieTexture");
        addVrmlNode("NavigationInfo");
        addVrmlNode("Normal");
        addVrmlNode("NormalInterpolator");
        addVrmlNode("OrientationInterpolator");
        //addVrmlNode("PixelTexture");
        addVrmlNode("PlaneSensor");
        addVrmlNode("PointLight");
        addVrmlNode("PointSet");
        addVrmlNode("PositionInterpolator");
        addVrmlNode("ProximitySensor");
        addVrmlNode("ScalarInterpolator");
        addVrmlNode("Shape");
        addVrmlNode("Sound");
        addVrmlNode("Sphere");
        addVrmlNode("SphereSensor");
        addVrmlNode("SpotLight");
        addVrmlNode("Switch");
        addVrmlNode("Text");
        addVrmlNode("TextureCoordinate");
        addVrmlNode("TextureTransform");
        addVrmlNode("TimeSensor");
        addVrmlNode("TouchSensor");
        addVrmlNode("Transform");
        addVrmlNode("Viewpoint");
        //addVrmlNode("VisibilitySensor");
        addVrmlNode("WorldInfo");

        // Field type codes
        fieldTypeCodes = new Hashtable();
        addField("SFBool",    SFBOOL);
        addField("SFColor",   SFCOLOR);
        addField("SFFloat",   SFFLOAT);
        addField("SFInt32",   SFINT32);
        //addField("SFImage",   SFIMAGE);
        addField("SFNode",    SFNODE);
        addField("SFRotation",SFROTATION);
        addField("SFString",  SFSTRING);
        addField("SFTime",    SFTIME);
        addField("SFVec2f",   SFVEC2F);
        addField("SFVec3f",   SFVEC3F);
        addField("MFColor",   MFCOLOR);
        addField("MFFloat",   MFFLOAT);
        addField("MFInt32",   MFINT32);
        addField("MFNode",    MFNODE);
        addField("MFRotation",MFROTATION);
        addField("MFString",  MFSTRING);
        addField("MFTime",    MFTIME);
        addField("MFVec2f",   MFVEC2F);
        addField("MFVec3f",   MFVEC3F);
    }

    // add a new node type to the vrmlNodes map
    void addVrmlNode(String nodeTypeId) {
        String className = "org.jdesktop.j3d.loaders.vrml97.impl." + nodeTypeId;
        try {
            Class nodeClass =  Class.forName(className);
            try {
            Constructor nodeConstructor =
                    nodeClass.getConstructor(loaderClass);
            vrmlNodes.put(nodeTypeId, nodeConstructor);
            } catch (NoSuchMethodException e) {
            System.out.println("vrml97 Loader: Initialization error: " +
                "Can't find constructor for VRML node: " + className);
            }
        } catch (ClassNotFoundException e) {
            System.out.println("vrml97 Loader: Initialization error: Can't " +
            "find class for VRML node: " + className);
        }
    }

    void addField(String fieldTypeId, int fieldCode) {
        String className = "org.jdesktop.j3d.loaders.vrml97.impl." + fieldTypeId;
        try {
            Class fieldClass =  Class.forName(className);
            fieldTypeCodes.put(fieldClass, new Integer(fieldCode));
        } catch (ClassNotFoundException e) {
            System.out.println("vrml97 Loader: Initialization error: Can't " +
            "find class for VRML node: " + className);
        }
    }

    // returns the constructor Node(Loader) corresponding to the nodeTypeId
    // returns null if nodeTypeId is not a VRML node type
    Constructor vrmlNodeConstructor(String nodeTypeId) {
            return (Constructor) vrmlNodes.get(nodeTypeId);
    }

// Grammar follows the structure in the ISO spec, except that TOKENS are
// at the bottom

// A.2 General

// vrmlScene in the spec:
  final public void Scene() throws ParseException {
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEF:
      case USE:
      case PROTO:
      case EXTERNPROTO:
      case ROUTE:
      case ID:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      Statement();
    }
    jj_consume_token(0);
  }

  final public void Statement() throws ParseException {
                   BaseNode node;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEF:
    case USE:
    case ID:
      node = NodeStatement();
        loader.addObject(node);
      break;
    case ROUTE:
      RouteStatement();
      break;
    case PROTO:
    case EXTERNPROTO:
      ProtoStatement();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public BaseNode NodeStatement() throws ParseException {
    BaseNode node;
    String defName;
    loader.cleanUp();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      node = Node();
        if (node instanceof ProtoInstance) {
            node = ((ProtoInstance)node).instanceNode();
        }
        {if (true) return node;}
      break;
    case DEF:
      jj_consume_token(DEF);
      defName = NodeNameId();
      node = Node();
        loader.namespaceDefine(defName, node);
        if (node instanceof ProtoInstance) {
            node = ((ProtoInstance)node).instanceNode();
        }
        {if (true) return node;}
      break;
    case USE:
      jj_consume_token(USE);
      defName = NodeNameId();
        node = loader.namespaceUse(defName);
        if (node instanceof ProtoInstance) {
            node = ((ProtoInstance)node).instanceNode();
        }
        // tell the node it is being used (again)
        node.registerUse(loader.scene);
        {if (true) return node;}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void ProtoStatement() throws ParseException {
                         Proto proto; String protoName;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROTO:
      ProtoDefinition();
      break;
    case EXTERNPROTO:
      ExternProtoDefinition();
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ProtoDefinition() throws ParseException {
                          Proto proto;
    jj_consume_token(PROTO);
    proto = ProtoFromName();
    ProtoInterface(proto);
    jj_consume_token(LBRACE);
    ProtoBody(proto);
    jj_consume_token(RBRACE);
        loader.endProtoDefine();
  }

  final public Proto ProtoFromName() throws ParseException {
                   String protoName;
    protoName = NodeNameId();
        Proto proto = new Proto(loader, protoName);
        loader.beginProtoDefine(proto);
        {if (true) return proto;}
    throw new Error("Missing return statement in function");
  }

  final public void ProtoInterface(Proto proto) throws ParseException {
    jj_consume_token(LBRACKET);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EVENTIN:
      case EVENTOUT:
      case FIELD:
      case EXPOSEDFIELD:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
      ProtoInterface_fields(proto);
    }
    jj_consume_token(RBRACKET);
  }

  final public void ProtoInterface_fields(Proto proto) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EVENTIN:
      jj_consume_token(EVENTIN);
      ProtoEventIn(proto);
      break;
    case FIELD:
      jj_consume_token(FIELD);
      ProtoField(proto);
      break;
    case EVENTOUT:
      jj_consume_token(EVENTOUT);
      ProtoEventOut(proto);
      break;
    case EXPOSEDFIELD:
      jj_consume_token(EXPOSEDFIELD);
      ProtoExposedField(proto);
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ProtoEventIn(Proto proto) throws ParseException {
    Token       token;
    Field       field;
    String      name;
    field = genEvent();
    name = EventInId();
        proto.setEventIn(name,field);
  }

  final public void ProtoField(Proto proto) throws ParseException {
                                Field f;
    f = genField();
        proto.setField(f.fieldName, f);
  }

  final public void ProtoEventOut(Proto proto) throws ParseException {
    Token token;
    Field field;
    String name;
    field = genEvent();
    name = EventOutId();
        proto.setEventOut(name,field);
  }

  final public void ProtoExposedField(Proto proto) throws ParseException {
                                       Field f;
    f = genField();
        proto.setExposedField(f.fieldName, f);
  }

  final public void ProtoBody(Proto proto) throws ParseException {
                               BaseNode node = null;
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEF:
      case USE:
      case PROTO:
      case EXTERNPROTO:
      case ROUTE:
      case ID:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      Statement();
    }
  }

  final public void ExternProtoDefinition() throws ParseException {
   String protoName;
   Vector protoFields = new Vector();
   Vector urlList = new Vector();
    jj_consume_token(EXTERNPROTO);
    protoName = NodeTypeId();
    jj_consume_token(LBRACKET);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EVENTIN:
      case EVENTOUT:
      case FIELD:
      case EXPOSEDFIELD:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      ExternProtoInterface(protoFields);
    }
    jj_consume_token(RBRACKET);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_5;
      }
      ExternProtoURL(urlList);
    }
        boolean found = false;
        int size = urlList.size();
        Exception lastException = null;
        for (int i = 0; !found && (i < size); i++) {
            try {
                String urlString = (String) urlList.elementAt(i);
                loader.loadProto(urlString, protoName, protoFields);
                found = true;
            } catch (Exception e) {
                if (e instanceof ParseException) {
                    {if (true) throw (ParseException)e;}
                } else {
                    lastException = e;
                }
            }
        }
        if (!found && (lastException != null)) {
             if (loader.debug) {
                 System.err.println("Exception reading EXTERNPROTO:");
                 lastException.printStackTrace(System.err);
             }
             {if (true) throw new ParseException("Exception " + lastException +
                " loading EXTERNPROTO");}
        }
  }

  final public void ExternProtoInterface(Vector protoFields) throws ParseException {
                                                Field f; String name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EVENTIN:
      jj_consume_token(EVENTIN);
      f = genEvent();
      name = EventInId();
        f.fieldName = name;
        protoFields.add(f);
      break;
    case FIELD:
      jj_consume_token(FIELD);
      f = genEvent();
      name = FieldId();
        f.fieldName = name;
        protoFields.add(f);
      break;
    case EVENTOUT:
      jj_consume_token(EVENTOUT);
      f = genEvent();
      name = EventOutId();
        f.fieldName = name;
        protoFields.add(f);
      break;
    case EXPOSEDFIELD:
      jj_consume_token(EXPOSEDFIELD);
      f = genEvent();
      name = FieldId();
        f.fieldName = name;
        protoFields.add(f);
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ExternProtoURL(Vector urlList) throws ParseException {
                                       String url;
    url = String();
                     urlList.add(url);
  }

  final public void RouteStatement() throws ParseException {
    String  fromName, fromField, toName, toField;
    jj_consume_token(ROUTE);
    fromName = NodeNameId();
    jj_consume_token(DOT);
    fromField = EventOutId();
    jj_consume_token(TO);
    toName = NodeNameId();
    jj_consume_token(DOT);
    toField = EventInId();
        BaseNode fromNode = loader.namespaceUse(fromName);
        BaseNode toNode = loader.namespaceUse(toName);
        if ((fromNode == null) || (toNode == null)) {
            {if (true) throw new ParseException("To or From node on ROUTE not DEF'd");}
        }
        loader.addRoute(fromNode, fromField, toNode, toField);
  }

// A.3 Node
  final public BaseNode Node() throws ParseException {
    String nodeTypeId;
    BaseNode node;
    nodeTypeId = NodeTypeId();
        if (nodeTypeId.equals("Script")) {
            node = Script();
        } else {
            node = NodeBody(nodeTypeId);
        }
        if (loader.curProto == null) {
            if (loader.timing) {
                double start;
                start = Time.getNow();
                node.initImpl();
                double elapsed = Time.getNow() - start;
                loader.nodeInitImpl += elapsed;
                if (node instanceof IndexedFaceSet) {
                    loader.ifsInit += elapsed;
                    loader.numIfs++;
                }
                if (node instanceof GroupBase) {
                    loader.numGroups++;
                }
            } else {
                node.initImpl();
            }
        }
        if (loader.parserMarks) {
            Token curToken = getToken(0);
            if (curToken.beginLine > (lastLine + 1000)) {
                lastLine = curToken.beginLine;
                // round the line down to the nearest 1000 
                lastLine = lastLine - (lastLine % 1000);
                System.out.println("Parser is at about line " + lastLine);
            }
        }
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public Node NodeBody(String nodeTypeId) throws ParseException {
    Node node = null;
    Constructor nodeConstructor;
    Proto proto;
    if ((nodeConstructor = (Constructor)vrmlNodeConstructor(nodeTypeId))
                                                                != null) {
        // create a node of the type matching the nodeTypeId 
        // (ain't it cool!)
        try {
            node = (Node)nodeConstructor.newInstance(loaderParam);
        } catch (Exception e) {
            System.out.println("vrml97 Loader: error in constructor for " +
            nodeTypeId + ": " + e);
        if ( e instanceof java.lang.reflect.InvocationTargetException ) {
            System.out.println(
                ((java.lang.reflect.InvocationTargetException)e).getTargetException());
            e.printStackTrace();
        }

    }
    // might be a proto
    } else if ((proto = loader.lookupProto(nodeTypeId)) != null) {
        ProtoInstance instance = proto.instance();
        if ((loader.debug) && (loader.browser != null)) {
            loader.browser.routePrinter.printRoutes(instance);
        }
        node = instance;
    } else {
        throw new ParseException("Unknown node type: " + nodeTypeId);
    }
    jj_consume_token(LBRACE);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PROTO:
      case EXTERNPROTO:
      case ROUTE:
      case ID:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_6;
      }
      NodeBodyElement(node);
    }
    jj_consume_token(RBRACE);
        {if (true) return node;}
    throw new Error("Missing return statement in function");
  }

  final public void NodeBodyElement(BaseNode node) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      FieldStatement(node);
      break;
    case ROUTE:
      RouteStatement();
      break;
    case PROTO:
    case EXTERNPROTO:
      ProtoStatement();
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Field FieldFromId(BaseNode node) throws ParseException {
    String fieldName;
    Field field;
    fieldName = FieldId();
        field = node.getField(fieldName);
        {if (true) return field;}
    throw new Error("Missing return statement in function");
  }

  final public void FieldStatement(BaseNode node) throws ParseException {
                                      Field field;
    field = FieldFromId(node);
    FieldInit(field);
  }

  final public void FieldInit(Field field) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      IsField(field);
      break;
    default:
      jj_la1[12] = jj_gen;
      FieldValue(field);
    }
  }

  final public void IsField(Field toField) throws ParseException {
                               String fieldName;
    jj_consume_token(IS);
    fieldName = FieldId();
        Proto proto;
        if ((proto = loader.curProto()) != null) {
            if (!proto.setupIsMap(toField, fieldName)) {
                {if (true) throw new ParseException("Error setting up IS map in PROTO");}
            }
        } else {
            {if (true) throw new ParseException("IS statement outside PROTO");}
        }
  }

  final public void FieldValue(Field field) throws ParseException {
         Integer fieldTypeCode = (Integer) fieldTypeCodes.get(field.getClass());
         if (fieldTypeCode == null) {
              {if (true) throw new ParseException("Parser Error: unexpected field type");}
         }
         switch (fieldTypeCode.intValue()) {
           case SFBOOL:
             _SFBool((SFBool)field);
             break;
           case SFCOLOR:
             _SFColor((SFColor)field);
             break;
           case SFFLOAT:
             _SFFloat((SFFloat)field);
             break;
           //case SFIMAGE:
           //   _SFImage((SFImage)field);
           //break;
           case SFINT32:
             _SFInt32((SFInt32)field);
             break;
           case SFNODE:
             _SFNode((SFNode)field);
             break;
           case SFROTATION:
             _SFRotation((SFRotation)field);
             break;
           case SFSTRING:
             _SFString((SFString)field);
             break;
           case SFTIME:
             _SFTime((SFTime)field);
             break;
           case SFVEC2F:
             _SFVec2f((SFVec2f)field);
             break;
           case SFVEC3F:
             _SFVec3f((SFVec3f)field);
             break;
           case MFCOLOR:
             _MFColor((MFColor)field);
             break;
           case MFFLOAT:
             _MFFloat((MFFloat)field);
             break;
           case MFINT32:
             _MFInt32((MFInt32)field);
             break;
           case MFNODE:
             _MFNode((MFNode)field);
             break;
           case MFROTATION:
             _MFRotation((MFRotation)field);
             break;
           case MFSTRING:
             _MFString((MFString)field);
             break;
           case MFTIME:
             _MFTime((MFTime)field);
             break;
           case MFVEC2F:
             _MFVec2f((MFVec2f)field);
             break;
           case MFVEC3F:
             _MFVec3f((MFVec3f)field);
             break;
           default:
             {if (true) throw new ParseException("Internal error: Field type " +
                field.getClass() + " not found");}
         }
         // Propigate changes in the field (used by Proto)
         field.route();
  }

  final public Script Script() throws ParseException {
    Script script = new Script(loader);
    jj_consume_token(LBRACE);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PROTO:
      case EVENTIN:
      case EVENTOUT:
      case FIELD:
      case EXTERNPROTO:
      case ROUTE:
      case ID:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_7;
      }
      ScriptBodyElement(script);
    }
    jj_consume_token(RBRACE);
        {if (true) return script;}
    throw new Error("Missing return statement in function");
  }

  final public void ScriptBodyElement(Script script) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EVENTIN:
      jj_consume_token(EVENTIN);
      ScriptEventIn(script);
      break;
    case EVENTOUT:
      jj_consume_token(EVENTOUT);
      ScriptEventOut(script);
      break;
    case FIELD:
      jj_consume_token(FIELD);
      ScriptField(script);
      break;
    case PROTO:
    case EXTERNPROTO:
    case ROUTE:
    case ID:
      NodeBodyElement(script);
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ScriptEventIn(Script s) throws ParseException {
    Field f;
    String name;
    f = genEvent();
    name = EventInId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      IsField(f);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
        // System.out.println(name+f);
        s.setEventIn(name,f);
  }

  final public void ScriptField(Script s) throws ParseException {
                               Field f;
    f = genField();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      IsField(f);
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
        //System.out.println(f.fieldName+f);
        s.setField(f.fieldName, f);
  }

  final public void ScriptEventOut(Script s) throws ParseException {
    Token t;
    Field f;
    String name;
    f = genEvent();
    name = EventOutId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS:
      IsField(f);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
        // System.out.println(name+f);
        s.setEventOut(name,f);
  }

// Fields initializers used by PROTOs and Scripts
// dont forget to add SFImage
  final public Field genEvent() throws ParseException {
                     Field field;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SFBOOL:
      jj_consume_token(SFBOOL);
                   field = new SFBool(false);
                   {if (true) return field;}
      break;
    case SFCOLOR:
      jj_consume_token(SFCOLOR);
                   field = new SFColor(0.0f,1.0f,0.0f);
                   {if (true) return field;}
      break;
    case SFFLOAT:
      jj_consume_token(SFFLOAT);
                   field = new SFFloat(0.0f);
                   {if (true) return field;}
      break;
    case SFINT32:
      jj_consume_token(SFINT32);
                   field = new SFInt32(0);
                   {if (true) return field;}
      break;
    case SFNODE:
      jj_consume_token(SFNODE);
                   field = new SFNode();
                   {if (true) return field;}
      break;
    case SFROTATION:
      jj_consume_token(SFROTATION);
                   field = new SFRotation();
                   {if (true) return field;}
      break;
    case SFSTRING:
      jj_consume_token(SFSTRING);
                   field = new SFString();
                   {if (true) return field;}
      break;
    case SFTIME:
      jj_consume_token(SFTIME);
                   field = new SFTime();
                   {if (true) return field;}
      break;
    case SFVEC2F:
      jj_consume_token(SFVEC2F);
                   field = new SFVec2f();
                   {if (true) return field;}
      break;
    case SFVEC3F:
      jj_consume_token(SFVEC3F);
                   field = new SFVec3f();
                   {if (true) return field;}
      break;
    case MFCOLOR:
      jj_consume_token(MFCOLOR);
                   field = new MFColor();
                   {if (true) return field;}
      break;
    case MFFLOAT:
      jj_consume_token(MFFLOAT);
                   field = new MFFloat();
                   {if (true) return field;}
      break;
    case MFINT32:
      jj_consume_token(MFINT32);
                   field = new MFInt32();
                   {if (true) return field;}
      break;
    case MFNODE:
      jj_consume_token(MFNODE);
                   field = new MFNode();
                   {if (true) return field;}
      break;
    case MFROTATION:
      jj_consume_token(MFROTATION);
                   field = new MFRotation();
                   {if (true) return field;}
      break;
    case MFSTRING:
      jj_consume_token(MFSTRING);
                   field = new MFString();
                   {if (true) return field;}
      break;
    case MFTIME:
      jj_consume_token(MFTIME);
                   field = new MFTime();
                   {if (true) return field;}
      break;
    case MFVEC2F:
      jj_consume_token(MFVEC2F);
                   field = new MFVec2f();
                   {if (true) return field;}
      break;
    case MFVEC3F:
      jj_consume_token(MFVEC3F);
                   field = new MFVec3f();
                   {if (true) return field;}
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Field genField() throws ParseException {
    Token t;
    Field field;
    String name;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SFBOOL:
      jj_consume_token(SFBOOL);
      name = FieldId();
                   field = new SFBool(false);
                   field.fieldName = name;
                   _SFBool((SFBool)field);
                   {if (true) return field;}
      break;
    case SFCOLOR:
      jj_consume_token(SFCOLOR);
      name = FieldId();
                   field = new SFColor(0.0f,1.0f,0.0f);
                   field.fieldName = name;
                   _SFColor((SFColor)field);
                   {if (true) return field;}
      break;
    case SFFLOAT:
      jj_consume_token(SFFLOAT);
      name = FieldId();
                   field = new SFFloat(0.0f);
                   field.fieldName = name;
                   _SFFloat((SFFloat)field);
                   {if (true) return field;}
      break;
    case SFINT32:
      jj_consume_token(SFINT32);
      name = FieldId();
                   field = new SFInt32(0);
                   field.fieldName = name;
                   _SFInt32((SFInt32)field);
                   {if (true) return field;}
      break;
    case SFNODE:
      jj_consume_token(SFNODE);
      name = FieldId();
                   field = new SFNode();
                   field.fieldName = name;
                   _SFNode((SFNode)field);
                   {if (true) return field;}
      break;
    case SFROTATION:
      jj_consume_token(SFROTATION);
      name = FieldId();
                   field = new SFRotation();
                   field.fieldName = name;
                   _SFRotation((SFRotation)field);
                   {if (true) return field;}
      break;
    case SFSTRING:
      jj_consume_token(SFSTRING);
      name = FieldId();
                   field = new SFString();
                   field.fieldName = name;
                   _SFString((SFString)field);
                   {if (true) return field;}
      break;
    case SFTIME:
      jj_consume_token(SFTIME);
      name = FieldId();
                   field = new SFTime();
                   field.fieldName = name;
                   _SFTime((SFTime)field);
                   {if (true) return field;}
      break;
    case SFVEC2F:
      jj_consume_token(SFVEC2F);
      name = FieldId();
                   field = new SFVec2f();
                   field.fieldName = name;
                   _SFVec2f((SFVec2f)field);
                   {if (true) return field;}
      break;
    case SFVEC3F:
      jj_consume_token(SFVEC3F);
      name = FieldId();
                   field = new SFVec3f();
                   field.fieldName = name;
                   _SFVec3f((SFVec3f)field);
                   {if (true) return field;}
      break;
    case MFCOLOR:
      jj_consume_token(MFCOLOR);
      name = FieldId();
                   field = new MFColor();
                   field.fieldName = name;
                   _MFColor((MFColor)field);
                   {if (true) return field;}
      break;
    case MFFLOAT:
      jj_consume_token(MFFLOAT);
      name = FieldId();
                   field = new MFFloat();
                   field.fieldName = name;
                   _MFFloat((MFFloat)field);
                   {if (true) return field;}
      break;
    case MFINT32:
      jj_consume_token(MFINT32);
      name = FieldId();
                   field = new MFInt32();
                   field.fieldName = name;
                   _MFInt32((MFInt32)field);
                   {if (true) return field;}
      break;
    case MFNODE:
      jj_consume_token(MFNODE);
      name = FieldId();
                   field = new MFNode();
                   field.fieldName = name;
                   _MFNode((MFNode)field);
                   {if (true) return field;}
      break;
    case MFROTATION:
      jj_consume_token(MFROTATION);
      name = FieldId();
                   field = new MFRotation();
                   field.fieldName = name;
                   _MFRotation((MFRotation)field);
                   {if (true) return field;}
      break;
    case MFSTRING:
      jj_consume_token(MFSTRING);
      name = FieldId();
                   field = new MFString();
                   field.fieldName = name;
                   _MFString((MFString)field);
                   {if (true) return field;}
      break;
    case MFTIME:
      jj_consume_token(MFTIME);
      name = FieldId();
                   field = new MFTime();
                   field.fieldName = name;
                   _MFTime((MFTime)field);
                   {if (true) return field;}
      break;
    case MFVEC2F:
      jj_consume_token(MFVEC2F);
      name = FieldId();
                   field = new MFVec2f();
                   field.fieldName = name;
                   _MFVec2f((MFVec2f)field);
                   {if (true) return field;}
      break;
    case MFVEC3F:
      jj_consume_token(MFVEC3F);
      name = FieldId();
                   field = new MFVec3f();
                   field.fieldName = name;
                   _MFVec3f((MFVec3f)field);
                   {if (true) return field;}
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Id non-terminals
  final public String NodeNameId() throws ParseException {
                      String id;
    id = Id();
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

  final public String NodeTypeId() throws ParseException {
                      String id;
    id = Id();
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

  final public String FieldId() throws ParseException {
                   String id;
    id = Id();
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

  final public String EventOutId() throws ParseException {
                      String id;
    id = Id();
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

  final public String EventInId() throws ParseException {
                     String id;
    id = Id();
                {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

  final public String Id() throws ParseException {
    jj_consume_token(ID);
                  {if (true) return new String(token.image);}
    throw new Error("Missing return statement in function");
  }

// Base non-terminals used by VRML field types
  final public String String() throws ParseException {
    jj_consume_token(STRING_LITERAL);
                      {if (true) return token.image.substring(1, token.image.length()-1);}
    throw new Error("Missing return statement in function");
  }

  final public void MultString(Vector stringVec) throws ParseException {
    jj_consume_token(STRING_LITERAL);
        stringVec.addElement(
                new String(token.image.substring(1,token.image.length()-1)));
  }

  final public int IntegerVal() throws ParseException {
    jj_consume_token(NUMBER_LITERAL);
        try {
            {if (true) return Integer.parseInt(token.image);}
            //TODO: worry about HEX (check for start with 0x)
        } catch (NumberFormatException ee) {
            {if (true) throw new ParseException("Can't parse integer");}
        }
    throw new Error("Missing return statement in function");
  }

  final public float FloatVal() throws ParseException {
    jj_consume_token(NUMBER_LITERAL);
        try {
            {if (true) return Float.parseFloat(token.image);}
        } catch (NumberFormatException ee) {
            {if (true) throw new ParseException("Can't parse float");}
        }
    throw new Error("Missing return statement in function");
  }

  final public double DoubleVal() throws ParseException {
               int intVal;
    jj_consume_token(NUMBER_LITERAL);
        try {
            {if (true) return Double.parseDouble(token.image);}
        } catch (NumberFormatException ee) {
            {if (true) throw new ParseException("Can't parse double");}
        }
    throw new Error("Missing return statement in function");
  }

  final public void MultIntegerVal() throws ParseException {
                          int val;
    val = IntegerVal();
        loader.intBuf.add(val);
  }

  final public void MultFloatVal() throws ParseException {
                        float val;
    val = FloatVal();
        loader.floatBuf.add(val);
  }

  final public void MultDoubleVal() throws ParseException {
                         double val;
    val = DoubleVal();
        loader.doubleBuf.add(val);
  }

  final public void _MultNode(Vector nodeVec) throws ParseException {
                                  BaseNode val;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEF:
    case USE:
    case ID:
      val = NodeStatement();
        nodeVec.addElement(val);
      break;
    case NULL:
      jj_consume_token(NULL);
        nodeVec.addElement(null);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// VRML field types.  Takes in a field of the data type and initializes the 
// value
  final public void _SFString(SFString field) throws ParseException {
    field.string = String();
  }

  final public void _MFString(MFString field) throws ParseException {
  String val; Vector stringVec = new Vector(); String[] strings;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      val = String();
        strings = new String[1];
        strings[0] = val;
        field.strings = strings;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_8;
        }
        MultString(stringVec);
      }
      jj_consume_token(RBRACKET);
        strings = new String[stringVec.size()];
        stringVec.copyInto(strings);
        field.strings = strings;
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _SFBool(SFBool field) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE_UC_LITERAL:
      jj_consume_token(TRUE_UC_LITERAL);
          field.value = true;
      break;
    case TRUE_LC_LITERAL:
      jj_consume_token(TRUE_LC_LITERAL);
          field.value = true;
      break;
    case FALSE_UC_LITERAL:
      jj_consume_token(FALSE_UC_LITERAL);
          field.value = false;
      break;
    case FALSE_LC_LITERAL:
      jj_consume_token(FALSE_LC_LITERAL);
          field.value = false;
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _SFInt32(SFInt32 field) throws ParseException {
    field.value = IntegerVal();

  }

//void _SFImage(SFImage field): { System.err.println("SFImage nyi, use ImageTexture"); }
//{
     //field.width = IntegerVal() field.height = IntegerVal() field.depth = IntegerVal() 
     //field.pixels = MultImByte( field.width, field.heith, field.depth ) {  }
//}

//byte[] MultImByte( int w, int h, int d ) { byte[] pix = new byte[w*h*d] }
  final public void _SFFloat(SFFloat field) throws ParseException {
    field.value = FloatVal();

  }

  final public void _SFTime(SFTime field) throws ParseException {
    field.time = FloatVal();

  }

  final public void _SFRotation(SFRotation field) throws ParseException {
                                      float[] vec = new float[4];
    vec[0] = FloatVal();
    vec[1] = FloatVal();
    vec[2] = FloatVal();
    vec[3] = FloatVal();
        field.rot = vec;
  }

  final public void _SFVec2f(SFVec2f field) throws ParseException {
                                float[] vec = new float[2];
    vec[0] = FloatVal();
    vec[1] = FloatVal();
        field.vec2f = vec;
  }

  final public void _SFVec3f(SFVec3f field) throws ParseException {
                                float[] vec = new float[3];
    vec[0] = FloatVal();
    vec[1] = FloatVal();
    vec[2] = FloatVal();
        field.value = vec;
  }

  final public void _SFColor(SFColor field) throws ParseException {
                                float[] color = new float[3];
    color[0] = FloatVal();
    color[1] = FloatVal();
    color[2] = FloatVal();
        field.color = color;
  }

  final public void _MFFloat(MFFloat field) throws ParseException {
    float val;
    float[] values;
    double start = 0.0;
    loader.floatBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      val = FloatVal();
        values = new float[1];
        values[0] = val;
        field.mfloat = values;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_9;
        }
        MultFloatVal();
      }
      jj_consume_token(RBRACKET);
        values = new float[loader.floatBuf.size];
        System.arraycopy(loader.floatBuf.array, 0, values, 0,
            loader.floatBuf.size);
        field.mfloat = values;
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFTime(MFTime field) throws ParseException {
    double val;
    double[] values;
    loader.doubleBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      val = DoubleVal();
        values = new double[1];
        values[0] = val;
        field.time = values;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_10;
        }
        MultDoubleVal();
      }
      jj_consume_token(RBRACKET);
        values = new double[loader.doubleBuf.size];
        System.arraycopy(loader.doubleBuf.array, 0, values, 0,
            loader.doubleBuf.size);
        field.time = values;
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFVec2f(MFVec2f field) throws ParseException {
    float val;
    float[] values;
    float x, y;
    double start = 0.0;
    loader.floatBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      x = FloatVal();
      y = FloatVal();
        values = new float[2];
        values[0] = x;
        values[1] = y;
        field.vals = values;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_11;
        }
        MultFloatVal();
      }
      jj_consume_token(RBRACKET);
        int numVecs = loader.floatBuf.size / 2;
        values = new float[numVecs * 2];
        System.arraycopy(loader.floatBuf.array, 0, values, 0,
            numVecs * 2);
        field.vals = values;
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFVec3f(MFVec3f field) throws ParseException {
    float val;
    float[] values;
    float x, y, z;
    double start = 0.0;
    if (loader.timing) {
        start = Time.getNow();
    }
    loader.floatBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      x = FloatVal();
      y = FloatVal();
      z = FloatVal();
        field.checkSize(3, false);
        field.size = 3;
        field.value[0] = x;
        field.value[1] = y;
        field.value[2] = z;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[30] = jj_gen;
          break label_12;
        }
        MultFloatVal();
      }
      jj_consume_token(RBRACKET);
        if (loader.timing) {
            double now = Time.getNow();
            loader.MFVec3fParse += now - start;
            start = now;
        }
        int numVecs = loader.floatBuf.size / 3;
        field.checkSize(numVecs * 3, false);
        System.arraycopy(loader.floatBuf.array, 0, field.value, 0,
            numVecs * 3);
        field.size = numVecs * 3;
        if (loader.timing) {
            loader.MFVec3fCopy += Time.getNow() - start;
        }
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFRotation(MFRotation field) throws ParseException {
    float val;
    SFRotation[] values;
    float x, y, z, angle;
    double start = 0.0;
    loader.floatBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      x = FloatVal();
      y = FloatVal();
      z = FloatVal();
      angle = FloatVal();
        values = new SFRotation[1];
        values[0] = new SFRotation(x, y, z, angle);
        field.rots = values;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_13;
        }
        MultFloatVal();
      }
      jj_consume_token(RBRACKET);
        int numRots = loader.floatBuf.size / 4;
        values = new SFRotation[numRots];
        for (int i = 0; i < numRots; i++) {
            x = loader.floatBuf.array[i * 4 + 0];
            y = loader.floatBuf.array[i * 4 + 1];
            z = loader.floatBuf.array[i * 4 + 2];
            angle = loader.floatBuf.array[i * 4 + 3];
            values[i] = new SFRotation(x, y, z, angle);
        }
        field.rots = values;
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFColor(MFColor field) throws ParseException {
    float val;
    float r,g,b;
    float[] values;
    double start = 0.0;
    loader.floatBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      r = FloatVal();
      g = FloatVal();
      b = FloatVal();
        values = new float[3];
        values[0] = r;
        values[1] = g;
        values[2] = b;
        field.vals = values;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_14;
        }
        MultFloatVal();
      }
      jj_consume_token(RBRACKET);
        int numVecs = loader.floatBuf.size / 3;
        values = new float[numVecs * 3];
        System.arraycopy(loader.floatBuf.array, 0, values, 0,
            numVecs * 3);
        field.vals = values;
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFInt32(MFInt32 field) throws ParseException {
    int val;
    int[] values;
    double start = 0.0;
    if (loader.timing) {
        start = Time.getNow();
    }
    loader.intBuf.reset();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER_LITERAL:
      val = IntegerVal();
        field.checkSize(1, false);
        field.value[0] = val;
        field.size = 1;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER_LITERAL:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_15;
        }
        MultIntegerVal();
      }
      jj_consume_token(RBRACKET);
        // a lot of Cosmo Player files carry empty index 
        if ( loader.intBuf.size > 0 ) {
            if (loader.timing) {
                double now = Time.getNow();
                loader.MFInt32Parse += now - start;
                start = now;
            }
            field.checkSize(loader.intBuf.size, false);
            field.size = loader.intBuf.size;
            System.arraycopy(loader.intBuf.array, 0, field.value, 0,
                loader.intBuf.size);
            loader.intBuf.reset();
            if (loader.timing) {
                loader.MFInt32Copy += Time.getNow() - start;
            }
        }
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _SFNode(SFNode field) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEF:
    case USE:
    case ID:
      field.node = NodeStatement();
      break;
    case NULL:
      jj_consume_token(NULL);
        field.node = null;
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void _MFNode(MFNode field) throws ParseException {
    Vector nodeVec = new Vector();
    BaseNode   single;
    BaseNode[] values;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      jj_consume_token(NULL);
        field.nodes = new BaseNode[0];
      break;
    case DEF:
    case USE:
    case ID:
      single = NodeStatement();
       values = new BaseNode[1];
       values[0] = single;
       field.nodes = values;
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DEF:
        case USE:
        case NULL:
        case ID:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_16;
        }
        _MultNode(nodeVec);
      }
      jj_consume_token(RBRACKET);
        values = new BaseNode[nodeVec.size()];
        for (int i = 0; i < nodeVec.size(); i++) {
            // TODO: faster to move through using an enumeration?
            values[i] = (BaseNode)nodeVec.elementAt(i);
        }
        field.nodes = values;
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  public ParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x61c0000,0x61c0000,0xc0000,0x2100000,0x1e00000,0x1e00000,0x61c0000,0x1e00000,0x200,0x1e00000,0x6100000,0x6100000,0x20000000,0x6f00000,0x6f00000,0x20000000,0x20000000,0x20000000,0x80000000,0x80000000,0x100c0000,0x200,0x1200,0x3c000,0x100,0x1100,0x100,0x1100,0x100,0x1100,0x100,0x1100,0x100,0x1100,0x100,0x1100,0x100,0x1100,0x100c0000,0x100c0000,0x100c1000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x40000,0x40000,0x40000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x40000,0x40000,0x0,0x40000,0x40000,0x0,0x0,0x0,0x3ffff,0x3ffff,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x40000,};
   }

  public Parser(java.io.InputStream stream) {
     this(stream, null);
  }
  public Parser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[53];
    for (int i = 0; i < 53; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 41; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 53; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
