package a3test.controller;

import jp.sourceforge.acerola3d.a3.*;
import java.awt.event.*;
import javax.vecmath.*;

public class ChaseControllerTest3 implements Runnable, KeyListener {
    Action3D avatar;
    double theta; //アバタのY軸周りの回転
    volatile int keyCode;
    A3Window w;
    public ChaseControllerTest3() throws Exception {
        w = new A3Window(300,300);
        w.getA3Canvas().addKeyListener(this);
        Action3D a3 = Action3D.load("x-res:///axis.a3");
        w.add(a3);
        avatar = Action3D.load("x-res:///vesma9.a3");
        avatar.setEnableBehavior(true);
        w.setAvatar(avatar);
        w.add(avatar);
        Vector3d lookAt = new Vector3d(0.0,0.0,0.0);
        Vector3d camera = new Vector3d(0.0,5.2,-3.0);
        Vector3d up = new Vector3d(0.0,1.0,0.0);
        ChaseController c = new ChaseController(lookAt,camera,up,1.0);
        w.setA3Controller(c);
        Thread t = new Thread(this);
        t.start();
    }
    public void run() {
        while (true) {
            if (keyCode==KeyEvent.VK_UP) {
                Vector3d dv = new Vector3d(Math.sin(theta),0.0,Math.cos(theta));
                dv.add(avatar.getLoc());
                avatar.setLoc(dv);
            } else if (keyCode==KeyEvent.VK_DOWN) {
                Vector3d dv = new Vector3d(-Math.sin(theta),0.0,-Math.cos(theta));
                dv.add(avatar.getLoc());
                avatar.setLoc(dv);
            } else if (keyCode==KeyEvent.VK_RIGHT) {
                theta = theta - 0.1;
                avatar.setRot(0.0,theta,0.0);
            } else if (keyCode==KeyEvent.VK_LEFT) {
                theta = theta + 0.1;
                avatar.setRot(0.0,theta,0.0);
            }
            try{Thread.sleep(100);}catch(Exception e){;}
        }
    }
    public void keyTyped(KeyEvent e) {;}
    public void keyPressed(KeyEvent e) {keyCode = e.getKeyCode();}
    public void keyReleased(KeyEvent e) {keyCode=0;}
    public static void main(String args[]) throws Exception {
        new ChaseControllerTest3();
    }
}
