package a3test.etc;

import jp.sourceforge.acerola3d.a3.*;

/*
 * replaceShape()のはSharedGroupを使った実装なので
 * Action3D.getNode()が使えない。それでAction3D用の
 * replaceShape()(replaceShapeWithA3())を作った。
 * それのテスト
 */
public class OverwriteShape3 {
    public static void main(String args[]) throws Exception {
        A3Window w = new A3Window(300,300);
        w.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);
        Action3D a3 = new Action3D("x-res:///mannequin.a3");
        a3.setLoc(0.0,-0.5,0.0);

        a3.replaceShapeWithA3("Head.wrl","x-res:///du_head.a3");
        a3.replaceShapeWithA3("Body.wrl","x-res:///du_body.a3");
        a3.replaceShapeWithA3("LeftHand.wrl","x-res:///du_lefthand.a3");

        w.add(a3);
        Thread.sleep(1000);
        a3.change("walk");
        Thread.sleep(1000);
        a3.shapeChange("Head.wrl","kappa");
        Thread.sleep(1000);
        a3.change("default");
        Thread.sleep(1000);
        a3.change("walk");
        Thread.sleep(1000);
        a3.shapeChange("Head.wrl","kintaro");
        Thread.sleep(1000);
        a3.shapeChange("Head.wrl","kappa");
    }
}
