package a3test.subcanvas;

import jp.sourceforge.acerola3d.a3.*;
import javax.swing.JFrame;
import java.awt.*;

public class A3SubCanvasTest {
    public static void main(String args[]) throws Exception {
        A3Canvas mainCanvas = A3Canvas.createA3Canvas(300,300);
        Action3D a3 = new Action3D("x-res:///axis.a3");
        mainCanvas.add(a3);
        mainCanvas.setNavigationMode(A3CanvasInterface.NaviMode.EDIT);

        A3SubCanvas subCanvas = A3SubCanvas.createA3SubCanvas(300,300);
        mainCanvas.addA3SubCanvas(subCanvas);

        JFrame f = new JFrame("A3SubCanvasTest");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLayout(new GridLayout(1,2));
        f.add(mainCanvas);
        f.add(subCanvas);
        f.pack();
        f.setVisible(true);

        subCanvas.setCameraLoc(3.0,0.0,3.0);
        subCanvas.setCameraRot(0.0,Math.PI/4.0,0.0);
    }
}
