package jp.sourceforge.acerola3d.j3dvrml;

import jp.sourceforge.acerola3d.*;
import jp.sourceforge.acerola3d.a3.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URL;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import javax.swing.*;

public class J3DVrml implements ActionListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem resetViewMenuItem;
    JMenuItem snapshotMenuItem;
    JMenu measureMenu;
    JMenuItem measureXZMenuItem;
    JMenuItem measureXYMenuItem;
    JMenuItem measureYZMenuItem;
    JMenuItem measureNoneMenuItem;
    JMenuItem backgroundMenuItem;
    JMenuItem helpMenuItem;
    JMenuItem aboutMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A3Canvas a3canvas;
    JButton resetViewButton;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    A3PHtmlViewer htmlViewer;
    A3PHtmlViewer helpViewer;
    Action3D measure;

    VRML vrml;
    String actionName = "0";
    MyExamController controller;
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public J3DVrml(String args[]) {
        frame = new JFrame("J3DVrml");
        frame.getContentPane().setLayout(new BorderLayout());
        MyVBox baseBox = new MyVBox();
        frame.getContentPane().add(baseBox,BorderLayout.CENTER);

        menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        menuBar.add(Box.createHorizontalGlue());
        configMenu = new JMenu("Config");
        menuBar.add(configMenu);
        consoleMenuItem = new JMenuItem("Console");
        consoleMenuItem.addActionListener(this);
        configMenu.add(consoleMenuItem);
        resetViewMenuItem = new JMenuItem("ResetView");
        resetViewMenuItem.addActionListener(this);
        configMenu.add(resetViewMenuItem);
        snapshotMenuItem = new JMenuItem("Snapshot");
        snapshotMenuItem.addActionListener(this);
        configMenu.add(snapshotMenuItem);
        measureMenu = new JMenu("measure");
        configMenu.add(measureMenu);
        measureXZMenuItem = new JMenuItem("measure XZ");
        measureXZMenuItem.addActionListener(this);
        measureMenu.add(measureXZMenuItem);
        measureXYMenuItem = new JMenuItem("measure XY");
        measureXYMenuItem.addActionListener(this);
        measureMenu.add(measureXYMenuItem);
        measureYZMenuItem = new JMenuItem("measure YZ");
        measureYZMenuItem.addActionListener(this);
        measureMenu.add(measureYZMenuItem);
        measureNoneMenuItem = new JMenuItem("measure None");
        measureNoneMenuItem.addActionListener(this);
        measureMenu.add(measureNoneMenuItem);
        backgroundMenuItem = new JMenuItem("Background");
        backgroundMenuItem.addActionListener(this);
        configMenu.add(backgroundMenuItem);
        helpMenuItem = new JMenuItem("help");
        helpMenuItem.addActionListener(this);
        configMenu.add(helpMenuItem);
        aboutMenuItem = new JMenuItem("about");
        aboutMenuItem.addActionListener(this);
        configMenu.add(aboutMenuItem);

        consoleFrame = new JFrame("Console");
        consoleFrame.getContentPane().setLayout(new BorderLayout());
        MyVBox b = new MyVBox();
        consoleTextArea = new JTextArea(20,60);
        consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(consoleTextArea);
        b.myAdd(sp,1.0);
        clearConsoleButton = new JButton("Clear");
        clearConsoleButton.addActionListener(this);
        b.myAdd(clearConsoleButton,0.0);
        consoleFrame.getContentPane().add(b,BorderLayout.CENTER);
        consoleFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(consoleTextArea,systemOut);
        PrintStream ps = new PrintStream(jtaos,true);
        System.setOut(ps);
        System.setErr(ps);
        consoleFrame.pack();
        
        MyHBox addressBox = new MyHBox();
        baseBox.myAdd(addressBox,0.0);
        addressBox.myAdd(new JLabel("URL:"),0.0);
        urlTextField = new JTextField();
        try {
            File f = null;
            if ((args!=null)&&(args.length==2)&&(args[0].equals("-open")))
                f  = new File(args[1]);
            else
                f = new File(args[0]);
            urlTextField.setText(f.toURI().toString());
        } catch (Exception e) {
            urlTextField.setText("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/Acerola3D.wrl");
        }
        urlTextField.addActionListener(this);
urlTextField.setMaximumSize(new Dimension(3000,30));
        addressBox.myAdd(urlTextField,1.0);
        refButton = new JButton("ref");
        refButton.addActionListener(this);
        addressBox.myAdd(refButton,0.0);

        MyHBox mainBox = new MyHBox();
        baseBox.myAdd(mainBox,1.0);
        a3canvas = A3Canvas.createA3Canvas(300,300);
        controller = new MyExamController();
        a3canvas.setA3Controller(controller);
        mainBox.myAdd(a3canvas,1.0);

        MyVBox controlBox = makeControlBox();
        mainBox.myAdd(controlBox,0.0);

        statusBarLabel = new JLabel("Status:");
        baseBox.myAdd(statusBarLabel,0.0);

        try {
            measure = new Action3D("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/measure.a3");
        } catch (Exception e) {
            e.printStackTrace();
        }

        frame.setTransferHandler(new VrmlTransferHandler(this));
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                frame.dispose();
                System.exit(0);
            }
        });
        frame.setSize(700,500);
        frame.setVisible(true);

        htmlViewer = new A3PHtmlViewer(frame);
        helpViewer = new A3PHtmlViewer(null);

        Runnable r = new Runnable() {
            public void run() {
                loadVRML();
            }
        };
        executor.schedule(r,100,TimeUnit.MILLISECONDS);
    }

    MyVBox makeControlBox() {
        MyVBox controlBox = new MyVBox();

        resetViewButton = new JButton("Reset View");
        resetViewButton.addActionListener(this);
        controlBox.myAdd(resetViewButton,0.0);

        controlBox.myAdd(new JLabel("Left drag: rotation"),0.0);
        controlBox.myAdd(new JLabel("Center drag: translation"),0.0);
        controlBox.myAdd(new JLabel("Right drag: scale"),0.0);

        controlBox.myAdd(Box.createVerticalGlue(),1.0);

        String buildDate = null;
        try {
            URL url = getClass().getClassLoader().getResource("buildDate.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(),"UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildDate = br.readLine();
        } catch (Exception e) {
            buildDate = "???";
        }
        controlBox.myAdd(new JLabel("build date:"),0.0);
        controlBox.myAdd(new JLabel("   "+buildDate),0.0);

        return controlBox;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == urlTextField) {
            Runnable r = new Runnable() {
                public void run() {
                    loadVRML();
                }
            };
            executor.schedule(r,100,TimeUnit.MILLISECONDS);
        } else if (ae.getSource() == resetViewButton) {
        	controller.reset(vrml);
        } else if (ae.getSource() == refButton) {
            ref();
        } else if (ae.getSource() == consoleMenuItem) {
            consoleFrame.setVisible(true);
        } else if (ae.getSource() == clearConsoleButton) {
            consoleTextArea.setText("");
        } else if (ae.getSource() == resetViewMenuItem) {
        	controller.reset(vrml);
        } else if (ae.getSource() == snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                a3canvas.saveImage(f);
            } catch (Exception e) {
                System.out.println("A3Viewer:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == measureXZMenuItem) {
            measure.setRot(-Math.PI/2.0,0.0,0.0);
            a3canvas.add(measure);
        } else if (ae.getSource() == measureXYMenuItem) {
            measure.setRot(0.0,0.0,0.0);
            a3canvas.add(measure);
        } else if (ae.getSource() == measureYZMenuItem) {
            measure.setRot(0.0,Math.PI/2.0,0.0);
            a3canvas.add(measure);
        } else if (ae.getSource() == measureNoneMenuItem) {
            a3canvas.del(measure);
        } else if (ae.getSource() == backgroundMenuItem){
            setBackground();
        } else if (ae.getSource() == helpMenuItem){
            openHelp();
        } else if (ae.getSource() == aboutMenuItem){
            openAbout();
        } else {
            System.out.append("gaha???");
        }
    }

    void loadVRML() {
        statusBarLabel.setText("Status: Loading ... ");
        statusBarLabel.repaint();
        if (vrml!=null)
            a3canvas.del(vrml);
        String urlString = urlTextField.getText();
        try {
            A23.initA23();
            VRML.clearCash();
            vrml = VRML.load(urlString);
            controller.reset(vrml);
        } catch(Exception e) {
            System.out.println("J3DVrml.loadVRML. error!");
            e.printStackTrace();
        }
        a3canvas.add(vrml);

        vrml.setLocImmediately(0.0,0.0,0.0);
        vrml.setQuatImmediately(0.0,0.0,0.0,1.0);
        vrml.setScaleImmediately(1.0);

        Runnable r = new Runnable() {
            public void run() {
                controller.reset(vrml);
            }
        };
        executor.schedule(r,100,TimeUnit.MILLISECONDS);

        statusBarLabel.setText("Status: Loading ... done.");
    }
    void loadVRML(File f) throws Exception {
        urlTextField.setText(f.toURI().toURL().toString());
        Runnable r = new Runnable() {
            public void run() {
                loadVRML();
            }
        };
        executor.schedule(r,100,TimeUnit.MILLISECONDS);
    }

    void ref() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        int returnVal = fileChooser.showOpenDialog(frame);
        if(returnVal != JFileChooser.APPROVE_OPTION)
            return;

        File f = fileChooser.getSelectedFile();
        URL url = null;
        try{url=new URL(f.toURI().toString());}catch(Exception e){;}
        if (url == null)
            return;
        urlTextField.setText(url.toExternalForm());

        Runnable r = new Runnable() {
            public void run() {
                loadVRML();
            }
        };
        executor.schedule(r,100,TimeUnit.MILLISECONDS);
    }
    void setBackground() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        int returnVal = fileChooser.showOpenDialog(frame);
        if (returnVal != JFileChooser.APPROVE_OPTION)
            return;

        File f = fileChooser.getSelectedFile();
        URL url = null;
        try{url=new URL(f.toURI().toString());}catch(Exception e){;}
        if (url == null)
            return;
        Action3D a = null;
        try{
            a = Action3D.load(url);
        } catch(Exception e) {
            e.printStackTrace();
        }
        if (a!=null)
            a3canvas.setBackground(a);
    }

    void openHelp() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/ja/help.html");
        } catch(Exception e) {
            e.printStackTrace();
        }
        helpViewer.open(url);
    }
    void openAbout() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/j3dvrml/resources/ja/about.html");
        } catch(Exception e) {
            e.printStackTrace();
        }
        htmlViewer.open(url);
    }

    public static void main(String args[]) {
        // セキュリティマネージャが、
        // LinuxのJava Web Startの時だけ
        // Exceptionを出すので、とりあえずnullに
        // しておく。
        System.setSecurityManager(null);
        final String argsCopy[] = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new J3DVrml(argsCopy);
            }
        });
    }
}
