package net.y3n20u.aeszip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import static net.y3n20u.aeszip.CommonValues.*;

public class MacFilterOutputStream extends FilterOutputStream {
	
	private Mac _authenticationMac;
	private CRC32 _crc;
	
	public MacFilterOutputStream(OutputStream out) {
		super(out);
		try {
			_authenticationMac = Mac.getInstance(AUTH_MAC_ALGORITHM);
		} catch (NoSuchAlgorithmException e) {
			// FIXME Auto-generated catch block
			throw new RuntimeException(e);
		}
		_crc = new CRC32();
	}
	
	public long getCrc() {
		return _crc.getValue();
	}

	public byte[] getAuthenticationCode() {
		return Arrays.copyOf(_authenticationMac.doFinal(), LENGTH_AUTHENTICATION_CODE);
	}

	public void init(byte[] authenticationKey) {
		Key authKey = new SecretKeySpec(authenticationKey, AUTH_MAC_ALGORITHM);
		try {
			_authenticationMac.init(authKey);
		} catch (InvalidKeyException e) {
			// FIXME Auto-generated catch block
			throw new RuntimeException(e);
		}
		_crc.reset();
	}
	
	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		this.out.write(b, off, len);
		_crc.update(b, off, len);
		_authenticationMac.update(b, off, len);
	}
}