//
//  AfficheurController.m
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "HotKeyedApplication.h"
#import "AfficheurController.h"
#import "TwitterAPI.h"
#import "JaikuAPI.h"
#import "TumblrAPI.h"
#import "GrowlNotifier.h"
#import "TinyURL.h"
#import <OgreKit/OgreKit.h>

@implementation AfficheurController

NSString*	Afficheur					= @"Afficheur";

NSString*	GrowlAfficheurNotify		= @"AfficheurNotify";
NSString*	GrowlAfficheurTwitterNotify	= @"AfficheurTwitterNotify";
NSString*	GrowlAfficheurJaikuNotify	= @"AfficheurJaikuNotify";
NSString*	GrowlAfficheurTumblrNotify	= @"AfficheurTumblrNotify";
NSString*	GrowlAfficheurWassrNotify	= @"AfficheurWassrNotify";
NSString*	GrowlAfficheurNowaNotify	= @"AfficheurNowaNotify";
NSString*	GrowlAfficheurFrepaNotify	= @"AfficheurFrepaNotify";

- (AfficheurController *)init
{
	self = [super init];
	if (self)
	{
		NSLog(@"%@#init", [self class]);
		_prefs = [[[AfficheurPreferences alloc] init] retain];
		_leopard = NO;
		_hotKeyRef = nil;
		SInt32 gestalt;
		if (!Gestalt(gestaltSystemVersion, &gestalt))
		{
			NSLog(@"%@#init: gestalt = %02X", [self class], gestalt);
			if (gestalt >= 0x1050)
			{
				_leopard = YES;
			}
		}
	}
	return self;
}

- (void)dealloc
{
	[_prefs release];
	[super dealloc];
}

- (void)awakeFromNib
{
	NSLog(@"%@#awakeFromNib", [self class]);
	[_window setAlphaValue:0.0];
//	[_panel setLevel:
//	 ([_prefs generalFloatingWindow] ? NSFloatingWindowLevel : NSNormalWindowLevel)];
	NSLog(@"[_panel level] = %d", [_panel level]);
	NSLog(@"NSNormalWindowLevel = %d", NSNormalWindowLevel);
	NSLog(@"NSFloatingWindowLevel = %d", NSFloatingWindowLevel);
}

- (void)unregisterHotKey
{
	if (_hotKeyRef)
	{
		[[HotKeyedApplication sharedApplication] unregisterHotKey:_hotKeyRef];
		_hotKeyRef = nil;
	}
}

- (void)registerHotKey
{
	UInt32 keyCode = [_prefs generalHotKey];
	[self unregisterHotKey];
	if (keyCode != -1)
	{
		_hotKeyRef = [[HotKeyedApplication sharedApplication] registerHotKey:[KeyEquivView keyCodeForKeyCode:keyCode]
																withModifier:[KeyEquivView modifierKeyForKeyCode:keyCode]
																	  target:self
																	selector:@selector(hotKey)];
	}
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
	NSLog(@"%@#applicationDidFinishLaunching", [self class]);
	NSLog(@"%@", [[NSProcessInfo processInfo] arguments]);
	NSStatusBar*	statusBar = [NSStatusBar systemStatusBar];
	//NSLog(@"%@#applicationDidFinishLaunching statusBar:%@", [self class], statusBar);
	NSStatusItem*	statusItem = [[statusBar statusItemWithLength:24/*NSVariableStatusItemLength*/] retain];
	//NSLog(@"%@#applicationDidFinishLaunching statusItem:%@", [self class], statusItem);
	NSImage* icon = [NSImage imageNamed:@"NSActionTemplate"];
	//NSLog(@"%@#applicationDidFinishLaunching icon:%@", [self class], icon);
	[statusItem setTitle:nil];
	[statusItem setImage:icon];
	[statusItem setHighlightMode:YES];
	[statusItem setMenu:_menu];
	[statusItem setEnabled:YES];
	[_growl initWithDelegate:self];
	[_growl startWithApplicationName:@"Afficheur"
					  notifications:[NSArray arrayWithObjects:
									 GrowlAfficheurNotify,
									 GrowlAfficheurTwitterNotify,
									 GrowlAfficheurJaikuNotify,
									 GrowlAfficheurTumblrNotify,
									 GrowlAfficheurWassrNotify,
									 GrowlAfficheurNowaNotify,
									 GrowlAfficheurFrepaNotify,
									 nil]
			   dafaultNotifications:nil
							   icon:nil];
	[self registerHotKey];
	[NSApp activateIgnoringOtherApps:YES];
	NSLog(@"%@#applicationDidFinishLaunching: %@", [self class],
		  [[NSBundle mainBundle] bundlePath]);
}

- (void)applicationWillTerminate:(NSNotification *)aNotification
{
	NSLog(@"%@#applicationWillTerminate: %@", [self class], aNotification);
	[_prefs applicationWillTerminate];
}

- (void)_applicationWillBecomeActive:(NSNotification *)aNotification
{
	NSLog(@"%@#applicationWillBecomeActive: %@", [self class], aNotification);
}

- (void)applicationDidBecomeActive:(NSNotification *)aNotification
{
	NSLog(@"%@#applicationDidBecomeActive: %@", [self class], aNotification);
	[self onOpen:self];
}

- (void)growlIsReady
{
	NSLog(@"%@#growlIsReady", [self class]);
}

- (void)growlNotificationWasClicked:(id)clickContext
{
	NSLog(@"%@#growlNotificationWasClicked: %@", [self class], clickContext);
}

- (void)growlNotificationTimedOut:(id)clickContext
{
	NSLog(@"%@#growlNotificationTimedOut: %@", [self class], clickContext);
}

- (BOOL) isURL:(NSString *)string
{
	return ([string rangeOfRegularExpressionString:@"(?:http|https)://"].length != 0);
}

- (void)performThread:(SEL)selector withStatus:(NSString *)status
{
#if 0
	if (_leopard && [self respondsToSelector:@selector(performSelectorInBackground:withObject:)])
	{
		NSLog(@"%@#performThread:%@ %@",
			  [self class],
			  NSStringFromSelector(selector),
			  @"performSelectorInBackground");
		[self performSelectorInBackground:selector
							   withObject:status];
	}
	else
	{
#endif
		NSLog(@"%@#performThread:%@ %@",
			  [self class],
			  NSStringFromSelector(selector),
			  @"detachNewThreadSelector");
		[NSThread detachNewThreadSelector:selector
								 toTarget:self
							   withObject:status];
#if 0
	}
#endif
}

- (NSString *)determineResponse:(NSArray *)response
{
	NSString* description = @"Success";
	if ([response count] > ResultDescription)
	{
		id res = [response objectAtIndex:ResultDescription];
		if (![res isKindOfClass:[NSNull class]])
		{
			description = [NSString stringWithFormat:@"%@", res];
		}
	}
	return description;
}

- (void)notifyWithTitle:(NSString *)title
			description:(NSString *)description
	   notificationName:(NSString *)notificationName
			   iconData:(NSData *)iconData
{
	[_growl notifyWithTitle:title
			   description:description
		  notificationName:notificationName
				  iconData:iconData
				  priority:0
				  isSticky:false
			  clickContext:nil];
}

- (void)postTwitter:(NSString *)status
{
	[self performThread:@selector(performPostTwitter:)
			 withStatus:status];
}

- (void)performPostTwitter:(NSString *)status
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	TwitterAPI *api = [[[TwitterAPI alloc] initWithObjectsAndKeys:
						[_prefs accountTwitterUser], TwitterUser,
						[_prefs accountTwitterPass], TwitterPass,
						Afficheur, TwitterSource,
						nil] autorelease];
	NSArray *res = [api update:status];
	NSString* description = [self determineResponse:res];
	NSLog(@"%@#performPostTwitter: %@", [self class], description);
	[self notifyWithTitle:@"Post to Twitter"
			  description:description
		 notificationName:GrowlAfficheurTwitterNotify
				 iconData:nil];
	[pool release];
}

- (void)postJaiku:(NSString *)status
{
	[self performThread:@selector(performPostJaiku:)
			 withStatus:status];
}

- (void)performPostJaiku:(NSString *)status
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	JaikuAPI *api = [[[JaikuAPI alloc] initWithObjectsAndKeys:
					  [_prefs accountJaikuUser], JaikuUser,
					  [_prefs accountJaikuPass], JaikuPass,
					  nil] autorelease];
	NSArray *res = [api update:status];
	NSString* description = [self determineResponse:res];
	NSLog(@"%@#performPostJaiku: %@", [self class], description);
	[self notifyWithTitle:@"Post to Jaiku"
			  description:description
		 notificationName:GrowlAfficheurJaikuNotify
				 iconData:nil];
	[pool release];
}

- (void)postTumblr:(NSString *)status
{
	[self performThread:@selector(performPostTumblr:)
			 withStatus:status];
}

- (void)performPostTumblr:(NSString *)status
{
	NSLog(@"%@#performPostTumblr: %@", [self class], status);
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	if ([self isURL:status])
	{
		NSString *url = nil;
		OGRegularExpression *regex = [OGRegularExpression
									  regularExpressionWithString:@"((?:http|https)://\\S+)"
									  options:OgreIgnoreCaseOption | OgreMultilineOption];
		// マッチ結果の列挙子の生成
		OGRegularExpressionMatch *match = [regex matchInString:status];
		NSString *substr = [match matchedString];
		if (substr)
		{
			url = substr;
		}
		regex = [OGRegularExpression
				 regularExpressionWithString:@"^(.*)\\s+(?:http|https)://"
				 options:OgreIgnoreCaseOption | OgreMultilineOption];
		// マッチ結果の列挙子の生成
		match = [regex matchInString:status];
		NSString *title = [match substringAtIndex:1];
		NSLog(@"%@#performPostTumblr: url = %@", [self class], url);
		NSLog(@"%@#performPostTumblr: title = %@", [self class], title);
		if (url)
		{
			TumblrAPI *api = [[[TumblrAPI alloc] initWithObjectsAndKeys:
							   [_prefs accountTumblrUser], TumblrUser,
							   [_prefs accountTumblrPass], TumblrPass,
							   Afficheur, TumblrGenerator,
							   nil] autorelease];
			NSArray *res = [api createLink:url title:title];
			NSString* description = [self determineResponse:res];
			NSLog(@"%@#performPostTumblr: %@", [self class], description);
			[self notifyWithTitle:@"Post to Tumblr"
					  description:description
				 notificationName:GrowlAfficheurTumblrNotify
						 iconData:nil];
		}
	}
	[pool release];
}

- (void)postWassr:(NSString *)status
{
	[self performThread:@selector(performPostWassr:)
			 withStatus:status];
}

- (void)performPostWassr:(NSString *)status
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	TwitterAPI *api = [[[TwitterAPI alloc] initWithObjectsAndKeys:
						@"api.wassr.jp", TwitterHost,
						@"http://api.wassr.jp/statuses", TwitterURL,
						[_prefs accountWassrUser], TwitterUser,
						[_prefs accountWassrPass], TwitterPass,
						Afficheur, TwitterSource,
						nil] autorelease];
	NSArray *res = [api update:status];
	NSString* description = [self determineResponse:res];
	NSLog(@"%@#performPostWassr: %@", [self class], description);
	[self notifyWithTitle:@"Post to Wassr"
			  description:description
		 notificationName:GrowlAfficheurWassrNotify
				 iconData:nil];
	[pool release];
}

- (void)postNowa:(NSString *)status
{
	[self performThread:@selector(performPostNowa:)
			 withStatus:status];
}

- (void)performPostNowa:(NSString *)status
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	TwitterAPI *api = [[[TwitterAPI alloc] initWithObjectsAndKeys:
						@"api.nowa.jp", TwitterHost,
						@"http://api.nowa.jp/statuses", TwitterURL,
						[_prefs accountNowaUser], TwitterUser,
						[_prefs accountNowaPass], TwitterPass,
						nil] autorelease];
	NSArray *res = [api update:status];
	NSString* description = [self determineResponse:res];
	NSLog(@"%@#performPostNowa: %@", [self class], description);
	[self notifyWithTitle:@"Post to nowa"
			  description:description
		 notificationName:GrowlAfficheurNowaNotify
				 iconData:nil];
	[pool release];
}

- (void)postFrepa:(NSString *)status
{
	[self performThread:@selector(performPostFrepa:)
			 withStatus:status];
}

- (void)performPostFrepa:(NSString *)status
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	TwitterAPI *api = [[[TwitterAPI alloc] initWithObjectsAndKeys:
						@"www.frepa.livedoor.com", TwitterHost,
						@"http://www.frepa.livedoor.com/statuses", TwitterURL,
						[_prefs accountFrepaUser], TwitterUser,
						[_prefs accountFrepaPass], TwitterPass,
						nil] autorelease];
	NSArray *res = [api update:status];
	NSString* description = [self determineResponse:res];
	NSLog(@"%@#performPostFrepa: %@", [self class], description);
	[self notifyWithTitle:@"Post to frepa"
			  description:description
		 notificationName:GrowlAfficheurFrepaNotify
				 iconData:nil];
	[pool release];
}

- (NSString *)titleOfSafari
{
	NSString *title = nil;
	NSDictionary* errorDict;
	NSAppleEventDescriptor* returnDescriptor = nil;
	NSAppleScript* scriptObject = [[NSAppleScript alloc] initWithSource:
								   @"\
								   tell application \"Safari\"\n\
								   set aTitle to (get name of document 1)\n\
								   end tell"];
	returnDescriptor = [scriptObject executeAndReturnError: &errorDict];
	[scriptObject release];
	if (returnDescriptor)
	{
		NSLog(@"%@#titleOfSafari: %@", [self class], returnDescriptor);
		// 実行が成功
		if ([returnDescriptor descriptorType] != kAENullEvent)
		{
			// スクリプトがAppleScript結果を返す
			if ([returnDescriptor descriptorType] == 'utxt')
			{
				title = [returnDescriptor stringValue];
			}
		}
	}
	NSLog(@"%@#titleOfSafari: '%@'", [self class], title);
	return title;
}

- (NSString *)URLOfSafari
{
	NSString *URL = nil;
	NSDictionary* errorDict;
	NSAppleEventDescriptor* returnDescriptor = nil;
	NSAppleScript* scriptObject = [[NSAppleScript alloc] initWithSource:
								   @"\
								   tell application \"Safari\"\n\
								   set aURL to (get URL of document 1)\n\
								   end tell"];
	returnDescriptor = [scriptObject executeAndReturnError: &errorDict];
	[scriptObject release];
	if (returnDescriptor)
	{
		NSLog(@"%@#URLOfSafari: %@", [self class], returnDescriptor);
		// 実行が成功
		if ([returnDescriptor descriptorType] != kAENullEvent)
		{
			// スクリプトがAppleScript結果を返す
			if ([returnDescriptor descriptorType] == 'utxt')
			{
				URL = [returnDescriptor stringValue];
			}
		}
	}
	NSLog(@"%@#URLOfSafari: '%@'", [self class], URL);
	return URL;
}

- (NSString *)titleAndURLOfSafari
{
	NSString *title = [self titleOfSafari];
	NSString *URL = [self URLOfSafari];
	if (title && URL)
	{
		return [NSString stringWithFormat:@"%@ %@", title, URL];
	}
	else if (title)
	{
		return title;
	}
	else if (URL)
	{
		return URL;
	}
	return nil;
}

- (NSString *)titleOfFirefox
{
	NSString *title = nil;
	NSDictionary* errorDict;
	NSAppleEventDescriptor* returnDescriptor = nil;
	NSAppleScript* scriptObject = [[NSAppleScript alloc] initWithSource:
								   @"\
								   tell application \"Firefox\"\n\
								   set theTitle to get «class pTit» of window 1\n\
								   end tell"];
	returnDescriptor = [scriptObject executeAndReturnError: &errorDict];
	[scriptObject release];
	if (returnDescriptor)
	{
		NSLog(@"%@#titleOfFirefox: %@", [self class], returnDescriptor);
		// 実行が成功
		if ([returnDescriptor descriptorType] != kAENullEvent)
		{
			// スクリプトがAppleScript結果を返す
			if ([returnDescriptor descriptorType] == 'utxt')
			{
				title = [returnDescriptor stringValue];
			}
		}
	}
	else
	{
		NSLog(@"%@#TitleOfFirefox: %@", [self class], errorDict);
	}
	NSLog(@"%@#titleOfFirefox: '%@'", [self class], title);
	return title;
}

- (NSString *)URLOfFirefox
{
	NSString *URL = nil;
	NSDictionary* errorDict;
	NSAppleEventDescriptor* returnDescriptor = nil;
	NSAppleScript* scriptObject = [[NSAppleScript alloc] initWithSource:
								   @"\
								   tell application \"Firefox\"\n\
								   set theURL to «class curl» of window 1\n\
								   end tell"];
	returnDescriptor = [scriptObject executeAndReturnError: &errorDict];
	[scriptObject release];
	if (returnDescriptor)
	{
		NSLog(@"%@#URLOfFirefox: %@", [self class], returnDescriptor);
		// 実行が成功
		if ([returnDescriptor descriptorType] != kAENullEvent)
		{
			// スクリプトがAppleScript結果を返す
			if ([returnDescriptor descriptorType] == 'utxt')
			{
				URL = [returnDescriptor stringValue];
			}
		}
	}
	else
	{
		NSLog(@"%@#URLOfFirefox: %@", [self class], errorDict);
	}
	NSLog(@"%@#URLOfFirefox: '%@'", [self class], URL);
	return URL;
}

- (NSString *)titleAndURLOfFirefox
{
	NSString *title = [self titleOfFirefox];
	NSString *URL = [self URLOfFirefox];
	if (title && URL)
	{
		return [NSString stringWithFormat:@"%@ %@", title, URL];
	}
	else if (title)
	{
		return title;
	}
	else if (URL)
	{
		return URL;
	}
	return nil;
}

- (NSWindow *)witchPanel
{
	return _leopard ? _panelHUD : _panel;
}

- (NSTextField *)witchText
{
	return _leopard ? _textHUD : _text;
}

- (NSTextField *)witchLabel
{
	return _leopard ? _labelHUD : _label;
}

- (void)setTextString:(NSString *)string
{
	NSTextField *textField = [self witchText];
	[textField setStringValue:string];
	[self controlTextDidChange:[NSDictionary dictionaryWithObjectsAndKeys:
								textField, @"object", nil]];
}

- (NSString *)encodeTinyURL:(NSString *)string
			 withCreateFlag:(BOOL)flag
{
	OGRegularExpression *regex = [OGRegularExpression
								  regularExpressionWithString:@"((?:http|https)://\\S+)"
								  options:OgreMultilineOption];
	// マッチ結果の列挙子の生成
	NSEnumerator    *enumerator = [regex matchEnumeratorInString:string];
	OGRegularExpressionMatch    *match;	// マッチ結果
	while ((match = [enumerator nextObject]) != nil) {	// 順番にマッチ結果を得る
		NSString *url = [match matchedString];
		NSLog(@"url = %@", url);
		NSString *tiny = @"http://tinyurl.com/123456";
		if (flag)
		{
			tiny = [TinyURL create:url];
		}
		NSLog(@"tiny = %@", tiny);
		if (tiny)
		{
			OGRegularExpression *replace = [OGRegularExpression
											regularExpressionWithString:url
											options:OgreMultilineOption];
			string = [replace replaceFirstMatchInString:string
											 withString:tiny];
		}
	}
	NSLog(@"= %@", string);
	return string;
}

- (NSString *)encodeTinyURL:(NSString *)string
{
	return [self encodeTinyURL:string withCreateFlag:YES];
}

- (void)doAfficheur:(NSString *)status
{
	NSLog(@"%@#doAfficheur", [self class]);
	NSString *encode = [NSString stringWithString:status];
	if ([_prefs generalEncodeTinyURL])
	{
		encode = [self encodeTinyURL:encode];
	}
	NSLog(@"%@#doAfficheur: status = '%@'", [self class], status);
	NSLog(@"%@#doAfficheur: encode = '%@'", [self class], encode);
	if (![status isEqual:@""])
	{
		if ([_prefs postTwitter])
		{
			[self postTwitter:encode];
		}
		if ([_prefs postJaiku])
		{
			[self postJaiku:encode];
		}
		if ([_prefs postTumblr])
		{
			[self postTumblr:status];
		}
		if ([_prefs postWassr])
		{
			[self postWassr:encode];
		}
		if ([_prefs postNowa])
		{
			[self postNowa:encode];
		}
		if ([_prefs postFrepa])
		{
			[self postFrepa:encode];
		}
	}
	[[self witchPanel] orderOut:self];
}

// TextField Delegate

- (void)controlTextDidChange:(NSNotification *)aNotification
{
	//NSLog(@"%@#controlTextDidChange: %@", [self class], aNotification);
	NSString* txt = [[self witchText]  stringValue];
	if (aNotification)
	{
		txt = [[aNotification valueForKey:@"object"]  stringValue];
	}
	NSString* opt = @"";
	if ([_prefs generalEncodeTinyURL] && [self isURL:txt])
	{
		NSString *tiny = [self encodeTinyURL:txt withCreateFlag:NO];
		opt = [NSString stringWithFormat:@" [%u character(s) / %u byte(s)]",
		 [tiny length],
		 [tiny lengthOfBytesUsingEncoding:NSUTF8StringEncoding]
		 ];
	}
	[[self witchLabel] setStringValue:
	 [NSString stringWithFormat:@"%u character(s) / %u byte(s)%@",
	  [txt length],
	  [txt lengthOfBytesUsingEncoding:NSUTF8StringEncoding],
	  opt
	 ]];
}

- (BOOL)control:(NSControl *)control
		 textView:(NSTextView *)textView
doCommandBySelector:(SEL)command
{
	NSString *cmd = NSStringFromSelector(command);
	NSLog(@"%@#control:textView:doCommandBySelector: %@", [self class], cmd);
	if ([cmd isEqual:@"insertNewline:"])
	{
		[self doAfficheur:[[textView textStorage] string]];
	}
	return NO;
}

// IBAction

- (IBAction)onOpen:(id)sender
{
	NSLog(@"%@#onOpen", [self class]);
	NSDictionary *ap = [[NSWorkspace sharedWorkspace] activeApplication];
	if ([[ap valueForKey:@"NSApplicationName"] compare:@"safari"
											   options:NSCaseInsensitiveSearch] == NSOrderedSame)
	{
		NSLog(@"%@#onOpen: Safari!!!", [self class]);
		NSString *title = [self titleAndURLOfSafari];
		if (title)
		{
			[self setTextString:title];
		}
	}
	if ([[ap valueForKey:@"NSApplicationName"] compare:@"firefox"
											   options:NSCaseInsensitiveSearch] == NSOrderedSame)
	{
		NSLog(@"%@#onOpen: Firefox!!!", [self class]);
		NSString *title = [self titleAndURLOfFirefox];
		if (title)
		{
			[self setTextString:title];
		}
	}
	[self controlTextDidChange:nil];
	[[self witchPanel] makeKeyAndOrderFront:self];
	[NSApp activateIgnoringOtherApps : YES];
}

- (void)endPreferences
{
	NSLog(@"%@#endPreferences", [self class]);
	[self registerHotKey];
}

- (IBAction)onPreferences:(id)sender
{
	NSLog(@"%@#onPreferences", [self class]);
	[NSApp activateIgnoringOtherApps : YES];
	[self unregisterHotKey];
	[_prefs doDialogWithWindow:[self witchPanel] selector:@selector(endPreferences) target:self];
}

- (IBAction)onAction:(id)sender
{
	[self doAfficheur:[sender stringValue]];
}

- (void)hotKey
{
	NSLog(@"%@#hotKey", [self class]);
	[self onOpen:self];
}

@end
