//
//  AfficheurPreferences.m
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "AfficheurPreferences.h"
#import "HotKeyedApplication.h"
#import "KeyEquivField.h"

@implementation AfficheurPreferences

// NIB file
NSString*	NibFile					= @"Preferences";

// UserDefault Keys
NSString*	PostTwitter				= @"Post.Twitter";
NSString*	PostJaiku				= @"Post.Jaiku";
NSString*	PostTumblr				= @"Post.Tumblr";
NSString*	PostWassr				= @"Post.Wassr";
NSString*	PostNowa				= @"Post.nowa";
NSString*	PostFrepa				= @"Post.frepa";

NSString*	GeneralDockIcon			= @"General.DockIcon";
NSString*	GeneralStartAtLogin		= @"General.StartAtLogin";
NSString*	GeneralUseGrowl			= @"General.UseGrowl";
NSString*	GeneralEncodeTinyURL	= @"General.EncodeTinyURL";
NSString*	GeneralHotKey			= @"General.HotKey";

NSString*	AccountTwitterUser		= @"Account.Twitter.User";
NSString*	AccountTwitterPass		= @"Account.Twitter.Pass";
NSString*	AccountJaikuUser		= @"Account.Jaiku.User";
NSString*	AccountJaikuPass		= @"Account.Jaiku.Pass";
NSString*	AccountTumblrUser		= @"Account.Tumblr.User";
NSString*	AccountTumblrPass		= @"Account.Tumblr.Pass";
NSString*	AccountWassrUser		= @"Account.Wassr.User";
NSString*	AccountWassrPass		= @"Account.Wassr.Pass";
NSString*	AccountNowaUser			= @"Account.nowa.User";
NSString*	AccountNowaPass			= @"Account.nowa.Pass";
NSString*	AccountFrepaUser		= @"Account.frepa.User";
NSString*	AccountFrepaPass		= @"Account.frepa.Pass";

// ToolBar Identifiers
NSString*	IdToolBar = @"PrefsToolBar";
NSString*	IdGeneral = @"PrefsGeneral";
NSString*	IdAccount = @"PrefsAccount";

enum {
	DIALOG_OK = 0,
	DIALOG_CANCEL
};

- (void)loadNib
{
	[NSBundle loadNibNamed:NibFile owner:self];
}

- (AfficheurPreferences *)init
{
	self = [super init];
	if (self)
	{
		NSLog(@"%@#init", [self class]);
		_openFirst = YES;
		_currentItem = @"";
		_panelToolBar = nil;
		_keyEquivView = [[[KeyEquivView alloc] init] retain];
		[_keyEquivView setFieldEditor:YES];
		NSDictionary *defaults = [NSDictionary dictionaryWithObjectsAndKeys:
								  [NSNumber numberWithBool:NO],		GeneralDockIcon,
								  [NSNumber numberWithBool:NO],		GeneralStartAtLogin,
								  [NSNumber numberWithBool:YES],	GeneralEncodeTinyURL,
								  [NSNumber numberWithBool:YES],	GeneralUseGrowl,
								  [NSNumber numberWithInt:-1],		GeneralHotKey,
								  nil];
		[[NSUserDefaults standardUserDefaults] registerDefaults:defaults];
		[self loadNib];
	}
	return self;
}

- (void)dealloc
{
	[_keyEquivView release];
	if (_panelToolBar)
	{
		[_panelToolBar release];
	}
	[super dealloc];
}

- (void)awakeFromNib
{
	NSLog(@"%@#awakeFromNib: %@", [self class], _panel);
	NSMutableParagraphStyle *style = [[NSMutableParagraphStyle alloc] init];
	[style setAlignment:NSRightTextAlignment];
	NSDictionary *attr = [NSDictionary dictionaryWithObjectsAndKeys:
						   [_label font], NSFontAttributeName,
						   [style copy], NSParagraphStyleAttributeName,
						   @"http://api.jaiku.com/", NSLinkAttributeName,
						   nil];
	NSAttributedString* str = [[NSAttributedString alloc] initWithString:@"API Key"
															  attributes:attr];
	[_jaikuAPI setSelectable:YES];
	[_jaikuAPI setEditable:YES];
    [_jaikuAPI setString:@""];
	[_jaikuAPI insertText:str];
	[_jaikuAPI setEditable:NO];
	attr = [NSDictionary dictionaryWithObjectsAndKeys:
			 [_label font], NSFontAttributeName,
			 [style copy], NSParagraphStyleAttributeName,
			 @"http://my.nowa.jp/config/account/api_auth", NSLinkAttributeName,
			 nil];
	
	str = [[NSAttributedString alloc] initWithString:@"API Password"
										  attributes:attr];
	[_nowaAPI setSelectable:YES];
	[_nowaAPI setEditable:YES];
    [_nowaAPI setString:@""];
	[_nowaAPI insertText:str];
	[_nowaAPI setEditable:NO];
	_openFirst = YES;
	_currentItem = @"";
	[_keyEquivView setTextField:_textField];
	[_keyEquivView setKeyCode:[self generalHotKey]];
}

- (BOOL)postTwitter
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:PostTwitter];
}

- (BOOL)postJaiku
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:PostJaiku];
}

- (BOOL)postTumblr
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:PostTumblr];
}

- (BOOL)postWassr
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:PostWassr];
}

- (BOOL)postNowa
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:PostNowa];
}

- (BOOL)postFrepa
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:PostFrepa];
}

- (BOOL)generalDockIcon
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:GeneralDockIcon];
}

- (BOOL)generalStartAtLogin
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:GeneralStartAtLogin];
}

- (BOOL)generalUseGrowl
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:GeneralUseGrowl];
}

- (BOOL)generalEncodeTinyURL
{
	return [[NSUserDefaults standardUserDefaults] boolForKey:GeneralEncodeTinyURL];
}

- (UInt32)generalHotKey
{
	return [[NSUserDefaults standardUserDefaults] integerForKey:GeneralHotKey];
}

- (NSString *)accountTwitterUser
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountTwitterUser];
}

- (NSString *)accountTwitterPass
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountTwitterPass];
}

- (NSString *)accountJaikuUser
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountJaikuUser];
}

- (NSString *)accountJaikuPass
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountJaikuPass];
}

- (NSString *)accountTumblrUser
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountTumblrUser];
}

- (NSString *)accountTumblrPass
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountTumblrPass];
}

- (NSString *)accountWassrUser
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountWassrUser];
}

- (NSString *)accountWassrPass
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountWassrPass];
}

- (NSString *)accountNowaUser
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountNowaUser];
}

- (NSString *)accountNowaPass
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountNowaPass];
}

- (NSString *)accountFrepaUser
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountFrepaUser];
}

- (NSString *)accountFrepaPass
{
	return [[NSUserDefaults standardUserDefaults] stringForKey:AccountFrepaPass];
}

- (void)savePreferences
{
	_generalUseGrowl = [self generalUseGrowl];
	_generalEncodeTinyURL = [self generalEncodeTinyURL];
	_accountTwitterUser = [self accountTwitterUser];
	_accountTwitterPass = [self accountTwitterPass];
	_accountJaikuUser = [self accountJaikuUser];
	_accountJaikuPass = [self accountJaikuPass];
	_accountTumblrUser = [self accountTumblrUser];
	_accountTumblrPass = [self accountTumblrPass];
	_accountWassrUser = [self accountWassrUser];
	_accountWassrPass = [self accountWassrPass];
	_accountNowaUser = [self accountNowaUser];
	_accountNowaPass = [self accountNowaPass];
	_accountFrepaUser = [self accountFrepaUser];
	_accountFrepaPass = [self accountFrepaPass];
}

- (void)restorePreferences
{
	[[NSUserDefaults standardUserDefaults] setBool:_generalUseGrowl forKey:GeneralUseGrowl];
	[[NSUserDefaults standardUserDefaults] setBool:_generalEncodeTinyURL forKey:GeneralEncodeTinyURL];
	[[NSUserDefaults standardUserDefaults] setObject:_accountTwitterUser forKey:AccountTwitterUser];
	[[NSUserDefaults standardUserDefaults] setObject:_accountTwitterPass forKey:AccountTwitterPass];
	[[NSUserDefaults standardUserDefaults] setObject:_accountJaikuUser forKey:AccountJaikuUser];
	[[NSUserDefaults standardUserDefaults] setObject:_accountJaikuPass forKey:AccountJaikuPass];
	[[NSUserDefaults standardUserDefaults] setObject:_accountTumblrUser forKey:AccountTumblrUser];
	[[NSUserDefaults standardUserDefaults] setObject:_accountTumblrPass forKey:AccountTumblrPass];
	[[NSUserDefaults standardUserDefaults] setObject:_accountWassrUser forKey:AccountWassrUser];
	[[NSUserDefaults standardUserDefaults] setObject:_accountWassrPass forKey:AccountWassrPass];
	[[NSUserDefaults standardUserDefaults] setObject:_accountNowaUser forKey:AccountNowaUser];
	[[NSUserDefaults standardUserDefaults] setObject:_accountNowaPass forKey:AccountNowaPass];
	[[NSUserDefaults standardUserDefaults] setObject:_accountFrepaUser forKey:AccountFrepaUser];
	[[NSUserDefaults standardUserDefaults] setObject:_accountFrepaPass forKey:AccountFrepaPass];
}

- (BOOL)removeFile:(NSString *)file
{
	NSFileManager *fm = [NSFileManager defaultManager];
	if ([fm fileExistsAtPath:file] && [fm isDeletableFileAtPath:file])
	{
		BOOL result = [fm removeFileAtPath:file handler:nil];
		if (!result)
		{
			NSLog(@"%@#removeFile:'%@' ERROR", [self class], file);
		}
		return result;
	}
	return YES;
}

- (BOOL)moveFile:(NSString *)srcFile toPath:(NSString *)dstFile
{
	NSFileManager *fm = [NSFileManager defaultManager];
	BOOL result = [fm movePath:srcFile toPath:dstFile handler:nil];
	if (!result)
	{
		NSLog(@"%@#moveFile:'%@' toPath:'%@' ERROR", [self class], srcFile, dstFile);
	}
	return result;
}

- (BOOL)saveInfoPlist
{
	NSString *dir = [NSString stringWithFormat:@"%@/Contents", [[NSBundle mainBundle] bundlePath]];
	NSString *plistName = @"Info.plist";
	NSString *tmpName = @"Info.plist~";
	NSString *bakName = @"Info.plist.bak";
	NSString *LSUIElement = @"LSUIElement";
	NSString *plistFile = [NSString stringWithFormat:@"%@/%@", dir, plistName];
	NSString *tmpFile = [NSString stringWithFormat:@"%@/%@", dir, tmpName];
	NSString *bakFile = [NSString stringWithFormat:@"%@/%@", dir, bakName];
	NSDictionary *plist = [NSDictionary dictionaryWithContentsOfFile:plistFile];
	if (!plist)
	{
		return NO;
	}
	id elm = [plist valueForKey:LSUIElement];
	BOOL dockIcon = ![self generalDockIcon];
	if ([elm boolValue] == dockIcon)
	{
		return YES;
	}
	[plist setValue:[NSString stringWithFormat:@"%d", dockIcon] forKey:LSUIElement];
	if (![plist writeToFile:tmpFile atomically:YES])
	{
		NSLog(@"%@#saveInfoPlist: ERROR [plist writeToFile:'%@']", [self class], tmpFile);
		return NO;
	}
	if (![self removeFile:bakFile])
	{
		return NO;
	}
	if (![self moveFile:plistFile toPath:bakFile])
	{
		return NO;
	}
	if (![self moveFile:tmpFile toPath:plistFile])
	{
		[self removeFile:plistFile];
		[self moveFile:bakFile toPath:plistFile];
		return NO;
	}
	return [self removeFile:bakFile];
}

- (void)saveStartAtLogin
{
	NSUserDefaults *defs = [NSUserDefaults standardUserDefaults];
	NSString *Loginwindow = @"loginwindow";
	NSString *AutoLaunchedApplicationDictionary = @"AutoLaunchedApplicationDictionary";
	NSString *Path = @"Path";
	NSString *Hide = @"Hide";
	NSString *bundlePath = [[NSBundle mainBundle] bundlePath];
	
	//loginwindowドメインのdictionaryを取得してコピー
	NSMutableDictionary *prefs = [[[defs persistentDomainForName:Loginwindow] mutableCopy] autorelease];
	
	//起動項目の配列を取得してコピー
	NSMutableArray *items = [[[prefs objectForKey:AutoLaunchedApplicationDictionary] mutableCopy] autorelease];
	unsigned n = [items count];
	BOOL	needSynchronize = NO;
	id		item;
	int		i = 0;
	for (i = 0 ; i < n ; i++)
	{
		item = [items objectAtIndex:i];
		if ([item isKindOfClass:[NSDictionary class]])
		{
			if ([[item valueForKey:Path] isEqual:bundlePath])
			{
				break;
			}
		}
	}
	if ([self generalStartAtLogin])
	{
		if (i >= n)
		{
			NSLog(@"%@#saveStartAtLogin: add", [self class]);
			[items addObject:[NSDictionary dictionaryWithObjectsAndKeys:
							  bundlePath, Path,
							  [NSNumber numberWithBool:NO], Hide,
							  nil]];
			needSynchronize = YES;
		}
	}
	else if (i < n)
	{
		NSLog(@"%@#saveStartAtLogin: remove", [self class]);
		[items removeObjectAtIndex:i];
		needSynchronize = YES;
	}
	
	if (needSynchronize)
	{
		NSLog(@"%@#saveStartAtLogin: synchronize", [self class]);
		[prefs setObject:items forKey:AutoLaunchedApplicationDictionary];
		[defs setPersistentDomain:prefs forName:Loginwindow];
		[defs synchronize];
	}
}

- (void)applicationWillTerminate
{
	[self saveInfoPlist];
	[self saveStartAtLogin];
}

- (BOOL)synchronize
{
	return [[NSUserDefaults standardUserDefaults] synchronize];
}

- (void)doDialogWithWindow:(NSWindow *)window
				  selector:(SEL)selector
					target:(id)target
{
	NSLog(@"%@#doDialogWithWindow", [self class]);
	[self savePreferences];
	[window makeKeyAndOrderFront:self];
	[[NSApplication sharedApplication]
	 beginSheet:_panel
	 modalForWindow:window
	 modalDelegate:self
	 didEndSelector:@selector(sheetDidEnd:returnCode:contextInfo:)
	 contextInfo:(void*)[[NSArray arrayWithObjects:
						  NSStringFromSelector(selector), target, nil] retain]];
	if (_openFirst)
	{
		_openFirst = NO;
		if (_panelToolBar)
		{
			[_panelToolBar release];
		}
		_panelToolBar = [[[NSToolbar alloc] initWithIdentifier:IdToolBar] retain];
		[_panelToolBar setDelegate:self];
		[_panel setToolbar:_panelToolBar];
	}
}

- (void)sheetDidEnd:(NSWindow*)sheet
		 returnCode:(int)returnCode
		contextInfo:(void*)contextInfo
{
    [sheet orderOut:self];
    // Check return code
    if(returnCode == DIALOG_CANCEL) {
        // Cancel button was pushed
        NSLog(@"%@#sheetDidEnd: Sheet is canceled", [self class]);
		[self restorePreferences];
		[self loadNib];
    }
    else if(returnCode == DIALOG_OK) {
        // OK button was pushed
        NSLog(@"%@#sheetDidEnd: Sheet is accepted", [self class]);
		[[NSUserDefaults standardUserDefaults] setInteger:[_keyEquivView keyCode]
												   forKey:GeneralHotKey];
		[self synchronize];
    }
	id info = (id)contextInfo;
	NSLog(@"%@#sheetDidEnd: %@", [self class], [info class]);
	if ([info isKindOfClass:[NSArray class]])
	{
        NSLog(@"%@#sheetDidEnd: Array", [self class]);
		SEL	selector = NSSelectorFromString([info objectAtIndex:0]);
		id	target = [info objectAtIndex:1];
		if (selector && target)
		{
			NSLog(@"%@#sheetDidEnd: %@ %@", [self class], NSStringFromSelector(selector), target);
			if ([target respondsToSelector:selector])
			{
				[target performSelector:selector];
			}
		}
	}
	if (info)
	{
		[info release];
	}
}

- (IBAction)onOK:(id)sender
{
    // OK button is pushed
    [[NSApplication sharedApplication] endSheet:_panel returnCode:DIALOG_OK];
}

- (IBAction)onCancel:(id)sender
{
    // Cancel button is pushed
    [[NSApplication sharedApplication] endSheet:_panel returnCode:DIALOG_CANCEL];
}

- (IBAction)onJaikuAPI:(id)sender
{
	NSLog(@"%@#onJaikuAPI", [self class]);
}

- (IBAction)onNowaAPI:(id)sender
{
	NSLog(@"%@#onNowaAPI", [self class]);
}

- (IBAction)onClear:(id)sender
{
	NSLog(@"%@#onClear", [self class]);
	[_keyEquivView setKeyCode:-1];
}

// Toolbar method

- (NSString *)label:(NSString *)key
{
	return [[NSDictionary dictionaryWithObjectsAndKeys:
			 @"General",	IdGeneral,
			 @"Account",	IdAccount,
			 nil]
			valueForKey:key];
}

- (NSString *)imageName:(NSString *)key
{
	return [[NSDictionary dictionaryWithObjectsAndKeys:
			 @"NSPreferencesGeneral",	IdGeneral,
			 @"NSUserAccounts",			IdAccount,
			 nil]
			valueForKey:key];
}

- (void)onSelectTab:(NSToolbarItem *)sender
{
	NSString* itemId = [sender itemIdentifier];
	[_panel setTitle:[self label:itemId]];
	[_panelToolBar setSelectedItemIdentifier:itemId];
	id view = nil;
	if ([itemId isEqual:IdGeneral])
	{
		view = _viewGeneral;
	}
	else if ([itemId isEqual:IdAccount])
	{
		view = _viewAccount;
	}
	if (view && (![_currentItem isEqual:itemId]))
	{
		_currentItem = itemId;
		NSRect	bounds = [view bounds];
		NSRect	aFrame = [_panel frameRectForContentRect:bounds];
		int		x = [_panel frame].origin.x + ([_panel frame].size.width - aFrame.size.width) / 2;
		int		y = [_panel frame].origin.y + ([_panel frame].size.height - aFrame.size.height);
		NSRect	rect = NSMakeRect(x, y, aFrame.size.width, aFrame.size.height);
		NSTimeInterval interval = [_panel animationResizeTime:rect];
		[_panel setContentView:_viewNil];
		[_panel setFrame:rect display:true animate:true];
		[NSTimer scheduledTimerWithTimeInterval:interval target:self selector:@selector(setView:) userInfo:view repeats:false];
	}
}

- (void)setView:(NSTimer *)theTimer
{
	if (theTimer && theTimer.userInfo)
	{
		[_panel setContentView:theTimer.userInfo];
		[_panel recalculateKeyViewLoop];
		[_panel selectKeyViewFollowingView:theTimer.userInfo];
	}
}

// NSToolbar delegate

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			IdGeneral,
			IdAccount,
			nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [self toolbarDefaultItemIdentifiers:toolbar];
}

- (NSArray *)toolbarSelectableItemIdentifiers:(NSToolbar *)toolbar
{
	return [self toolbarDefaultItemIdentifiers:toolbar];
}

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSString* label = [self label:itemIdentifier];
	if (!label)
	{
		return nil;
	}
	NSToolbarItem* item = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] retain];
	[item setTarget:self];
	[item setAction:@selector(onSelectTab:)];
	[item setLabel:label];
	[item setImage:[NSImage imageNamed:[self imageName:itemIdentifier]]];
	if ([itemIdentifier isEqual:IdGeneral])
	{
		[self onSelectTab:item];
	}
	return item;
}

// TextField delegate

- (BOOL)control:(NSControl *)control
		 textView:(NSTextView *)textView
doCommandBySelector:(SEL)command
{
	NSLog(@"%@#control:textView:doCommandBySelector: %@", [self class], NSStringFromSelector(command));
	NSLog(@"%@#control:textView:doCommandBySelector: %@", [self class], [textView nextKeyView]);
	return NO;
}

- (id)windowWillReturnFieldEditor:(NSWindow *)sender toObject:(id)anObject
{
//	NSLog(@"%@#windowWillReturnFieldEditor:%p toObject:%p", [self class], sender, anObject);
	if ([anObject isKindOfClass:[KeyEquivField class]])
	{
		return _keyEquivView;
	}	 
	return nil;//anObject;
}

@end
