//
//  TextField.m
//  Afficheur
//
//  Created by kichi on 08/04/10.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "KeyEquivView.h"


@implementation KeyEquivView

+ (UInt16)keyCodeForKeyCode:(UInt32)keyCode
{
	return keyCode & 0xff;
}

+ (UInt32)modifierKeyForKeyCode:(UInt32)keyCode
{
	return keyCode & (NSShiftKeyMask | NSAlternateKeyMask | NSControlKeyMask | NSCommandKeyMask);
}

- (id)init
{
	NSLog(@"%@#init", [self class]);
	self = [super init];
	if (self)
	{
		_keyCode = (UInt32)-1;
		_textField = nil;
		_functionKeys = [[NSDictionary dictionaryWithObjectsAndKeys:
						  @"Space",		@"31",
						  @"Prior",		@"21",
						  @"Next",		@"22",
						  @"PageUp",	@"74",
						  @"PageDown",	@"79",
						  @"End",		@"77",
						  @"Home",		@"73",
						  @"Left",		@"7B",
						  @"Up",		@"7E",
						  @"Right",		@"7C",
						  @"Down",		@"7D",
						  @"Delete⌦",	@"75",
						  @"Delete⌫",	@"33",
						  @"Help",		@"72",
						  @"F1",		@"7A",
						  @"F2",		@"78",
						  @"F3",		@"63",
						  @"F4",		@"76",
						  @"F5",		@"60",
						  @"F6",		@"61",
						  @"F7",		@"62",
						  @"F8",		@"64",
						  @"F9",		@"65",
						  @"F10",		@"6D",
						  @"F11",		@"67",
						  @"F12",		@"6F",
						  @"F13",		@"69",
						  @"F14",		@"6B",
						  @"F15",		@"71",
						  nil] retain];
		_padKeys = [[NSArray arrayWithObjects:
					 @"41",
					 @"43",
					 @"45",
					 @"4B",
					 @"4E",
					 @"51",
					 @"52",
					 @"53",
					 @"54",
					 @"55",
					 @"56",
					 @"57",
					 @"58",
					 @"59",
					 @"5B",
					 @"5C",
					 nil] retain];
		OSStatus err = KLGetCurrentKeyboardLayout(&_keyboardLayout);
		if (err != noErr)
		{
			return nil;
		}
		err = KLGetKeyboardLayoutProperty(_keyboardLayout, kKLKind, (const void **)&_keyLayoutKind);
		if (err != noErr)
		{
			return nil;
		}
		if (_keyLayoutKind == kKLKCHRKind)
		{
			err = KLGetKeyboardLayoutProperty(_keyboardLayout, kKLKCHRData, (const void **)&_KCHRData);
		}
		else
		{
			err = KLGetKeyboardLayoutProperty(_keyboardLayout, kKLuchrData, (const void **)&_uchrData);
		}
		if (err != noErr)
		{
			return nil;
		}
		NSLog(@"%@#init: %@", [self class], [self description]);
	}
	return self;
}

- (void)dealloc
{
	[_functionKeys release];
	[_padKeys release];
	[super dealloc];
}

- (BOOL)acceptsFirstResponder
{
	return YES;
}

- (NSString *)description
{
    NSString *kind;
    if (_keyLayoutKind == kKLKCHRKind)
	{
        kind = @"KCHR";
	}
    else
	{
        kind = @"uchr";
	}
    NSString *layoutName;
    KLGetKeyboardLayoutProperty(_keyboardLayout, kKLLocalizedName, (const void **)&layoutName);
    return [NSString stringWithFormat:@"%@ layout=%@ (%@)", [self class], layoutName, kind];
}

- (void)setTextField:(NSTextField *)textField
{
	_textField = textField;
}

- (UInt32)keyCode
{
	return _keyCode;
}

- (NSString *)translateKeyCode:(unsigned short)keyCode
			   withModifierKey:(unsigned int)modifierKey
{
    if (_keyLayoutKind == kKLKCHRKind)
	{
		NSLog(@"%@#translateKeyCode: kKLKCHRKind", [self class]);
        UInt32 charCode = KeyTranslate( _KCHRData, keyCode, &_keyTranslateState );
        char theChar = (charCode & 0x00FF);
		return [[[NSString alloc] initWithData:[NSData dataWithBytes:&theChar length:1] encoding:NSMacOSRomanStringEncoding] autorelease];
    }
	NSLog(@"%@#translateKeyCode: !kKLKCHRKind", [self class]);
	UniCharCount maxStringLength = 10, actualStringLength;
	UniChar unicodeString[10];
	/*OSStatus err =*/ UCKeyTranslate(_uchrData, keyCode, kUCKeyActionDisplay, modifierKey, LMGetKbdType(), kUCKeyTranslateNoDeadKeysBit, &_deadKeyState, maxStringLength, &actualStringLength, unicodeString);
	NSLog(@"%@#translateKeyCode: actualStringLength = %d", [self class], actualStringLength);
	NSLog(@"%@#translateKeyCode: %@", [self class], [NSData dataWithBytes:unicodeString length:sizeof(unicodeString)]);
	return [NSString stringWithCharacters:unicodeString length:actualStringLength];
}

- (NSString *)translateKeyCode:(unsigned short)keyCode
{
	return [self translateKeyCode:keyCode withModifierKey:0];
}

- (NSString *)stringForKeyCode:(unsigned short)keyCode
			   withModifierKey:(unsigned int)modifierKey
{
	NSString *keyStr = [NSString stringWithFormat:@"%02X", keyCode];
	NSLog(@"%@#stringForKeyCode: %@", [self class], keyStr);
	NSString *result = [_functionKeys objectForKey:keyStr];
	if (!result)
	{
		result = [[self translateKeyCode:keyCode] uppercaseString];
		if ([_padKeys indexOfObject:keyStr] != NSNotFound)
		{
			result = [NSString stringWithFormat:@"Pad %@", result];
		}
	}
	//^⎇⇧⌘
	if (modifierKey & NSCommandKeyMask)
	{
		result = [NSString stringWithFormat:@"⌘%@", result];
	}
	if (modifierKey & NSShiftKeyMask)
	{
		result = [NSString stringWithFormat:@"⇧%@", result];
	}
	if (modifierKey & NSAlternateKeyMask)
	{
		result = [NSString stringWithFormat:@"⎇%@", result];
	}
	if (modifierKey & NSControlKeyMask)
	{
		result = [NSString stringWithFormat:@"^%@", result];
	}
	return result;
}

- (NSString *)stringForKeyCode:(unsigned short)keyCode
{
	return [self stringForKeyCode:keyCode withModifierKey:0];
}

- (void)setKeyCode:(UInt32)keyCode
{
	NSString *str = @"";
	_keyCode = keyCode;
	if (_keyCode == (UInt32)-1)
	{
		[self selectAll:self];
		[self delete:self];
	}
	else
	{
		str = [self stringForKeyCode:[KeyEquivView keyCodeForKeyCode:_keyCode]
					 withModifierKey:[KeyEquivView modifierKeyForKeyCode:_keyCode]];
			[self setString:str];
	}
	[_textField setStringValue:str];
	NSLog(@"%@#setKeyCode: '%@'", [self class], str);
}

- (void)setKeyCode:(UInt16)keyCode
   withModifierKey:(UInt32)modifierKey
{
	[self setKeyCode:(modifierKey & (NSShiftKeyMask |
									 NSAlternateKeyMask |
									 NSControlKeyMask |
									 NSCommandKeyMask)) | (UInt32)(keyCode & 0xff)];
}

- (void)keyDown:(NSEvent *)theEvent
{
	NSLog(@"%@#keyDown: %@", [self class], theEvent);
	NSLog(@"%@#keyDown: modifier = %04X", [self class], [theEvent modifierFlags] & (NSControlKeyMask | NSAlternateKeyMask | NSShiftKeyMask | NSCommandKeyMask));
	switch ([theEvent keyCode])
	{
		case 0x24:
		case 0x35:
		case 0x30:
			[super keyDown:theEvent];
			break;
		default:
		{
			[self setKeyCode:[theEvent keyCode] withModifierKey:[theEvent modifierFlags]];
			if (_textField)
			{
				[[_textField window] selectKeyViewFollowingView:_textField];
			}
		}
		break;
	}
}

@end
