//
//  TwitterAPI.m
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TwitterAPI.h"
#import <JSON/JSON.h>
#import <OgreKit/OgreKit.h>

NSString *TwitterUser	= @"TwitterUser";
NSString *TwitterPass	= @"TwitterPass";
NSString *TwitterHost	= @"TwitterHost";
NSString *TwitterURL	= @"TwitterURL";
NSString *TwitterSource	= @"TwitterSource";

@implementation TwitterAPI

- (TwitterAPI *)init
{
	self = [super init];
	if (self)
	{
		_keys = [NSDictionary dictionaryWithObjectsAndKeys:
				 @"", TwitterUser,
				 @"", TwitterPass,
				 @"", TwitterHost,
				 @"", TwitterURL,
				 @"", TwitterSource,
				 nil];
		_dic = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
				 @"", TwitterUser,
				 @"", TwitterPass,
				 @"twitter.com", TwitterHost,
				 @"http://twitter.com/statuses", TwitterURL,
				 nil] retain];
		//NSLog(@"%@#init: %@", [self class], _dic);
	}
	return self;
}

- (void)dealloc
{
	[_dic release];
	[super dealloc];
}

- (TwitterAPI *)initWithObjectsAndKeys:(id)firstObject, ...
{
	[self init];
	id obj = firstObject;
	va_list	ap;
	va_start(ap, firstObject);
	while (obj)
	{
		id key = va_arg(ap, id);
		if (key == nil)
		{
			break;
		}
		id val = [_keys valueForKey:key];
		if (val == nil)
		{
			NSLog(@"%@#initWithObjectsAndKeys: NoKey: %@", [self class], key);
		}
		else
		{
			//NSLog(@"%@#initWithObjectsAndKeys: %@ = %@", [self class], key, obj);
			[_dic setValue:obj forKey:key];
		}
		obj = va_arg(ap, id);
	}
	va_end(ap);
	//NSLog(@"%@#initWithObjectsAndKeys: %@", [self class], db);
	return self;
}


- (NSArray *)postWithAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body
{
	//NSLog(@"%@#post:surl = %@", [self class], surl);
	NSString* src = @"";
	if ([_dic valueForKey:TwitterSource])
	{
		src = [NSString stringWithFormat:@"&source=%@", [_dic valueForKey:TwitterSource]];
	}
	NSString *auth = [HTTP base64String:
					  [NSString stringWithFormat:@"%@:%@",
					   [_dic valueForKey:TwitterUser],
					   [_dic valueForKey:TwitterPass]]];
	[header setValue:[_dic valueForKey:TwitterHost] forKey:@"Host"];
	[header setValue:[NSString stringWithFormat:@"Basic %@", auth] forKey:@"Authorization"];
	return [self post:[NSString stringWithFormat:@"%@/%@", [_dic valueForKey:TwitterURL], path]
			   header:header
				 body:[NSString stringWithFormat:@"%@%@", body, src]];
}

- (NSString *)determineError:(NSError *)error
					response:(NSURLResponse *)response
					  result:(id)result
{
	NSLog(@"%@#determineResponse: error = %@", [self class], error);
	NSLog(@"%@#determineResponse: response = %@", [self class], response);
	NSLog(@"%@#determineResponse: result = %@", [self class], result);
	NSString *description = nil;
	if (![error isKindOfClass:[NSNull class]])
	{
		description = @"Failure";
		if ([result isKindOfClass:[NSString class]])
		{
			if ([result rangeOfRegularExpressionString:@"^<!DOCTYPE HTML"
											   options:OgreIgnoreCaseOption].length ||
				[result rangeOfRegularExpressionString:@"^<HTML"
											   options:OgreIgnoreCaseOption].length)
			{
				// 正規表現オブジェクトの生成
				OGRegularExpression *regex = [OGRegularExpression
											  regularExpressionWithString:@"<TITLE>(.*)</TITLE>$"
											  options:OgreIgnoreCaseOption | OgreMultilineOption];
				// マッチ結果の列挙子の生成
				OGRegularExpressionMatch *match = [regex matchInString:result];
				NSString *title = [match substringAtIndex:1];
				if (title)
				{
					result = title;
				}
			}
			description = [NSString stringWithFormat:@"Failure\n(%@)", result];
		}
	}
	NSLog(@"%@#determineResponse: description = %@", [self class], description);
	return description;
}

- (NSArray *)update:(NSString *)status
{
	NSArray *res = [self postWithAuth:@"update.json"
							   header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
										@"application/x-www-form-urlencoded",
										@"Content-Type",
										nil]
									   autorelease]
								 body:[NSString stringWithFormat:@"status=%@", 
									   [HTTP urlEncode:status
											 unescaped:nil
											   escaped:@"+"]]];
	NSError *error = (NSError *)[NSNull null];
	NSURLResponse *response = (NSURLResponse *)[NSNull null];
	id result = [NSNull null];
	if ([res count] > ResultError)
	{
		error = [res objectAtIndex:ResultError];
	}
	if ([res count] > ResultResponse)
	{
		response = [res objectAtIndex:ResultResponse];
	}
	if ([res count] > ResultData)
	{
		result = [[NSString alloc] initWithData:[res objectAtIndex:ResultData]
									   encoding:NSUTF8StringEncoding];
	}
	if ([error class] == [NSNull class])
	{
		result = [result JSONValue];
	}
	NSString *description = [self determineError:(NSError *)error
										response:(NSURLResponse *)response
										  result:(id)result];
	if (!description)
	{
		description = (NSString *)[NSNull null];
	}
	return [NSArray arrayWithObjects:
			error,
			response,
			result,
			description,
			nil];
}
@end
