//
//  AfficheurGrowl.m
//  Afficheur
//
//  Created by kichi on 08/10/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "AfficheurGrowl.h"
#import "GrowlNotifier.h"


@implementation AfficheurGrowl

NSString*	GrowlAfficheurSuccessNotify			= @"Afficheur post was successful";
NSString*	GrowlAfficheurFailureNotify			= @"Afficheur post was failure";
NSString*	GrowlAfficheurKeywordsNotify		= @"Afficheur keywords";
NSString*	GrowlAfficheurTwitterNotify			= @"Twitter";
NSString*	GrowlAfficheurTwitterReplyNotify	= @"Twitter Reply";
NSString*	GrowlAfficheurTwitterDirectNotify	= @"Twitter Direct Message";
NSString*	GrowlAfficheurTwitterErrorNotify	= @"Twitter Error";
NSString*	GrowlAfficheurJaikuNotify			= @"Jaiku";
NSString*	GrowlAfficheurJaikuChannelNotify	= @"Jaiku Channel";
NSString*	GrowlAfficheurJaikuCommentNotify	= @"Jaiku Comment";
NSString*	GrowlAfficheurJaikuReplyNotify		= @"Jaiku Reply";
NSString*	GrowlAfficheurJaikuErrorNotify		= @"Jaiku Error";
NSString*	GrowlAfficheurWassrNotify			= @"Wassr";
NSString*	GrowlAfficheurWassrChannelNotify	= @"Wassr Channel";
NSString*	GrowlAfficheurWassrReplyNotify		= @"Wassr Reply";
NSString*	GrowlAfficheurWassrErrorNotify		= @"Wassr Error";
//NSString*	GrowlAfficheurNowaNotify			= @"nowa";
//NSString*	GrowlAfficheurNowaReplyNotify		= @"nowa Reply";
//NSString*	GrowlAfficheurNowaErrorNotify		= @"nowa Error";
NSString*	GrowlAfficheurIdenticaNotify		= @"identi.ca";
NSString*	GrowlAfficheurIdenticaGroupNotify	= @"identi.ca Group";
NSString*	GrowlAfficheurIdenticaReplyNotify	= @"identi.ca Reply";
NSString*	GrowlAfficheurIdenticaDirectNotify	= @"identi.ca Direct Message";
NSString*	GrowlAfficheurIdenticaErrorNotify	= @"identi.ca Error";
NSString*	GrowlAfficheurJiskoNotify			= @"Jisko";
NSString*	GrowlAfficheurJiskoReplyNotify		= @"Jisko Reply";
NSString*	GrowlAfficheurJiskoPrivateNotify	= @"Jisko Private Note";
NSString*	GrowlAfficheurJiskoErrorNotify		= @"Jisko Error";

NSString*	KeyGrowlTitle				= @"title";
NSString*	KeyGrowlDescription			= @"description";
NSString*	KeyGrowlNotificationName	= @"notificationName";
NSString*	KeyGrowlIconData			= @"iconData";
NSString*	KeyGrowlClickContext		= @"clickContext";

- (AfficheurGrowl *)init
{
	//LOG(@"[%@ init]", [self className]);
	self = [super init];
	if (self)
	{
		_delegate = nil;
		_mainThread = nil;
		_queueGrowl = [[NSMutableArray alloc] init];
		_lockQueueGrowl = [[NSLock alloc] init];
		_lockedGrowl = NO;
		_lockGrowl = [[NSLock alloc] init];
	}
	return self;
}

- (void)dealloc
{
	[_queueGrowl release];
	[_lockQueueGrowl release];
	[_lockGrowl release];
	[super dealloc];
}

- (void)performLockGrowl:(id)object
{
	@synchronized(_lockGrowl)
	{
		_lockedGrowl = YES;
		[_lockGrowl lock];
	}
}

- (void)lockGrowl
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performLockGrowl:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performLockGrowl:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performUnlockGrowl:(id)object
{
	@synchronized(_lockGrowl)
	{
		if (_lockedGrowl)
		{
			_lockedGrowl = NO;
			[_lockGrowl unlock];
		}
	}
}

- (void)unlockGrowl
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performUnlockGrowl:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performUnlockGrowl:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)getMainThread:(id)object
{
	_mainThread = [NSThread currentThread];
}

- (void)notifyWithTitle:(NSString *)title
			description:(NSString *)description
	   notificationName:(NSString *)notificationName
			   iconData:(NSData *)iconData
		   clickContext:(id)clickContext
{
	//LOG(@"[%@ notifyWithTitle] %@", [self className], notificationName);
	[_lockQueueGrowl lock];
	@try
	{
		[_queueGrowl addObject:[NSDictionary dictionaryWithObjectsAndKeys:
								title, KeyGrowlTitle,
								description, KeyGrowlDescription,
								notificationName, KeyGrowlNotificationName,
								[NSData dataWithData:iconData], KeyGrowlIconData,
								clickContext, KeyGrowlClickContext,
								nil]];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ notifyWithTitle] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[_lockQueueGrowl unlock];
	[self unlockGrowl];
}

- (void)performNotify:(NSDictionary *)notify
{
	@synchronized(_growl)
	{
		//LOG(@"[%@ performNotify]\n%@\n%@", [self className], [notify valueForKey:KeyGrowlTitle], [notify valueForKey:KeyGrowlDescription]);
		[_growl notifyWithTitle:[notify valueForKey:KeyGrowlTitle]
					description:[notify valueForKey:KeyGrowlDescription]
			   notificationName:[notify valueForKey:KeyGrowlNotificationName]
					   iconData:[notify valueForKey:KeyGrowlIconData]
					   priority:0
					   isSticky:NO
				   clickContext:[notify valueForKey:KeyGrowlClickContext]];
	}
}

- (void)threadGrowl:(id)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		for (;;)
		{
			NSAutoreleasePool *internalPool = [[NSAutoreleasePool alloc] init];
			[_lockGrowl lock];
			@try
			{
				UInt32	i = 0;
				[_lockQueueGrowl lock];
				while ([_queueGrowl count] > 0)
				{
					id obj = [_queueGrowl objectAtIndex:0];
					[_lockQueueGrowl unlock];
					@try
					{
						[self performSelectorOnMainThread:@selector(performNotify:)
											   withObject:obj
											waitUntilDone:YES];
						if (++i % 3 == 0)
						{
							[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:1]];
						}
						else
						{
							[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:0.3]];
						}
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
					[_lockQueueGrowl lock];
					[_queueGrowl removeObjectAtIndex:0];
				}
				[_lockQueueGrowl unlock];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			[_lockGrowl unlock];
			[self lockGrowl];
			[internalPool release];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[pool release];
	[NSThread exit];
}

- (void)startWithDelegate:(id)delegate
{
	_delegate = delegate;
	[_growl initWithDelegate:self];
	[_growl startWithApplicationName:@"Afficheur"
					   notifications:[NSArray arrayWithObjects:
									  GrowlAfficheurSuccessNotify,
									  GrowlAfficheurFailureNotify,
									  GrowlAfficheurKeywordsNotify,
									  GrowlAfficheurTwitterNotify,
									  GrowlAfficheurTwitterReplyNotify,
									  GrowlAfficheurTwitterDirectNotify,
									  GrowlAfficheurTwitterErrorNotify,
									  GrowlAfficheurJaikuNotify,
									  GrowlAfficheurJaikuChannelNotify,
									  GrowlAfficheurJaikuCommentNotify,
									  GrowlAfficheurJaikuReplyNotify,
									  GrowlAfficheurJaikuErrorNotify,
									  GrowlAfficheurWassrNotify,
									  GrowlAfficheurWassrChannelNotify,
									  GrowlAfficheurWassrReplyNotify,
									  GrowlAfficheurWassrErrorNotify,
//									  GrowlAfficheurNowaNotify,
//									  GrowlAfficheurNowaReplyNotify,
//									  GrowlAfficheurNowaErrorNotify,
									  GrowlAfficheurIdenticaNotify,
									  GrowlAfficheurIdenticaGroupNotify,
									  GrowlAfficheurIdenticaReplyNotify,
									  GrowlAfficheurIdenticaDirectNotify,
									  GrowlAfficheurIdenticaErrorNotify,
									  GrowlAfficheurJiskoNotify,
									  GrowlAfficheurJiskoReplyNotify,
									  GrowlAfficheurJiskoPrivateNotify,
									  GrowlAfficheurJiskoErrorNotify,
									  nil]
				dafaultNotifications:nil
								icon:nil];

	[self performSelectorOnMainThread:@selector(getMainThread:)
						   withObject:nil
						waitUntilDone:YES];
	[NSThread detachNewThreadSelector:@selector(threadGrowl:)
							 toTarget:self
						   withObject:nil];
}

// Growl Delegate

- (void)growlIsReady
{
}

- (void)growlNotificationWasClicked:(id)clickContext
{
	if (_delegate && [_delegate respondsToSelector:@selector(growlNotificationWasClicked:)])
	{
		[_delegate performSelector:@selector(growlNotificationWasClicked:) withObject:clickContext];
	}
}

@end
