//
//  AfficheurPanel.h
//  Afficheur
//
//  Created by kichi on 08/11/23.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class TextViewHUD;
@class AfficheurPreferences;
@class AfficheurController;
@class JaikuIconView;

@interface AfficheurPanel : NSObject {
	IBOutlet id					_panel;
	IBOutlet id					_text;
	IBOutlet id					_reply;
	IBOutlet id					_label;
	IBOutlet id					_spinner;
	IBOutlet id					_checkTwitter;
	IBOutlet id					_checkJaiku;
	IBOutlet id					_checkTumblr;
	IBOutlet id					_checkWassr;
//	IBOutlet id					_checkNowa;
	IBOutlet id					_checkIdentica;
	IBOutlet id					_checkJisko;
	IBOutlet id					_checkTinyURLize;
	IBOutlet id					_buttonEmoji;
	IBOutlet id					_viewDoCoMo;
	IBOutlet id					_viewEZweb;
	IBOutlet id					_viewSoftBank;
	IBOutlet id					_viewJaiku;
	IBOutlet id					_viewJaikuIcon;

	float						_height;
	
	AfficheurPreferences*		_preferences;
	AfficheurController*		_controller;
	
	NSDictionary*				_emojiViews;
	
	TextViewHUD*				_textViewHUD;
	NSString*					_undoOldText;
	NSRange						_undoOldRange;
	NSRange						_undoOldOldRange;
	
	NSString*					_inReplyTo;
	NSString*					_inReplyToService;
	NSString*					_inReplyToText;
	NSAttributedString*			_inReplyReply;
	
	NSLock*						_lockClick;
	
	int							_doCommand;
	
	BOOL						_saveState;
	NSThread*					_mainThread;

	NSLock*						_lockText;
	BOOL						_lockedText;
	NSMutableArray*				_queueText;
	
	NSLock*						_lockReply;

	BOOL						_keyView;
	BOOL						_setUpDoCoMo;
	BOOL						_setUpEZweb;
	BOOL						_setUpSoftBank;
	BOOL						_setUpJaiku;
	BOOL						_animatingEmoji;
	
	BOOL						_completePosting;
	BOOL						_commandHandling;
	BOOL						_stringSetting;
}

+ (const int *)tableOfJaikuIcon;

- (id)initWithPreferences:(AfficheurPreferences *)preferences;

- (void)applicationWillTerminate;

- (void)setController:(AfficheurController *)controller;
- (void)startThread;

- (void)setButtonEmoji:(NSString *)selected;
- (BOOL)isEnabledButtonEmoji;

- (void)clearJaikuIcon:(id)sender;

- (BOOL)isKeyView;

- (BOOL)canHide;
- (void)setCanHide:(BOOL)canHide;

- (NSWindow *)panel;
- (void)panelOrderOut:(id)sender;
- (void)panelOrderFront:(id)sender;
- (void)panelMakeKeyAndOrderFront:(id)sender;

- (void)performSetStringText:(NSString *)string
				   withRange:(NSRange)aRange;
- (void)setStringText:(NSString *)string;
- (void)insertStringText:(NSString *)string;
- (void)setEnabledText:(BOOL)enabled;
- (BOOL)isEnabledText;
- (NSRange)selectedRangeText;
- (void)setSelectedRangeText:(NSRange)range;

- (BOOL)makeFirstResponderText;
- (NSResponder *)firstResponder;

- (void)setComplete;

- (NSString *)inReplyTo;
- (NSString *)inReplyToText;
- (NSString *)inReplyToService;
- (int)iconCode;

- (void)setCheckBoxEnabled;
- (BOOL)isCheckBoxEnabled:(NSString *)service;

- (void)setReply:(NSAttributedString *)reply
	 withService:(NSString *)servie
	   inReplyTo:(NSString *)inReplyTo
			text:(NSString *)text
		  sender:(id)sender;

- (void)controlTextDidChange;

- (IBAction)onClickTwitter:(id)sender;
- (IBAction)onClickJaiku:(id)sender;
- (IBAction)onClickTumblr:(id)sender;
//- (IBAction)onClickNowa:(id)sender;
- (IBAction)onClickWassr:(id)sender;
- (IBAction)onClickIdentica:(id)sender;
- (IBAction)onClickJisko:(id)sender;
- (IBAction)onButtonEmoji:(id)sender;

@end

@interface NSObject (AfficheurPanel)

- (void)performSetReply;

@end
