//
//  AfficheurService.m
//  Afficheur
//
//  Created by kichi on 08/11/23.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "AfficheurService.h"
#import "AfficheurController.h"
#import "AfficheurPreferences.h"
#import "ServiceTwitter.h"
#import "ServiceJaiku.h"
#import "ServiceTumblr.h"
//#import "ServiceNowa.h"
#import "ServiceWassr.h"
#import "ServiceIdentica.h"
#import "ServiceJisko.h"
#import "ServiceXMPP.h"

@implementation AfficheurService

NSString*	KeyTimelineCommand		= @"command";
NSString*	KeyTimelineService		= @"service";

NSString*	CmdTimeline				= @"timeline";
NSString*	CmdReplies				= @"replies";
NSString*	CmdDM					= @"dm";
NSString*	CmdChannel				= @"channel";

- (AfficheurService *)init
{
	self = [super init];
	if (self)
	{
		_mainThread = nil;
		_queueRetrieve = [[NSMutableArray alloc] init];
		_lockedRetrieve = NO;
		_lockRetrieve = [[NSLock alloc] init];
		_queueTick = [[NSMutableArray alloc] init];
		_lockedTick = NO;
		_lockTick = [[NSLock alloc] init];
		_services = nil;
	}
	return self;
}


- (void)dealloc
{
	[_serviceTwitter release];
	[_serviceJaiku release];
	[_serviceTumblr release];
	[_serviceWassr release];
//	[_serviceNowa release];
	[_serviceIdentica  release];
	[_serviceJisko release];
	[_xmpp release];
	[_queueRetrieve release];
	[_lockRetrieve release];
	[_queueTick release];
	[_lockTick release];
	if (_services)
	{
		[_services release];
	}
	[super dealloc];
}

- (void)setupWithController:(AfficheurController *)controller
				preferences:(AfficheurPreferences *)preferences
{
	NSDate *date = [NSDate dateWithTimeIntervalSinceNow:0];
	_controller = controller;
	_preferences = preferences;
	_serviceTwitter  = [[ServiceTwitter  alloc] init:Twitter  WithController:_controller preferences:_preferences];
	_serviceJaiku    = [[ServiceJaiku    alloc] init:Jaiku    WithController:_controller preferences:_preferences];
	_serviceTumblr   = [[ServiceTumblr   alloc] init:Tumblr   WithController:_controller preferences:_preferences];
	_serviceWassr    = [[ServiceWassr    alloc] init:Wassr    WithController:_controller preferences:_preferences];
//	_serviceNowa     = [[ServiceNowa     alloc] init:Nowa     WithController:_controller preferences:_preferences];
	_serviceIdentica = [[ServiceIdentica alloc] init:Identica WithController:_controller preferences:_preferences];
	_serviceJisko    = [[ServiceJisko    alloc] init:Jisko    WithController:_controller preferences:_preferences];

	_services = [[NSDictionary dictionaryWithObjectsAndKeys:
				  _serviceTwitter,	Twitter,
				  _serviceJaiku,	Jaiku,
				  _serviceTumblr,	Tumblr,
				  _serviceWassr,	Wassr,
//				  _serviceNowa,		Nowa,
				  _serviceIdentica,	Identica,
				  _serviceJisko,	Jisko,
				  nil] retain];
	[_serviceTwitter setupRetrieveDate:date];
	[_serviceJaiku setupRetrieveDate:date];
//	[_serviceNowa setupRetrieveDate:date];
	[_serviceWassr setupRetrieveDate:date];
	[_serviceIdentica setupRetrieveDate:date];
	[_serviceJisko setupRetrieveDate:date];
	
	_xmpp = [[ServiceXMPP alloc] init];
	[_xmpp setController:controller];
	[self setupXMPP];
	
	[self performSelectorOnMainThread:@selector(getMainThread:)
						   withObject:nil
						waitUntilDone:YES];
	
	[self lockRetrieve];
	[NSThread detachNewThreadSelector:@selector(threadRetrieve:)
							 toTarget:self
						   withObject:nil];

	[self lockTick];
	[NSThread detachNewThreadSelector:@selector(threadTickTimer:)
							 toTarget:self
						   withObject:nil];
	LOG(@"[%@ setupWithController] done", [self className]);
}

- (void)setupXMPP
{
	[_serviceJaiku setupXMPP:_xmpp];
	[_serviceWassr setupXMPP:_xmpp];
	[_serviceIdentica setupXMPP:_xmpp];
	[_serviceJisko setupXMPP:_xmpp];
}

- (void)getMainThread:(id)object
{
	_mainThread = [NSThread currentThread];
}

- (void)applicationWillTerminate;
{
	[_xmpp disconnectAll];
}

- (Service *)service:(NSString *)service
{
	return [_services valueForKey:service];
}

- (void)saveState:(BOOL)state
	   andEnabled:(BOOL)enabled
		  service:(NSString *)service
{
	if ([service isEqualToString:Twitter])
	{
		[_serviceTwitter saveState:state andEnabled:enabled];
	}
	else if ([service isEqualToString:Jaiku])
	{
		[_serviceJaiku saveState:state andEnabled:enabled];
	}
	else if ([service isEqualToString:Tumblr])
	{
		[_serviceTumblr saveState:state andEnabled:enabled];
	}
//	else if ([service isEqualToString:Nowa])
//	{
//		[_serviceNowa saveState:state andEnabled:enabled];
//	}
	else if ([service isEqualToString:Wassr])
	{
		[_serviceWassr saveState:state andEnabled:enabled];
	}
	else if ([service isEqualToString:Identica])
	{
		[_serviceIdentica saveState:state andEnabled:enabled];
	}
	else if ([service isEqualToString:Jisko])
	{
		[_serviceJisko saveState:state andEnabled:enabled];
	}
}

- (BOOL)status:(NSString *)service
{
	if ([service isEqualToString:Twitter])
	{
		return [_serviceTwitter status];
	}
	else if ([service isEqualToString:Jaiku])
	{
		return [_serviceJaiku status];
	}
	else if ([service isEqualToString:Tumblr])
	{
		return [_serviceTumblr status];
	}
//	else if ([service isEqualToString:Nowa])
//	{
//		return [_serviceNowa status];
//	}
	else if ([service isEqualToString:Wassr])
	{
		return [_serviceWassr status];
	}
	else if ([service isEqualToString:Identica])
	{
		return [_serviceIdentica status];
	}
	else if ([service isEqualToString:Jisko])
	{
		return [_serviceJisko status];
	}
	return NO;
}

- (BOOL)enable:(NSString *)service
{
	if ([service isEqualToString:Twitter])
	{
		return [_serviceTwitter enable];
	}
	else if ([service isEqualToString:Jaiku])
	{
		return [_serviceJaiku enable];
	}
	else if ([service isEqualToString:Tumblr])
	{
		return [_serviceTumblr enable];
	}
//	else if ([service isEqualToString:Nowa])
//	{
//		return [_serviceNowa enable];
//	}
	else if ([service isEqualToString:Wassr])
	{
		return [_serviceWassr enable];
	}
	else if ([service isEqualToString:Identica])
	{
		return [_serviceIdentica enable];
	}
	else if ([service isEqualToString:Jisko])
	{
		return [_serviceJisko enable];
	}
	return NO;
}

- (int)rateLimitOfTwitter
{
	return [_serviceTwitter rateLimit];
}

- (void)performPost:(id)objects
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	LOG(@"[%@ performPost]", [self className]);
	[_controller lockPost];
	NSString *status = [objects objectAtIndex:0];
	NSString *inReplyTo = [objects objectAtIndex:1];
	NSString *inReplyToService = [objects objectAtIndex:2];
	BOOL altEncodeTinyURL = [[objects objectAtIndex:3] boolValue];
	if (inReplyTo && ([inReplyTo isKindOfClass:[NSNull class]] || [inReplyTo isEqualToString:@""]))
	{
		inReplyTo = nil;
	}
	if (inReplyToService && ([inReplyToService isKindOfClass:[NSNull class]] || [inReplyToService isEqualToString:@""]))
	{
		inReplyToService = nil;
	}
	int postCount = 0;
	@try
	{
		NSString *encode = [NSString stringWithString:status];
		BOOL encodeTinyURL = [_preferences generalEncodeTinyURL];
		if (altEncodeTinyURL)
		{
			encodeTinyURL = !encodeTinyURL;
		}
		if (encodeTinyURL)
		{
			encode = [_controller encodeTinyURL:encode];
		}
		if (!encode)
		{
			postCount = -1;
		}
		else if (![status isEqualTo:@""])
		{
			@try
			{
				if ([_controller isEnabled:Twitter] && [_preferences postTwitter])
				{
					NSString *reply = @"";
					if (inReplyTo && [inReplyToService isEqualToString:Twitter])
					{
						reply = inReplyTo;
					}
					postCount++;
					[_serviceTwitter post:encode
								withReply:reply];
				}
				if ([_controller isEnabled:Jaiku] && [_preferences postJaiku])
				{
					postCount++;
					if ([_preferences accountJaikuUseXMPP] && [_preferences accountJaikuPostXMPP])
					{
						[_xmpp post:encode withService:Jaiku];
					}
					else if (inReplyTo && ![inReplyTo isEqualToString:@""]
							 && [inReplyToService isEqualToString:Jaiku])
					{
						[_serviceJaiku comment:encode
									  withItem:inReplyTo];
					}
					else
					{
						[_serviceJaiku post:encode withIcon:[_controller iconCode]];
					}
				}
				if ([_controller isEnabled:Tumblr] && [_preferences postTumblr] && [_controller isURL:encode])
				{
					postCount++;
					[_serviceTumblr post:encode];
				}
				if ([_controller isEnabled:Wassr] && [_preferences postWassr])
				{
					NSString *reply = @"";
					if (inReplyTo && [inReplyToService isEqualToString:Wassr])
					{
						reply = inReplyTo;
					}
					postCount++;
					[_serviceWassr post:encode
							  withReply:reply];
				}
//				if ([_controller isEnabled:Nowa] && [_preferences postNowa])
//				{
//					NSString *reply = @"";
//					if (inReplyTo && [inReplyToService isEqualToString:Nowa])
//					{
//						reply = inReplyTo;
//					}
//					postCount++;
//					[_serviceNowa post:encode
//							 withReply:reply];
//				}
				if ([_controller isEnabled:Identica] && [_preferences postIdentica])
				{
					NSString *reply = @"";
					if (inReplyTo && [inReplyToService isEqualToString:Identica])
					{
						reply = inReplyTo;
					}
					postCount++;
					if ([_preferences accountIdenticaUseXMPP] && [_preferences accountIdenticaPostXMPP])
					{
						[_xmpp post:encode withService:Identica];
					}
					else
					{
						[_serviceIdentica post:encode
									 withReply:reply];
					}
				}
				if ([_controller isEnabled:Jisko] && [_preferences postJisko])
				{
					NSString *reply = @"";
					if (inReplyTo && [inReplyToService isEqualToString:Jisko])
					{
						reply = inReplyTo;
					}
					postCount++;
					[_serviceJisko post:encode
							  withReply:reply];
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ performPost] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performPost] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[_controller posted:postCount];
	[_controller unlockPost];
	LOG(@"[%@ performPost] done", [self className]);
	[pool release];
	[NSThread exit];
}

- (void)post:(NSString *)status
withInReplyTo:(NSString *)inReplyTo
inReplyToService:(NSString *)inReplyToService
altEncodeTinyURL:(BOOL)altEncodeTinyURL
{
	LOG(@"[%@ post]", [self className]);
	//LOG(@"[%@ post] status: %p\n'%@'", [self className], status, status);
	//LOG(@"[%@ post] inReplyTo: %p\n'%@'", [self className], inReplyTo, inReplyTo);
	//LOG(@"[%@ post] inReplyToService: %p", [self className], inReplyToService);
	//LOG(@"[%@ post] inReplyToService: %p\n'%@'", [self className], inReplyToService, inReplyToService);
	//LOG(@"[%@ post] altEncodeTinyURL: %d", [self className], altEncodeTinyURL);
	@try
	{
		NSArray *objects = [[NSArray alloc] initWithObjects:
							status,
							(inReplyTo ? inReplyTo : (id)[NSNull null]),
							(inReplyToService ? inReplyToService : (id)[NSNull null]),
							[NSNumber numberWithBool:altEncodeTinyURL],
							nil];
		LOG(@"[%@ post]\n%@", [self className], objects);
		[NSThread detachNewThreadSelector:@selector(performPost:)
								 toTarget:self
							   withObject:objects];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ post] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)doRetrieveTimelineTwitter
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter retrieveTimeline];
	}
}

- (void)doRetrieveTimelineJaiku
{
	if ([_controller isEnabled:Jaiku])
	{
		[_serviceJaiku retrieveContactsFeed];
	}
}

- (void)doRetrieveTimelineWassr
{
	if ([_controller isEnabled:Wassr])
	{
		[_serviceWassr retrieveTimeline];
	}
}

//- (void)doRetrieveTimelineNowa
//{
//	if ([_controller isEnabled:Nowa])
//	{
//		[_serviceNowa retrieveTimeline];
//	}
//}

- (void)doRetrieveTimelineIdentica
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica retrieveTimeline];
	}
}

- (void)doRetrieveTimelineJisko
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko retrieveTimeline];
	}
}

- (void)doRetrieveRepliesTwitter
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter retrieveReplies];
	}
}

- (void)doRetrieveRepliesWassr
{
	if ([_controller isEnabled:Wassr])
	{
		[_serviceWassr retrieveReplies];
	}
}

- (void)doRetrieveRepliesIdentica
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica retrieveReplies];
	}
}

- (void)doRetrieveRepliesJisko
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko retrieveReplies];
	}
}

- (void)doRetrieveDirectMessageTwitter
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter retrieveDirectMessage];
	}
}

- (void)doRetrieveDirectMessageIdentica
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica retrieveDirectMessage];
	}
}

- (void)doRetrieveDirectMessageJisko
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko retrieveDirectMessage];
	}
}

- (void)doRetrieveChannelWassr
{
	if ([_controller isEnabled:Wassr])
	{
		[_serviceWassr retrieveChannel];
	}
}

- (void)doFavoriteTwitter:(NSString *)item_id
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter favorite:item_id];
	}
}

- (void)doFavoriteWassr:(NSString *)item_id
{
	if ([_controller isEnabled:Wassr])
	{
		id item = [_controller fetchTimeline:item_id withService:Wassr];
		if (item)
		{
			NSString *rid = [item valueForKey:KeyRId];
			[_serviceWassr favorite:rid];
		}
	}
}

- (void)doFavoriteIdentica:(NSString *)item_id
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica favorite:item_id];
	}
}

- (void)doFavoriteJisko:(NSString *)item_id
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko favorite:item_id];
	}
}

- (void)doFavorite:(NSString *)item_id
	   withService:(NSString *)service
{
	//LOG(@"[%@ doFavorite] %@ : %@", [self className], item_id, service);
	if ([service isEqualToString:Twitter])
	{
		[self doFavoriteTwitter:item_id];
	}
	else if ([service isEqualToString:Wassr])
	{
		[self doFavoriteWassr:item_id];
	}
	else if ([service isEqualToString:Identica])
	{
		[self doFavoriteIdentica:item_id];
	}
	else if ([service isEqualToString:Jisko])
	{
		[self doFavoriteJisko:item_id];
	}
}

- (void)doPermalinkTwitter:(NSString *)item_id
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter permalink:item_id];
	}
}

- (void)doPermalinkJaiku:(NSString *)item_id
{
	if ([_controller isEnabled:Jaiku])
	{
		[_serviceJaiku permalink:item_id];
	}
}

- (void)doPermalinkWassr:(NSString *)item_id
{
	if ([_controller isEnabled:Wassr])
	{
		[_serviceWassr permalink:item_id];
	}
}

//- (void)doPermalinkNowa:(NSString *)item_id
//{
//	if ([_controller isEnabled:Nowa])
//	{
//		[_serviceNowa permalink:item_id];
//	}
//}

- (void)doPermalinkIdentica:(NSString *)item_id
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica permalink:item_id];
	}
}

- (void)doPermalinkJisko:(NSString *)item_id
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko permalink:item_id];
	}
}

- (void)doPermalink:(NSString *)item_id
		withService:(NSString *)service
{
	//LOG(@"[%@ doPermalink] %@ : %@", [self className], item_id, service);
	if ([service isEqualToString:Twitter])
	{
		[self doPermalinkTwitter:item_id];
	}
	else if ([service isEqualToString:Jaiku])
	{
		[self doPermalinkJaiku:item_id];
	}
	else if ([service isEqualToString:Wassr])
	{
		[self doPermalinkWassr:item_id];
	}
//	else if ([service isEqualToString:Nowa])
//	{
//		[self doPermalinkNowa:item_id];
//	}
	else if ([service isEqualToString:Identica])
	{
		[self doPermalinkIdentica:item_id];
	}
	else if ([service isEqualToString:Jisko])
	{
		[self doPermalinkJisko:item_id];
	}
}

- (void)doOpenURLTwitter:(NSString *)item_id
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter openURL:item_id];
	}
}

- (void)doOpenURLJaiku:(NSString *)item_id
{
	if ([_controller isEnabled:Jaiku])
	{
		[_serviceJaiku openURL:item_id];
	}
}

- (void)doOpenURLWassr:(NSString *)item_id
{
	if ([_controller isEnabled:Wassr])
	{
		[_serviceWassr openURL:item_id];
	}
}

//- (void)doOpenURLNowa:(NSString *)item_id
//{
//	if ([_controller isEnabled:Nowa])
//	{
//		[_serviceNowa openURL:item_id];
//	}
//}

- (void)doOpenURLIdentica:(NSString *)item_id
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica openURL:item_id];
	}
}

- (void)doOpenURLJisko:(NSString *)item_id
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko openURL:item_id];
	}
}

- (void)doOpenURL:(NSString *)item_id
	  withService:(NSString *)service
{
	//LOG(@"[%@ doOpenURL] %@ : %@", [self className], item_id, service);
	if ([service isEqualToString:Twitter])
	{
		[self doOpenURLTwitter:item_id];
	}
	else if ([service isEqualToString:Jaiku])
	{
		[self doOpenURLJaiku:item_id];
	}
	else if ([service isEqualToString:Wassr])
	{
		[self doOpenURLWassr:item_id];
	}
//	else if ([service isEqualToString:Nowa])
//	{
//		[self doOpenURLNowa:item_id];
//	}
	else if ([service isEqualToString:Identica])
	{
		[self doOpenURLIdentica:item_id];
	}
	else if ([service isEqualToString:Jisko])
	{
		[self doOpenURLJisko:item_id];
	}
}

- (void)doReplyTwitter:(NSString *)item_id
{
	if ([_controller isEnabled:Twitter])
	{
		[_serviceTwitter doReply:item_id];
	}
}

- (void)doReplyJaiku:(NSString *)item_id
{
	if ([_controller isEnabled:Jaiku])
	{
		[_serviceJaiku doReply:item_id];
	}
}

//- (void)doReplyNowa:(NSString *)item_id
//{
//	if ([_controller isEnabled:Nowa])
//	{
//		[_serviceNowa doReply:item_id];
//	}
//}

- (void)doReplyWassr:(NSString *)item_id
{
	if ([_controller isEnabled:Wassr])
	{
		[_serviceWassr doReply:item_id];
	}
}

- (void)doReplyIdentica:(NSString *)item_id
{
	if ([_controller isEnabled:Identica])
	{
		[_serviceIdentica doReply:item_id];
	}
}

- (void)doReplyJisko:(NSString *)item_id
{
	if ([_controller isEnabled:Jisko])
	{
		[_serviceJisko doReply:item_id];
	}
}

- (void)doReply:(NSString *)item_id
	withService:(NSString *)service
{
	//LOG(@"[%@ doReply]\n%@, %@", [self className], item_id, service);
	if ([service isEqualToString:Twitter])
	{
		[self doReplyTwitter:item_id];
	}
	else if ([service isEqualToString:Jaiku])
	{
		[self doReplyJaiku:item_id];
	}
//	else if ([service isEqualToString:Nowa])
//	{
//		[self doReplyNowa:item_id];
//	}
	else if ([service isEqualToString:Wassr])
	{
		[self doReplyWassr:item_id];
	}
	else if ([service isEqualToString:Identica])
	{
		[self doReplyIdentica:item_id];
	}
	else if ([service isEqualToString:Jisko])
	{
		[self doReplyJisko:item_id];
	}
}

- (void)doRetweet:(NSString *)item_id
	  withService:(NSString *)service
{
	[[self service:service] doRetweet:item_id];
}

- (void)doDirectMessage:(NSString *)item_id
			withService:(NSString *)service
{
	[[self service:service] doDirectMessage:item_id];
}

- (void)performLockRetrieve:(id)object
{
	@synchronized(_lockRetrieve)
	{
		_lockedRetrieve = YES;
		[_lockRetrieve lock];
	}
}

- (void)lockRetrieve
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performLockRetrieve:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performLockRetrieve:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performUnlockRetrieve:(id)object
{
	@synchronized(_lockRetrieve)
	{
		if (_lockedRetrieve)
		{
			_lockedRetrieve = NO;
			[_lockRetrieve unlock];
		}
	}
}

- (void)unlockRetrieve
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performUnlockRetrieve:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performUnlockRetrieve:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)queueingCommand:(NSString *)command
			withService:(NSString *)service
{
	@synchronized(_queueRetrieve)
	{
		NSEnumerator *enumerator = [_queueRetrieve objectEnumerator];
		id object;
		BOOL queueing = YES;
		while ((object = [enumerator nextObject]))
		{
			if ([[object valueForKey:KeyTimelineCommand] isEqualToString:command] &&
				[[object valueForKey:KeyTimelineService] isEqualToString:service])
			{
				queueing = NO;
				break;
			}
		}
		if (queueing)
		{
			//LOG(@"[%@ queueingCommand] %@:%@", [self className], service, command);
			[_queueRetrieve addObject:[NSDictionary dictionaryWithObjectsAndKeys:
									   command, KeyTimelineCommand,
									   service, KeyTimelineService,
									   nil]];
		}
	}
	//[self unlockRetrieve];
}

- (void)doRetrieveTimeline
{
	BOOL queueing = NO;
	if ([_preferences accountTwitterExecMenu])
	{
		[self queueingCommand:CmdTimeline withService:Twitter];
		queueing = YES;
	}
	if ([_preferences accountWassrExecMenu])
	{
		[self queueingCommand:CmdTimeline withService:Wassr];
		[self queueingCommand:CmdChannel withService:Wassr];
		queueing = YES;
	}
//	if ([_preferences accountNowaExecMenu])
//	{
//		[self queueingCommand:CmdTimeline withService:Nowa];
//		queueing = YES;
//	}
	if ([_preferences accountIdenticaExecMenu])
	{
		[self queueingCommand:CmdTimeline withService:Identica];
		queueing = YES;
	}
	if ([_preferences accountJiskoExecMenu])
	{
		[self queueingCommand:CmdTimeline withService:Jisko];
		queueing = YES;
	}
	if ([_preferences accountJaikuExecMenu])
	{
		[self queueingCommand:CmdTimeline withService:Jaiku];
		queueing = YES;
	}
	if (queueing)
	{
		[self unlockRetrieve];
	}
}

- (void)doRetrieveReplies
{
	BOOL queueing = NO;
	if ([_preferences accountTwitterExecMenu])
	{
		[self queueingCommand:CmdReplies withService:Twitter];
		queueing = YES;
	}
	if ([_preferences accountWassrExecMenu])
	{
		[self queueingCommand:CmdReplies withService:Wassr];
		queueing = YES;
	}
	if ([_preferences accountIdenticaExecMenu])
	{
		[self queueingCommand:CmdReplies withService:Identica];
		queueing = YES;
	}
	if ([_preferences accountJiskoExecMenu])
	{
		[self queueingCommand:CmdReplies withService:Jisko];
		queueing = YES;
	}
	if (queueing)
	{
		[self unlockRetrieve];
	}
}

- (void)doRetrieveDirectMessage
{
	BOOL queueing = NO;
	if ([_preferences accountTwitterExecMenu])
	{
		[self queueingCommand:CmdDM withService:Twitter];
		queueing = YES;
	}
	if ([_preferences accountIdenticaExecMenu])
	{
		[self queueingCommand:CmdDM withService:Identica];
		queueing = YES;
	}
	if ([_preferences accountJiskoExecMenu])
	{
		[self queueingCommand:CmdDM withService:Jisko];
		queueing = YES;
	}
	if (queueing)
	{
		[self unlockRetrieve];
	}
}

- (void)threadRetrieve:(id)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		for (;;)
		{
			NSAutoreleasePool *internalPool = [[NSAutoreleasePool alloc] init];
			[_lockRetrieve lock];
			@try
			{
				@synchronized(_queueRetrieve)
				{
					@try
					{
						while ([_queueRetrieve count] > 0)
						{
							id obj = [_queueRetrieve objectAtIndex:0];
							NSString *command = [obj valueForKey:KeyTimelineCommand];
							NSString *service = [obj valueForKey:KeyTimelineService];
							//LOG(@"[%@ threadRetrieve] %@:%@", [self className], service, command);
							if ([command isEqualToString:CmdTimeline])
							{
								if ([service isEqualToString:Twitter])
								{
									[self doRetrieveTimelineTwitter];
								}
								else if ([service isEqualToString:Jaiku])
								{
									[self doRetrieveTimelineJaiku];
								}
								else if ([service isEqualToString:Wassr])
								{
									[self doRetrieveTimelineWassr];
								}
//								else if ([service isEqualToString:Nowa])
//								{
//									[self doRetrieveTimelineNowa];
//								}
								else if ([service isEqualToString:Identica])
								{
									[self doRetrieveTimelineIdentica];
								}
								else if ([service isEqualToString:Jisko])
								{
									[self doRetrieveTimelineJisko];
								}
							}
							else if ([command isEqualToString:CmdChannel])
							{
								if ([service isEqualToString:Wassr])
								{
									[self doRetrieveChannelWassr];
								}
							}
							else if ([command isEqualToString:CmdReplies])
							{
								if ([service isEqualToString:Twitter])
								{
									[self doRetrieveRepliesTwitter];
								}
								else if ([service isEqualToString:Wassr])
								{
									[self doRetrieveRepliesWassr];
								}
								else if ([service isEqualToString:Identica])
								{
									[self doRetrieveRepliesIdentica];
								}
								else if ([service isEqualToString:Jisko])
								{
									[self doRetrieveRepliesJisko];
								}
							}
							else if ([command isEqualToString:CmdDM])
							{
								if ([service isEqualToString:Twitter])
								{
									[self doRetrieveDirectMessageTwitter];
								}
								else if ([service isEqualToString:Identica])
								{
									[self doRetrieveDirectMessageIdentica];
								}
								else if ([service isEqualToString:Jisko])
								{
									[self doRetrieveDirectMessageJisko];
								}
							}
							[_queueRetrieve removeObjectAtIndex:0];
						}
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ threadRetrieve] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadRetrieve] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			[_lockRetrieve unlock];
			[self lockRetrieve];
			[internalPool release];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ threadRetrieve] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[pool release];
	[NSThread exit];
}

- (void)performLockTick:(id)object
{
	@synchronized(_lockTick)
	{
		_lockedTick = YES;
		[_lockTick lock];
	}
}

- (void)lockTick
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performLockTick:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performLockTick:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performUnlockTick:(id)object
{
	@synchronized(_lockTick)
	{
		if (_lockedTick)
		{
			_lockedTick = NO;
			[_lockTick unlock];
		}
	}
}

- (void)unlockTick
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performUnlockTick:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performUnlockTick:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)threadTickTimer:(id)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		for (;;)
		{
			NSAutoreleasePool *internalPool = [[NSAutoreleasePool alloc] init];
			[_lockTick lock];
			@try
			{
				NSDate *date = nil;
				@synchronized(_queueTick)
				{
					if ([_queueTick count] > 0)
					{
						date = [_queueTick objectAtIndex:0];
					}
				}
				if (date)
				{
					//LOG(@"[%@ threadTickTimer]", [self className]);
					[date retain];
					@try
					{
						if (![_controller isSleep])
						{
							BOOL queueing = NO;
							// Twitter
							if ([_serviceTwitter checkRetrieveTimeline:date])
							{
								[_serviceTwitter setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdTimeline withService:Twitter];
								queueing = YES;
							}
							if ([_serviceTwitter checkRetrieveReplies:date])
							{
								[_serviceTwitter setupRetrieveDateReplies:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdReplies withService:Twitter];
								queueing = YES;
							}
							if ([_serviceTwitter checkRetrieveDM:date])
							{
								[_serviceTwitter setupRetrieveDateDM:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdDM withService:Twitter];
								queueing = YES;
							}
							// Wassr
							if ([_serviceWassr checkRetrieveTimeline:date])
							{
								[_serviceWassr setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdTimeline withService:Wassr];
								queueing = YES;
							}
							if ([_serviceWassr checkRetrieveReplies:date])
							{
								[_serviceWassr setupRetrieveDateReplies:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdReplies withService:Wassr];
								queueing = YES;
							}
							if ([_serviceWassr checkRetrieveChannel:date])
							{
								[_serviceWassr setupRetrieveDateChannel:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdChannel withService:Wassr];
								queueing = YES;
							}
//							// nowa
//							if ([_serviceNowa checkRetrieveTimeline:date])
//							{
//								[_serviceNowa setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:36000]];
//								[self queueingCommand:CmdTimeline withService:Nowa];
//								queueing = YES;
//							}
							// Identica
							if ([_serviceIdentica checkRetrieveTimeline:date])
							{
								[_serviceIdentica setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdTimeline withService:Identica];
								queueing = YES;
							}
							if ([_serviceIdentica checkRetrieveReplies:date])
							{
								[_serviceIdentica setupRetrieveDateReplies:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdReplies withService:Identica];
								queueing = YES;
							}
							if ([_serviceIdentica checkRetrieveDM:date])
							{
								[_serviceIdentica setupRetrieveDateDM:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdDM withService:Identica];
								queueing = YES;
							}
							// Jisko
							if ([_serviceJisko checkRetrieveTimeline:date])
							{
								[_serviceJisko setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdTimeline withService:Jisko];
								queueing = YES;
							}
							if ([_serviceJisko checkRetrieveReplies:date])
							{
								[_serviceJisko setupRetrieveDateReplies:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdReplies withService:Jisko];
								queueing = YES;
							}
							if ([_serviceJisko checkRetrieveDM:date])
							{
								[_serviceJisko setupRetrieveDateDM:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdDM withService:Jisko];
								queueing = YES;
							}
							// Jaiku
							if ([_serviceJaiku checkRetrieveTimeline:date])
							{
								[_serviceJaiku setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:36000]];
								[self queueingCommand:CmdTimeline withService:Jaiku];
								queueing = YES;
							}
							if (queueing)
							{
								[self unlockRetrieve];
							}
						}
						// XMPP
						[_xmpp keepConnections:date];
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ threadTickTimer] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
					@finally
					{
						[date release];
					}
				}
				@synchronized(_queueTick)
				{
					if ([_queueTick count] > 0)
					{
						[_queueTick removeObjectAtIndex:0];
					}
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadTickTimer] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			[_lockTick unlock];
			[self lockTick];
			[internalPool release];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ threadTickTimer] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[pool release];
	[NSThread exit];
}

- (void)tickTimer:(NSDate *)date
{
	@try
	{
		@synchronized(_queueTick)
		{
			[_queueTick addObject:[date copy]];
		}
		[self unlockTick];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ tickTimer] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

@end
