//
//  AfficheurTimeline.h
//  Afficheur
//
//  Created by kichi on 08/09/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AfficheurController;
@class AfficheurPreferences;
@class Service;

@interface AfficheurTimeline : NSObject {
	IBOutlet id						_panel;
	IBOutlet id						_view;
	IBOutlet id						_scroll;
	IBOutlet id						_statusBar;
	IBOutlet id						_timeline;
	IBOutlet id						_profile;
	IBOutlet id						_past;

	NSTableColumn*					_columnIcon;
	NSTableColumn*					_columnText;
	NSTableColumn*					_columnDate;

	AfficheurController*			_controller;
	AfficheurPreferences*			_preferences;

	NSMutableDictionary*			_removeDic;

	NSPredicate*					_predicateService;
	NSPredicate*					_predicateUser;
	NSString*						_titleService;
	NSString*						_titleUser;
	NSString*						_textStatusBar;

	NSLock*							_lockTimeline;
	BOOL							_inhibitTimeline;

	NSLock*							_lockProfile;
	BOOL							_lockedProfile;
	NSMutableArray*					_queueProfile;
	NSLock*							_lockQueueProfile;
	NSMutableDictionary*			_queueError;
	BOOL							_isPhoto;

	NSLock*							_lockNotify;
	BOOL							_lockedNotify;
	NSMutableArray*					_queueNotify;
	NSLock*							_lockQueueNotify;

	NSLock*							_lockPast;
	BOOL							_lockedPast;
	NSMutableArray*					_queuePast;
	NSLock*							_lockQueuePast;

	NSMutableArray*					_queuePhotoURL;
	NSLock*							_lockQueuePhotoURL;

	NSMutableArray*					_queueAdd;

	NSThread*						_mainThread;

	BOOL							_keyView;
	BOOL							_selectedRow;
}

- (id)initWithController:(AfficheurController *)controller
			 preferences:(AfficheurPreferences *)preferences;

- (void)startThread;

- (BOOL)isDisplay;
- (void)setDisplay:(BOOL)state;

- (BOOL)canHide;
- (void)setCanHide:(BOOL)canHide;

- (BOOL)isEnabledReply;
- (BOOL)isEnabledFavorite;
- (BOOL)isEnabledOpenPermaLink;
- (BOOL)isEnabledOpenURL;
- (BOOL)isEnabledRetweet;
- (BOOL)isEnabledDirectMessage;

- (NSImage *)profileImage:(NSString *)userProfile;

- (NSDictionary *)fetch:(NSString *)item_id
			withService:(NSString *)service;
- (NSDictionary *)fetchALL:(NSString *)item_id
			   withService:(NSString *)service;
- (NSDictionary *)fetchRid:(NSString *)item_id
			   withService:(NSString *)service;
- (NSDictionary *)begins:(NSString *)item_id
			 withService:(NSString *)service
					user:(NSString *)user;

- (NSString *)removed:(NSString *)item_id
		  withService:(NSString *)service;

- (void)queueingParsePhotoURL:(NSDictionary *)item;

- (BOOL)addTimeline:(NSDictionary *)item
		withService:(Service *)service;
- (void)finishAddTimeline:(NSArray *)objects
			   withNotify:(NSArray *)notify
				  service:(Service *)service;

- (id)replace:(NSString *)item_id
  withService:(NSString *)service
	 photoURL:(NSString *)photoURL;

- (float)withOfTimeline;

- (NSDictionary *)appearanceColor:(NSDictionary *)object
					   withColors:(NSDictionary *)colors;
- (void)formatText:(id)object
	   withService:(Service *)service
	   appearances:(NSDictionary *)appearances;
- (void)reformat;

- (NSArray *)selectedObjects;

- (void)setSelectedItem:(NSString *)item_id
			withService:(NSString *)service;

- (void)releaseFiltering;

- (void)applicationWillTerminate;

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem;

- (void)tableView:(NSTableView *)aTableView
	 flagsChanged:(NSEvent *)theEvent;

- (IBAction)onClicked:(id)sender;

@end

APPKIT_EXTERN NSString*	LogoTwitter;
APPKIT_EXTERN NSString*	LogoJaiku;
APPKIT_EXTERN NSString*	LogoWassr;
//APPKIT_EXTERN NSString*	LogoNowa;
APPKIT_EXTERN NSString*	LogoIdentica;
APPKIT_EXTERN NSString*	LogoJisko;
APPKIT_EXTERN NSString*	Mail;
