//
//  AfficheurTimeline.m
//  Afficheur
//
//  Created by kichi on 08/09/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "AfficheurTimeline.h"
#import "AfficheurController.h"
#import "AfficheurPreferences.h"
#import "AfficheurPanel.h"
#import "AfficheurGrowl.h"
#import "Service.h"
#import "ServiceJaiku.h"
#import "HTTP.h"
#import "NSStringOgreKit.h"
#import <OgreKit/OgreKit.h>
#import "TextFieldCell.h"
#import <math.h>
#import "i18n.h"


@implementation AfficheurTimeline

// NIB file
static NSString *NibFile	= @"Timeline";

// Title
static NSString *TIMELINE	= @"Timeline";

// Past controll
static NSString *Past		= @"past";

// Predicate
static NSString *Predicate	= @"predicate";
static NSString *Title		= @"title";
static NSString *Status		= @"status";

// Logo
NSString *LogoTwitter		= @"logo-Twitter";
NSString *LogoJaiku			= @"logo-Jaiku";
NSString *LogoWassr			= @"logo-Wassr";
//NSString *LogoNowa			= @"logo-nowa";
NSString *LogoIdentica		= @"logo-identica";
NSString *LogoJisko			= @"logo-Jisko";
NSString *Mail				= @"mail";


- (void)loadNib
{
	//LOG(@"[%@ loadNib]", [self className]);
	[NSBundle loadNibNamed:NibFile owner:self];
}

- (id)initWithController:(AfficheurController *)controller
			 preferences:(AfficheurPreferences *)preferences;
{
	//LOG(@"[%@ init]", [self className]);
	self = [super init];
	if (self)
	{
		_controller = controller;
		_preferences = preferences;
		_removeDic = [[NSMutableDictionary alloc] init];

		_columnIcon = nil;
		_columnText = nil;
		_columnDate = nil;

		_predicateService = nil;
		_predicateUser = nil;
		_titleService = nil;
		_titleUser = nil;
		_textStatusBar = nil;

		_lockTimeline = [[NSLock alloc] init];
		_inhibitTimeline = NO;
		
		_lockProfile = [[NSLock alloc] init];
		_lockedProfile = NO;
		_queueProfile = [[NSMutableArray alloc] init];
		_lockQueueProfile = [[NSLock alloc] init];
		_queueError = [[NSMutableDictionary alloc] init];

		_lockNotify = [[NSLock alloc] init];
		_lockedNotify = NO;
		_queueNotify = [[NSMutableArray alloc] init];
		_lockQueueNotify = [[NSLock alloc] init];

		_lockPast = [[NSLock alloc] init];
		_lockedPast = NO;
		_queuePast = [[NSMutableArray alloc] init];
		_lockQueuePast = [[NSLock alloc] init];

		_queuePhotoURL = [[NSMutableArray alloc] init];
		_lockQueuePhotoURL = [[NSLock alloc] init];

		_queueAdd = [[NSMutableArray alloc] init];

		_mainThread = nil;
		_keyView = NO;
		_selectedRow = NO;
		[self loadNib];
	}
	return self;
}

- (void)dealloc
{
	if (_predicateService)
	{
		[_predicateService release];
	}
	if (_predicateUser)
	{
		[_predicateUser release];
	}
	if (_titleService)
	{
		[_titleService release];
	}
	if (_titleUser)
	{
		[_titleUser release];
	}
	if (_textStatusBar)
	{
		[_textStatusBar release];
	}
	[_removeDic release];
	[_lockTimeline release];
	[_lockProfile release];
	[_queueProfile release];
	[_lockQueueProfile release];
	[_lockPast release];
	[_queuePast release];
	[_lockQueuePast release];
	[_queuePhotoURL release];
	[_lockQueuePhotoURL release];
	[_queueAdd release];
	[super dealloc];
}

- (BOOL)isDisplay
{
	return [_panel isVisible];
}

- (void)setDisplay:(BOOL)state
{
	if (state)
	{
		[_panel orderFront:self];
	}
	else
	{
		[_panel orderOut:self];
	}
}

- (BOOL)canHide
{
	return [_panel canHide];
}

- (void)setCanHide:(BOOL)canHide
{
	[_panel setCanHide:canHide];
}

- (BOOL)isEnabledReply
{
	return _selectedRow;
}

- (BOOL)isEnabledFavorite
{
	return _selectedRow;
}

- (BOOL)isEnabledOpenPermaLink
{
	return _selectedRow;
}

- (BOOL)isEnabledOpenURL
{
	return _selectedRow;
}

- (BOOL)isEnabledRetweet
{
	if (_selectedRow)
	{
		NSArray *selected = [_timeline selectedObjects];
		if (selected && ([selected count] > 0))
		{
			id obj = [selected objectAtIndex:0];
			if ([[obj valueForKey:KeyService] isEqualToString:Jaiku])
			{
				return NO;
			}
			if ([[obj valueForKey:KeyService] isEqualToString:Wassr] &&
				[[obj valueForKey:KeyFrom] isEqualToString:FromXMPP])
			{
				return NO;
			}
			if ([[obj valueForKey:KeyProtected] intValue] == 0)
			{
				return YES;
			}
		}
	}
	return NO;
}

- (BOOL)isEnabledDirectMessage
{
	if (_selectedRow)
	{
		NSArray *selected = [_timeline selectedObjects];
		if (selected && ([selected count] > 0))
		{
			id obj = [selected objectAtIndex:0];
			NSString *service = [obj valueForKey:KeyService];
			if ([service isEqualToString:Twitter])
			{
				return YES;
			}
			if ([service isEqualToString:Identica])
			{
				return YES;
			}
			if ([service isEqualToString:Jisko])
			{
				return YES;
			}
		}
	}
	return NO;
}

- (NSDictionary *)fetch:(NSString *)item_id
			withService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@) AND (%K == %@)",
							   KeyFrom, FromAPI,
							   KeyService, service,
							   KeyId, item_id];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return [fetch objectAtIndex:0];
}

- (NSArray *)arrayFetchALL:(NSString *)item_id
			   withService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyId, item_id];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSDictionary *)fetchALL:(NSString *)item_id
			   withService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyId, item_id];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return [fetch objectAtIndex:0];
}

- (NSDictionary *)fetchRid:(NSString *)rid
			   withService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyRId, rid];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return [fetch objectAtIndex:0];
}

- (NSArray *)fetchFromAPIWithService:(NSString *)service
								user:(NSString *)user
								text:(NSString *)text
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@) AND (%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyFrom, FromAPI,
							   KeyUser, user,
							   KeyText, text];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSArray *)fetchFromAPIWithService:(NSString *)service
								user:(NSString *)user
							text_raw:(NSString *)text_raw
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@) AND (%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyFrom, FromAPI,
							   KeyUser, user,
							   KeyTextRaw, text_raw];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSArray *)fetchFromXMPPWithService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyFrom, FromXMPP];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSArray *)fetchFromXMPPWithService:(NSString *)service
								 user:(NSString *)user
								 text:(NSString *)text
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@) AND (%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyFrom, FromXMPP,
							   KeyUser, user,
							   KeyText, text];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSArray *)fetchFromXMPPWithService:(NSString *)service
								 user:(NSString *)user
							 text_raw:(NSString *)text_raw
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@) AND (%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyFrom, FromXMPP,
							   KeyUser, user,
							   KeyTextRaw, text_raw];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSArray *)fetchErrorWithService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:@"(%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyId, @"0"];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return fetch;
}

- (NSString *)removed:(NSString *)item_id
		  withService:(NSString *)service
{
	return [_removeDic valueForKey:[NSString stringWithFormat:@"%@:%@", service, item_id]];
}

- (NSDictionary *)begins:(NSString *)item_id
			 withService:(NSString *)service
					user:(NSString *)user
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:
							   @"(%K == %@) AND (%K == %@) AND (%K beginswith %@)",
							   KeyService, service,
							   KeyUser, user,
							   KeyId, item_id];
	NSArray *fetch = nil;
	@synchronized(_timeline)
	{
		fetch = [[_timeline content] filteredArrayUsingPredicate:predicates];
	}
	if ([fetch count] <= 0)
	{
		return nil;
	}
	return [fetch objectAtIndex:0];
}

- (void)performLockProfile:(id)object
{
	@synchronized(_lockProfile)
	{
		//LOG(@"[%@ lockProfile]", [self className]);
		_lockedProfile = YES;
		[_lockProfile lock];
	}
}

- (void)lockProfile
{
	//LOG(@"[%@ lockProfile]", [self className]);
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performLockProfile:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performLockProfile:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performUnlockProfile:(id)object
{
	@synchronized(_lockProfile)
	{
		if (_lockedProfile)
		{
			//LOG(@"[%@ unlockProfile]", [self className]);
			_lockedProfile = NO;
			[_lockProfile unlock];
		}
	}
}

- (void)unlockProfile
{
	//LOG(@"[%@ unlockProfile]", [self className]);
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performUnlockProfile:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performUnlockProfile:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performLockNotify:(id)object
{
	@synchronized(_lockNotify)
	{
		if (!_lockedNotify)
		{
			_lockedNotify = YES;
			[_lockNotify lock];
		}
	}
}

- (void)lockNotify
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performLockNotify:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performLockNotify:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performUnlockNotify:(id)object
{
	@synchronized(_lockNotify)
	{
		if (_lockedNotify)
		{
			_lockedNotify = NO;
			[_lockNotify unlock];
		}
	}
}

- (void)unlockNotify
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performUnlockNotify:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performUnlockNotify:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performLockPast:(id)object
{
	@synchronized(_lockPast)
	{
		if (!_lockedPast)
		{
			_lockedPast = YES;
			[_lockPast lock];
		}
	}
}

- (void)lockPast
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performLockPast:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performLockPast:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performUnlockPast:(id)object
{
	@synchronized(_lockPast)
	{
		if (_lockedPast)
		{
			_lockedPast = NO;
			[_lockPast unlock];
		}
	}
}

- (void)unlockPast
{
	if ([[NSThread currentThread] isEqual:_mainThread])
	{
		[self performUnlockPast:nil];
	}
	else
	{
		[self performSelectorOnMainThread:@selector(performUnlockPast:)
							   withObject:nil
							waitUntilDone:YES];
	}
}

- (void)performGetMainThread:(id)object
{
	_mainThread = [NSThread currentThread];
}

- (void)startThread
{
	//LOG(@"[%@ startThread]\n%@", [self className], [NSThread currentThread]);
	[self performSelectorOnMainThread:@selector(performGetMainThread:)
						   withObject:nil
						waitUntilDone:YES];
	[self lockProfile];
	[NSThread detachNewThreadSelector:@selector(threadProfileImage:)
							 toTarget:self
						   withObject:nil];
	[self unlockProfile];
	[self lockNotify];
	[NSThread detachNewThreadSelector:@selector(threadNotify:)
							 toTarget:self
						   withObject:nil];
	[self unlockNotify];
	[self lockPast];
	[NSThread detachNewThreadSelector:@selector(threadPast:)
							 toTarget:self
						   withObject:nil];
	[self unlockPast];
}

- (NSImage *)profileImage:(NSString *)userProfile
{
	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"%K == %@",
							  KeyUserProfile,
							  userProfile];
	NSArray *fetch = nil;
	@synchronized(_profile)
	{
		fetch = [[_profile content] filteredArrayUsingPredicate:predicate];
	}
	if (!fetch || [fetch count] <= 0)
	{
		return nil;
	}
	return [[fetch objectAtIndex:0] valueForKey:KeyProfileImage];
}

- (NSDictionary *)fetchPast:(NSString *)item_id
				withService:(NSString *)service
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:
							   @"(%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyId, item_id];
	@synchronized(_past)
	{
		NSArray *fetch = [[_past content] filteredArrayUsingPredicate:predicates];
		if (fetch && [fetch count] > 0)
		{
			return [fetch objectAtIndex:0];
		}
	}
	return nil;
}

- (NSDictionary *)fetchPast:(NSString *)item_id
				withService:(NSString *)service
					   kind:(NSString *)kind
{
	NSPredicate *predicates = [NSPredicate predicateWithFormat:
							   @"(%K == %@) AND (%K == %@) AND (%K == %@)",
							   KeyService, service,
							   KeyId, item_id,
							   KeyKind, kind];
	@synchronized(_past)
	{
		NSArray *fetch = [[_past content] filteredArrayUsingPredicate:predicates];
		if (fetch && [fetch count] > 0)
		{
			return [fetch objectAtIndex:0];
		}
	}
	return nil;
}

- (void)performNotifyIcon:(NSArray *)object
{
	@try
	{
		NSImage *icon = [object objectAtIndex:0];
		NSImage *profileImage = [object objectAtIndex:1];
		NSImage *serviceIcon = [object objectAtIndex:2];
		[icon lockFocus];
		if (![profileImage isKindOfClass:[NSNull class]])
		{
			[profileImage compositeToPoint:NSMakePoint(4, 4)
								 operation:NSCompositeSourceOver];
		}
		if (![serviceIcon isKindOfClass:[NSNull class]])
		{
			[serviceIcon compositeToPoint:NSMakePoint(0, 0)
								operation:NSCompositeSourceOver];
		}
		[icon unlockFocus];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performNotifyIcon] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)notify:(id)object
{
	@try
	{
		NSImage *icon = [[[NSImage alloc] initWithSize:NSMakeSize(48+4, 48+4)] autorelease];
		if (![[object valueForKey:KeyUser] isEqualToString:@""])
		{
			NSImage *profileImage = [object valueForKey:KeyProfileImage];
			NSImage *serviceIcon = [object valueForKey:KeyServiceIcon];
			if (!profileImage)
			{
				profileImage = (NSImage *)[NSNull null];
			}
			if (!serviceIcon)
			{
				serviceIcon = (NSImage *)[NSNull null];
			}
			@synchronized([NSApplication sharedApplication])
			{
				[self performSelectorOnMainThread:@selector(performNotifyIcon:)
									   withObject:[NSArray arrayWithObjects:
												   icon, profileImage, serviceIcon, nil]
									waitUntilDone:YES];
			}
		}
		else
		{
			icon = [object valueForKey:KeyProfileImage];
		}
		NSData *data = nil;
		if (icon)
		{
			data = [NSData dataWithData:[icon TIFFRepresentation]];
		}
		[_controller notifyWithTitle:[object valueForKey:KeyNotifyTitle]
						 description:[object valueForKey:KeyTextNotify]
					notificationName:[object valueForKey:KeyNotify]
							iconData:data
						clickContext:[NSString stringWithFormat:@"%@ %@",
									  [object valueForKey:KeyService],
									  [object valueForKey:KeyId]]];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ notify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (BOOL)notify1:(id)object
{
	BOOL notified = NO;
	@try
	{
		id item = [self fetchALL:[object valueForKey:KeyId]
					 withService:[object valueForKey:KeyService]];
		if (item &&
			![[item valueForKey:KeyFirst] boolValue] &&
			![self fetchPast:[item valueForKey:KeyId] withService:[item valueForKey:KeyService]])
		{
			NSString *userProfile = [item valueForKey:KeyUserProfile];
			id profileImage = nil;
			if ([userProfile isEqualToString:@""])
			{
				profileImage = @"";
			}
			else
			{
				profileImage = [self profileImage:userProfile];
				if (!profileImage)
				{
					[_lockQueueProfile lock];
					id error = [_queueError valueForKey:userProfile];
					[_lockQueueProfile unlock];
					if (error && [error intValue] == 0)
					{
						LOG(@"[%@ notify1] error\n%@: %@\n%@", [self className], [item valueForKey:KeyUserProfile], [item valueForKey:KeyText], userProfile);
						profileImage = @"";
					}
				}
			}
			if (profileImage)
			{
				//LOG(@"[%@ notify1]\n%@: %@", [self className], [item valueForKey:KeyUserProfile], [item valueForKey:KeyText]);
				[self notify:item];
				notified = YES;
			}
		}
		else
		{
			notified = YES;
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ notify1] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	return notified;
}

- (void)reindex
{
	//LOG(@"[%@ reindex]", [self className]);
	@try
	{
		@synchronized(_timeline)
		{
			NSMutableArray *content = [_timeline content];
			NSEnumerator *enumerator = [content objectEnumerator];
			id object;
			int i = 0;
			while((object = [enumerator nextObject]))
			{
				id obj = [NSMutableDictionary dictionaryWithDictionary:object];
				[obj setValue:[NSNumber numberWithInt:i] forKey:KeyIndex];
				[content replaceObjectAtIndex:i withObject:obj];
				i++;
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ reindex] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performSetSelectedObjects:(NSArray *)objects
{
	[_timeline setSelectedObjects:objects];
}

- (void)performScrollRowToVisible:(NSNumber *)number
{
	[_view scrollRowToVisible:[number intValue]];
}

- (void)performSetSelectedItem:(NSString *)item_id
				   withService:(NSString *)service
{
	//LOG(@"[%@ performSetSelectedItem]\n%@: %@", [self className], service, item_id);
	@try
	{
		NSEnumerator *enumerator = [[_timeline arrangedObjects] objectEnumerator];
		id obj;
		int i = 0;
		while ((obj = [enumerator nextObject]))
		{
			if ([service isEqualToString:[obj valueForKey:KeyService]] &&
				[item_id isEqualToString:[obj valueForKey:KeyId]])
			{
				//LOG(@"[%@ performSetSelectedItem] setSelectedObjects", [self className]);
				if ([[NSThread currentThread] isEqual:_mainThread])
				{
					[_timeline setSelectedObjects:[NSArray arrayWithObjects:obj, nil]];
				}
				else
				{
					[self performSelectorOnMainThread:@selector(performSetSelectedObjects:)
										   withObject:[NSArray arrayWithObjects:obj, nil]
										waitUntilDone:YES];
				}
				//LOG(@"[%@ performSetSelectedItem] scrollRowToVisible", [self className]);
				if ([[NSThread currentThread] isEqual:_mainThread])
				{
					[_view scrollRowToVisible:i];
				}
				else
				{
					[self performSelectorOnMainThread:@selector(performScrollRowToVisible:)
										   withObject:[NSNumber numberWithInt:i]
										waitUntilDone:YES];
				}
				break;
			}
			i++;
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performSetSelectedItem] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)setSelectedObject:(id)object
{
	//LOG(@"[%@ setSelectedObject] %@", [self className], [object className]);
	@try
	{
		[self performSetSelectedItem:[object valueForKey:KeyId]
						 withService:[object valueForKey:KeyService]];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ setSelectedObject] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performRearrangeObjects:(NSNumber *)keepSelectedItem
{
	//LOG(@"[%@ performRearrangeObjects]", [self className]);
	@try
	{
		@synchronized(_timeline)
		{
			NSClipView *superview = (NSClipView *)[_view superview];
			NSRect rect = [superview documentVisibleRect];
			NSArray *selected = [_timeline selectedObjects];
			[_timeline rearrangeObjects];
			if ([keepSelectedItem boolValue] && ([selected count] > 0))
			{
				NSDictionary *item = [selected objectAtIndex:0];
				NSString *service = [item valueForKey:KeyService];
				NSString *removedID = [self removed:[item valueForKey:KeyId]
										withService:service];
				if (removedID)
				{
					id fetch = [self fetch:removedID
							   withService:service];
					if (fetch)
					{
						item = fetch;
					}
				}
				[self setSelectedObject:item];
			}
			[superview scrollToPoint:rect.origin];
			[_scroll reflectScrolledClipView:superview];
			if (([_view gridStyleMask] & NSTableViewSolidHorizontalGridLineMask) == 0)
			{
				[_view setGridStyleMask:NSTableViewSolidHorizontalGridLineMask];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performRearrangeObjects] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performNoteNumberOfRowsChanged:(id)object
{
	LOG(@"[%@ performNoteNumberOfRowsChanged]", [self className]);
	[_view noteNumberOfRowsChanged];
}

- (void)addRemoveID:(NSString *)removeID
		withService:(NSString *)service
			  newID:(NSString *)newID
{
	LOG(@"[%@ addRemoveID] %@:%@ = %@", [self className], service, removeID, newID);
	if (![removeID isEqualToString:newID])
	{
		@try
		{
			@synchronized(_removeDic)
			{
				[_removeDic setObject:newID
							   forKey:[NSString stringWithFormat:
									   @"%@:%@",
									   service,
									   removeID]];
			}
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@ removeID] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
		}
	}
}

- (void)performAddObject:(id)object
{
	@try
	{
		id reply = nil;
		@synchronized(_timeline)
		{
			if ([[object valueForKey:KeyId] isEqualToString:IdZero])
			{
				@try
				{
					NSString *service = [object valueForKey:KeyService];
					NSArray *error = [self fetchErrorWithService:service];
					if (error)
					{
						int count = [error count];
						int i = 0;
						while (i < [[_timeline content] count])
						{
							id obj = [[_timeline content] objectAtIndex:i];
							if ([[obj valueForKey:KeyId] isEqualToString:@"0"] &&
								[[obj valueForKey:KeyService] isEqualToString:service])
							{
								[[_timeline content] removeObjectAtIndex:i];
								count--;
								if (count <= 0)
								{
									break;
								}
							}
							else
							{
								i++;
							}
						}
					}
				}
				@catch (NSException *exception)
				{
					EXPLOG(@"[%@ performAddObject] IDZero EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
				}
			}
			BOOL replace = NO;
			NSString *serviceName = [object valueForKey:KeyService];
			if ([[object valueForKey:KeyFrom] isEqualToString:FromAPI])
			{
				NSArray *xmpp = [self fetchFromXMPPWithService:serviceName];
				if (xmpp)
				{
					@try
					{
						Service *service = [_controller service:serviceName];
						NSString *xmppId = [object valueForKey:KeyId];
						NSString *user = [object valueForKey:KeyUser];
						NSString *text_raw = [object valueForKey:KeyTextRaw];
						int count = [xmpp count];
						int i = 0;
						while (i < [[_timeline content] count])
						{
							id obj = [[_timeline content] objectAtIndex:i];
							if ([[obj valueForKey:KeyFrom] isEqualToString:FromXMPP] &&
								[[obj valueForKey:KeyService] isEqualToString:serviceName])
							{
								//LOG(@"[%@ performAddObject]"\
								//	@"\n\%@: '%@\'",
								//	[self className], [obj valueForKey:KeyUser], [obj valueForKey:KeyTextRaw]);
								if([[obj valueForKey:KeyId] isEqualToString:xmppId])
								{
									LOG(@"[%@ performAddObject]"\
										@"\nremove id: %@"\
										@"\n%@"\
										@"\n%@"\
										@"\n%@"\
										@"\n%@",
										[self className], xmppId, text_raw, [obj valueForKey:KeyTextRaw], [object valueForKey:KeyTextEx], [obj valueForKey:KeyTextEx]);
									@synchronized(_past)
									{
										[object setValue:[obj valueForKey:KeyProfileImage] forKey:KeyProfileImage];
										[object setValue:[obj valueForKey:KeyPhotoURL] forKey:KeyPhotoURL];
										[object setValue:[obj valueForKey:KeyImageURL] forKey:KeyImageURL];
										[object setValue:[obj valueForKey:KeyImage] forKey:KeyImage];
										if ([obj valueForKey:KeyImage])
										{
											[self formatText:object
												 withService:service
												 appearances:[_preferences appearances]];
										}
										[_past removeObject:[NSDictionary dictionaryWithObjectsAndKeys:
															 [obj valueForKey:KeyId], KeyId,
															 [obj valueForKey:KeyKind], KeyKind,
															 [obj valueForKey:KeyService], KeyService,
															 nil]];
									}
									[self addRemoveID:[obj valueForKey:KeyId]
										  withService:serviceName
												newID:[object valueForKey:KeyId]];
									[[_timeline content] removeObjectAtIndex:i];
								}
								else if([[obj valueForKey:KeyUser] isEqualToString:user] &&
										[[obj valueForKey:KeyTextRaw] isEqualToString:text_raw])
								{
									LOG(@"[%@ performAddObject]"\
										@"\nremove: %@"\
										@"\n%@"\
										@"\n%@",
										[self className], [obj valueForKey:KeyId], text_raw, [obj valueForKey:KeyTextRaw]);
									[object setValue:[obj valueForKey:KeyProfileImage] forKey:KeyProfileImage];
									[object setValue:[obj valueForKey:KeyPhotoURL] forKey:KeyPhotoURL];
									[object setValue:[obj valueForKey:KeyImageURL] forKey:KeyImageURL];
									[object setValue:[obj valueForKey:KeyImage] forKey:KeyImage];
									if ([obj valueForKey:KeyImage])
									{
										[self formatText:object
											 withService:service
											 appearances:[_preferences appearances]];
									}
									@synchronized(_past)
									{
										[_past removeObject:[NSDictionary dictionaryWithObjectsAndKeys:
															 [obj valueForKey:KeyId], KeyId,
															 [obj valueForKey:KeyKind], KeyKind,
															 [obj valueForKey:KeyService], KeyService,
															 nil]];
									}
									[self addRemoveID:[obj valueForKey:KeyId]
										  withService:serviceName
												newID:[object valueForKey:KeyId]];
									if ([service isDelayedReply:[obj valueForKey:KeyId]])
									{
										reply = [obj copy];
									}
									[[_timeline content] removeObjectAtIndex:i];
								}
								else
								{
									i++;
								}
								count--;
								if (count <= 0)
								{
									break;
								}
							}
							else
							{
								i++;
							}
						}
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ performAddObject] XMPP EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
				}
			}
			else if (([[object valueForKey:KeyService] isEqualToString:Identica]) &&
					 ([[object valueForKey:KeyFrom] isEqualToString:FromXMPP]))
			{
				NSDictionary *fetch = [self fetch:[object valueForKey:KeyId]
								 withService:[object valueForKey:KeyService]];
				if (fetch)
				{
					@try
					{
						NSString *item_id = [object valueForKey:KeyId];
						NSString *text_raw = [object valueForKey:KeyTextRaw];
						int count = [[_timeline content] count];
						int i = 0;
						while (i < count)
						{
							id obj = [[_timeline content] objectAtIndex:i];
							if (([[obj valueForKey:KeyService] isEqualToString:serviceName]) &&
								([[obj valueForKey:KeyId] isEqualToString:item_id]) &&
								(![[obj valueForKey:KeyTextRaw] isEqualToString:text_raw]))
							{
								LOG(@"[%@ performAddObject]"\
									@"\nreplace: %@"\
									@"\n%@"\
									@"\n%@",
									[self className], [obj valueForKey:KeyId], text_raw, [obj valueForKey:KeyTextRaw]);
								[obj setValue:[object valueForKey:KeyText] forKey:KeyText];
								[obj setValue:[object valueForKey:KeyText] forKey:KeyTextEx];
								[obj setValue:[object valueForKey:KeyTextRaw] forKey:KeyTextRaw];
								//[obj setValue:[object valueForKey:KeyTextDisplay] forKey:KeyTextDisplay];
								//[obj setValue:[object valueForKey:KeyTextDisplaySelected] forKey:KeyTextDisplaySelected];
								[obj setValue:[object valueForKey:KeyTextNotify] forKey:KeyTextNotify];
								[obj setValue:[object valueForKey:KeyNotifyTitle] forKey:KeyNotifyTitle];
								[self formatText:obj
									 withService:[_controller service:[obj valueForKey:KeyService]]
									 appearances:[_preferences appearances]];
								[[_timeline content] replaceObjectAtIndex:i withObject:obj];
								replace = YES;
								break;
							}
							i++;
						}
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ performAddObject] REPLACE EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
				}
			}
			if (!replace)
			{
				BOOL exist = NO;
				NSString *item_id = [object valueForKey:KeyId];
				NSDate *item_date = [object valueForKey:KeyCreatedAt];
				int count = [[_timeline content] count];
				int i = 0;
				while (i < count)
				{
					id obj = [[_timeline content] objectAtIndex:i];
					if ([[obj valueForKey:KeyService] isEqualToString:serviceName] &&
						[[obj valueForKey:KeyId] isEqualToString:item_id])
					{
						LOG(@"[%@ performAddObject] EXIST!", [self className]);
						exist = YES;
						break;
					}
					if ([item_date compare:[obj valueForKey:KeyCreatedAt]] != NSOrderedAscending)
					{
						break;
					}
					i++;
				}
				if (!exist)
				{
					[[_timeline content] insertObject:object atIndex:i];
					//[self reindex];
				}
			}
		}
		if (reply)
		{
			[object retain];
			@try
			{
				Service *service = [_controller service:[object valueForKey:KeyService]];
				[service doReply:[object valueForKey:KeyId] withText:NO];
				[service removeDelayedReply:[reply valueForKey:KeyId]];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ performAddObject] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			@finally
			{
				[object release];
				[reply release];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performAddObject] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performUpdateProfileImage:(NSDictionary *)object
{
	//LOG(@"[%@ performUpdateProfileImage] %d", [self className], [objects count]);
	@try
	{
		@synchronized(_timeline)
		{
			NSString *userProfile = [object valueForKey:KeyUserProfile];
			NSImage *profileImage = [object valueForKey:KeyProfileImage];
			NSMutableArray *content = [_timeline content];
			NSString *key = KeyUserProfile;
			NSString *image = KeyProfileImage;
			if ([userProfile lengthOfRegularExpression:[NSString stringWithFormat:@"^%@", Photo]] > 0)
			{
				//LOG(@"[%@ performUpdateProfileImage] photo\n%@\n%@", [self className], userProfile, profileImage);
				key = KeyImageURL;
				image = KeyImage;
			}
			NSDictionary *appearances = [_preferences appearances];
			int count = [content count];
			int i = 0;
			while (i < count)
			{
				id obj = [[_timeline content] objectAtIndex:i];
				if (([[obj valueForKey:key] isEqualToString:userProfile]) &&
					![obj valueForKey:image])
				{
					obj = [NSMutableDictionary dictionaryWithDictionary:obj];
					[obj setValue:profileImage forKey:image];
					if ([key isEqualToString:KeyImageURL])
					{
						//LOG(@"[%@ performUpdateProfileImage] photo\n%@", [self className], userProfile);
						_isPhoto = YES;
						[self formatText:obj
							 withService:[_controller service:[obj valueForKey:KeyService]]
							 appearances:appearances];
						[obj setValue:[NSNumber numberWithInt:-1] forKey:KeyWidth];
						[obj setValue:[NSNumber numberWithInt:-1] forKey:KeyHeight];
					}
					[content replaceObjectAtIndex:i withObject:obj];
				}
				i++;
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performUpdateProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)updateProfileImage:(NSString *)userProfile
				 withImage:(NSImage *)profileImage
{
	//LOG(@"[%@ updateProfileImage]", [self className]);
	[_lockTimeline lock];
	BOOL inhibitTimeline = _inhibitTimeline;
	@try
	{
		_inhibitTimeline = YES;
		_isPhoto = NO;
		[self performSelectorOnMainThread:@selector(performUpdateProfileImage:)
							   withObject:[NSDictionary dictionaryWithObjectsAndKeys:
										   userProfile, KeyUserProfile,
										   profileImage, KeyProfileImage,
										   nil]
							waitUntilDone:YES];
		[self performSelectorOnMainThread:@selector(performRearrangeObjects:)
							   withObject:[NSNumber numberWithBool:[_preferences generalKeepSelectedItem]]
							waitUntilDone:YES];
		if (_isPhoto)
		{
			[self performSelectorOnMainThread:@selector(performNoteNumberOfRowsChanged:)
								   withObject:nil
								waitUntilDone:YES];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ updateProfiles] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		if (!inhibitTimeline)
		{
			_inhibitTimeline = NO;
		}
		[_lockTimeline unlock];
	}
}

- (NSImage *)getProfileImage:(NSString *)url
{
	//LOG(@"[%@ getProfileImage] %@", [self className], url);
	NSImage *profileImage = nil;
	HTTP *http = [[HTTP alloc] init];
	if (http && ![url isEqualToString:@""])
	{
		@try
		{
			[http setTimeoutInterval:5];
			id result = nil;
			if ([url lengthOfRegularExpression:@"wassr\\.jp/.*photo$"] > 0)
			{
				result = [[_controller service:Wassr] getWithAuth:url];
			}
			else
			{
				result = [http get:[HTTP urlEncode:url
										 unescaped:@"?&=%"
										   escaped:@"+"]
							header:[NSDictionary
									dictionaryWithObjectsAndKeys:
									[url replaceWithExpression:@"^.*://(.*?)/.*$"
													   replace:@"\\1"], @"Host", nil]
							  body:@""];
			}
			if (result && ![result isKindOfClass:[NSError class]])
			{
				profileImage = [[[NSImage alloc] initWithData:result] autorelease];
				if (!profileImage)
				{
					LOG(@"[%@ getProfileImage] ERROR\n%@\n%@\n%@\n%@",
						[self className],
						[result className],
						result,
						[HTTP urlEncode:url unescaped:@"?&=%" escaped:@"+"],
						[[[NSString alloc] initWithData:result encoding:NSUTF8StringEncoding] autorelease]);
				}
			}
			else
			{
				LOG(@"[%@ getProfileImage] ERROR\n%@\n%@", [self className], result, url);
			}
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@ getProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
		}
		@finally
		{
			[http release];
		}
	}
	return profileImage;
}

- (void)performCreateProfileImage:(NSArray *)images
{
	@try
	{
		if ([images count] == 2)
		{
			NSImage *profileImage = [images objectAtIndex:0];
			NSImage *profileImage1 = [images objectAtIndex:1];
			[profileImage lockFocus];
			[profileImage1 drawInRect:NSMakeRect(0, 0, [profileImage size].width, [profileImage size].height)
							 fromRect:NSMakeRect(0, 0, [profileImage1 size].width, [profileImage1 size].height)
							operation:NSCompositeSourceOver
							 fraction:1.0];
			[profileImage unlockFocus];
		}
		else if ([images count] > 3)
		{
			NSImage *profileImage = [images objectAtIndex:0];
			NSImage *profileImage1 = [images objectAtIndex:1];
			NSImage *profileImage2 = [images objectAtIndex:2];
			BOOL isMail = [[images objectAtIndex:3] boolValue];
			NSImage *profileIcon = [[[NSImage alloc] initWithSize:NSMakeSize(18, 18)] autorelease];
			[profileIcon lockFocus];
			[[NSColor whiteColor] set];
			if (isMail)
			{
				[NSBezierPath fillRect:NSMakeRect(3, 0, 15, 12)];
			}
			else
			{
				[NSBezierPath fillRect:NSMakeRect(0, 0, 18, 18)];
			}
			[profileImage2 drawInRect:NSMakeRect(0, 0, 18, 18)
							 fromRect:NSMakeRect(0, 0, [profileImage2 size].width, [profileImage2 size].height)
							operation:NSCompositeSourceOver
							 fraction:1.0];
			[profileIcon unlockFocus];
			[profileImage lockFocus];
			[profileImage1 drawInRect:NSMakeRect(0, 0, [profileImage size].width, [profileImage size].height)
							 fromRect:NSMakeRect(0, 0, [profileImage1 size].width, [profileImage1 size].height)
							operation:NSCompositeCopy
							 fraction:1.0];
			[profileIcon drawInRect:NSMakeRect(30, 0, 18, 18)
						   fromRect:NSMakeRect(0, 0, [profileIcon size].width, [profileIcon size].height)
						  operation:NSCompositeSourceOver
						   fraction:1.0];
			[profileImage unlockFocus];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performCreateProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (NSImage *)createProfileImage:(NSImage *)image
					   withIcon:(NSImage *)icon
						   mail:(BOOL)isMail
{
	NSImage *profileImage = [[NSImage alloc] initWithSize:NSMakeSize(48, 48)];
	@try
	{
		@synchronized([NSApplication sharedApplication])
		{
			[self performSelectorOnMainThread:@selector(performCreateProfileImage:)
								   withObject:[NSArray arrayWithObjects:
											   profileImage, image, icon,
											   [NSNumber numberWithBool:isMail], nil]
								waitUntilDone:YES];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ createProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	return profileImage;
}

- (void)threadProfileImage:(id)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		for (;;)
		{
			NSAutoreleasePool *internalPool = [[NSAutoreleasePool alloc] init];
			BOOL unlockNotify = NO;
			[_lockProfile lock];
			//LOG(@"[%@ threadProfileImage] lock", [self className]);
			[_controller lockService];
			//LOG(@"[%@ threadProfileImage] locked", [self className]);
			@try
			{
				[_lockQueueProfile lock];
				while ([_queueProfile count] > 0)
				{
					id item = [_queueProfile objectAtIndex:0];
					[_lockQueueProfile unlock];
					if ([item isKindOfClass:[NSDictionary class]])
					{
						NSString *userProfile = [item valueForKey:KeyUserProfile];
						if ([userProfile isEqualToString:Past])
						{
							unlockNotify = YES;
						}
						else if (![userProfile isEqualToString:@""])
						{
							NSImage *profileImage = nil;
							if ([userProfile lengthOfRegularExpression:@" "] <= 0)
							{
								NSImage *profileImage1 = [self profileImage:userProfile];
								if (!profileImage1)
								{
									if ([userProfile lengthOfRegularExpression:[NSString stringWithFormat:@"^%@", Photo]] > 0)
									{
										NSString *url = [userProfile replaceWithExpression:[NSString stringWithFormat:@"^%@(.*)$", Photo]
																				   replace:@"\\1"];
										//LOG(@"[%@ threadProfileImage] photo\n%@", [self className], url);
										profileImage1 = [self getProfileImage:url];
										//LOG(@"[%@ threadProfileImage] photo\n%@", [self className], profileImage1);
									}
									else
									{
										profileImage1 = [self getProfileImage:userProfile];
										if (!profileImage1)
										{
											LOG(@"[%@ threadProfileImage] error0\n%@", [self className], userProfile);
										}
									}
								}
								if (profileImage1)
								{
									if ([userProfile lengthOfRegularExpression:[NSString stringWithFormat:@"^%@", Photo]] > 0)
									{
										profileImage = profileImage1;
									}
									else
									{
										profileImage = [self createProfileImage:profileImage1
																	   withIcon:nil
																		   mail:NO];
									}
								}
							}
							else
							{
								NSString *userProfile1 = [userProfile replaceWithExpression:@"^(.*) (.*)$" replace:@"\\1"];
								NSString *userProfile2 = [userProfile replaceWithExpression:@"^(.*) (.*)$" replace:@"\\2"];
								NSImage *profileImage1 = [self profileImage:userProfile1];
								NSImage *profileImage2 = [self profileImage:userProfile2];
								if (!profileImage1)
								{
									profileImage1 = [self getProfileImage:userProfile1];
									if (!profileImage1)
									{
										LOG(@"[%@ threadProfileImage] error1\n%@", [self className], userProfile1);
									}
								}
								if (!profileImage2)
								{
									profileImage2 = [self getProfileImage:userProfile2];
									if (!profileImage2)
									{
										LOG(@"[%@ threadProfileImage] error2\n%@", [self className], userProfile2);
									}
								}
								if (profileImage1 && profileImage2)
								{
									profileImage = [self createProfileImage:profileImage1
																   withIcon:profileImage2
																	   mail:[userProfile2 isEqualToString:Mail]];
								}
							}
							if (profileImage)
							{
								@synchronized(_profile)
								{
									[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
														 userProfile, KeyUserProfile,
														 profileImage, KeyProfileImage,
														 nil]];
								}
								[self updateProfileImage:userProfile withImage:profileImage];
								unlockNotify = YES;
							}
							else
							{
								int errorCount = 0;
								[_lockQueueProfile lock];
								id error = [_queueError valueForKey:userProfile];
								[_lockQueueProfile unlock];
								if (!error)
								{
									errorCount = 1;
								}
								else
								{
									errorCount = [error intValue];
									if (errorCount < 3)
									{
										errorCount++;
									}
									else
									{
										LOG(@"[%@ threadProfileImage] ERROR\n%@", [self className], userProfile);
										errorCount = 0;
										unlockNotify = YES;
									}
								}
								//LOG(@"[%@ threadProfileImage]\nerror: %d", [self className], errorCount);
								[_lockQueueProfile lock];
								[_queueError setValue:[NSNumber numberWithInt:errorCount]
											   forKey:userProfile];
								[_lockQueueProfile unlock];
								if (errorCount > 0)
								{
									[_lockQueueProfile lock];
									[_queueProfile insertObject:item atIndex:1];
									[_lockQueueProfile unlock];
								}
								//else
								//{
								//	[_queueError removeObjectForKey:userProfile];
								//}
							}
						}
					}
					else
					{
						unlockNotify = YES;
					}
					[_lockQueueProfile lock];
					@try
					{
						[_queueProfile removeObjectAtIndex:0];
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ threadProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
					@finally
					{
						[_lockQueueProfile unlock];
					}
					[_lockQueueProfile lock];
				}
				[_lockQueueProfile unlock];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			@finally
			{
				//LOG(@"[%@ threadProfileImage] done\nnotify = %d, past = %d, photo = %d", [self className], [_queueNotify count], [_queuePast count], [_queuePhotoURL count]);
				[_controller unlockService];
				[_lockProfile unlock];
				[self lockProfile];
			}
			if (unlockNotify)
			{
				[self unlockNotify];
			}
			[internalPool release];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ threadProfileImage] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[pool release];
	[NSThread exit];
}

- (void)queueingUserProfile:(id)userProfile
{
	//LOG(@"[%@ queueingUserProfile]\n%@", [self className], userProfile);
	@try
	{
		id object = nil;
		if ([userProfile isKindOfClass:[NSString class]])
		{
			if ([userProfile isEqualToString:@""])
			{
				object = @"";
			}
			else if ([userProfile isEqualToString:Past])
			{
				object = Past;
			}
			else
			{
				NSPredicate *predicates = [NSPredicate predicateWithFormat:@"%K == %@",
										   KeyUserProfile,
										   userProfile];
				[_lockQueueProfile lock];
				id list = [_queueProfile filteredArrayUsingPredicate:predicates];
				[_lockQueueProfile unlock];
				if (!list || [list count] <= 0)
				{
					object = userProfile;
				}
			}
		}
		if (object)
		{
			[_lockQueueProfile lock];
			[_queueProfile addObject:
			 [NSDictionary dictionaryWithObjectsAndKeys:object, KeyUserProfile, nil]];
			[_lockQueueProfile unlock];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ queueingUserProfile] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)queueingUserProfile:(id)userProfile
				 withUnlock:(BOOL)unlock
{
	//LOG(@"[%@ queueingUserProfile:withUnlock:]\n%@", [self className], userProfile);
	@try
	{
		[self queueingUserProfile:userProfile];
		if (unlock)
		{
			[self unlockProfile];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ queueingUserProfile:withUnlock:] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)threadNotify:(id)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		for (;;)
		{
			NSAutoreleasePool *internalPool = [[NSAutoreleasePool alloc] init];
			BOOL unlockProfile = NO;
			BOOL unlockPast = NO;
			[_lockNotify lock];
			//LOG(@"[%@ threadNotify] lock", [self className]);
			//LOG(@"[%@ threadNotify] locked", [self className]);
			@try
			{
				[_lockQueueNotify lock];
				while (!unlockProfile && [_queueNotify count] > 0)
				{
					id item = [_queueNotify objectAtIndex:0];
					[_lockQueueNotify unlock];
					if ([item isKindOfClass:[NSDictionary class]])
					{
						if (![self notify1:item])
						{
							NSString *userProfile = [item valueForKey:KeyUserProfile];
							//LOG(@"[%@ threadNotify] queueing\n%@: %@\n%@", [self className], [item valueForKey:KeyUser], [item valueForKey:KeyText], userProfile);
							[self queueingUserProfile:userProfile];
							unlockProfile = YES;
						}
					}
					else
					{
						unlockPast = YES;
					}
					[_lockQueueNotify lock];
					@try
					{
						if (!unlockProfile)
						{
							[_queueNotify removeObjectAtIndex:0];
						}
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
				}
				[_lockQueueNotify unlock];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			@finally
			{
				//LOG(@"[%@ threadNotify] done\nnotify = %d, past = %d, photo = %d", [self className], [_queueNotify count], [_queuePast count], [_queuePhotoURL count]);
				[_lockNotify unlock];
				[self lockNotify];
			}
			if (unlockProfile)
			{
				[self unlockProfile];
			}
			else if (unlockPast)
			{
				[self unlockPast];
			}
			[internalPool release];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[pool release];
	[NSThread exit];
}

- (void)queueingNotify:(id)notifies
{
	//LOG(@"[%@ queueingNotify]", [self className]);
	@try
	{
		if ([notifies isKindOfClass:[NSArray class]])
		{
			[_lockQueueNotify lock];
			@try
			{
				NSEnumerator *enumerator = [notifies objectEnumerator];
				id obj;
				while ((obj = [enumerator nextObject]))
				{
					[_queueNotify addObject:obj];
				}
				[_queueNotify addObject:@""];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ queueingUserProfile] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			@finally
			{
				[_lockQueueNotify unlock];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ queueingUserProfile] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)queueingParsePhotoURL:(NSDictionary *)item
{
	[_lockQueuePhotoURL lock];
	@try
	{
		[_queuePhotoURL addObject:item];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ addParsePhotoURL] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[_lockQueuePhotoURL unlock];
}

- (void)performReplace:(NSDictionary *)object
{
	//LOG(@"[%@ performReplace] %d", [self className], [objects count]);
	@try
	{
		BOOL doReplace = NO;
		@synchronized(_timeline)
		{
			NSString *item_id = [object valueForKey:KeyId];
			NSString *service = [object valueForKey:KeyService];
			NSMutableArray *content = [_timeline content];
			int count = [content count];
			int i = 0;
			while (i < count)
			{
				id obj = [[_timeline content] objectAtIndex:i];
				if ([[obj valueForKey:KeyId] isEqualToString:item_id] &&
					[[obj valueForKey:KeyService] isEqualToString:service])
				{
					//LOG(@"[%@ performReplace]\n%@[%@] %@: %@\n%@\n%@",
					//	[self className],
					//	service, item_id, [obj valueForKey:KeyUser], [object valueForKey:KeyText],
					//	[object valueForKey:KeyImageURL],
					//	[object valueForKey:KeyImage]);
					obj = [NSMutableDictionary dictionaryWithDictionary:object];
					[obj setValue:[NSNumber numberWithInt:-1]
						   forKey:KeyWidth];
					[content replaceObjectAtIndex:i withObject:obj];
					doReplace = YES;
					break;
				}
				i++;
			}
		}
		if (doReplace)
		{
			[self performRearrangeObjects:
			 [NSNumber numberWithBool:[_preferences generalKeepSelectedItem]]];
			[self performNoteNumberOfRowsChanged:nil];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performReplace] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)updatePhotoURL:(NSString *)item_id
		   withService:(NSString *)service
{
	@try
	{
		NSDictionary *item = [self fetchALL:item_id
								withService:service];
		if (item)
		{
			[_controller lockService];
			@try
			{
				//LOG(@"[%@ updatePhotoURL] parse", [self className]);
				NSDictionary *parse = [[_controller service:service] parsePhotoURL:item];
				if (parse && ![parse isEqualToDictionary:item])
				{
					[_lockTimeline lock];
					BOOL inhibitTimeline = _inhibitTimeline;
					@try
					{
						_inhibitTimeline = YES;
						NSMutableDictionary *replace = [NSMutableDictionary dictionaryWithDictionary:parse];
						[self formatText:replace
							 withService:[_controller service:service]
							 appearances:[_preferences appearances]];
						//LOG(@"[%@ updatePhotoURL] replace", [self className]);
						[self performSelectorOnMainThread:@selector(performReplace:)
											   withObject:[NSDictionary dictionaryWithDictionary:replace]
											waitUntilDone:YES];
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ updatePhotoURL] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
					@finally
					{
						if (!inhibitTimeline)
						{
							_inhibitTimeline = NO;
						}
						[_lockTimeline unlock];
					}
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ updatePhotoURL] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			@finally
			{
				[_controller unlockService];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ updatePast] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)updatePast:(NSArray *)objects
{
	@try
	{
		if ([objects count] > 0)
		{
			//LOG(@"[%@ updatePast]", [self className]);
			NSDictionary *item = [objects objectAtIndex:0];
			NSString* kind = [item valueForKey:KeyKind];
			if (![kind isEqualToString:KindError])
			{
				@synchronized(_past)
				{
					NSString* service = [item valueForKey:KeyService];
					UInt32 n = 0;
					UInt32 i = 0;
					while (i < [[_past content] count])
					{
						NSDictionary *past = [[_past content] objectAtIndex:i];
						if ([[past valueForKey:KeyService] isEqualToString:service] &&
							[[past valueForKey:KeyKind] isEqualToString:kind])
						{
							//LOG(@"[%@ updatePast]\n+%@ %@ %@", [self className], [past valueForKey:KeyService], [past valueForKey:KeyKind], [past valueForKey:KeyId]);
							n++;
						}
						i++;
					}
					i = 0;
					while ((i < [[_past content] count]) && (n > 50))
					{
						NSDictionary *past = [[_past content] objectAtIndex:i];
						if ([[past valueForKey:KeyService] isEqualToString:service] &&
							[[past valueForKey:KeyKind] isEqualToString:kind])
						{
							//LOG(@"[%@ updatePast]\n-%@ %@ %@", [self className], [past valueForKey:KeyService], [past valueForKey:KeyKind], [past valueForKey:KeyId]);
							[_past removeObjectAtArrangedObjectIndex:i];
							n--;
						}
						else
						{
							i++;
						}
					}
					i = 0;
					while (i < [objects count])
					{
						NSDictionary *object = [objects objectAtIndex:i];
						NSString *item_id = [object valueForKey:KeyId];
						NSString *item_service = [object valueForKey:KeyService];
						NSDictionary *fetch = [self fetchPast:item_id
												  withService:item_service
														 kind:[object valueForKey:KeyKind]];
						if (!fetch)
						{
#if 0 //def _D_E_B_U_G_
							if ([[object valueForKey:KeyService] isEqualToString:Twitter])
							{
								LOG(@"[%@ updatePast] Add\n%@ [%@] %@",
									[self className],
									[object valueForKey:KeyService],
									[object valueForKey:KeyKind],
									[object valueForKey:KeyId]);
							}
#endif
							[_past addObject:[NSDictionary dictionaryWithObjectsAndKeys:
											  item_id, KeyId,
											  item_service, KeyService,
											  [object valueForKey:KeyKind], KeyKind,
											  nil]];
						}
						i++;
					}
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ updatePast] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)threadPast:(id)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		for (;;)
		{
			NSAutoreleasePool *internalPool = [[NSAutoreleasePool alloc] init];
			[_lockPast lock];
			//LOG(@"[%@ threadPast]", [self className]);
			@try
			{
				// Past
				[_lockQueuePast lock];
				@try
				{
					while ([_queuePast count] > 0)
					{
						NSArray *past = [_queuePast objectAtIndex:0];
						[_lockQueuePast unlock];
						@try
						{
#if 0 //def _D_E_B_U_G_
							if ([past count] > 0)
							{
								id item = [past objectAtIndex:0];
								if ([[item valueForKey:KeyService] isEqualToString:Twitter])
								{
									LOG(@"[%@ threadPast]\n%@: %@", [self className], [item valueForKey:KeyId], [item valueForKey:KeyKind]);
								}
							}
#endif
							[self updatePast:past];
						}
						@catch (NSException *exception)
						{
							EXPLOG(@"[%@ threadPast] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
						}
						[_lockQueuePast lock];
						[_queuePast removeObjectAtIndex:0];
					}
				}
				@catch (NSException *exception)
				{
					EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
				}
				@finally
				{
					[_lockQueuePast unlock];
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadPast] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			//LOG(@"[%@ threadPast] done\nnotify = %d, past = %d, photo = %d", [self className], [_queueNotify count], [_queuePast count], [_queuePhotoURL count]);
			[_lockPast unlock];
			[self lockPast];

			// PhotoURL
			[_lockQueuePhotoURL lock];
			@try
			{
				while ([_queuePhotoURL count] > 0)
				{
					id item = [_queuePhotoURL objectAtIndex:0];
					[_lockQueuePhotoURL unlock];
					@try
					{
						[self updatePhotoURL:[item valueForKey:KeyId]
								 withService:[item valueForKey:KeyService]];
					}
					@catch (NSException *exception)
					{
						EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
					}
					@finally
					{
						[_lockQueuePhotoURL lock];
						[_queuePhotoURL removeObjectAtIndex:0];
					}
					[_lockQueuePast lock];
					int count = [_queuePast count];
					[_lockQueuePast unlock];
					if (count > 0)
					{
						break;
					}
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ threadNotify] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
			}
			@finally
			{
				//LOG(@"[%@ threadPast] done photo\nnotify = %d, past = %d, photo = %d", [self className], [_queueNotify count], [_queuePast count], [_queuePhotoURL count]);
				[_lockQueuePhotoURL unlock];
			}
			[internalPool release];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ threadPast] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[pool release];
	[NSThread exit];
}

- (void)queueingPast:(NSArray *)object
		 withService:(Service *)service
{
	//LOG(@"[%@ queueingPast]", [self className]);
	[_lockQueuePast lock];
	@try
	{
		[_queuePast addObject:[NSArray arrayWithArray:object]];
		if ([object count] > 0)
		{
			if ([[[object objectAtIndex:0] valueForKey:KeyKind] isEqualToString:KindTimeline])
			{
				NSMutableArray *replies = [NSMutableArray array];
				NSEnumerator *enumerator = [object objectEnumerator];
				id obj;
				while ((obj = [enumerator nextObject]))
				{
					if ([service isReply:obj])
					{
						NSMutableDictionary *item = [NSMutableDictionary dictionaryWithDictionary:obj];
						[item setObject:KindReply forKey:KeyKind];
						[replies addObject:item];
					}
				}
				if ([replies count] > 0)
				{
#ifdef _D_E_B_U_G_
					if ([[service service] isEqualToString:Twitter])
					{
						enumerator = [replies objectEnumerator];
						while ((obj = [enumerator nextObject]))
						{
							LOG(@"[%@ queueingPast] Reply\n%@ [%@] %@: %@ - %@",
								[self className],
								[obj valueForKey:KeyId],
								[obj valueForKey:KeyKind],
								[obj valueForKey:KeyUser],
								[obj valueForKey:KeyText],
								[[obj valueForKey:KeyDate] replaceWithExpression:@"\n"
																		 replace:@" "
																		 options:OgreMultilineOption]);
						}
					}
#endif
					[_queuePast addObject:[NSArray arrayWithArray:replies]];
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ queueingPast] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	[_lockQueuePast unlock];
}

- (NSDictionary *)appearanceColor:(NSDictionary *)object
			 withColors:(NSDictionary *)colors
{
	Service *service = [_controller service:[object valueForKey:KeyService]];
	NSDictionary *color = [colors valueForKey:AppearanceNormal];
	if ([[object valueForKey:KeyKind] isEqualToString:KindDM])
	{
		color = [colors valueForKey:AppearanceMessage];
	}
	else if ([[object valueForKey:KeyKind] isEqualToString:KindReply])
	{
		color = [colors valueForKey:AppearanceReply];
	}
	else if ([service isReply:object])
	{
		color = [colors valueForKey:AppearanceReply];
	}
	else if ([[object valueForKey:KeyKind] isEqualToString:KindChannel])
	{
		color = [colors valueForKey:AppearanceChannel];
	}
	else if ([service isChannel:object])
	{
		color = [colors valueForKey:AppearanceChannel];
	}
	else if ([[object valueForKey:KeyNotify] isEqualToString:GrowlAfficheurKeywordsNotify])
	{
		color = [colors valueForKey:AppearanceKeyword];
	}
	return color;
}

- (NSAttributedString *)lockIconWithBaseLine:(float)baseLine
										attr:(NSDictionary *)attr
{
	id str = nil;
	NSImage *image = [NSImage imageNamed:@"icon_lock"];
	NSTextAttachment *textAtt = [[[NSTextAttachment alloc] init] autorelease];
	NSImage *cellImage = [[[NSImage alloc] initWithSize:NSMakeSize([image size].width, [image size].height)] autorelease];
	NSSize cellSize = [cellImage size];
	NSSize imageSize = [image size];
	[cellImage lockFocus];
	[image drawInRect:NSMakeRect(0, 0, cellSize.width, cellSize.height)
			 fromRect:NSMakeRect(0, 0, imageSize.width, imageSize.height)
			operation:NSCompositeCopy
			 fraction:1.0];
	[cellImage unlockFocus];
	NSTextAttachmentCell *cell = [[[NSTextAttachmentCell alloc] initImageCell:cellImage] autorelease];
	[textAtt setAttachmentCell:cell];
	if (textAtt)
	{
		str = [NSMutableAttributedString attributedStringWithAttachment:textAtt];
		NSMutableDictionary *attach = [NSMutableDictionary
									   dictionaryWithDictionary:attr];
		[attach setValue:[NSNumber numberWithFloat:baseLine]
				  forKey:NSBaselineOffsetAttributeName];
		[str addAttributes:attach
					 range:NSMakeRange(0, [str length])];
	}
	return str;
}

- (void)formatText:(id)object
	   withService:(Service *)service
	   appearances:(NSDictionary *)appearances
{
	//LOG(@"[%@ formatText]", [self className]);
	@try
	{
		NSString *text = [object valueForKey:KeyTextEx];
		NSString *comment = [object valueForKey:KeyComment];
		if (!text || [text isKindOfClass:[NSNull class]])
		{
			text = @"";
		}
		NSString *cmtD = @"";
		NSString *cmtN = @"";
		if (comment && ![comment isKindOfClass:[NSNull class]] && ![comment isEqualToString:@""])
		{
			cmtD = [NSString stringWithFormat:@"\n%@",
					[[[service convertText:comment] replaceWithExpression:@"\\n" replace:@" "]
					 replaceWithExpression:@"\\s\\s\\s" replace:@" "]];
			cmtN = [NSString stringWithFormat:@"\n%@",
					[[service convertText:comment] replaceWithExpression:@"\\s\\s\\s" replace:@" "]];
		}
		else
		{
			comment = @"";
		}
		NSString *user = [object valueForKey:KeyUser];
		NSString *name = [object valueForKey:KeyName];
		NSString *channel = [object valueForKey:KeyChannel];
		NSString *header = [NSString stringWithFormat:@"%@%@%@", 
							[service convertText:user],
							[service convertText:name],
							[service convertText:channel]];
		NSString *notifyTitle = [NSString stringWithString:header];
		if (![[object valueForKey:KeyId] isEqualToString:IdZero])
		{
			[object setValue:notifyTitle forKey:KeyNotifyTitle];
		}
		NSString *txt = [[service convertText:text] replaceWithExpression:@"\\s\\s\\s" replace:@" "];
#ifdef _D_E_B_U_G_
		NSDateFormatter *formatter = [[[NSDateFormatter alloc] init] autorelease];
		[formatter setFormatterBehavior:NSDateFormatterBehavior10_4];
		NSLocale *locale = [[[NSLocale alloc] initWithLocaleIdentifier:@"en_US"] autorelease];
		[formatter setLocale:locale];
		[formatter setDateFormat:@"yyyy/MM/dd HH:mm:ss"];
		NSString *txtN = [NSString stringWithFormat:@"%@%@\n%@",
						  txt ,
						  cmtN,
						  [formatter stringFromDate:[object valueForKey:KeyCreatedAt]]
						  ];
#else
		NSString *txtN = [NSString stringWithFormat:@"%@%@",
						  txt ,
						  cmtN
						  ];
#endif
		[object setValue:txtN forKey:KeyTextNotify];
		NSDictionary *fonts = [appearances valueForKey:AppearanceFont];
		NSDictionary *colors = [appearances valueForKey:AppearanceColor];
		NSDictionary *color = [self appearanceColor:object withColors:colors];
		// TextDisplay
		NSMutableAttributedString *txtD = [[[NSMutableAttributedString alloc] init] autorelease];
		NSDictionary *attr = [NSDictionary dictionaryWithObjectsAndKeys:
							  [fonts valueForKey:AppearanceUser], NSFontAttributeName,
							  [color valueForKey:AppearanceUser], NSForegroundColorAttributeName,
							  nil];
		[txtD beginEditing];
		if (![header isEqualToString:@""])
		{
			[txtD appendAttributedString:[service attributedString:header
														  withSize:12
														  baseLine:-2
															  attr:attr]];
			if ([[object valueForKey:KeyProtected] intValue])
			{
				[txtD appendAttributedString:[service attributedString:@" "
															  withSize:12
															  baseLine:-2
																  attr:attr]];
				[txtD appendAttributedString:[self lockIconWithBaseLine:-2 attr:attr]];
			}
			[txtD appendAttributedString:[service attributedString:@"\n"
														  withSize:12
														  baseLine:-2
															  attr:attr]];
		}
		attr = [NSDictionary dictionaryWithObjectsAndKeys:
				[fonts valueForKey:AppearanceText], NSFontAttributeName,
				[color valueForKey:AppearanceText], NSForegroundColorAttributeName,
				nil];
		[txtD appendAttributedString:[service attributedString:txt
													  withSize:12
													  baseLine:-2
														  attr:attr]];
#if defined(_D_E_B_U_G_)
		if (![[object valueForKey:KeySource] isEqualToString:@""])
		{
			[txtD appendAttributedString:[service attributedString:
										  [NSString stringWithFormat:@"\nfrom %@",
										   [object valueForKey:KeySource]]
														  withSize:12
														  baseLine:-2
															  attr:attr]];
		}
#endif //defined(_D_E_B_U_G_)
		attr = [NSDictionary dictionaryWithObjectsAndKeys:
				[fonts valueForKey:AppearanceComment], NSFontAttributeName,
				[color valueForKey:AppearanceComment], NSForegroundColorAttributeName,
				nil];
		[txtD appendAttributedString:[service attributedString:cmtD
													  withSize:12
													  baseLine:-2
														  attr:attr]];
		NSImage *photo = [object valueForKey:KeyImage];
		if (photo)
		{
			//LOG(@"[%@ formatText] photo\n%@", [self className], photo);
			[txtD appendAttributedString:[service attributedString:photo
														  withSize:12
														  baseLine:-2
															  attr:attr]];
		}
		[txtD endEditing];
		[object setValue:txtD forKey:KeyTextDisplay];
		// TextDisplaySelected
		txtD = [[[NSMutableAttributedString alloc] init] autorelease];
		attr = [NSDictionary dictionaryWithObjectsAndKeys:
							  [fonts valueForKey:AppearanceUser], NSFontAttributeName,
							  [NSColor selectedTextColor], NSForegroundColorAttributeName,
							  nil];
		[txtD beginEditing];
		if (![header isEqualToString:@""])
		{
			[txtD appendAttributedString:[service attributedString:header
														  withSize:12
														  baseLine:-2
															  attr:attr]];
			if ([[object valueForKey:KeyProtected] intValue])
			{
				[txtD appendAttributedString:[service attributedString:@" "
															  withSize:12
															  baseLine:-2
																  attr:attr]];
				[txtD appendAttributedString:[self lockIconWithBaseLine:-2 attr:attr]];
			}
			[txtD appendAttributedString:[service attributedString:@"\n"
														  withSize:12
														  baseLine:-2
															  attr:attr]];
		}
		attr = [NSDictionary dictionaryWithObjectsAndKeys:
				[fonts valueForKey:AppearanceText], NSFontAttributeName,
				[NSColor selectedTextColor], NSForegroundColorAttributeName,
				nil];
		[txtD appendAttributedString:[service attributedString:txt
													  withSize:12
													  baseLine:-2
														  attr:attr]];
#if defined(_D_E_B_U_G_)
		if (![[object valueForKey:KeySource] isEqualToString:@""])
		{
			[txtD appendAttributedString:[service attributedString:
										  [NSString stringWithFormat:@"\nfrom %@",
										   [object valueForKey:KeySource]]
														  withSize:12
														  baseLine:-2
															  attr:attr]];
		}
#endif //defined(_D_E_B_U_G_)
		attr = [NSDictionary dictionaryWithObjectsAndKeys:
				[fonts valueForKey:AppearanceComment], NSFontAttributeName,
				[NSColor selectedTextColor], NSForegroundColorAttributeName,
				nil];
		[txtD appendAttributedString:[service attributedString:cmtD
													  withSize:12
													  baseLine:-2
														  attr:attr]];
		photo = [object valueForKey:KeyImage];
		if (photo)
		{
			[txtD appendAttributedString:[service attributedString:photo
														  withSize:12
														  baseLine:-2
															  attr:attr]];
		}
		[txtD endEditing];
		[object setValue:txtD forKey:KeyTextDisplaySelected];
		// DateDisplay
		NSString *date = [object valueForKey:KeyDate];
		if (date)
		{
			NSMutableParagraphStyle *paragraph = [[[NSMutableParagraphStyle alloc] init] autorelease];
			//[paragraph  setAlignment:NSJustifiedTextAlignment];
			[paragraph  setAlignment:NSCenterTextAlignment];
			attr = [NSDictionary dictionaryWithObjectsAndKeys:
					[fonts valueForKey:AppearanceDate], NSFontAttributeName,
					[color valueForKey:AppearanceDate], NSForegroundColorAttributeName,
					paragraph, NSParagraphStyleAttributeName,
					nil];
			[object setValue:[[[NSMutableAttributedString alloc]
							   initWithString:date
							   attributes:attr] autorelease]
					  forKey:KeyDateDisplay];
			// DateDisplaySelected
			paragraph = [[[NSMutableParagraphStyle alloc] init] autorelease];
			//[paragraph  setAlignment:NSJustifiedTextAlignment];
			[paragraph  setAlignment:NSCenterTextAlignment];
			attr = [NSDictionary dictionaryWithObjectsAndKeys:
					[fonts valueForKey:AppearanceDate], NSFontAttributeName,
					[NSColor selectedTextColor], NSForegroundColorAttributeName,
					paragraph, NSParagraphStyleAttributeName,
					nil];
			[object setValue:[[[NSMutableAttributedString alloc]
							   initWithString:date
							   attributes:attr] autorelease]
					  forKey:KeyDateDisplaySelected];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ formatText] EXCEPTION\n%@: %@\n%@", [self className], [exception name], [exception reason], object);
	}
}

- (BOOL)addTimeline:(NSDictionary *)item
		withService:(Service *)service
{
	//LOG(@"[%@ addTimeline]", [self className]);
	BOOL notify = NO;
	[item retain];
	[_lockTimeline lock];
	@try
	{
		NSMutableDictionary *object = [NSMutableDictionary dictionaryWithDictionary:item];
		NSString *serviceName = [object valueForKey:KeyService];
		if ([[object valueForKey:KeyService] isEqualToString:Identica] &&
			[[object valueForKey:KeyFrom] isEqualToString:FromAPI] &&
			![[object valueForKey:KeyId] isEqualToString:IdZero])
		{
			NSArray *xmpp = [self fetchFromXMPPWithService:serviceName];
			if (xmpp)
			{
				NSString *xmppId = [object valueForKey:KeyId];
				int count = [xmpp count];
				int i = 0;
				while (i < [[_timeline content] count])
				{
					id obj = [[_timeline content] objectAtIndex:i];
					if ([[obj valueForKey:KeyService] isEqualToString:serviceName] &&
						[[obj valueForKey:KeyFrom] isEqualToString:FromXMPP])
					{
						//LOG(@"[%@ addObject] from XMPP"\
						//	@"\n%@"\
						//	@"\n\'%@\'",
						//	[self className],
						//	[obj valueForKey:KeyId], [obj valueForKey:KeyText]);
						if([[obj valueForKey:KeyId] isEqualToString:xmppId])
						{
							LOG(@"[%@ addObject] Replace text"\
								@"\n%@"\
								@"\n\'%@\'",
								[self className],
								[object valueForKey:KeyId], [object valueForKey:KeyText]);
							[object setValue:[obj valueForKey:KeyText] forKey:KeyText];
							[object setValue:[obj valueForKey:KeyText] forKey:KeyTextEx];
							[object setValue:[obj valueForKey:KeyTextRaw] forKey:KeyTextRaw];
							break;
						}
						count--;
						if (count <= 0)
						{
							break;
						}
					}
					i++;
				}
			}
		}
		NSString *item_id = [object valueForKey:KeyId];
		BOOL add = NO;
		if ([item_id isEqualToString:IdZero])
		{
			add = YES;
		}
		else if ([[object valueForKey:KeyFrom] isEqualToString:FromXMPP])
		{
			if (![self fetchFromAPIWithService:serviceName
									  user:[object valueForKey:KeyUser]
								  text_raw:[object valueForKey:KeyTextRaw]])
			{
				add = YES;
			}
		}
		else if	(![self fetch:item_id withService:serviceName])
		{
			add = YES;
		}
		if (add)
		{
			_inhibitTimeline = YES;
			object = [NSMutableDictionary dictionaryWithDictionary:object];
			//LOG(@"[%@ addTimeline] %@:%@", [self className], serviceName, item_id);
			NSString *userProfile = [object valueForKey:KeyUserProfile];
			id profileImage = [self profileImage:userProfile];
			if (![userProfile isEqualToString:@""] && profileImage)
			{
				[object setValue:profileImage forKey:KeyProfileImage];
			}
			else
			{
				//[self queueingUserProfile:[object valueForKey:KeyUserProfile]];
			}
			if ([[object valueForKey:KeyFrom] isEqualToString:FromXMPP])
			{
				notify = YES;
			}
			else if (![self fetchALL:item_id withService:serviceName] &&
					 ![self fetchFromXMPPWithService:serviceName
												user:[object valueForKey:KeyUser]
											text_raw:[object valueForKey:KeyTextRaw]])
			{
				notify = YES;
			}
			[self formatText:object
				 withService:service
				 appearances:[_preferences appearances]];
			[_queueAdd addObject:object];
			[self performSelectorOnMainThread:@selector(performAddObject:)
								   withObject:object
								waitUntilDone:YES];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ addTimeline] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		[_lockTimeline unlock];
		[item release];
	}
	return notify;
}

- (NSString *)IDs:(NSArray *)array
{
	NSMutableString *str = [NSMutableString stringWithString:@""];
	NSEnumerator *enumerator = [array objectEnumerator];
	id obj;
	while ((obj = [enumerator nextObject]))
	{
		//LOG(@"[%@ IDs] %@\n%@", [self className], [obj className], obj);
		if (![str isEqualToString:@""])
		{
			[str appendString:@"\n"];
		}
		[str appendFormat:@"%@:", [obj valueForKey:KeyService]];
		[str appendFormat:@"%@ ", [obj valueForKey:KeyId]];
		[str appendFormat:@"%@ / ", [obj valueForKey:KeyUser]];
		[str appendFormat:@"%@", [obj valueForKey:KeyTextRaw]];
	}
	return str;
}

- (void)finishAddTimeline:(NSArray *)objects
			   withNotify:(NSArray *)notify
				  service:(Service *)service
{
	NSString *serviceName = [service service];
	//LOG(@"[%@ finishAddTimeline]\n%d / %d / %d", [self className], [objects count], [notify count], [_queueProfile count]);
	[_lockTimeline lock];
	@try
	{
		if ([_queueAdd count] > 0)
		{
			LOG(@"[%@ finishAddTimeline]"\
				@"\nobjects = %d"\
				@", notify = %d"\
				@", profile = %d"\
				@", add = %d",
				[self className], [objects count], [notify count], [_queueProfile count], [_queueAdd count]);
			LOG(@"[%@ finishAddTimeline(%@)]\nperformRearrangeObjects %d", [self className], serviceName, [[_timeline content] count]);
			[self reindex];
			[self performSelectorOnMainThread:@selector(performRearrangeObjects:)
								   withObject:[NSNumber numberWithBool:[_preferences generalKeepSelectedItem]]
								waitUntilDone:YES];
			if (([notify count] < [_queueAdd count]) || ([[_controller service:serviceName] changeHeight]))
			{
				[self performSelectorOnMainThread:@selector(performNoteNumberOfRowsChanged:)
									   withObject:nil
									waitUntilDone:YES];
			}
			while ([_queueAdd count] > 0)
			{
				[self queueingParsePhotoURL:[_queueAdd objectAtIndex:0]];
				[_queueAdd removeObjectAtIndex:0];
			}
		}
		[self queueingPast:objects withService:service];
		[self queueingNotify:notify];
		[self queueingUserProfile:Past withUnlock:YES];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ finishAddTimeline] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		//LOG(@"[%@ finishAddTimeline(%@)] done\nprofile = %d, notify = %d, past = %d, photo   = %d", [self className], serviceName, [_queueProfile count], [_queueNotify count], [_queuePast count], [_queuePhotoURL count]);
		_inhibitTimeline = NO;
		[_lockTimeline unlock];
	}
	if (_keyView)
	{
		[self tableView:_view flagsChanged:nil];
	}
}

- (void)performReplacePhotoURL:(NSDictionary *)object
{
	LOG(@"[%@ performReplacePhotoURL]", [self className]);
	@try
	{
		BOOL doReplace = NO;
		@synchronized(_timeline)
		{
			NSString *item_id = [object valueForKey:KeyId];
			NSString *service = [object valueForKey:KeyService];
			NSMutableArray *content = [_timeline content];
			int count = [content count];
			int i = 0;
			while (i < count)
			{
				id obj = [[_timeline content] objectAtIndex:i];
				if ([[obj valueForKey:KeyId] isEqualToString:item_id] &&
					[[obj valueForKey:KeyService] isEqualToString:service])
				{
#if defined(_D_E_B_U_G_)
					NSString *photoURL = [object valueForKey:KeyImageURL];
					LOG(@"[%@ performReplacePhotoURL]\n%@: %@\n%@", [self className], [obj valueForKey:KeyUser], [obj valueForKey:KeyText], photoURL);
#endif //defined(_D_E_B_U_G_)
					[content replaceObjectAtIndex:i withObject:object];
					[self queueingParsePhotoURL:object];
					doReplace = YES;
					break;
				}
				i++;
			}
		}
		if (doReplace)
		{
			[self performRearrangeObjects:
			 [NSNumber numberWithBool:[_preferences generalKeepSelectedItem]]];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performReplacePhotoURL] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		[object release];
	}
}

- (id)replace:(NSString *)item_id
  withService:(NSString *)service
	 photoURL:(NSString *)photoURL
{
	LOG(@"[%@ replace]", [self className]);
	id obj = nil;
	[_lockTimeline lock];
	BOOL inhibitTimeline = _inhibitTimeline;
	@try
	{
		_inhibitTimeline = YES;
		@synchronized(_timeline)
		{
			obj = [self fetchALL:item_id withService:service];
			if (obj)
			{
				NSArray *urls = [photoURL componentsSeparatedByString:Photo];
				NSString *url = [urls objectAtIndex:0];
				if ([urls count] > 1)
				{
					url = [urls objectAtIndex:1];
				}
				obj = [NSMutableDictionary dictionaryWithDictionary:obj];
				[obj setValue:photoURL forKey:KeyImageURL];
				NSString *text = [NSString stringWithFormat:@"%@\n%@",
								  [obj valueForKey:KeyText], url];
				[obj setValue:text forKey:KeyText];
				[obj setValue:text forKey:KeyTextEx];
				[obj setValue:[NSNumber numberWithInt:-1] forKey:KeyWidth];
				[self formatText:obj
					 withService:[_controller service:service]
					 appearances:[_preferences appearances]];
			}
		}
		if (obj)
		{
			[self performSelectorOnMainThread:@selector(performReplacePhotoURL:)
								   withObject:[obj copy]
								waitUntilDone:YES];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ replace] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		if (!inhibitTimeline)
		{
			_inhibitTimeline = YES;
		}
		[_lockTimeline unlock];
	}
	if (_keyView)
	{
		[self tableView:_view flagsChanged:nil];
	}
	return obj;
}

- (float)withOfTimeline
{
	return [_columnText width];
}

- (void)setDateWidth
{
	@try
	{
		NSDictionary *appearances = [_preferences appearances];
		NSDictionary *fonts = [appearances valueForKey:AppearanceFont];
		NSFont *font = [fonts valueForKey:AppearanceDate];
		NSMutableParagraphStyle *paragraph = [[[NSMutableParagraphStyle alloc] init] autorelease];
		//[paragraph  setAlignment:NSJustifiedTextAlignment];
		[paragraph  setAlignment:NSCenterTextAlignment];
		TextFieldCell *cell = [[TextFieldCell alloc] init];
		[cell setAttributedStringValue:
		 [[[NSAttributedString alloc]
		   initWithString:@"88/88\n88:88"
		   attributes:[NSDictionary dictionaryWithObjectsAndKeys:
					   font, NSFontAttributeName,
					   paragraph, NSParagraphStyleAttributeName,
					   nil]] autorelease]];
		float width = [cell cellSizeForBounds:NSMakeRect(0, 0, 2000, 2000)].width;
		float mod = modff(width, &width);
		LOG(@"[%@ setDateWidth]\nwidth = %f\nmod = %f\n%@", [self className], width, mod, font);
		if (mod > 0)
		{
			width += 1.0;
		}
		float diff = width - [_columnDate width];
		if (diff > 0)
		{
			[_columnText setWidth:[_columnText width] - diff];
		}
		[_columnDate setWidth:width];
		if (diff < 0)
		{
			[_columnText setWidth:[_columnText width] - diff];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ setDateWidth] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performReformat
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	NSDate *date = [[NSDate dateWithTimeIntervalSinceNow:0] retain];
	BOOL rearrange = NO;
	@try
	{
		[_lockTimeline lock];
		NSMutableArray *format = [[NSMutableArray array] retain];
		@try
		{
			NSDictionary *appearances = [_preferences appearances];
			NSMutableArray *content = [_timeline content];
			int count = [content count];
			@synchronized(_timeline)
			{
				//LOG(@"[%@ performReformat]\n%@", [self className], [_preferences appearances]);
				int i = 0;
				while (i < count)
				{
					NSMutableDictionary *obj = [NSMutableDictionary dictionaryWithDictionary:
												[content objectAtIndex:0]];
					[self formatText:obj
						 withService:[_controller service:[obj valueForKey:KeyService]]
						 appearances:appearances];
					[obj setValue:[NSNumber numberWithInt:-1] forKey:KeyWidth];
					[format addObject:obj];
					[content removeObjectAtIndex:0];
					i++;
				}
				if (count > 0)
				{
					rearrange = YES;
				}
			}
			[self performSelectorOnMainThread:@selector(setDateWidth)
								   withObject:nil
								waitUntilDone:YES];
			if (rearrange)
			{
				[self performSelectorOnMainThread:@selector(performRearrangeObjects:)
									   withObject:[NSNumber numberWithBool:[_preferences generalKeepSelectedItem]]
									waitUntilDone:YES];
				[self performSelectorOnMainThread:@selector(performNoteNumberOfRowsChanged:)
									   withObject:nil
									waitUntilDone:YES];
			}
			@synchronized(_timeline)
			{
				int i = 0;
				while (i < count)
				{
					[content addObject:[format objectAtIndex:0]];
					[format removeObjectAtIndex:0];
					i++;
				}
			}
			if (rearrange)
			{
				[self performSelectorOnMainThread:@selector(performRearrangeObjects:)
									   withObject:[NSNumber numberWithBool:[_preferences generalKeepSelectedItem]]
									waitUntilDone:YES];
				[self performSelectorOnMainThread:@selector(performNoteNumberOfRowsChanged:)
									   withObject:nil
									waitUntilDone:YES];
			}
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@ performReformat] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
		}
		@finally
		{
			[format release];
			[_lockTimeline unlock];
		}
		if (rearrange && _keyView)
		{
			[self tableView:_view flagsChanged:nil];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performReformat] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
#if defined(_D_E_B_U_G_)
	int count = [[_timeline content] count];
	NSTimeInterval interval = [[NSDate date] timeIntervalSinceDate:date];
	LOG(@"[%@ performReformat]\n%d: %f / %f", [self className], count, interval, interval / (NSTimeInterval)count);
#endif //defined(_D_E_B_U_G_)
	[date release];
	[pool release];
	[NSThread exit];
}

- (void)reformat
{
	[NSThread detachNewThreadSelector:@selector(performReformat)
							 toTarget:self
						   withObject:nil];
}

- (NSArray *)selectedObjects
{
	NSArray* selected = nil;
	[_lockTimeline lock];
	@try
	{
		@synchronized(_timeline)
		{
			selected = [_timeline selectedObjects];
			if ([selected count] <= 0)
			{
				selected = nil;
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ selectedObjects] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		[_lockTimeline unlock];
	}
	return selected;
}

- (void)setSelectedItem:(NSString *)item_id
		withService:(NSString *)service
{
	//[_lockTimeline lock];
	@try
	{
		//@synchronized(_timeline)
		{
			[self performSetSelectedItem:item_id withService:service];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ setSelected] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		//[_lockTimeline unlock];
	}
}

- (void)setTitle:(NSString *)title
{
	[_panel setTitle:title];
}

- (void)setFilterPredicate:(NSPredicate *)predicate
{
	[_timeline setFilterPredicate:predicate];
}

- (void)setStatusBar:(NSString *)status
{
	[_statusBar setStringValue:status];
}

- (NSDictionary *)predicate:(id)obj
				 withColumn:(int)column
{
	//LOG(@"[%@ predicate]", [self className]);
	NSPredicate *predicate = nil;
	NSString *status = @"";
	NSString *title = nil;
	@try
	{
		int modifiers = [_controller keyModifiers];
		if (column == 0)
		{
			NSString *channel = [obj valueForKey:KeyChannel];
			if ((modifiers == NSAlternateKeyMask) &&
				(channel && ![channel isEqualToString:@""]))
			{
				predicate = [NSPredicate predicateWithFormat:
							 @"(%K == %@) AND (%K == %@)",
							 KeyService,
							 [obj valueForKey:KeyService],
							 KeyChannel,
							 [obj valueForKey:KeyChannel]];
				title = [NSString stringWithFormat:@"%@ [%@]",
						 [obj valueForKey:KeyService],
						 [channel substringWithRange:NSMakeRange(2, [channel length] - 2)]];
				status = [NSString stringWithFormat:FILTER_CHANNEL, title];
			}
			else
			{
				predicate = [NSPredicate predicateWithFormat:
							 @"%K == %@",
							 KeyService,
							 [obj valueForKey:KeyService]];
				title = [NSString stringWithFormat:@"%@",
						 [obj valueForKey:KeyService]];
				status = [NSString stringWithFormat:FILTER_SERVICE, title];
			}
			if (_predicateService &&
				[[predicate predicateFormat] isEqualToString:
				 [_predicateService predicateFormat]])
			{
				predicate = nil;
				title = _titleService;
			}
		}
		else if (column == 1)
		{
			NSString *user = [obj valueForKey:KeyUser];
			NSString *comment = [obj valueForKey:KeyComment];
			NSString *reply = nil;
			NSString *prefix = @"";
			if ((modifiers == NSAlternateKeyMask) &&
				comment && ![comment isEqualToString:@""] &&
				[[obj valueForKey:KeyService] isEqualToString:Jaiku])
			{
				NSString *item_id = [obj valueForKey:KeyId];
				item_id = [[item_id componentsSeparatedByString:@"-"] objectAtIndex:0];
				title = [comment substringWithRange:NSMakeRange(4, [comment length] - 5)];
				if ([title length] > 32)
				{
					title = [title substringWithRange:NSMakeRange(0, 32)];
					title = [title stringByAppendingString:@"…"];
				}
				prefix = FILTER_THREAD;
				predicate = [NSPredicate predicateWithFormat:
							 @"%K beginswith %@",
							 KeyId,
							 item_id];
				//LOG(@"[%@ predicate] predicate:\n%@", [self className], predicate);
				//LOG(@"[%@ predicate] title:\n%@", [self className], title);
			}
			if (!predicate && user && ![user isEqualToString:@""])
			{
				prefix = FILTER_USER;
				NSString *text = [obj valueForKey:KeyText];
				NSString *inReplyUser = [obj valueForKey:KeyInReplyUser];
				NSString *text_user = [[text componentsSeparatedByString:@" "] objectAtIndex:0];
				text_user = [[text_user componentsSeparatedByString:@"　"] objectAtIndex:0];
				NSString *atmark = @"";
				if ([text_user length] > 0)
				{
					atmark = [text_user substringWithRange:NSMakeRange(0, 1)];
				}
				NSString *inReplyChannel = @"";
				if (inReplyUser && [inReplyUser length] > 0)
				{
					inReplyChannel = [inReplyUser substringWithRange:NSMakeRange(0, 1)];
				}
				if ([atmark isEqualToString:@"@"] &&
					![inReplyUser isEqualTo:@""] &&
					![inReplyChannel isEqualTo:@"#"] &&
					![inReplyChannel isEqualTo:@"!"])
				{
					reply = text_user;
					predicate = [NSPredicate predicateWithFormat:
								 @"(%K == %@) OR (%K contains[c] %@) OR (%K == %@) OR (%K == %@)",
								 KeyUser,
								 [obj valueForKey:KeyUser],
								 KeyTextNotify,
								 [obj valueForKey:KeyUser],
								 KeyUser,
								 [obj valueForKey:KeyInReplyUser],
								 KeyUser,
								 reply];
				}
				else if ([atmark isEqualToString:@"@"])
				{
					reply = text_user;
					predicate = [NSPredicate predicateWithFormat:
								 @"(%K == %@) OR (%K contains[c] %@) OR (%K == %@)",
								 KeyUser,
								 [obj valueForKey:KeyUser],
								 KeyTextNotify,
								 [obj valueForKey:KeyUser],
								 KeyUser,
								 reply];
				}
				else if (![inReplyUser isEqualTo:@""] &&
						 ![inReplyChannel isEqualTo:@"#"] &&
						 ![inReplyChannel isEqualTo:@"!"])
				{
					reply = [obj valueForKey:KeyInReplyUser];
					predicate = [NSPredicate predicateWithFormat:
								 @"(%K == %@) OR (%K contains[c] %@) OR (%K == %@)",
								 KeyUser,
								 [obj valueForKey:KeyUser],
								 KeyTextNotify,
								 [obj valueForKey:KeyUser],
								 KeyUser,
								 reply];
				}
				else
				{
					predicate = [NSPredicate predicateWithFormat:
								 @"(%K == %@) OR (%K contains[c] %@)",
								 KeyUser,
								 [obj valueForKey:KeyUser],
								 KeyTextNotify,
								 [obj valueForKey:KeyUser]];
				}
			}
			if (_predicateUser && predicate &&
				[[predicate predicateFormat] isEqualToString:
				 [_predicateUser predicateFormat]])
			{
				predicate = nil;
				title = _titleUser;
			}
			else if (!title)
			{
				//LOG(@"[%@ performClicked] predicate:\n%@", [self className], predicate);
				//LOG(@"[%@ performClicked] reply:\n%@", [self className], reply);
				if (reply && ![reply isEqualToString:user])
				{
					title = [NSString stringWithFormat:@"%@ + %@", user, reply];
				}
				else
				{
					title = [NSString stringWithFormat:@"%@", user];
				}
			}
			status = [NSString stringWithFormat:@"%@%@", prefix, title];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ predicate] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	return [NSDictionary dictionaryWithObjectsAndKeys:
			predicate ? predicate : (id)[NSNull null], Predicate,
			title ? title : (id)[NSNull null], Title,
			status ? status : (id)[NSNull null], Status,
			nil];
}

- (void)indicatePredicate:(NSPoint)point
{
	//LOG(@"[%@ indicatePredicate]", [self className]);
	@try
	{
		NSString *status = @"";
		NSRect bounds = [_scroll bounds];
		float bx = bounds.origin.x;
		float bw = bx + bounds.size.width;
		float by = bounds.origin.y;
		float bh = by + bounds.size.height;
		NSPoint pt = [_scroll convertPoint:point fromView:nil];
		float x = pt.x;
		float y = pt.y;
		//LOG(@"[%@ indicatePredicate]\n%f, %f\n%f, %f, %f, %f", [self className], x, y, bx, by, bw, bh);
		if ((x >= bx) && (x < bw) && (y >= by) && (y < bh))
		{
			bounds = [_view bounds];
			bx = bounds.origin.x;
			bw = bx + bounds.size.width;
			by = bounds.origin.y;
			bh = by + bounds.size.height;
			pt = [_view convertPoint:point fromView:nil];
			x = pt.x;
			y = pt.y;
			//LOG(@"[%@ indicatePredicate]\n%f, %f\n%f, %f, %f, %f", [self className], x, y, bx, by, bw, bh);
			if ((x >= bx) && (x < bw) && (y >= by) && (y < bh))
			{
				int row = [_view rowAtPoint:pt];
				int column = [_view columnAtPoint:pt];
				if ((row >= 0) && (column >= 0) && (column < 2))
				{
					id obj = [[_timeline arrangedObjects] objectAtIndex:row];
					int index = [[obj valueForKey:KeyIndex] intValue];
					if (index >= 0)
					{
						obj = [[_timeline content] objectAtIndex:index];
						obj = [self predicate:obj withColumn:column];
						NSPredicate *predicate = [obj valueForKey:Predicate];
						if ([predicate isKindOfClass:[NSNull class]])
						{
							status = [NSString stringWithFormat:
									  RELEASE_FILTERS, [obj valueForKey:Status]];
						}
						else
						{
							status = [NSString stringWithFormat:
									  FILTERS_IN, [obj valueForKey:Status]];
						}
					}
				}
			}
		}
		if (!_textStatusBar || ![status isEqualToString:_textStatusBar])
		{
			if (_textStatusBar)
			{
				[_textStatusBar release];
			}
			_textStatusBar = [status retain];
			[self setStatusBar:status];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ indicatePredicate] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performMouseMoved:(NSEvent *)theEvent
{
	//LOG(@"[%@ performMouseMoved]", [self className]);
	@try
	{
		@synchronized(_timeline)
		{
			NSPoint point;
			if (theEvent)
			{
				point = [theEvent locationInWindow];
			}
			else
			{
				point = [[_view window] convertScreenToBase:[NSEvent mouseLocation]];
			}
			[self indicatePredicate:point];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performMouseMoved] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (void)performClicked:(NSNumber *)number
{
	LOG(@"[%@ performClicked]", [self className]);
	@try
	{
		NSArray* selected = nil;
		id obj = nil;
		BOOL doPredicate = NO;
		NSPredicate *predicate = nil;
		NSString *title = TIMELINE;
		//[_lockTimeline lock];
		@try
		{
			@synchronized(_timeline)
			{
				selected = [_timeline selectedObjects];
				if ([selected count] > 0)
				{
					int column = [number intValue];
					obj = [self predicate:[selected objectAtIndex:0]
							   withColumn:column];
					LOG(@"[%@ performClicked]\n%@", [self className], predicate);
					predicate = [obj valueForKey:Predicate];
					if (column == 0)
					{
						doPredicate = YES;
						if (!predicate || [predicate isKindOfClass:[NSNull class]])
						{
							[_predicateService release];
							_predicateService = nil;
							[_titleService release];
							_titleService = nil;
						}
						else
						{
							_predicateService = [predicate retain];
							_titleService = [[obj valueForKey:Title] retain];
						}
					}
					else //if (column == 1)
					{
						doPredicate = YES;
						if (!predicate || [predicate isKindOfClass:[NSNull class]])
						{
							[_predicateUser release];
							_predicateUser = nil;
							if (_titleUser)
							{
								[_titleUser release];
								_titleUser = nil;
							}
						}
						else
						{
							_predicateUser = [predicate retain];
							if (_titleUser)
							{
								[_titleUser release];
							}
							_titleUser = [[obj valueForKey:Title] retain];
						}
					}
				}
			}
			if (doPredicate)
			{
				if (_titleService && _titleUser)
				{
					title = [title stringByAppendingFormat:@" - %@ / %@",
							 _titleService, _titleUser];
				}
				else if (_titleService)
				{
					title = [title stringByAppendingFormat:@" - %@", _titleService];
				}
				else if (_titleUser)
				{
					title = [title stringByAppendingFormat:@" - %@", _titleUser];
				}
				if (_predicateService && _predicateUser)
				{
					predicate = [NSCompoundPredicate andPredicateWithSubpredicates:
								 [NSArray arrayWithObjects:
								  _predicateService,
								  _predicateUser,
								  nil]];
				}
				else if (_predicateService)
				{
					predicate = _predicateService;
				}
				else if (_predicateUser)
				{
					predicate = _predicateUser;
				}
				else
				{
					predicate = nil;
				}
				if (predicate)
				{
					LOG(@"[%@ performClicked]\n%@", [self className], [predicate predicateFormat]);
				}
				[self setFilterPredicate:predicate];
				[self setTitle:title];
				if (obj)
				{
					//LOG(@"[%@ performClicked] setSelectedObject", [self className]);
					[self setSelectedObject:obj];
				}
			}
			//LOG(@"[%@ performClicked] done", [self className]);
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@ performClicked] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
		}
		@finally
		{
			//[_lockTimeline unlock];
		}
		if (doPredicate && _keyView)
		{
			[self tableView:_view flagsChanged:nil];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performClicked] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
}

- (IBAction)onClicked:(id)sender
{
	//LOG(@"[%@ onClicked]", [self className]);
	int selectedRow = [_view selectedRow];
	if (selectedRow >= 0)
	{
		int column = [_view columnAtPoint:
					  [[_view window] convertScreenToBase:[NSEvent mouseLocation]]];
		if ((column == 0) || (column == 1))
		{
			[self performClicked:[[NSNumber alloc] initWithInt:column]];
		}
	}
}

- (void)performDoubleClicked
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	NSString *action = nil;
	[_lockTimeline lock];
	@try
	{
		@synchronized(_timeline)
		{
			NSArray* selected = [_timeline selectedObjects];
			if ([selected count] > 0)
			{
				id obj = [selected objectAtIndex:0];
				action = [NSString stringWithFormat:@"%@ %@",
						  [obj valueForKey:KeyService],
						  [obj valueForKey:KeyId]];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performDoubleClicked] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		[_lockTimeline unlock];
	}
	if (action)
	{
		[_controller doClickAction:action];
	}
	[pool release];
	[NSThread exit];
}

- (IBAction)onDoubleClicked:(id)sender
{
	//LOG(@"[%@ onDoubleClicked]\n%@", [self className], sender);
	[NSThread detachNewThreadSelector:@selector(performDoubleClicked)
							 toTarget:self
						   withObject:nil];
}

- (void)releaseFiltering
{
	if (_predicateService)
	{
		[_predicateService release];
		_predicateService = nil;
	}
	if (_predicateUser)
	{
		[_predicateUser release];
		_predicateUser = nil;
	}
	[self setFilterPredicate:nil];
	[self setTitle:TIMELINE];
}

#pragma mark NSObject Delegates

- (void)awakeFromNib
{
	//LOG(@"[%@ awakeFromNib]", [self className]);
	NSRect frame = [_panel frame];
	NSString *frameTimeline = [_preferences frameTimeline];
	if (!frameTimeline)
	{
		NSRect screen = [[NSScreen mainScreen] frame];
		frame.origin.x = (screen.size.width - frame.size.width) / 2 + screen.origin.x;
		frame.origin.y = (screen.size.height - frame.size.height) / 4 * 2 + screen.origin.y;
		[_panel setFrame:frame display:YES];
	}
	
	NSArray *columns = [_view tableColumns];
	NSTableColumn *column = [columns objectAtIndex:0];
	[[column dataCell] setImageAlignment:NSImageAlignTop];
	column = [columns objectAtIndex:1];
	[[column dataCell] setImageAlignment:NSImageAlignTop];
	_columnIcon = [columns objectAtIndex:1];
	_columnText = [columns objectAtIndex:2];
	_columnDate = [columns objectAtIndex:3];
	[self setDateWidth];
	
	[_timeline setSortDescriptors:[NSArray arrayWithObjects:
								   [[[NSSortDescriptor alloc] initWithKey:KeyCreatedAt ascending:NO] autorelease],
								   nil]];
	[_view setDoubleAction:@selector(onDoubleClicked:)];
	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
						 LogoTwitter, KeyUserProfile,
						 [NSImage imageNamed:LogoTwitter], KeyProfileImage,
						 nil]];
	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
						 LogoJaiku, KeyUserProfile,
						 [NSImage imageNamed:LogoJaiku], KeyProfileImage,
						 nil]];
	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
						 LogoWassr, KeyUserProfile,
						 [NSImage imageNamed:LogoWassr], KeyProfileImage,
						 nil]];
//	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
//						 LogoNowa, KeyUserProfile,
//						 [NSImage imageNamed:LogoNowa], KeyProfileImage,
//						 nil]];
	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
						 LogoIdentica, KeyUserProfile,
						 [NSImage imageNamed:LogoIdentica], KeyProfileImage,
						 nil]];
	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
						 LogoJisko, KeyUserProfile,
						 [NSImage imageNamed:LogoJisko], KeyProfileImage,
						 nil]];
	[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
						 Mail, KeyUserProfile,
						 [NSImage imageNamed:Mail], KeyProfileImage,
						 nil]];
	Service *service = [_controller service:Twitter];
	int const*table = [AfficheurPanel tableOfJaikuIcon];
	while (*table)
	{
		NSString *name = [service imageNameJaiku:*table];
		NSImage *image = [NSImage imageNamed:name];
		if (image)
		{
			[_profile addObject:[NSDictionary dictionaryWithObjectsAndKeys:
								 name, KeyUserProfile,
								 image, KeyProfileImage,
								 nil]];
		}
		table++;
	}
	LOG(@"[%@ awakeFromNib] %d", [self className], [[_view window] acceptsMouseMovedEvents]);
	[[_view window] setAcceptsMouseMovedEvents:YES];
}

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
	SEL action = [menuItem action];
	if (action == @selector(onReleaseFiltering:))
	{
		return _predicateService || _predicateUser;
	}
	return YES;
}

- (void)applicationWillTerminate
{
}

#pragma mark NSTableView Delegates

- (float)tableView:(NSTableView *)tableView
		heightOfRow:(int)row
{
	float height = 42;
	@synchronized(_timeline)
	{
		NSArray *arrangedObjects = [_timeline arrangedObjects];
		if (row < [arrangedObjects count])
		{
			NSDictionary *item = [arrangedObjects objectAtIndex:row];
			@try
			{
				int index = [[item valueForKey:KeyIndex] intValue];
				float width = [_columnText width];
				float itemWidth = [[item valueForKey:KeyWidth] floatValue];
				if ((itemWidth < 0) || (itemWidth != width))
				{
					NSMutableDictionary *obj = [NSMutableDictionary dictionaryWithDictionary:item];
					NSCell *cell = [_columnText dataCell];
					[cell setAttributedStringValue:[item valueForKey:KeyTextDisplay]];
					height = [cell cellSizeForBounds:NSMakeRect(0, 0, width, 2000)].height;
					if (!_inhibitTimeline)
					{
						[obj setValue:[NSNumber numberWithFloat:width] forKey:KeyWidth];
						[obj setValue:[NSNumber numberWithFloat:height] forKey:KeyHeight];
						NSMutableArray *content = [_timeline content];
						if ((index >= 0) && (index < [content count]))
						{
							[content replaceObjectAtIndex:index withObject:obj];
						}
					}
				}
				else
				{
					height = [[item valueForKey:KeyHeight] floatValue];
				}
				float min = [_columnIcon width];
				if (height < min)
				{
					height = min;
				}
				if (index < 0)
				{
					LOG(@"[%@ heightOfRow]!!!\n%@", [self className], item);
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@ heightOfRow] EXCEPTION\n%@: %@\n%@", [self className], [exception name], [exception reason], [item valueForKey:KeyService]);
			}
		}
	}
	return height + 2;
}

- (void)tableView:(NSTableView *)aTableView
  willDisplayCell:(id)aCell
   forTableColumn:(NSTableColumn *)aTableColumn
			  row:(int)rowIndex
{
	@synchronized(_timeline)
	{
		NSDictionary *item = [[_timeline arrangedObjects] objectAtIndex:rowIndex];
		@try
		{
			int selected = [aTableView selectedRow];
			if (item)
			{
				NSDictionary *appearances = [_preferences appearances];
				NSDictionary *colors = [appearances valueForKey:AppearanceColor];
				NSDictionary *color = [self appearanceColor:item withColors:colors];
				if ((selected < 0) || (selected != rowIndex))
				{
					[aCell setDrawsBackground:YES];
					[aCell setBackgroundColor:[color valueForKey:AppearanceBackground]];
				}
				else
				{
					[aCell setDrawsBackground:NO];
					if ([aTableColumn isEqual:_columnText])
					{
						//LOG(@"[%@ willDisplayCell] text", [self className]);
						[aCell setAttributedStringValue:[item valueForKey:KeyTextDisplaySelected]];
					}
					else if ([aTableColumn isEqual:_columnDate])
					{
						//LOG(@"[%@ willDisplayCell] date", [self className]);
						[aCell setAttributedStringValue:[item valueForKey:KeyDateDisplaySelected]];
					}
				}
				if ([aTableColumn isEqual:_columnIcon])
				{
					NSString *userProfile = [item valueForKey:KeyUserProfile];
					if (![userProfile isEqualToString:@""])
					{
						id profileImage = [self profileImage:userProfile];
						if (!profileImage)
						{
							//LOG(@"[%@ willDisplayCell] queueing\n%@", [self className], userProfile);
							[self queueingUserProfile:userProfile
										   withUnlock:YES];
						}
					}
				}
				else if ([aTableColumn isEqual:_columnText])
				{
					NSString *photo_url = [item valueForKey:KeyImageURL];
					if (photo_url &&
						![photo_url isKindOfClass:[NSNull class]] &&
						![photo_url isEqualToString:@""] &&
						[_preferences generalInlineImage])
					{
						id photo = [self profileImage:photo_url];
						if (!photo)
						{
							//LOG(@"[%@ willDisplayCell] queueing\n%@", [self className], photo_url);
							[self queueingUserProfile:photo_url
										   withUnlock:YES];
						}
					}
				}
			}
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@ willDisplayCell] EXCEPTION\n%@: %@\n%@", [self className], [exception name], [exception reason], [item valueForKey:KeyService]);
		}
	}
}

- (void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
	//LOG(@"[%@ tableViewSelectionDidChange]\n%@", [self className], aNotification);
	if ([_view selectedRow] >= 0)
	{
		_selectedRow = YES;
	}
	else
	{
		_selectedRow = NO;
	}
}

- (void)tableView:(NSTableView *)aTableView
			keyUp:(NSEvent *)theEvent
{
	//LOG(@"[%@ keyUp]", [self className]);
	[self performMouseMoved:nil];
}

- (void)tableView:(NSTableView *)aTableView
	   mouseMoved:(NSEvent *)theEvent
{
	//LOG(@"[%@ mouseMoved]", [self className]);
	[self performMouseMoved:theEvent];
}

- (void)tableView:(NSTableView *)aTableView
	   flagsChanged:(NSEvent *)theEvent
{
	//LOG(@"[%@ flagsChanged] %d", [self className], _keyView);
	[self performMouseMoved:nil];
}

- (void)tableView:(NSTableView *)aTableView
	 scrollWheel:(NSEvent *)theEvent
{
	//LOG(@"[%@ scrollWheel] %d", [self className], _keyView);
	if (_keyView)
	{
		[self performMouseMoved:nil];
	}
}

#pragma mark NSWindow Delegates

- (void)windowDidResize:(NSNotification *)notification
{
	//LOG(@"[%@ windowDidResize]", [self className]);
	[_view noteNumberOfRowsChanged];
}

- (void)windowDidBecomeKey:(NSNotification *)notification
{
	LOG(@"[%@ windowDidBecomeKey]\n%@", [self className], notification);
	_keyView = YES;
	[self tableView:_view flagsChanged:nil];
}

- (void)windowDidResignKey:(NSNotification *)notification
{
	LOG(@"[%@ windowDidResignKey]\n%@", [self className], notification);
	_keyView = NO;
	[self setStatusBar:@""];
}

@end
