//
//  HTTP.h
//  Afficheur
//
//  Created by kichi on 08/04/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface HTTP : NSObject {
	NSURLConnection*	_connection;
	int					_statusCode;
	NSDictionary*		_headers;
	
	NSThread*			_mainThread;
	BOOL				_locked;
	NSLock*				_lock;
	
	double				_timeout;
	NSError*			_error;
	NSMutableData*		_data;
	BOOL				_redirect;
	BOOL				_shouldHandleCookies;
}

enum {
	ResultError = 0,
	ResultResponse,
	ResultData,
	ResultDescription
};

+ (NSString *)base64String:(NSString *)string;
+ (NSString *)base64StringWithBytes:(const char *)cstr
							 length:(int)length;
+ (NSString *)stringWithBase64String:(NSString *)string;
+ (NSString *)urlEncode:(NSString *)string;
+ (NSString *)urlEncode:(NSString *)string
		   withEncoding:(CFStringEncoding)encoding;
+ (NSString *)urlEncode:(NSString *)string
			  unescaped:(NSString *)unescaped
				escaped:(NSString *)escaped;
+ (NSString *)urlEncode:(NSString *)string
			  unescaped:(NSString *)unescaped
				escaped:(NSString *)escaped
			   encoding:(CFStringEncoding)encoding;
+ (NSString *)urlDencode:(NSString *)string;

+ (BOOL)isHTML:(NSString *)string;

- (void)setTimeoutInterval:(double)timeout;
- (void)setRedirect:(BOOL)doNotRedirect;
- (BOOL)redirect;

- (void)setShouldHandleCookies:(BOOL)shouldHandleCookies;
- (BOOL)shouldHandleCookies;

- (int)statusCode;
- (NSDictionary *)headers;

- (id)post:(NSString *)path
	header:(NSDictionary *)aHeader
	  body:(NSString *)aBody;
- (id)get:(NSString *)path
   header:(NSDictionary *)aHeader
	 body:(NSString *)aBody;
- (id)head:(NSString *)path
	header:(NSDictionary *)header
	  body:(NSString *)body;

- (NSString *)titleOfHTML:(NSString *)string;
- (id)determineError:(id)object
			WithJSON:(BOOL)json;

- (NSString *)errorLocalizedDescription:(NSError *)error;

@end
