//
//  JaikuIconView.m
//  Afficheur
//
//  Created by kichi on 09/03/21.
//  Copyright 2009 Katsuhiko Ichinose. All rights reserved.
//

#import "JaikuIconView.h"


@implementation JaikuIconView

- (id)initWithFrame:(NSRect)frameRect
{
	self = [super initWithFrame:frameRect];
	if (self)
	{
		[self setIconCode:0];
		[self setImageFrameStyle:NSImageFrameNone];
		[self setAnimates:NO];
		[self setImage:nil];
	}
	return self;
}

- (id)initWithFrame:(NSRect)frameRect
		   iconCode:(int)iconCode
			  image:(NSImage *)image
{
	self = [super initWithFrame:frameRect];
	if (self)
	{
		[self setIconCode:iconCode];
		[self setImageFrameStyle:NSImageFrameNone];
		[self setAnimates:NO];
		[self setImage:image];
	}
	return self;
}

- (int)iconCode
{
	return _iconCode;
}

- (void)setIconCode:(int)iconCode
{
	_iconCode = iconCode;
}

- (void)setImage:(NSImage *)image
{
	if (image)
	{
		NSImage *cellImage = [[[NSImage alloc] initWithSize:[self bounds].size] autorelease];
		NSSize cellSize = [cellImage size];
		NSSize imageSize = [image size];
		[cellImage lockFocus];
		[image drawInRect:NSMakeRect(0, 0, cellSize.width, cellSize.height)
				 fromRect:NSMakeRect(0, 0, imageSize.width, imageSize.height)
				operation:NSCompositeCopy
				 fraction:1.0];
		[cellImage unlockFocus];
		[super setImage:cellImage];
	}
	else
	{
		[super setImage:nil];
	}
}

@end
