//
//  JiskoAPI.m
//  Afficheur
//
//  Created by kichi on 08/12/12.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "JiskoAPI.h"
#import "NSStringOgreKit.h"
#import <OgreKit/OgreKit.h>
#import <JSON/JSON.h>


@implementation JiskoAPI

- (id)init
{
	self = [super init];
	if (self)
	{
		[_dic setObject:@"jisko.net" forKey:TwitterHost];
		[_dic setObject:@"http://jisko.net/statuses" forKey:TwitterURL];
	}
	return self;
}

- (id)friends
{
	id result = [self getWithAuth:[NSString stringWithFormat:
								   @"%@/friendships/exists.json",
								   [_dic valueForKey:TwitterURL]]
						   header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									nil] autorelease]
							 body:@""];
	return [self determineError:result WithJSON:YES];
}

- (id)avatar:(NSString *)user
{
	id result = [self getWithAuth:[NSString stringWithFormat:
								   @"http://jisko.net/%@",
								   user]
						   header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									nil] autorelease]
							 body:@""];
	result = [self determineError:result WithJSON:NO];
	if ([result isKindOfClass:[NSString class]])
	{
		//LOG(@"[%@ avatar] %@", [self className], result);
		if ([result rangeOfRegularExpressionString:@"^<!DOCTYPE html PUBLIC "].length)
		{
			if ([result rangeOfRegularExpressionString:
				@"<div class=\"avatar_note\"><img src=\".*?\" alt=\"avatar\""].length)
			{
				result = [result replaceWithExpression:@"^.*?<div class=\"avatar_note\"><img src=\"(.*?)\" alt=\"avatar\".*$"
											   replace:@"\\1"
											   options:OgreMultilineOption];
			}
			else
			{
				result = nil;
			}
		}
		else
		{
			result = nil;
		}

	}
	else
	{
		result = nil;
	}
	return result;
}

@end
