//
//  KeyEquivField.m
//  Afficheur
//
//  Created by kichi on 08/04/14.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "KeyEquivField.h"
#import "KeyEquivView.h"
#import "KeyEquivCell.h"


@implementation KeyEquivField

- (id)init
{
	self = [super init];
	if (self)
	{
		_textView = nil;
		_isLeopard = NO;
		_trackMouse = NO;
		_eventDone = NO;
		_imageView = nil;
	}
	return self;
}

- (void)dealloc
{
	if (_imageView)
	{
		[_imageView release];
	}
	[super dealloc];
}

- (void)setIsLeopard:(BOOL)isLeopard
{
	_isLeopard = isLeopard;
}

- (BOOL)isLeopard
{
	return _isLeopard;
}

- (void)setEventDone:(BOOL)done
{
	_eventDone = done;
}

- (void)setTextView:(NSTextView *)textView;
{
	_textView = textView;
	[[[self cell] searchButtonCell] setImage:nil];
}
- (BOOL)becomeFirstResponder
{
	LOG(@"[%@ becomeFirstResponder] %p", [self className], self);
	if (_isLeopard)
	{
		[self performClick:self];
		return YES;
	}
	return [super becomeFirstResponder];
}

- (BOOL)resignFirstResponder
{
	LOG(@"[%@ resignFirstResponder] %p", [self className], self);
	if (_textView)
	{
		[_textView setEnableKeyDown:NO];
	}
	return [super resignFirstResponder];
}

- (void)addCursorRect:(NSRect)aRect cursor:(NSCursor *)aCursor
{
	//LOG(@"[%@ addCursorRect]\n%@: %f, %f - %f, %f",
	//	[self className], aCursor,
	//	aRect.origin.x, aRect.origin.y, aRect.size.width, aRect.size.height);
	if ([aCursor isEqualTo:[NSCursor IBeamCursor]])
	{
		//LOG(@"[%@ addCursorRect] IBeam", [self className]);
		aCursor = [NSCursor arrowCursor];
	}
	[super addCursorRect:aRect cursor:aCursor];
}

- (void)resetCursorRects
{
	//LOG(@"[%@ resetCursorRects]", [self className]);
	[self discardCursorRects];
	[self addCursorRect:[self bounds] cursor:[NSCursor arrowCursor]];
	if ([self window])
	{
		[[self window] invalidateCursorRectsForView:self];
		if (_textView)
		{
			[[self window] invalidateCursorRectsForView:_textView];
		}
	}
}

- (BOOL)isInButton:(NSEvent *)theEvent
{
	NSRect bounds = [self bounds];
	NSRect rect = NSMakeRect(bounds.size.width - 16, 4, 13, 13);
	NSPoint loc = [theEvent locationInWindow];
	loc.x -= [self frame].origin.x;
	loc.y -= [self frame].origin.y;
	//LOG(@"[%@ isInButton] %d", [self className], [self mouse:loc inRect:rect]);
	return [self mouse:loc inRect:rect];
}

- (BOOL)isInRect:(NSEvent *)theEvent
{
	if ([self isInButton:theEvent])
	{
		return NO;
	}
	NSRect frame = [self frame];
	NSRect rect = NSMakeRect(frame.origin.x + 16, frame.origin.y,
							 frame.size.width - 32, frame.size.height);
	NSPoint loc = [theEvent locationInWindow];
	//LOG(@"[%@ isInRect] %d", [self className], [self mouse:loc inRect:rect]);
	return [self mouse:loc inRect:rect];
}

- (void)keyDown:(NSEvent *)theEvent
{
	LOG(@"[%@ keyDown]\n%@", [self className], theEvent);
	if (_isLeopard && _textView)
	{
		_eventDone = NO;
		[_textView keyDown:theEvent];
		if (!_eventDone)
		{
			if ([self window])
			{
				if ([[[self window] firstResponder] isEqualTo:self])
				{
					LOG(@"[%@ keyDown] super", [self className]);
					[super keyDown:theEvent];
				}
			}
		}
	}
}

- (void)mouseDown:(NSEvent *)theEvent
{
	//LOG(@"[%@ mouseDown]\n%@", [self className], theEvent);
	if ([_textView isValidKeyCode] && [self isInButton:theEvent])
	{
		[_textView setPushedCancelButton];
	}
	if ([self isInRect:theEvent] && ![_textView isValidKeyCode])
	{
		_trackMouse = YES;
	}
}

- (void)mouseUp:(NSEvent *)theEvent
{
	//LOG(@"[%@ mouseUp]\n%@", [self className], theEvent);
	if ([_textView isPushedCancelButton] && [self isInButton:theEvent])
	{
		[_textView setCancelButton];
		[_textView setKeyCode:-1];
	}
	else
	{
		[_textView setCancelButton];
	}
	if (_trackMouse && [self isInRect:theEvent])
	{
		[_textView setEnableKeyDown:![_textView isEnableKeyDown]];
	}
	_trackMouse = NO;
}

- (void)mouseDragged:(NSEvent *)theEvent
{
	//LOG(@"[%@ mouseDragged]\n%@", [self className], theEvent);
	if ([_textView isPushedCancelButton] && ![self isInButton:theEvent])
	{
		//LOG(@"[%@ mouseDragged] !!", [self className]);
		[_textView setCancelButton];
	}
}

- (void)_mouseEntered:(NSEvent *)theEvent
{
	//LOG(@"[%@ mouseEntered]", [self className]);
}

- (void)_mouseExited:(NSEvent *)theEvent
{
	//LOG(@"[%@ mouseExited]", [self className]);
}

- (void)rightMouseDown:(NSEvent *)theEvent
{
	//LOG(@"[%@ rightMouseDown]\n%@", [self className], theEvent);
}

- (void)rightMouseDragger:(NSEvent *)theEvent
{
	//LOG(@"[%@ rightMouseDragger]", [self className]);
}

- (void)rightMouseUp:(NSEvent *)theEvent
{
	//LOG(@"[%@ rightMouseUp]\n%@", [self className], theEvent);
}

- (void)otherMouseDown:(NSEvent *)theEvent
{
	//LOG(@"[%@ otherMouseDown]\n%@", [self className], theEvent);
}

- (void)otherMouseDragger:(NSEvent *)theEvent
{
	//LOG(@"[%@ otherMouseDragger]", [self className]);
}

- (void)otherMouseUp:(NSEvent *)theEvent
{
	//LOG(@"[%@ otherMouseUp]\n%@", [self className], theEvent);
}

@end
