//
//  ServiceTwitter.m
//  Afficheur
//
//  Created by kichi on 08/09/02.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "ServiceTwitter.h"
#import "AfficheurController.h"
#import "AfficheurPreferences.h"
#import "AfficheurGrowl.h"
#import "AfficheurTimeline.h"
#import "NSStringOgreKit.h"
#import <OgreKit/OgreKit.h>
#import <JSON/JSON.h>


@implementation ServiceTwitter

static NSString* CONSUMER_KEY = @"VEJpa2RJdE92cEIxVE40ZEhCR0Vn";
static NSString* CONSUMER_SECRET = @"dVl2Y05EdVRzOFF6WVhMRmgzVEVSVkxwMGpFNmVnTWNmeUVPQVpPaw==";
static NSString* REQUEST_TOKEN_PATH = @"http://twitter.com/oauth/request_token";
static NSString* AUTHORIZE_PATH = @"http://twitter.com/oauth/authorize";
static NSString* ACCESS_TOKEN_PATH = @"http://twitter.com/oauth/access_token";

- (id)init
{
	//LOG(@"[%@ init]", [self className]);
	self = [super init];
	if (self)
	{
		_title = nil;
		_since = [[NSMutableArray alloc] init];
		_dateTimeline = nil;
		_dateReplies = nil;
		_dateDM = nil;
		_first = YES;
		_tweets = 20;
		_keepTweets = 0;
		_request_token = nil;
		_request_token_secret = nil;
		_access_token = nil;
		_access_token_secret = nil;
	}
	return self;
}

- (void)dealloc
{
	[_title release];
	if (_since)
	{
		[_since release];
	}
	if (_request_token)
	{
		[_request_token release];
	}
	if (_request_token_secret)
	{
		[_request_token_secret release];
	}
	if (_access_token)
	{
		[_access_token release];
	}
	if (_access_token_secret)
	{
		[_access_token_secret release];
	}
	[super dealloc];
}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences
{
	self = [super init:service
		WithController:controller
		   preferences:preferences];
	if (self)
	{
		if ([service isEqualToString:Twitter])
		{
			_notify = GrowlAfficheurTwitterNotify;
			_notifyReply = GrowlAfficheurTwitterReplyNotify;
			_notifyDM = GrowlAfficheurTwitterDirectNotify;
			_notifyError = GrowlAfficheurTwitterErrorNotify;
		}
		else if ([service isEqualToString:Wassr])
		{
			_notify = GrowlAfficheurWassrNotify;
			_notifyReply = GrowlAfficheurWassrReplyNotify;
			_notifyDM = GrowlAfficheurWassrReplyNotify;
			_notifyError = GrowlAfficheurWassrErrorNotify;
		}
//		else if ([service isEqualToString:Nowa])
//		{
//			_notify = GrowlAfficheurNowaNotify;
//			_notifyReply = GrowlAfficheurNowaReplyNotify;
//			_notifyDM = GrowlAfficheurNowaReplyNotify;
//			_notifyError = GrowlAfficheurNowaErrorNotify;
//		}
		else if ([service isEqualToString:Identica])
		{
			_notify = GrowlAfficheurIdenticaNotify;
			_notifyReply = GrowlAfficheurIdenticaReplyNotify;
			_notifyDM = GrowlAfficheurIdenticaDirectNotify;
			_notifyError = GrowlAfficheurIdenticaErrorNotify;
		}
		else if ([service isEqualToString:Jisko])
		{
			_notify = GrowlAfficheurJiskoNotify;
			_notifyReply = GrowlAfficheurJiskoReplyNotify;
			_notifyDM = GrowlAfficheurJiskoPrivateNotify;
			_notifyError = GrowlAfficheurJiskoErrorNotify;
		}
	}
	return self;
}

- (void)setRequestToken:(NSString *)requestToken
{
	if (_request_token)
	{
		[_request_token release];
	}
	_request_token = [requestToken copy];
}

- (void)setRequestTokenSecret:(NSString *)requestTokenSecret
{
	if (_request_token_secret)
	{
		[_request_token_secret release];
	}
	_request_token_secret = [requestTokenSecret copy];
}

- (void)setAccessToken:(NSString *)accessToken
{
	if (_access_token)
	{
		[_access_token release];
	}
	_access_token = [accessToken copy];
}

- (void)setAccessTokenSecret:(NSString *)accessTokenSecret
{
	if (_access_token_secret)
	{
		[_access_token_secret release];
	}
	_access_token_secret = [accessTokenSecret copy];
}

- (NSString *)accessToken
{
	return [[_access_token copy] autorelease];
}

- (NSString *)accessTokenSecret
{
	return [[_access_token_secret copy] autorelease];
}

- (NSString *)authorize
{
	LOG(@"[%@ authorize]", [self className]);
	NSString *authorize = nil;
	@try
	{
		OAuth *oAuth = [[OAuth alloc] init];
		[oAuth setConsumerKey:[HTTP stringWithBase64String:CONSUMER_KEY]];
		[oAuth setConsumerSecret:[HTTP stringWithBase64String:CONSUMER_SECRET]];
		[oAuth setRequestTokenPath:REQUEST_TOKEN_PATH];
		[oAuth setAuthorizePath:AUTHORIZE_PATH];
		[oAuth setAccessTokenPath:ACCESS_TOKEN_PATH];
		if ([oAuth request_token])
		{
			[self setRequestToken:[oAuth requestToken]];
			[self setRequestTokenSecret:[oAuth requestTokenSecret]];
			authorize = [NSString stringWithFormat:
						 @"%@?oauth_token=%@&perms=delete",
						 [oAuth authorizePath], [oAuth requestToken]];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ authorize] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	return authorize;
}

- (BOOL)access_token
{
	LOG(@"[%@ access_token]", [self className]);
	BOOL access_token = NO;
	@try
	{
		OAuth *oAuth = [[OAuth alloc] init];
		[oAuth setConsumerKey:[HTTP stringWithBase64String:CONSUMER_KEY]];
		[oAuth setConsumerSecret:[HTTP stringWithBase64String:CONSUMER_SECRET]];
		[oAuth setRequestToken:_request_token];
		[oAuth setRequestTokenSecret:_request_token_secret];
		[oAuth setRequestTokenPath:REQUEST_TOKEN_PATH];
		[oAuth setAuthorizePath:AUTHORIZE_PATH];
		[oAuth setAccessTokenPath:ACCESS_TOKEN_PATH];
		if ([oAuth access_token])
		{
			[self setAccessToken:[oAuth accessToken]];
			[self setAccessTokenSecret:[oAuth accessTokenSecret]];
			access_token = YES;
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ access_token] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	return access_token;
}

- (void)setupRetrieveDate:(NSDate *)date
{
	[self setupRetrieveDateTimeline:date];
	[self setupRetrieveDateReplies:date];
	[self setupRetrieveDateDM:date];
}

- (void)setupRetrieveDateTimeline:(NSDate *)date
{
	@synchronized(self)
	{
		if (_dateTimeline)
		{
			[_dateTimeline release];
			[_dateTimeline release];
		}
		if (date)
		{
			_dateTimeline = [[[NSDate alloc] initWithTimeInterval:0 sinceDate:date] retain];
		}
		else
		{
			_dateTimeline = nil;
		}
	}
}

- (void)setupRetrieveDateReplies:(NSDate *)date
{
	@synchronized(self)
	{
		if (_dateReplies)
		{
			[_dateReplies release];
			[_dateReplies release];
		}
		if (date)
		{
			_dateReplies = [[[NSDate alloc] initWithTimeInterval:0 sinceDate:date] retain];
		}
		else
		{
			_dateReplies = nil;
		}
	}
}

- (void)setupRetrieveDateDM:(NSDate *)date
{
	@synchronized(self)
	{
		if (_dateDM)
		{
			[_dateDM release];
			[_dateDM release];
		}
		if (date)
		{
			_dateDM = [[[NSDate alloc] initWithTimeInterval:0 sinceDate:date] retain];
		}
		else
		{
			_dateDM = nil;
		}
	}
}

- (BOOL)checkRetrieve:(NSDate *)now
			 withDate:(NSDate *)date
			 interval:(NSTimeInterval)interval
{
	BOOL check = NO;
	@synchronized(self)
	{
		if (date && (interval > 0))
		{
			if (![date isKindOfClass:[NSDate class]])
			{
				LOG(@"[%@(%@) checkRetrieve] %@", [self className], _service, [date className]);
			}
			NSDate *aDate = [date addTimeInterval:interval];
			if ([now compare:aDate] != NSOrderedAscending)
			{
				check = YES;
			}
		}
	}
	return check;
}

- (BOOL)checkRetrieveTimeline:(NSDate *)now
{
	return [self checkRetrieve:now
					  withDate:_dateTimeline
					  interval:[_preferences accountTwitterIntervalTimeline]];
}

- (BOOL)checkRetrieveReplies:(NSDate *)now
{
	return [self checkRetrieve:now
					  withDate:_dateReplies
					  interval:[_preferences accountTwitterIntervalReplies]];
}

- (BOOL)checkRetrieveDM:(NSDate *)now
{
	return [self checkRetrieve:now
					  withDate:_dateDM
					  interval:[_preferences accountTwitterIntervalDM]];
}

- (int)rateLimit
{
	int rateLimit = -1;
	@try
	{
		NSString *user = [_preferences accountTwitterUser];
		NSString *pass = [_preferences accountTwitterPass];
		NSString *key = [_preferences accountTwitterOAuthKey];
		NSString *secret = [_preferences accountTwitterOAuthSecret];
		if (!pass)
		{
			pass = (NSString *)[NSNull null];
		}
		if (!key)
		{
			key = (NSString *)[NSNull null];
		}
		if (!secret)
		{
			secret = (NSString *)[NSNull null];
		}
		TwitterAPI *api = [[[TwitterAPI alloc] initWithDictionary:
							[NSDictionary dictionaryWithObjectsAndKeys:
							 user, TwitterUser,
							 pass, TwitterPass,
							 @"http://twitter.com", TwitterURL,
							 nil]] autorelease];
		id status = [api rateLimit];
		LOG(@"[%@(%@) rateLimit]\n%@", [self className], _service, status);
		if (status && [status isKindOfClass:[NSDictionary class]])
		{
			id hourly_limit = [status valueForKey:@"hourly_limit"];
			if (hourly_limit && [hourly_limit isKindOfClass:[NSNumber class]])
			{
				rateLimit = [hourly_limit intValue];
				//LOG(@"[%@(%@) rateLimit] %d", [self className], _service, rateLimit);
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) rateLimit] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	return rateLimit;
}

- (NSString *)determinePost:(id)object
					withAPI:(TwitterAPI *)api
				   function:(NSString *)function
{
	id description = [NSString stringWithFormat:@"%@ was failuer.", function];
	@try
	{
		//LOG(@"[%@(%@) determinPost] %@", [self className], _service, [api className]);
		if ([object isKindOfClass:[NSError class]])
		{
			NSString *desc = [api errorLocalizedDescription:object];
			if (desc)
			{
				description = [NSString stringWithFormat:@"%@\n(%@)", description, desc];
			}
		}
		else if((![_service isEqualToString:Jisko] && ![object isKindOfClass:[NSDictionary class]]) ||
				([_service isEqualToString:Jisko] && ![object isKindOfClass:[NSArray class]]))
		{
			NSString *strring = [NSString stringWithFormat:@"%@", object];
			NSString *title = [api titleOfHTML:strring];
			if (title)
			{
				strring = title;
			}
			description = [NSString stringWithFormat:@"%@\n(%@)", description, strring];
		}
		else
		{
			description = nil;
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) determinPost] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	return description;
}

- (TwitterAPI *)createAPI:(NSDictionary *)dic
{
	TwitterAPI *api = [[[TwitterAPI alloc] initWithDictionary:dic] autorelease];
	if (api)
	{
		[api setConsumerKey:[HTTP stringWithBase64String:CONSUMER_KEY]];
		[api setConsumerSecret:[HTTP stringWithBase64String:CONSUMER_SECRET]];
		[api setRequestTokenPath:REQUEST_TOKEN_PATH];
		[api setAuthorizePath:AUTHORIZE_PATH];
		[api setAccessTokenPath:ACCESS_TOKEN_PATH];
	}
	return api;
}

- (void)performPost:(NSArray *)array
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		[_controller syncPost];
		TwitterAPI *api = [self createAPI:[array objectAtIndex:1]];
		if (api)
		{
			[self registComplete:[array objectAtIndex:0]];
			id result = nil;
//			if ([_service isEqualToString:Nowa])
//			{
//				result = [api updateNowa:[array objectAtIndex:0]
//							   withReply:[array objectAtIndex:2]];
//			}
//			else
			{
				result = [api update:[array objectAtIndex:0]
						   withReply:[array objectAtIndex:2]];
			}
			[self determinePost:[self determinePost:result withAPI:api function:@"Post"]
					  withTitle:_title
					   function:@"Post"];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performPost] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	@finally
	{
		[array release];
	}
	[pool release];
	[NSThread exit];
}

- (void)post:(NSString *)status
   withReply:(NSString *)reply
{
	@synchronized(self)
	{
		@try
		{
			if (![reply isEqualToString:@""])
			{
				reply = [NSString stringWithFormat:@"&in_reply_to_status_id=%@", reply];
			}
			NSString *user = [_preferences accountTwitterUser];
			NSString *pass = [_preferences accountTwitterPass];
			NSString *key = [_preferences accountTwitterOAuthKey];
			NSString *secret = [_preferences accountTwitterOAuthSecret];
			if (!pass)
			{
				pass = (NSString *)[NSNull null];
			}
			if (!key)
			{
				key = (NSString *)[NSNull null];
			}
			if (!secret)
			{
				secret = (NSString *)[NSNull null];
			}
			NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:
								 user, TwitterUser,
								 pass, TwitterPass,
								 key, TwitterKey,
								 secret, TwitterSecret,
								 Afficheur, TwitterSource,
								 nil];
			if ([_preferences generalConvertEmoji])
			{
				status = [self stringFromEmoji:status];
			}
			[NSThread detachNewThreadSelector:@selector(performPost:)
									 toTarget:self
								   withObject:[[NSArray alloc] initWithObjects:status, dic, reply, nil]];
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@(%@) post] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
		}
	}
}

- (BOOL)isReply:(NSDictionary *)object
{
	return [[object valueForKey:KeyNotify] isEqualToString:_notifyReply];
}

- (NSDictionary *)parse:(NSDictionary *)obj
			   withUser:(NSString *)user_id
				   kind:(int)kind
				  first:(BOOL)first
{
	if (![obj isKindOfClass:[NSDictionary class]])
	{
		return nil;
	}
	NSDictionary *item = nil;
	@try
	{
		NSString *item_id = [NSString stringWithFormat:@"%@", [obj valueForKey:@"id"]];
		//LOG(@"[%@(%@) parse:%d] %@", [self className], _service, kind, item_id);
		NSDictionary *user = [obj valueForKey:@"user"];
		if (!user)
		{
			user = [obj valueForKey:@"sender"];
		}
		id protected = [user valueForKey:@"protected"];
		NSString *screen_name = [user valueForKey:@"screen_name"];
		NSString *user_name = [user valueForKey:@"name"];
		if (!user_name)
		{
			user_name = @"";
		}
		else if ([user_name isKindOfClass:[NSNull class]])
		{
			user_name = @"";
		}
		user_name = [self convertText:user_name];
		NSString *name = @"";
		if ((![user_name isEqualToString:@""]) &&(![user_name isEqualToString:screen_name]))
		{
			name = [NSString stringWithFormat:@" / %@", user_name];
		}
		NSString *user_profile = [user valueForKey:@"profile_image_url"];
		NSString *date = [obj valueForKey:@"created_at"];
		NSString *channel = @"";
		NSString *text = [obj valueForKey:@"text"];
		NSString *comment = @"";
		NSString *notify = _notify;
		NSString *kindStr = KindTimeline;
		NSString *inReplyUser = nil;
		if (!text || [text isKindOfClass:[NSNull class]])
		{
			text = @"";
		}
		if (![screen_name isEqualToString:user_id] && [self hasKeyword:text])
		{
			notify = GrowlAfficheurKeywordsNotify;
			first = NO;
		}
		if (kind == kindReply)
		{
			notify = _notifyReply;
			kindStr = KindReply;
		}
		else if (kind == kindDM)
		{
			notify = _notifyDM;
			kindStr = KindDM;
		}
		id in_reply = [obj valueForKey:@"in_reply_to_status_id"];
		if (!in_reply || [in_reply isKindOfClass:[NSNull class]])
		{
			if ((kind == kindTimeline) || (kind == kindChannel))
			{
				if (([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@$", user_id]] > 0) ||
					([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@[^!-~]", user_id]] > 0))
				{
					//LOG(@"[%@(%@) parse:%d] Reply\n%@:%@", [self className], _service, kind, screen_name, text);
					notify = _notifyReply;
					first = NO;
				}
			}
		}
		else
		{
			NSDictionary *reply = [self fetch:[NSString stringWithFormat:@"%@", in_reply]
								  withService:_service];
			if (reply)
			{
				inReplyUser = [reply valueForKey:KeyUser];
				comment = [NSString stringWithFormat:@"(on %@: %@)",
						   [reply valueForKey:KeyUser], [reply valueForKey:KeyText]];
				if ((kind == kindTimeline) || (kind == kindChannel))
				{
					if ([[reply valueForKey:KeyUser] isEqualToString:user_id])
					{
						//LOG(@"[%@(%@) parse:%d] Reply\n%@:%@", [self className], _service, kind, screen_name, text);
						notify = _notifyReply;
						first = NO;
					}
				}
			}
			else if ((kind == kindTimeline) || (kind == kindChannel))
			{
				if (([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@$", user_id]] > 0) ||
					([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@[^!-~]", user_id]] > 0))
				{
					//LOG(@"[%@(%@) parse:%d] Reply\n%@:%@", [self className], _service, kind, screen_name, text);
					notify = _notifyReply;
					first = NO;
				}
			}
		}
		if (kind == kindTimeline)
		{
			int i = 0;
			while (i < [_since count])
			{
				NSString *since = [_since objectAtIndex:i];
				if ([since compare:item_id] != NSOrderedDescending)
				{
					break;
				}
				i++;
			}
			[_since insertObject:item_id atIndex:i];
		}
		if (kind == kindDM)
		{
			item_id = [NSString stringWithFormat:@"DM%@", item_id];
			user_profile = [NSString stringWithFormat:@"%@ %@", user_profile, Mail];
		}
		NSString *rid = [obj valueForKey:@"rid"];
		item = [self createItem:item_id
					   withUser:screen_name
						   name:name
						channel:channel
							rid:rid
						   text:text
						comment:comment
						 source:[obj valueForKey:@"source"]
					 created_at:[NSDate dateWithNaturalLanguageString:date]
				   user_profile:user_profile
						 notify:notify
						   kind:kindStr
					inReplyUser:inReplyUser
						protect:[protected intValue]
						  first:first];
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) parse:%d] EXCEPTION\n%@: %@", [self className], _service, kind, [exception name], [exception reason]);
	}
	return item;
}

- (NSString *)since
{
	NSString * since = nil;
	int i = 20;
	int count = [_since count];
	if (i >= count)
	{
		i = count - 1;
	}
	if (i >= 0)
	{
		since = [_since objectAtIndex:i];
	}
	return since;
}

- (void)performRetrieve:(TwitterAPI *)api
			 withObject:(id)object
				   kind:(int)kind
				  first:(BOOL)first
			   useTweet:(BOOL)useTweet
{
	//LOG(@"[%@(%@) performRetrieve:%d] %@", [self className], _service, kind, [object className]);
	@try
	{
		id description = nil;
		switch (kind)
		{
			default:
			case kindTimeline:
				description = @"Retrieve timeline was failuer.";
				break;
			case kindReply:
				description = @"Retrieve replies was failuer.";
				break;
			case kindDM:
				description = @"Retrieve direct message was failuer.";
				break;
			case kindChannel:
				description = @"Retrieve channel was failuer.";
				break;
		}
		if ([object isKindOfClass:[NSError class]])
		{
			NSString *desc = [api errorLocalizedDescription:object];
			if (desc)
			{
				description = [NSString stringWithFormat:@"%@\n(%@)", description, desc];
			}
		}
		if (![object isKindOfClass:[NSArray class]])
		{
			if ([object isKindOfClass:[NSDictionary class]])
			{
				NSString *error = [object valueForKey:@"error"];
				if (error &&
					![error isKindOfClass:[NSNull class]] &&
					![error isEqualToString:@""])
				{
					description = [NSString stringWithFormat:@"%@\n(%@)", description, error];
				}
			}
			else if ([object isKindOfClass:[NSString class]])
			{
				if ([HTTP isHTML:object])
				{
					NSString *title = [api titleOfHTML:object];
					if (title)
					{
						description = [NSString stringWithFormat:@"%@\n(%@)", description, title];
					}
				}
				else
				{
					description = [NSString stringWithFormat:@"%@\n(%@)", description, object];
				}
			}
			NSDictionary *item = [[self createItem:IdZero
										  withUser:@""
											  name:@""
										   channel:@""
											   rid:@""
											  text:[NSString stringWithFormat:@"%@", description]
										   comment:@""
											source:nil
										created_at:[NSDate dateWithTimeIntervalSinceNow:0.0]
									  user_profile:_errorIcon
											notify:_notifyError
											  kind:KindError
									   inReplyUser:nil
											 first:NO] retain];
			@try
			{
				[self addTimeline:item];
				NSArray *notify = [NSArray arrayWithObjects:item, nil];
				[self finishAddTimeline:notify withNotify:notify];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) performRetrieve:%d] EXCEPTION\n%@: %@", [self className], _service, kind, [exception name], [exception reason]);
			}
			@finally
			{
				[item release];
			}
		}
		else
		{
#if 0 //def _D_E_B_U_G_
			if ([_service isEqualToString:Wassr] && (kind == kindTimeline))
			{
				LOG(@"[%@(%@) performRetrieve]\n%@", [self className], _service, [api headers]);
			}
#endif
			NSMutableArray *list = [[NSMutableArray alloc] init];
			NSMutableArray *notify = [[NSMutableArray alloc] init];
			@try
			{
				int i = [object count];
				while (i-- > 0)
				{
					id obj = [object objectAtIndex:i];
					id item = [self parse:obj
								 withUser:[api user]
									 kind:kind
									first:first];
					if (item)
					{
						[item retain];
						@try
						{
							if ([self addTimeline:item])
							{
								NSString *channel = [item valueForKey:KeyChannel];
								if (channel && ![channel isEqualToString:@""])
								{
									[self registComplete:channel
											flagIdentica:[_service isEqualToString:Identica]];
								}
								[self registComplete:[item valueForKey:KeyText]
										flagIdentica:[_service isEqualToString:Identica]];
								if ([_preferences generalGrowlOldOrder])
								{
									[notify addObject:item];
								}
								else
								{
									[notify insertObject:item atIndex:0];
								}
							}
							[list addObject:item];
						}
						@catch (NSException *exception)
						{
							EXPLOG(@"[%@(%@) performRetrieve:%d] EXCEPTION\n%@: %@", [self className], _service, kind, [exception name], [exception reason]);
						}
						@finally
						{
							[item release];
						}
					}
				}
				if (kind == kindTimeline)
				{
					while ([_since count] > 30)
					{
						//[[_since objectAtIndex:30] release];
						[_since removeObjectAtIndex:30];
					}
					if (useTweet && !first)
					{
#ifdef _D_E_B_U_G_
						int old = _tweets;
#endif //_D_E_B_U_G_
						int tweets = _tweets;
						int max = [_preferences tweetsMaxAccountTwitterRetrieveTweets];
						int min = [_preferences tweetsMinAccountTwitterRetrieveTweets];
						int inc = [_preferences tweetsIncAccountTwitterRetrieveTweets];
						int dec = [_preferences tweetsDecAccountTwitterRetrieveTweets];
						int up = [_preferences tweetsUpAccountTwitterRetrieveTweets];
						int down = [_preferences tweetsDownAccountTwitterRetrieveTweets];
						int keep = [_preferences tweetsKeepAccountTwitterRetrieveTweets];
						int diff = tweets - [notify count];
						if (diff <= up)
						{
							_keepTweets = 0;
							tweets += inc;
							if (tweets > max)
							{
								tweets = max;
							}
						}
						else if (diff >= down)
						{
							_keepTweets++;
							if (_keepTweets >= keep)
							{
								_keepTweets = 0;
								tweets -= dec;
								if (tweets < min)
								{
									tweets = min;
								}
							}
						}
						else
						{
							_keepTweets = 0;
						}
						_tweets = tweets;
						LOG(@"[%@(%@) performRetrieve:%d] %d -> %d / %d", [self className], _service, kind, old, tweets, _keepTweets);
					}
				}
				[self finishAddTimeline:list withNotify:notify];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) performRetrieve:%d] EXCEPTION\n%@: %@", [self className], _service, kind, [exception name], [exception reason]);
			}
			@finally
			{
				[notify release];
				[list release];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performRetrieve:%d] EXCEPTION\n%@: %@", [self className], _service, kind, [exception name], [exception reason]);
	}
}

- (void)performRetrieve:(TwitterAPI *)api
			 withObject:(id)object
				   kind:(int)kind
				  first:(BOOL)first
{
	[self performRetrieve:api
			   withObject:object
					 kind:kind
					first:first
				 useTweet:NO];
}

- (void)performRetrieveTimeline:(NSDictionary *)dic
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	//LOG(@"[%@(%@) performRetrieveTimeline]", [self className], _service);
	[self setupRetrieveDateTimeline:nil];
	@try
	{
		TwitterAPI *api = [self createAPI:dic];		
		if (api)
		{
			[api setTimeoutInterval:30];
			id head = [api headHost];
			if (head && ![head isKindOfClass:[NSError class]])
			{
				//LOG(@"[%@(%@) performRetrieveTimeline] lock", [self className], _service);
				[self lockService];
				//LOG(@"[%@(%@) performRetrieveTimeline] locked", [self className], _service);
				@try
				{
					id result = nil;
					if ([_service isEqualToString:Twitter])
					{
						LOG(@"[%@(%@) performRetrieveTimeline] %d", [self className], _service, _tweets);
						result = [api friendsTimelineWithSince:[self since] tweets:_tweets];
						[self performRetrieve:api withObject:result kind:kindTimeline first:_first useTweet:YES];
					}
					else
					{
						result = [api friendsTimelineWithSince:nil];
						[self performRetrieve:api withObject:result kind:kindTimeline first:_first];
					}
					if (_first)
					{
						_first = NO;
					}
#if 0	//def __D_E_B_U_G__
					if ([_service isEqualToString:Twitter])
					{
						NSString *user = [_preferences accountTwitterUser];
						NSString *pass = [_preferences accountTwitterPass];
						api = [[[TwitterAPI alloc] initWithDictionary:
								[NSDictionary dictionaryWithObjectsAndKeys:
								 user, TwitterUser,
								 pass, TwitterPass,
								 @"http://twitter.com", TwitterURL,
								 nil]] autorelease];
						id status = [api rateLimit];
						LOG(@"[%@(%@) performRetrieveTimeline]\n%@", [self className], _service, status);
					}
#endif	//def __D_E_B_U_G__
				}
				@catch (NSException *exception)
				{
					EXPLOG(@"[%@(%@) performRetrieveTimeline] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
				}
				@finally
				{
					//LOG(@"[%@(%@) performRetrieveTimeline] unlock", [self className], _service);
					[self unlockService];
				}
			}
			else
			{
				LOG(@"[%@(%@) performRetrieveTimeline]\n%@", [self className], _service, head);
				if ([head isKindOfClass:[NSError class]])
				{
					LOG(@"[%@(%@) performRetrieveReplies]\n%@", [self className], _service, [head localizedDescription]);
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performRetrieveTimeline] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	@finally
	{
		[dic release];
		[self setupRetrieveDateTimeline:[NSDate dateWithTimeIntervalSinceNow:0]];
	}
	[pool release];
	[NSThread exit];
}

- (void)performRetrieveReplies:(NSDictionary *)dic
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	//LOG(@"[%@(%@) performRetrieveReplies]", [self className], _service);
	[self setupRetrieveDateReplies:nil];
	@try
	{
		TwitterAPI *api = [self createAPI:dic];		
		if (api)
		{
			[api setTimeoutInterval:30];
			id head = [api headHost];
			if (head && ![head isKindOfClass:[NSError class]])
			{
				//LOG(@"[%@(%@) performRetrieveReplies] lock", [self className], _service);
				[self lockService];
				//LOG(@"[%@(%@) performRetrieveReplies] locked", [self className], _service);
				@try
				{
					id result = [api replies];
					[self performRetrieve:api withObject:result kind:kindReply first:NO];
#if 0	//def __D_E_B_U_G__
					if ([_service isEqualToString:Twitter])
					{
						NSString *user = [_preferences accountTwitterUser];
						NSString *pass = [_preferences accountTwitterPass];
						api = [[[TwitterAPI alloc] initWithDictionary:
								[NSDictionary dictionaryWithObjectsAndKeys:
								 user, TwitterUser,
								 pass, TwitterPass,
								 @"http://twitter.com", TwitterURL,
								 nil]] autorelease];
						id status = [api rateLimit];
						LOG(@"[%@(%@) performRetrieveReplies]\n%@", [self className], _service, status);
					}
#endif	//def __D_E_B_U_G__
				}
				@catch (NSException *exception)
				{
					EXPLOG(@"[%@(%@) performRetrieveReplies] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
				}
				@finally
				{
					//LOG(@"[%@(%@) performRetrieveReplies] unlock", [self className], _service);
					[self unlockService];
				}
			}
			else
			{
				LOG(@"[%@(%@) performRetrieveReplies]\n%@", [self className], _service, head);
				if ([head isKindOfClass:[NSError class]])
				{
					LOG(@"[%@(%@) performRetrieveReplies]\n%@", [self className], _service, [head localizedDescription]);
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performRetrieveReplies] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	@finally
	{
		[dic release];
		[self setupRetrieveDateReplies:[NSDate dateWithTimeIntervalSinceNow:0]];
	}
	[pool release];
	[NSThread exit];
}

- (void)performRetrieveDirectMessage:(NSDictionary *)dic
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	//LOG(@"[%@(%@) performRetrieveDirectMessage]", [self className], _service);
	[self setupRetrieveDateDM:nil];
	@try
	{
		TwitterAPI *api = [self createAPI:dic];		
		if (api)
		{
			[api setTimeoutInterval:30];
			id head = [api headHost];
			if (head && ![head isKindOfClass:[NSError class]])
			{
				//LOG(@"[%@(%@) performRetrieveDirectMessage] lock", [self className], _service);
				[self lockService];
				//LOG(@"[%@(%@) performRetrieveDirectMessage] locked", [self className], _service);
				@try
				{
					id result = [api directMessage];
					BOOL perform = YES;
					if ([_service isEqualToString:Jisko])
					{
						//LOG(@"[%@(%@) performRetrieveDirectMessage]\nclass = %@\nresult = %@", [self className], _service, [result className], result);
						if (result && [result isKindOfClass:[NSString class]] && [result isEqualToString:@""])
						{
							perform = NO;
						}
					}
					if (perform)
					{
						[self performRetrieve:api withObject:result kind:kindDM first:NO];
					}
#if 0	//def __D_E_B_U_G__
					if ([_service isEqualToString:Twitter])
					{
						NSString *user = [_preferences accountTwitterUser];
						NSString *pass = [_preferences accountTwitterPass];
						api = [[[TwitterAPI alloc] initWithDictionary:
								[NSDictionary dictionaryWithObjectsAndKeys:
								 user, TwitterUser,
								 pass, TwitterPass,
								 @"http://twitter.com", TwitterURL,
								 nil]] autorelease];
						id status = [api rateLimit];
						LOG(@"[%@(%@) performRetrieveDirectMessage]\n%@", [self className], _service, status);
					}
#endif	//def __D_E_B_U_G__
				}
				@catch (NSException *exception)
				{
					EXPLOG(@"[%@(%@) performRetrieveDirectMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
				}
				@finally
				{
					//LOG(@"[%@(%@) performRetrieveDirectMessage] unlock", [self className], _service);
					[self unlockService];
				}
			}
			else
			{
				LOG(@"[%@(%@) performRetrieveDirectMessage]\n%@", [self className], _service, head);
				if ([head isKindOfClass:[NSError class]])
				{
					LOG(@"[%@(%@) performRetrieveDirectMessage]\n%@", [self className], _service, [head localizedDescription]);
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performRetrieveDirectMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	@finally
	{
		[dic release];
		[self setupRetrieveDateDM:[NSDate dateWithTimeIntervalSinceNow:0]];
	}
	[pool release];
	[NSThread exit];
}

- (void)performFavorite:(NSArray *)object
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	//LOG(@"[%@(%@) performFavorite]", [self className], _service);
	@try
	{
		NSString *item_id = [object objectAtIndex:0];
		NSDictionary *dic = [object objectAtIndex:1];
		TwitterAPI *api = [self createAPI:dic];		
		if (api)
		{
			[api setTimeoutInterval:30];
			id result = [api favorite:item_id];
			[self determinePost:[self determinePost:result withAPI:api function:@"Favorite"]
					  withTitle:_title
					   function:@"Favorite"];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performFavorite] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	@finally
	{
		[object release];
	}
	[pool release];
	[NSThread exit];
}

- (void)retrieveTimeline
{
	//LOG(@"[%@(%@) retrieveTimeline]", [self className], _service);
	@synchronized(self)
	{
		if (_dateTimeline)
		{
			[self setupRetrieveDateTimeline:nil];
			@try
			{
				NSString *user = [_preferences accountTwitterUser];
				NSString *pass = [_preferences accountTwitterPass];
				NSString *key = [_preferences accountTwitterOAuthKey];
				NSString *secret = [_preferences accountTwitterOAuthSecret];
				if (!pass)
				{
					pass = (NSString *)[NSNull null];
				}
				if (!key)
				{
					key = (NSString *)[NSNull null];
				}
				if (!secret)
				{
					secret = (NSString *)[NSNull null];
				}
				NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
									 user, TwitterUser,
									 pass, TwitterPass,
									 key, TwitterKey,
									 secret, TwitterSecret,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performRetrieveTimeline:)
										 toTarget:self
									   withObject:dic];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) retrieveTimeline] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
		}
	}
}

- (void)retrieveReplies
{
	//LOG(@"[%@(%@) retrieveTimeline]", [self className], _service);
	@synchronized(self)
	{
		if (_dateReplies)
		{
			[self setupRetrieveDateReplies:nil];
			@try
			{
				NSString *user = [_preferences accountTwitterUser];
				NSString *pass = [_preferences accountTwitterPass];
				NSString *key = [_preferences accountTwitterOAuthKey];
				NSString *secret = [_preferences accountTwitterOAuthSecret];
				if (!pass)
				{
					pass = (NSString *)[NSNull null];
				}
				if (!key)
				{
					key = (NSString *)[NSNull null];
				}
				if (!secret)
				{
					secret = (NSString *)[NSNull null];
				}
				NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
									 user, TwitterUser,
									 pass, TwitterPass,
									 key, TwitterKey,
									 secret, TwitterSecret,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performRetrieveReplies:)
										 toTarget:self
									   withObject:dic];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) retrieveReplies] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
		}
	}
}

- (void)retrieveDirectMessage
{
	//LOG(@"[%@(%@) retrieveDirectMessage]", [self className], _service);
	@synchronized(self)
	{
		if (_dateDM)
		{
			[self setupRetrieveDateDM:nil];
			@try
			{
				NSString *user = [_preferences accountTwitterUser];
				NSString *pass = [_preferences accountTwitterPass];
				NSString *key = [_preferences accountTwitterOAuthKey];
				NSString *secret = [_preferences accountTwitterOAuthSecret];
				if (!pass)
				{
					pass = (NSString *)[NSNull null];
				}
				if (!key)
				{
					key = (NSString *)[NSNull null];
				}
				if (!secret)
				{
					secret = (NSString *)[NSNull null];
				}
				NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
									 @"http://twitter.com", TwitterURL,
									 user, TwitterUser,
									 pass, TwitterPass,
									 key, TwitterKey,
									 secret, TwitterSecret,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performRetrieveDirectMessage:)
										 toTarget:self
									   withObject:dic];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) retrieveDirectMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
		}
	}
}

- (void)doReply:(NSString *)item_id
	   withText:(BOOL)withText
{
	@try
	{
		//LOG(@"[%@(%@) doReply]\n%@", [self className], _service, item_id);
		id obj = [_controller fetchTimeline:item_id withService:_service];
		if (obj)
		{
			if (![[obj valueForKey:KeyKind] isEqualToString:KindDM])
			{
				NSString *text = @"";
				if (withText)
				{
					text = [NSString stringWithFormat:@"@%@",
							[obj valueForKey:KeyUser]];
				}
				[_controller setReply:[self replyAttributedString:[NSString stringWithFormat:@"Reply to: %@%@",
															  [obj valueForKey:KeyText], [obj valueForKey:KeyComment]]]
						  withService:_service
							inReplyTo:item_id
								 text:text];
			}
			else
			{
				NSString *text = @"";
				if (withText)
				{
					text = [NSString stringWithFormat:@"d %@",
							[obj valueForKey:KeyUser]];
				}
				[_controller setReply:[self replyAttributedString:[NSString stringWithFormat:@"Reply DM: %@%@",
															  [obj valueForKey:KeyText], [obj valueForKey:KeyComment]]]
						  withService:_service
							inReplyTo:item_id
								 text:text];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) doReply] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

- (void)favorite:(NSString *)item_id
{
	//LOG(@"[%@(%@) favorite]", [self className], _service);
	@synchronized(self)
	{
		@try
		{
			id item = [self fetch:item_id withService:_service];
			if (item && ![[item valueForKey:KeyKind] isEqualToString:KindDM])
			{
				NSString *user = [_preferences accountTwitterUser];
				NSString *pass = [_preferences accountTwitterPass];
				NSString *key = [_preferences accountTwitterOAuthKey];
				NSString *secret = [_preferences accountTwitterOAuthSecret];
				if (!pass)
				{
					pass = (NSString *)[NSNull null];
				}
				if (!key)
				{
					key = (NSString *)[NSNull null];
				}
				if (!secret)
				{
					secret = (NSString *)[NSNull null];
				}
				NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:
									 @"http://twitter.com", TwitterURL,
									 user, TwitterUser,
									 pass, TwitterPass,
									 key, TwitterKey,
									 secret, TwitterSecret,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performFavorite:)
										 toTarget:self
									   withObject:[[NSArray alloc] initWithObjects:item_id, dic, nil]];
			}
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@(%@) favorite] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
		}
	}
}

- (void)permalink:(NSString *)item_id
{
	@try
	{
		id item = [self fetch:item_id withService:_service];
		if (item)
		{
			if ([[item valueForKey:KeyKind] isEqualToString:KindDM])
			{
				[self doOpenURL:@"http://twitter.com/inbox"];
			}
			else
			{
				NSString *user = [item valueForKey:KeyUser];
				[self doOpenURL:[NSString stringWithFormat:@"http://twitter.com/%@/statuses/%@",
								 user, item_id]];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) permalink] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

- (void)doDirectMessage:(NSString *)item_id
{
	@try
	{
		//LOG(@"[%@(%@) doDirectMessage]\n%@", [self className], _service, item_id);
		id obj = [_controller fetchTimeline:item_id withService:_service];
		if (obj)
		{
			NSString *text = @"";
			text = [NSString stringWithFormat:@"d %@",
					[obj valueForKey:KeyUser]];
			[_controller setReply:[self replyAttributedString:[NSString stringWithFormat:@"DM: %@%@",
															   [obj valueForKey:KeyText], [obj valueForKey:KeyComment]]]
					  withService:_service
						inReplyTo:item_id
							 text:text];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) doDirectMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

@end
