//
//  ServiceXMPP.h
//  Afficheur
//
//  Created by kichi on 08/11/15.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AfficheurController;
@class Service;
@class ServiceXMPPClient;

@interface ServiceXMPP : NSObject {
	AfficheurController*	_controller;
	NSDictionary*			_from;
	NSDictionary*			_jid;
	NSMutableDictionary*	_service;
	NSMutableDictionary*	_xmpp;

	NSThread*				_mainThread;

	NSMutableArray*			_queuePost;
	NSLock*					_lockQueuePost;
	BOOL					_lockedPost;
	NSLock*					_lockPost;
	
	NSMutableArray*			_queueError;
	NSLock*					_lockQueueError;
	BOOL					_lockedError;
	NSLock*					_lockError;
	BOOL					_alert;
	
}

- (id)init;

- (void)setController:(AfficheurController *)controller;

- (void)addService:(NSString *)service
		withObject:(Service *)object;

- (void)addXMPP:(NSString *)service
		withJid:(NSString *)jid
		   pass:(NSString *)pass
		 server:(NSString *)server
		   port:(int)port
		offline:(BOOL)offline
	   resource:(NSString *)resource;

- (void)addXMPP:(NSString *)service
		withJid:(NSString *)jid
		   pass:(NSString *)pass
		 server:(NSString *)server
		   port:(int)port
		offline:(BOOL)offline;

- (void)removeXMPP:(NSString *)service;

- (void)disconnectAll;

- (void)keepConnections:(NSDate *)date;

- (void)post:(NSString *)message
 withService:(NSString *)service;

@end

@interface NSObject (ServiceXMPPDelegate)

- (void)serviceXMPP:(ServiceXMPPClient *)xc
  didReceiveMessage:(NSXMLElement *)message;

@end
