//
//  TextFieldHUD.m
//  Afficheur
//
//  Created by kichi on 08/04/16.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TextFieldHUD.h"


@implementation TextFieldHUD

- (IBAction)undo:(id)sender
{
	//LOG(@"[%@ undo]", [self className]);
	if ([[[self window] undoManager] canUndo])
	{
		LOG(@"[%@ undo] do", [self className]);
		[[[self window] undoManager] undo];
	}
}

- (IBAction)redo:(id)sender
{
	//LOG(@"[%@ redo]", [self className]);
	if ([[[self window] undoManager] canRedo])
	{
		LOG(@"[%@ redo] do", [self className]);
		[[[self window] undoManager] redo];
	}
}

#pragma mark NSObject Delegates

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
	//LOG(@"[%@ validateMenuItem]", [self className]);
	//LOG(@"[%@ validateMenuItem]\n%@", [self className], menuItem);
	//NSString *item = [menuItem title];
	if ([menuItem action] == @selector(undo:))
	{
		return [[[self window] undoManager] canUndo];
	}
	else if ([menuItem action] == @selector(redo:))
	{
		return [[[self window] undoManager] canRedo];
	}
	return YES;
}

#pragma mark NSText Delegates

- (void)textDidBeginEditing:(NSNotification *)aNotification
{
	//LOG(@"[%@ textDidBeginEditing]", [self className]);
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(textDidBeginEditing:)])
	{
		[delegate performSelector:@selector(textDidBeginEditing:)
					   withObject:aNotification];
	}
}

- (void)textDidEndEditing:(NSNotification *)aNotification
{
	//LOG(@"[%@ textDidEndEditing]", [self className]);
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(textDidEndEditing:)])
	{
		[delegate performSelector:@selector(textDidEndEditing:)
					   withObject:aNotification];
	}
}

#pragma mark NSTextView Delegates

- (void)textViewDidChangeSelection:(NSNotification *)aNotification
{
	//LOG(@"[%@ textViewDidChangeSelection]", [self className]);
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(textViewDidChangeSelection:)])
	{
		[delegate performSelector:@selector(textViewDidChangeSelection:)
					   withObject:aNotification];
	}
}

- (void)textDidChange:(NSNotification *)aNotification
{
	//LOG(@"[%@ textDidChange]", [self className]);
	id delegate = [self delegate];
	if (delegate && [delegate respondsToSelector:@selector(textDidChange:)])
	{
		[delegate performSelector:@selector(textDidChange:)
					   withObject:aNotification];
	}
}

@end
