//
//  TinyURL.m
//  Afficheur
//
//  Created by kichi on 08/04/10.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TinyURL.h"
#import "HTTP.h"

@implementation TinyURL

+ (NSString *)create:(NSString *)url
{
	NSString *path = [NSString stringWithFormat:@"http://tinyurl.com/api-create.php?url=%@", [HTTP urlEncode:url]];
	NSDictionary *header = [NSDictionary dictionaryWithObjectsAndKeys:
							@"tinyurl.com", @"Host",
							nil];
	HTTP *http = [[[HTTP alloc] init] autorelease];
	[http setTimeoutInterval:5];
	id result = [http get:path header:header body:@""];
	if (![result isKindOfClass:[NSData class]])
	{
		return nil;
	}
	return [[[NSString alloc] initWithData:result encoding:NSUTF8StringEncoding] autorelease];
}

@end
