//
//  WassrAPI.m
//  Afficheur
//
//  Created by kichi on 08/09/19.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "WassrAPI.h"


@implementation WassrAPI

- (id)init
{
	self = [super init];
	if (self)
	{
		[_dic setObject:@"api.wassr.jp" forKey:TwitterHost];
		[_dic setObject:@"http://api.wassr.jp/statuses" forKey:TwitterURL];
	}
	return self;
}

- (id)initWithDictionary:(NSDictionary *)dic
{
	self = [super initWithDictionary:dic];
	return self;
}

- (id)channel_update:(NSString *)message
		 withChannel:(NSString *)channel
{
	id result = [self postWithAuth:channel
							header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									 @"application/x-www-form-urlencoded",
									 @"Content-Type",
									 nil]
									autorelease]
							  body:[NSString stringWithFormat:@"%@=%@", 
									[_dic valueForKey:TwitterUpdate],
									[HTTP urlEncode:message
										  unescaped:nil
											escaped:@"&+;"]]];
	return [self determineError:result WithJSON:YES];
}

- (id)channel_list
{
	id result = [self getWithAuth:[NSString stringWithFormat:
								   @"%@/channel_user/user_list.json?login_id=%@",
								   [_dic valueForKey:TwitterURL],
								   [_dic valueForKey:TwitterUser]]
						   header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									@"application/x-www-form-urlencoded",
									@"Content-Type",
									nil]
								   autorelease]
							 body:@""];
	return [self determineError:result WithJSON:YES];
}

- (id)channel
{
	return [self performRetrieve:[NSString stringWithFormat:@"http://%@/%@?login_id=%@",
								  [_dic valueForKey:TwitterHost],
								  @"channel_timeline.json",
								  [_dic valueForKey:TwitterUser]]
					   withSince:nil];
}

- (id)channel_favorite:(NSString *)rid
{
	id result = [self postWithAuth:[NSString stringWithFormat:
									@"channel_favorite/toggle.json?channel_message_rid=%@",
									rid]
							header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									 @"application/x-www-form-urlencoded",
									 @"Content-Type",
									 nil]
									autorelease]
							  body:@""];
	return [self determineError:result WithJSON:YES];
}

- (id)show:(NSString *)user
{
	id result = [self getWithAuth:[NSString stringWithFormat:
								   @"%@/show.json?id=%@",
								   [_dic valueForKey:TwitterURL],
								   user]
						   header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									nil] autorelease]
							 body:@""];
	return [self determineError:result WithJSON:YES];
}

@end
