//
//  AfficheurController.h
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AfficheurPreferences;
@class AfficheurTimeline;
@class AfficheurPanel;
@class AfficheurService;
@class AfficheurGrowl;
@class Service;

#define THREADINGSERVICE	0

@interface AfficheurController : NSObject {
	IBOutlet AfficheurService*	_service;
	IBOutlet AfficheurGrowl*	_growl;
	IBOutlet id					_window;
	IBOutlet id					_menu;
	IBOutlet id					_mainMenuItemDocomo;
	IBOutlet id					_mainMenuItemAu;
	IBOutlet id					_mainMenuItemSoftBank;
	IBOutlet id					_mainMenuItemJaiku;
	IBOutlet id					_menuItemDocomo;
	IBOutlet id					_menuItemAu;
	IBOutlet id					_menuItemSoftBank;
	IBOutlet id					_menuItemJaiku;
	IBOutlet id					_mainMenuToolbar;
	IBOutlet id					_menuToolbar;
	
	BOOL						_active;
	AfficheurPreferences*		_preferences;
	AfficheurPanel*				_panel;
	AfficheurTimeline*			_timeline;
	BOOL						_leopard;
	BOOL						_snowLeopard;
	void*						_hotKeyRef;
	void*						_hotKeyRefTimeline;
	int							_postCount;
	int							_postNG;
	BOOL						_lockedPost;
	NSLock*						_lockPost;

	NSStatusItem*				_statusItem;

	BOOL						_doPreferences;
	BOOL						_sleep;

	NSLock*						_lockService;
	NSThread*					_mainThread;

	NSString*					_activeApplicationName;
	NSDictionary*				_appearances;

	NSMutableDictionary*		_tinyURL;
//	NSString*					_jiskoUser;
//	NSString*					_jiskoPass;
}

+ (NSString *)stringRegularExpressionURL;

- (BOOL)isLeopard;
- (BOOL)isSnowLeopard;

- (void)hideAfficheur;

- (BOOL)isURL:(NSString *)string;
- (void)postOK;
- (void)postNG;

- (NSWindow *)panel;

- (void)notifyWithTitle:(NSString *)title
			description:(NSString *)description
	   notificationName:(NSString *)notificationName
			   iconData:(NSData *)iconData
		   clickContext:(id)clickContext;

- (NSImage *)profileImage:(NSString *)userProfile;

- (NSDictionary *)fetchTimeline:(NSString *)item_id
					withService:(NSString *)service;
- (NSDictionary *)fetchTimelineALL:(NSString *)item_id
					   withService:(NSString *)service;
- (NSDictionary *)fetchTimelineRid:(NSString *)item_id
					   withService:(NSString *)service;
- (NSDictionary *)beginsTimeline:(NSString *)item_id
					 withService:(NSString *)service
							user:(NSString *)user;

- (void)queueingParsePhotoURL:(NSDictionary *)item;

- (BOOL)addTimeline:(NSDictionary *)item
		withService:(Service *)service
			  first:(BOOL)first;
- (void)finishAddTimeline:(NSArray *)objects
			   withNotify:(NSArray *)notify
				  service:(Service *)service;

- (id)replaceTimeline:(NSString *)item_id
		  withService:(NSString *)service
			 photoURL:(NSString *)photoURL;

- (BOOL)deleteTimeline:(NSString *)item_id
		   withService:(NSString *)service;

- (float)withOfTimeline;

- (void)setComplete;

- (BOOL)tryLockService;
- (void)lockService;
- (void)unlockService;
- (Service *)service:(NSString *)service;
- (int)rateLimitOfTwitter;

- (NSString *)encodeTinyURL:(NSString *)string
			 withCreateFlag:(BOOL)flag;
- (NSString *)encodeTinyURL:(NSString *)string;

- (void)setTinyURL:(NSString *)tinyURL withURL:(NSString *)url;
- (NSString *)tinyURL:(NSString *)tinyURL;

- (UInt32)keyModifiers;
- (void)doClickAction:(id)action;

- (BOOL)isEnabled:(NSString *)service;

- (void)doPost:(NSString *)text
withAltEncodeTinyURL:(BOOL)altEncodeTinyURL;
- (void)posted:(int)postCount;

- (void)userStream:(id)userStream
	   withService:(NSString *)service;
- (void)finishUserStreamWithService:(NSString *)service;
- (void)errorUserStream:(NSError *)error
			withService:(NSString *)service;

- (int)iconCode;

- (void)syncPost;
- (void)lockPost;
- (void)unlockPost;

- (void)setReply:(NSAttributedString *)reply
	 withService:(NSString *)servie
	   inReplyTo:(NSString *)inReplyTo
			text:(NSString *)text
	  tinyURLize:(BOOL)tinyURLize;

- (void)setReply:(NSAttributedString *)reply
	 withService:(NSString *)servie
	   inReplyTo:(NSString *)inReplyTo
			text:(NSString *)text;

- (void)saveState:(BOOL)state
	   andEnabled:(BOOL)enabled
		  service:(NSString *)service;
- (BOOL)status:(NSString *)service;
- (BOOL)enable:(NSString *)service;

- (void)alert:(NSString *)message
	withTitle:(NSString *)title
	 selector:(SEL)selector
	   target:(id)target;

- (void)alert:(NSString *)message
 withSelector:(SEL)selector
	   target:(id)target;

- (BOOL)isSleep;

- (void)setMenuIcon:(NSNumber *)icon;

- (void)setToolbarMenuTitle:(NSString *)title;

- (IBAction)onOpen:(id)sender;
- (IBAction)onPreferences:(id)sender;
- (IBAction)onRetrieveTimeline:(id)sender;
- (IBAction)onRetrieveReplies:(id)sender;
- (IBAction)onRetrieveDirectMessage:(id)sender;
- (IBAction)onViewTimeline:(id)sender;
- (IBAction)onKeepCursor:(id)sender;

- (IBAction)onGrabSafari:(id)sender;
- (IBAction)onGrabFirefox:(id)sender;
- (IBAction)onGrabChrome:(id)sender;
- (IBAction)onGrabITunes:(id)sender;

- (IBAction)onReply:(id)sender;
- (IBAction)onFavorite:(id)sender;
- (IBAction)onOpenPermalink:(id)sender;
- (IBAction)onOpenURL:(id)sender;
- (IBAction)onRetweetViaAPI:(id)sender;
- (IBAction)onDirectMessage:(id)sender;

- (IBAction)onReleaseFiltering:(id)sender;

- (IBAction)onService:(id)sender;
- (IBAction)onEmoji:(id)sender;

- (IBAction)onToolbar:(id)sender;
- (IBAction)onFiltering:(id)sender;

- (IBAction)onCopy:(id)sender;
- (IBAction)onCopyPermalink:(id)sender;

APPKIT_EXTERN NSString *Afficheur;

APPKIT_EXTERN NSString *stringRegularExpressionURLtrailer;
APPKIT_EXTERN NSString *stringURLShorten;

@end
