//
//  ButtonCellHUD.m
//  Afficheur
//
//  Created by kichi on 08/04/16.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "ButtonCellHUD.h"


@implementation ButtonCellHUD

- (void)drawImage:(NSImage*)image withFrame:(NSRect)frame inView:(NSView*)controlView
{
	if ([[controlView window] firstResponder] ==  controlView)
	{
		if([self showsStateBy] == NSNoCellMask){
			[super drawImage:image withFrame:frame inView:controlView];
			return;
		}
		NSString *state = [self isHighlighted] ? @"P" : @"N";
		NSString *position = [self intValue] ? @"On" : @"Off";
		NSImage *checkImage = [NSImage imageNamed:[NSString stringWithFormat:@"HUDCheckbox%@%@.tiff", position, state]];
		NSSize size = [checkImage size];
		float addX = 2;
		float y = NSMaxY(frame) - (frame.size.height-size.height)/2.0;
		float x = frame.origin.x+addX;
		
		[checkImage compositeToPoint:NSMakePoint(x, y) operation:NSCompositeSourceOver];
		[checkImage compositeToPoint:NSMakePoint(x, y) operation:NSCompositePlusDarker];
	}
	else
	{
		[super drawImage:image withFrame:frame inView:controlView];
	}
}

- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
	[super drawWithFrame:cellFrame inView:controlView];
}

@end
