//
//  ButtonHUD.m
//  Afficheur
//
//  Created by kichi on 08/04/16.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "ButtonHUD.h"
#import "ButtonCellHUD.h"


@implementation ButtonHUD

+ (Class)cellClass
{
	return [ButtonCellHUD class];
}

- initWithCoder: (NSCoder *)origCoder
{
	if(![origCoder isKindOfClass: [NSKeyedUnarchiver class]]){
		self = [super initWithCoder: origCoder]; 
	} else {
		NSKeyedUnarchiver *coder = (id)origCoder;
		
		NSString *oldClassName = [[[self superclass] cellClass] className];
		Class oldClass = [coder classForClassName: oldClassName];
		if(!oldClass)
		{
			oldClass = [[super superclass] cellClass];
		}
		[coder setClass: [[self class] cellClass] forClassName: oldClassName];
		self = [super initWithCoder: coder];
		[coder setClass: oldClass forClassName: oldClassName];
		
		NSMutableDictionary *attrs = [[NSMutableDictionary alloc]init];
		[attrs addEntriesFromDictionary:[[self attributedTitle] attributesAtIndex:0 effectiveRange:NULL]];
		[attrs setObject:[NSColor whiteColor]forKey:NSForegroundColorAttributeName];
		NSMutableAttributedString *attrStr = [[NSMutableAttributedString alloc] initWithString:[self title] attributes:attrs];
		[self setAttributedTitle:attrStr];
	}
	
	return self;
}

@end
