//
//  KeyEquivCell.m
//  Afficheur
//
//  Created by kichi on 09/03/07.
//  Copyright 2009 Katsuhiko Ichinose. All rights reserved.
//

#import "KeyEquivCell.h"
#import "KeyEquivView.h"


@implementation KeyEquivCell

- (id)init
{
	self = [super init];
	if (self)
	{
		_string = nil;
	}
	return self;
}

- (void)dealloc
{
	if (_string)
	{
		[_string release];
	}
	[super dealloc];
}

- (void)setString:(NSString *)string
{
	if (_string)
	{
		[_string release];
	}
	_string = [string copy];
}

- (void)setImage:(NSImage *)image
{
	_image = image;
}

- (NSImage *)image
{
	return _image;
}
- (void)resetCursorRect:(NSRect)cellFrame inView:(NSView *)controlView
{
	//LOG(@"[%@ resetCursorRect]\n%@: %f, %f - %f, %f",
	//	[self className], controlView,
	//	cellFrame.origin.x, cellFrame.origin.y, cellFrame.size.width, cellFrame.size.height);
	[super resetCursorRect:cellFrame
					inView:controlView];
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame
					   inView:(NSView *)controlView
{
	//LOG(@"[%@ drawInteriorWithFrame]\n%f, %f - %f, %f\n%@\n%@\n%d",
	//	[self className],
	//	cellFrame.origin.x, cellFrame.origin.y, cellFrame.size.width, cellFrame.size.height,
	//	controlView, self, [controlView isFlipped]);
	if (_string)
	{
		NSMutableParagraphStyle *paragraph = [[[NSMutableParagraphStyle alloc] init] autorelease];
		[paragraph  setAlignment:[self alignment]];
		NSDictionary *attr = [NSDictionary dictionaryWithObjectsAndKeys:
							  [self font], NSFontAttributeName,
							  [self textColor], NSForegroundColorAttributeName,
							  [self backgroundColor], NSForegroundColorAttributeName,
							  paragraph, NSParagraphStyleAttributeName,
							  nil];
		NSRect rect = NSMakeRect(cellFrame.origin.x, cellFrame.origin.y + 2,
								 cellFrame.size.width, cellFrame.size.height - 4);
		[_string drawInRect:rect withAttributes:attr];
		if (_image)
		{
			NSSize sz = [_image size];
			NSPoint pt = NSMakePoint(cellFrame.origin.x + cellFrame.size.width - sz.width - 4,
									 cellFrame.origin.y);
			if ([controlView isFlipped])
			{
				pt.y += (sz.height + 4);
			}
			else
			{
				pt.y -= (sz.height + 4);
			}
			[_image compositeToPoint:pt operation:NSCompositeSourceOver];
		}
	}
	else if ([self placeholderString])
	{
		NSMutableParagraphStyle *paragraph = [[[NSMutableParagraphStyle alloc] init] autorelease];
		[paragraph  setAlignment:[self alignment]];
		NSDictionary *attr = [NSDictionary dictionaryWithObjectsAndKeys:
							  [self font], NSFontAttributeName,
							  [NSColor disabledControlTextColor], NSForegroundColorAttributeName,
							  [self backgroundColor], NSForegroundColorAttributeName,
							  paragraph, NSParagraphStyleAttributeName,
							  nil];
		NSRect rect = NSMakeRect(cellFrame.origin.x, cellFrame.origin.y + 2,
								 cellFrame.size.width, cellFrame.size.height - 4);
		[[self placeholderString] drawInRect:rect withAttributes:attr];
	}
}

@end
