//
//  ServiceWassr.h
//  Afficheur
//
//  Created by kichi on 08/09/19.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ServiceTwitter.h"

@class ServiceXMPP;

@interface ServiceWassr : ServiceTwitter {
	NSMutableDictionary*	_userProfile;
	NSDate*					_dateChannel;

	NSMutableDictionary*	_channelList;
	NSMutableDictionary*	_channelListL;

	id						_previousMessage;
	NSString*				_name;

	BOOL					_firstChannel;
}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (void)setupXMPP:(ServiceXMPP *)xmpp;

- (void)setupRetrieveDate:(NSDate *)date;
- (void)setupRetrieveDateChannel:(NSDate *)date;

- (BOOL)checkRetrieveTimeline:(NSDate *)now;
- (BOOL)checkRetrieveReplies:(NSDate *)now;
- (BOOL)checkRetrieveChannel:(NSDate *)now;

- (void)post:(NSString *)status
   withReply:(NSString *)reply;

- (void)retrieveTimeline;
- (void)retrieveReplies;
- (void)retrieveDirectMessage;
- (void)retrieveChannel;

- (id)getWithAuth:(NSString *)url;

- (void)favorite:(NSString *)item_id;

- (NSString *)permalinkURL:(NSString *)item_id;
- (void)permalink:(NSString *)item_id;

@end
