//
//  AfficheurService.h
//  Afficheur
//
//  Created by kichi on 08/11/23.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class AfficheurController;
@class AfficheurPreferences;
@class Service;
@class ServiceTwitter;
@class ServiceJaiku;
@class ServiceTumblr;
//@class ServiceNowa;
@class ServiceWassr;
@class ServiceIdentica;
//@class ServiceJisko;
//@class ServiceChuitter;
@class ServiceFriendFeed;
@class ServiceFaceBook;
@class ServiceXMPP;

@interface AfficheurService : NSObject {
	AfficheurController*	_controller;
	AfficheurPreferences*	_preferences;

	ServiceTwitter*			_serviceTwitter;
	ServiceJaiku*			_serviceJaiku;
	ServiceTumblr*			_serviceTumblr;
	ServiceWassr*			_serviceWassr;
//	ServiceNowa*			_serviceNowa;
	ServiceIdentica*		_serviceIdentica;
//	ServiceJisko*			_serviceJisko;
//	ServiceChuitter*		_serviceChuitter;
	ServiceFriendFeed*		_serviceFriendFeed;
	ServiceFaceBook*		_serviceFaceBook;
	ServiceXMPP*			_xmpp;

	NSDictionary*			_services;
	
	NSThread*				_mainThread;

	NSMutableArray*			_queueRetrieve;
	BOOL					_lockedRetrieve;
	NSLock*					_lockRetrieve;
}

- (void)setupWithController:(AfficheurController *)controller
				preferences:(AfficheurPreferences *)preferences;

- (void)setupXMPP;

- (void)applicationWillTerminate;

- (Service *)service:(NSString *)service;

- (void)saveState:(BOOL)state
	   andEnabled:(BOOL)enabled
		  service:(NSString *)service;
- (BOOL)status:(NSString *)service;
- (BOOL)enable:(NSString *)service;

- (int)rateLimitOfTwitter;

- (void)post:(NSString *)status
withInReplyTo:(NSString *)inReplyTo
inReplyToService:(NSString *)inReplyToService
altEncodeTinyURL:(BOOL)altEncodeTinyURL;

- (void)doRetrieveTimeline;
- (void)doRetrieveReplies;
- (void)doRetrieveDirectMessage;

- (void)doFavorite:(NSString *)item_id
	   withService:(NSString *)service;
- (void)doPermalink:(NSString *)item_id
		withService:(NSString *)service;
- (void)doOpenURL:(NSString *)item_id
	  withService:(NSString *)service;
- (void)doReply:(NSString *)item_id
	withService:(NSString *)service;
- (void)doRetweetViaAPI:(NSString *)item_id
			withService:(NSString *)service;
- (void)doDirectMessage:(NSString *)item_id
			withService:(NSString *)service;

- (void)doCopyPermalink:(NSString *)item_id
			withService:(NSString *)service;

- (void)lockRetrieve;

- (void)tickTimer;

- (void)userStream:(id)stream
	   withService:(NSString *)service;
- (void)finishUserStreamWithService:(NSString *)service;
- (void)errorUserStream:(NSError *)error
			withService:(NSString *)service;

@end
