//
//  FaceBookAPI.h
//  Afficheur
//
//  Created by kichi on 11/01/02.
//  Copyright 2011 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "HTTP.h"


@interface FaceBookAPI : HTTP {
	NSDictionary		*_keys;
	NSMutableDictionary	*_dic;

	NSString*			_access_token;
}

- (id)init;
- (id)initWithDictionary:(NSDictionary *)dic;

- (NSString *)accessToken;
- (void)setAccessToken:(NSString *)access_token;

- (NSString *)stringGraphURL:(NSString *)path;
- (id)getGraph:(NSString *)path;
- (id)headGraph:(NSString *)path;

- (id)postFeed:(NSString *)feed;
- (id)comment:(NSString *)comment
	   withId:(NSString *)commentId;

- (id)homeFeed;
- (id)headHomeFeed;

- (id)me;

- (NSString *)userId;

- (id)likes:(NSString *)item_id;

@end

APPKIT_EXTERN NSString *FaceBookId;
APPKIT_EXTERN NSString *FaceBookUser;
APPKIT_EXTERN NSString *FaceBookHost;
APPKIT_EXTERN NSString *FaceBookURL;
APPKIT_EXTERN NSString *FaceBookToken;
