//
//  ImageView.m
//  Afficheur
//
//  Created by kichi on 09/02/15.
//  Copyright 2009 Katsuhiko Ichinose. All rights reserved.
//

#import "ImageView.h"


@implementation ImageView

- (id)init
{
	self = [super init];
	if (self)
	{
		_style = nil;
		_mouseUpTarget = nil;
		_mouseUpSelector = nil;
	}
	return self;
}

- (void)mouseDown:(NSEvent *)theEvent
{
	LOG(@"[%@ mouseDown] %08X", [self className], [theEvent modifierFlags]);
	if (([theEvent modifierFlags] & NSDeviceIndependentModifierFlagsMask) == 0)
	{
		LOG(@"[%@ mouseDown]\n%@", [self className], theEvent);
		_style = [self imageFrameStyle];
		[self setImageFrameStyle:NSImageFrameGroove];
	}
}

- (void)mouseUp:(NSEvent *)theEvent
{
	if ([self imageFrameStyle] == NSImageFrameGroove)
	{
		LOG(@"[%@ mouseUp]\n%@", [self className], theEvent);
		if (_style)
		{
			[self setImageFrameStyle:_style];
			_style = nil;
		}
		else
		{
			[self setImageFrameStyle:NSImageFrameNone];
		}
		NSPoint loc = [self convertPoint:[theEvent locationInWindow] fromView:nil];
		float x = loc.x;
		float y = loc.y;
		NSRect frame = [self frame];
		if ((x >= 0) && (x < frame.size.width) &&
			(y >= 0) && (y < frame.size.height))
		{
			if (_mouseUpTarget && [_mouseUpTarget respondsToSelector:_mouseUpSelector])
			{
				[_mouseUpTarget performSelector:_mouseUpSelector withObject:self];
			}
		}
	}
}

- (void)setMouseUpAction:(SEL)selector
			  withTarget:(id)target
{
	_mouseUpTarget = target;
	_mouseUpSelector = selector;
}

@end
