//
//  JaikuAPI.h
//  Afficheur
//
//  Created by kichi on 08/04/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OAuth.h"


@interface JaikuAPI : OAuth {
	NSDictionary		*_keys;
	NSMutableDictionary	*_dic;
}

- (id)init;
- (id)initWithDictionary:(NSDictionary *)dic;


- (NSString *)user;

- (id)update:(NSString *)status;
- (id)update:(NSString *)status
	withIcon:(NSString *)iconName
	location:(NSString *)location;
- (id)comment:(NSString *)comment
	  withURL:(NSString *)url;

- (id)contactsFeed;
- (id)headContactsFeed;
//- (id)presence:(NSString *)url;

- (id)userInfo:(NSString *)user;

@end

APPKIT_EXTERN NSString *JaikuUser;
APPKIT_EXTERN NSString *JaikuHost;
APPKIT_EXTERN NSString *JaikuURL;
APPKIT_EXTERN NSString *JaikuKey;
APPKIT_EXTERN NSString *JaikuSecret;
