/**
 * @file alpha.hpp
 */

#include <manah/memory.hpp>
#include <manah/win32/windows.hpp>

namespace alpha {
	manah::AutoBuffer<WCHAR> a2u(const char* first, const char* last, DWORD flags = MB_PRECOMPOSED);
	manah::AutoBuffer<char> u2a(const WCHAR* first, const WCHAR* last, DWORD flags = 0);
}

// std.min  std.max ̕⊮ (VC6 + NOMINMAX p)
#if(_MSC_VER < 1300)
namespace std {
	template<typename T> inline const T& max(const T& a1, const T& a2) {return (a1 < a2) ? a2 : a1;}
	template<typename T, typename Pr> inline const T& max(const T& a1, const T& a2, Pr pred) {return pred(a1, a2) ? a2 : a1;}
	template<typename T> inline const T& min(const T& a1, const T& a2) {return (a2 < a1) ? a2 : a1;}
	template<typename T, typename Pr> inline const T& min(const T& a1, const T& a2, Pr pred) {return pred(a2, a1) ? a2 : a1;}
	typedef unsigned int size_t;
}
#endif // _MSC_VER < 1300

#pragma warning(disable: 4503)	// uꂽO̒Ez܂v(1)
#pragma warning(disable: 4786)	// uʎq 'number' ɐ؂l߂܂v(3)

#ifdef _DEBUG
#	define ALERT(msg)	::MessageBoxW(0, (msg), L"Debug alert", MB_ICONEXCLAMATION);
#else
#	define ALERT(msg)
#endif // _DEBUG

// for XR[v (VC6 pBVC7 ł /Zc:forScope g)
#if(_MSC_VER < 1300)
#	define for if(0); else for 
#endif
