/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"
#include "AlterDnD.h"
#include "Locale.h"

static NOTIFYICONDATA ni;
static UINT_PTR trayTimerId = 0;

void AddTaskTrayIcon(HWND hWnd)
{
	int icon = IDI_SMALL;

	ni.cbSize			= sizeof(NOTIFYICONDATA);
	ni.hIcon			= LoadIconLocale(MAKEINTRESOURCE(icon));
	ni.hWnd				= hWnd;
	ni.uFlags			= NIF_ICON | NIF_MESSAGE | NIF_TIP;
	ni.uID				= ID_ALTERDND_TRAY_ICON;
	ni.uCallbackMessage	= WM_ALTERDND_TRAY_ICON;
	StringCchCopy(ni.szTip, _countof(ni.szTip), szTitle);

	if (Shell_NotifyIcon(NIM_ADD, &ni)) {
		if (trayTimerId) {
			KillTimer(hWnd, trayTimerId);
			trayTimerId = 0;
		}
	} else {
		// ACRo^łȂꍇ́A莞ԌナgC
		trayTimerId = SetTimer(hWnd, ID_TIMER_RETRY_TRAY, 500, NULL);
	}
}

void RemoveTaskTrayIcon(HWND hWnd)
{
	if (trayTimerId) {
		KillTimer(hWnd, trayTimerId);
		trayTimerId = 0;
	}
	Shell_NotifyIcon(NIM_DELETE, &ni);
}
