/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"
#include "DropTargetWrapper.h"
#include "registory.h"

#ifndef MSGFLG_ADD
#define MSGFLT_ADD 1
#define MSGFLT_REMOVE 2
#endif

#define ALTERDND_CF_PROJECT_NAME	_T("S Project")
#define ALTERDND_CF_APP_NAME		_T("Alter Drag & Drop")
#define ALTERDND_CF_MODE			_T("Mode")

#define ALTERDND_REG_APP_KEY		(_T("Software\\") ALTERDND_CF_PROJECT_NAME _T("\\") ALTERDND_CF_APP_NAME)

#define TARGET_PROCESS_NAME		_T("explorer.exe")
#define TARGET_WINDOW_CLASS		_T("CabinetWClass")

#pragma data_seg(".AlterDnD_shared")
HHOOK wndProcHook = NULL;
DWORD gDnDMode = DNDMODE_NORMAL;
#pragma data_seg()

HINSTANCE hInst;
BOOL gIsTargetProcess = TRUE;
BOOL gIsTargetProcessChecked = FALSE;
UINT gHookDnDMsg = 0;
LONG gDLLRefCount = 0;

BOOL CheckTargetProcess();
LRESULT CALLBACK MsgHookProc(int nCode, WPARAM wParam, LPARAM lParam);

void SetAlterDnDWindowMessageFilter()
{
	BOOL (WINAPI *pChangeWindowMessageFilter)(UINT, DWORD);
	HMODULE hUser = LoadLibrary(_T("user32.dll"));
	pChangeWindowMessageFilter = (BOOL (WINAPI*)(UINT, DWORD))GetProcAddress(hUser, "ChangeWindowMessageFilter");

	if (pChangeWindowMessageFilter) {
		pChangeWindowMessageFilter(gHookDnDMsg, MSGFLT_ADD);
	}
	FreeLibrary(hUser);
}

void InitializeDLL(HMODULE hModule)
{
	hInst = hModule;
}

HMODULE GetDLLModuleHandle()
{
	return (HMODULE)hInst;
}

IMPORT BOOL InstallHook()
{
	//wndProcRetHook = SetWindowsHookEx(WH_CALLWNDPROCRET, MsgHookProc, hInst, 0);
	wndProcHook = SetWindowsHookEx(WH_CALLWNDPROCRET, MsgHookProc, hInst, 0);
	
	DP(_T("InstallHook=%x"), wndProcHook);
	return TRUE;
}

IMPORT void UninstallHook()
{
	SetDnDMode(DNDMODE_NORMAL);
	if (wndProcHook != NULL) {
		UnhookWindowsHookEx(wndProcHook);
		wndProcHook = NULL;
	}
	//UINT hookDnDMsg = RegisterWindowMessage(TEXT("WM_AlterDnD_Hook"));
	//PostMessage(HWND_BROADCAST, hookDnDMsg, FALSE, NULL);
}

BOOL CheckTargetProcess()
{
	TCHAR path[MAX_PATH] = _T("");
	HMODULE hMod = GetModuleHandle(NULL);
	GetModuleFileName(hMod, path, _countof(path));

	// pXt@CɕϊĐ؂o
	TCHAR *name = &path[_tcslen(path)];
	while (name > path && *name != _T('\\')) {
		*name = _totlower(*name);
		name--;
	}
	name++;
	if (_tccmp(name, TARGET_PROCESS_NAME) == 0) {
		return TRUE;

	}
	//EnumWindows(EnumWindowsProc_CheckTargetProcess, NULL);
	return FALSE;
}

IMPORT BOOL LoadDnDMode()
{
	HKEY appKey;

	if (RegOpenKeyEx(HKEY_CURRENT_USER, ALTERDND_REG_APP_KEY, 0, KEY_READ, &appKey) != ERROR_SUCCESS) {
		appKey = NULL;
	}
	DWORD mode = ReadDWord(appKey, ALTERDND_CF_MODE, DNDMODE_ANY_KEYDOWN);
	SetDnDMode(mode);

	if (appKey) {
		RegCloseKey(appKey);
		return TRUE;
	}
	return FALSE;
}

IMPORT BOOL SaveDnDMode()
{
	HKEY appKey;
	BOOL error = FALSE;
	DWORD disp;
	
	if (RegCreateKeyEx(HKEY_CURRENT_USER, ALTERDND_REG_APP_KEY, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &appKey, &disp) == ERROR_SUCCESS) {
		error |= !WriteDWord(appKey, ALTERDND_CF_MODE, GetDnDMode());

		RegCloseKey(appKey);
	} else {
		error = TRUE;
	}
	return !error;
}

IMPORT DWORD GetDnDMode()
{
	DP(_T("GetDnDMode=%d"), gDnDMode);
	return gDnDMode;
}

IMPORT void SetDnDMode(DWORD mode)
{
	gDnDMode = mode;
	DP(_T("SetDnDMode=%d"), mode);
}

void HookDropTarget(HWND hwnd)
{
	TCHAR buff[256] = { _T('\0') };

	GetClassName(hwnd, buff, sizeof(buff));
	DP(_T("HookDnD ClassName=%s"), buff);

	IDropTarget *target = (IDropTarget *)GetProp(hwnd, _T("OleDropTargetInterface"));
	if (target) {
		target->AddRef();
	}
	DP(_T("IDropTarget=%d"), target);

	//GetWindowText(hwnd, buff, sizeof(buff));
	//DP(_T("WindowText=%s"), buff);

	//GetExeFileName(hwnd, buff, sizeof(buff));
	//DP(_T("ExeFileName=%s"), buff);

	if (target) {
		DropTargetWrapper *target2;
		HRESULT hr = target->QueryInterface(IID_DropTargetWrapper, (void **)&target2);

		DP(_T("QueryInterface=%d(%x)"), target2, hr);
		if (SUCCEEDED(hr)) {
			target2->Release();
		} else {
			HRESULT hr = RevokeDragDrop(hwnd);
			DP(_T("RevokeDragDrop=%x"), hr);
			if (SUCCEEDED(hr)) {
				IDropTarget *wrap = new DropTargetWrapper(hwnd, target);
				hr = RegisterDragDrop(hwnd, wrap);
				DP(_T("RegisterDragDrop=%x, %d"), wrap, hr);
			}
		}
		target->Release();
	}
}

void UnHookDropTarget(HWND hwnd)
{
	RemoveProp(hwnd, _T("AlterDnD_Checked"));
	IDropTarget *target = (IDropTarget *)GetProp(hwnd, _T("OleDropTargetInterface"));
	if (target) {
		target->AddRef();
	}
	if (target) {
		DropTargetWrapper *target2;
		HRESULT hr = target->QueryInterface(IID_DropTargetWrapper, (void **)&target2);
		if (SUCCEEDED(hr)) {
			HRESULT hr = RevokeDragDrop(hwnd);
			DP(_T("UnHookDnD_Revoke=%d"), hr);
			if (SUCCEEDED(hr)) {
				IDropTarget *org = target2->GetOriginalTarget();
				hr = RegisterDragDrop(hwnd, org);
				DP(_T("UnHookDnD_Register=%d"), hr);
				org->Release();
			}
			target2->Release();
		}
		target->Release();
	}
}

BOOL CALLBACK EnumChildWindowsProc_HookDropTarget(HWND hwnd, LPARAM lParam)
{
	HookDropTarget(hwnd);
	return TRUE;
}


BOOL CALLBACK EnumChildWindowsProc_UnHookDropTarget(HWND hwnd, LPARAM lParam)
{
	TCHAR buff[256] = { _T('\0') };
	GetClassName(hwnd, buff, sizeof(buff));
	DP(_T("UnHookDropTarget=%s"), buff);
	UnHookDropTarget(hwnd);
	return TRUE;
}

LRESULT CALLBACK MsgHookProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (!gIsTargetProcess) {
		return CallNextHookEx(wndProcHook, nCode, wParam, lParam);
	}
	if (!gIsTargetProcessChecked) {
		gIsTargetProcessChecked = TRUE;
		gIsTargetProcess = CheckTargetProcess();
		//if (gIsTargetProcess) {
		//	gHookDnDMsg = RegisterWindowMessage(TEXT("WM_AlterDnD_Hook"));
		//	SetAlterDnDWindowMessageFilter();	// AlterDnD.exe ̃bZ[W
		//	//PostMessage(HWND_BROADCAST, gHookDnDMsg, TRUE, NULL);
		//}
	}

	if (nCode == HC_ACTION) {
		LPCWPRETSTRUCT p = (LPCWPRETSTRUCT)lParam;

		if (GetProp(p->hwnd, _T("OleDropTargetInterface")) != NULL) {
			if (GetProp(p->hwnd, _T("AlterDnD Checked")) == NULL) {
				TCHAR className[256] = {_T('\0') };
				GetClassName(p->hwnd, className, sizeof(className));

				TCHAR rootClass[256] = {_T('\0') };
				HWND hRoot = GetAncestor(p->hwnd, GA_ROOT);
				GetClassName(hRoot, rootClass, sizeof(rootClass));

				//DP(_T("hRoot=%s"), buff);
				if (_tcscmp(rootClass, TARGET_WINDOW_CLASS) == 0) {
					DP(_T("WM_ %x class=%s"), p->message, className);
					HookDropTarget(p->hwnd);
				}
				SetProp(p->hwnd, _T("AlterDnD Checked"), p->hwnd);	// NULL ȊOȂ牽ł
			}
		}
	}
	return CallNextHookEx(wndProcHook, nCode, wParam, lParam);
}

void LockThisDLL()
{
	LONG count = InterlockedIncrement(&gDLLRefCount);
	DP(_T("LockThisDLL=%d"), count);
	if (count == 1) {
		TCHAR name[MAX_PATH] = {_T('\0')};
		GetModuleFileName(hInst, name, _countof(name));
		LoadLibrary(name);	// ɃA[hȂ悤
	}
}

void UnlockThisDLL()
{
	LONG count = InterlockedDecrement(&gDLLRefCount);
	DP(_T("UnlockThisDLL=%d"), count);
	if (count == 0) {
		//FreeLibrary(hInst);
	}
}

