/***********************************************************************
*
* Copyright (C) 2013 イ
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
***********************************************************************/

#include "stdafx.h"
#include "AlterDnD_DLL.h"
#include "DropTargetWrapper.h"

void LockThisDLL();
void UnlockThisDLL();

DropTargetWrapper::DropTargetWrapper(HWND hwnd, IDropTarget *pTarget)
{
	LockThisDLL();
	m_hWnd = hwnd;
	m_cRef = 0;
	m_pTarget = pTarget;
	ULONG count = m_pTarget->AddRef();
	DP(_T("DropTargetWrapper:DropTargetWrapper  m_pTarget->AddRef() hwnd=%x count=%d"), m_hWnd, (int)count);
}

DropTargetWrapper::~DropTargetWrapper()
{
	ULONG ret = m_pTarget->Release();
	DP(_T("DropTargetWrapper:~DropTargetWrapper  m_pTarget->Release() hwnd=%x count=%d"), m_hWnd, (int)ret);
	m_pTarget = NULL;
	UnlockThisDLL();
}

IDropTarget* DropTargetWrapper::GetOriginalTarget()
{
	ULONG count = m_pTarget->AddRef();
	DP(_T("DropTargetWrapper::GetOriginalTarget hwnd=%x count=%d"), m_hWnd, count);
	return m_pTarget;
}

STDMETHODIMP DropTargetWrapper::QueryInterface(REFIID riid, void **ppvObject)
{
	DP(_T("DropTargetWrapper::QueryInterface hwnd=%x"), m_hWnd);

	*ppvObject = NULL;

	if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IDropTarget) || IsEqualIID(riid, IID_DropTargetWrapper))
		*ppvObject = static_cast<IDropTarget *>(this);
	else
		return E_NOINTERFACE;

	AddRef();

	return S_OK;
}

STDMETHODIMP_(ULONG) DropTargetWrapper::AddRef()
{
	DP(_T("DropTargetWrapper::AddRef hwnd=%x count=%d"), m_hWnd, m_cRef + 1);
	return InterlockedIncrement(&m_cRef);
}

STDMETHODIMP_(ULONG) DropTargetWrapper::Release()
{
	DP(_T("DropTargetWrapper::Release hwnd=%x count=%d"), m_hWnd, m_cRef - 1);
	if (InterlockedDecrement(&m_cRef) == 0) {
		DP(_T("hwnd=%x delete"), m_hWnd);
		delete this;
		return 0;
	}
	return m_cRef;
}

void DropTargetWrapper::DnDFilter(LPDWORD pKeyState, LPDWORD pEffect)
{
	DWORD mode = GetDnDMode();

	if (mode == DNDMODE_FORBIDS) {
		*pEffect = DROPEFFECT_NONE;
	} else if (mode == DNDMODE_ANY_KEYDOWN) {
		if ((*pKeyState & (MK_SHIFT | MK_CONTROL | MK_ALT)) == 0) {
			*pEffect = DROPEFFECT_NONE;
		}
	} else if (mode == DNDMODE_RBUTTON_SIMULATE) {
		 *pKeyState = (*pKeyState & ~MK_LBUTTON) | MK_RBUTTON;
	}
}

STDMETHODIMP DropTargetWrapper::DragEnter(IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
	DP(_T("DropTargetWrapper:DragEnter=%x,%x"), grfKeyState, *pdwEffect);
	if (grfKeyState & MK_LBUTTON) {
		DnDFilter(&grfKeyState, pdwEffect);
	}
	DP(_T("DropTargetWrapper:DragEnter2=%x,%x"), grfKeyState, *pdwEffect);
	HRESULT hr = m_pTarget->DragEnter(pDataObj, grfKeyState, pt, pdwEffect);
	//DP(_T("DROPEFFECT=%d"), (int)*pdwEffect);
	return hr;
}

STDMETHODIMP DropTargetWrapper::DragOver(DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
	DP(_T("DropTargetWrapper:DragOver hwnd=%x param=%x,%x"), m_hWnd, grfKeyState, *pdwEffect);
	if (grfKeyState & MK_LBUTTON) {
		DnDFilter(&grfKeyState, pdwEffect);
	}
	DP(_T("DropTargetWrapper:DragOver2=%x,%x"), grfKeyState, *pdwEffect);
	HRESULT hr = m_pTarget->DragOver(grfKeyState, pt, pdwEffect);
	//DP(_T("DROPEFFECT=%d"), (int)*pdwEffect);
	return hr;
}

STDMETHODIMP DropTargetWrapper::DragLeave()
{
	DP(_T("DropTargetWrapper:DragLeave hwnd=%x"), m_hWnd);
	return m_pTarget->DragLeave();
}

STDMETHODIMP DropTargetWrapper::Drop(IDataObject *pDataObj, DWORD grfKeyState, POINTL pt, DWORD *pdwEffect)
{
	DP(_T("DropTargetWrapper:Drop hwnd=%x param=%x,%x"), m_hWnd, grfKeyState, *pdwEffect);
	//DnDFilter(&grfKeyState, pdwEffect);
	//DP(_T("DropTargetWrapper:Drop2=%x,%x"), grfKeyState, *pdwEffect);
	HRESULT hr = m_pTarget->Drop(pDataObj, grfKeyState, pt, pdwEffect);
	//DP(_T("DROPEFFECT=%d"), (int)*pdwEffect);
	return hr;
}
