/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeUsage$Depender;
import org.apache.ivy.core.resolve.IvyNodeUsage$NodeConf;
import scala.math.ScalaNumber;

public final class IvyNodeUsage {
    private IvyNode node;
    private Map rootModuleConfs;
    private Map requiredConfs;
    private Map dependers;
    private Map blacklisted;

    public IvyNodeUsage(IvyNode ivyNode) {
        this.rootModuleConfs = new HashMap();
        this.requiredConfs = new HashMap();
        this.dependers = new HashMap();
        this.blacklisted = new HashMap();
        this.node = ivyNode;
    }

    protected final Collection getRequiredConfigurations(IvyNode ivyNode, String string) {
        return (Collection)this.requiredConfs.get(new IvyNodeUsage$NodeConf(ivyNode, string));
    }

    protected final void setRequiredConfs(IvyNode ivyNode, String string, Collection collection) {
        this.requiredConfs.put(new IvyNodeUsage$NodeConf(ivyNode, string), new HashSet(collection));
    }

    protected final Set getConfigurations(String string) {
        return (Set)this.rootModuleConfs.get(string);
    }

    protected final Set addAndGetConfigurations(String string) {
        HashSet hashSet = (HashSet)this.rootModuleConfs.get(string);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.rootModuleConfs.put(string, hashSet);
        }
        return hashSet;
    }

    protected final Set getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet();
    }

    public final void updateDataFrom(Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IvyNodeUsage ivyNodeUsage = (IvyNodeUsage)iterator.next();
            String string2 = string;
            IvyNodeUsage ivyNodeUsage2 = ivyNodeUsage;
            IvyNodeUsage ivyNodeUsage3 = this;
            Map map2 = ivyNodeUsage3.requiredConfs;
            Map map3 = ivyNodeUsage2.requiredConfs;
            Iterator iterator2 = map3.keySet().iterator();
            while (iterator2.hasNext()) {
                Object k = iterator2.next();
                IvyNodeUsage.updateMapOfSetForKey(map3, map2, k);
            }
            IvyNodeUsage.updateMapOfSetForKey(ivyNodeUsage2.rootModuleConfs, ivyNodeUsage3.rootModuleConfs, string2);
            IvyNodeUsage.updateMapOfSetForKey(ivyNodeUsage2.dependers, ivyNodeUsage3.dependers, string2);
        }
    }

    private static void updateMapOfSetForKey(Map map2, Map map3, Object object) {
        Set set = (Set)map2.get(object);
        if (set != null) {
            Set set2 = (Set)map3.get(object);
            if (set2 != null) {
                set2.addAll(set);
                return;
            }
            map3.put(object, new HashSet(set));
        }
    }

    public final void addUsage(String string, DependencyDescriptor dependencyDescriptor, String string2) {
        Map map2 = this.dependers;
        IvyNodeUsage$Depender ivyNodeUsage$Depender = new IvyNodeUsage$Depender(dependencyDescriptor, string2);
        String string3 = string;
        HashSet<IvyNodeUsage$Depender> hashSet = (HashSet<IvyNodeUsage$Depender>)map2.get(string3);
        if (hashSet == null) {
            hashSet = new HashSet<IvyNodeUsage$Depender>();
            map2.put(string3, hashSet);
        }
        hashSet.add(ivyNodeUsage$Depender);
    }

    protected final Set getDependencyArtifactsSet(String string) {
        Collection collection = (Collection)this.dependers.get(string);
        if (collection == null) {
            return null;
        }
        HashSet<DependencyArtifactDescriptor> hashSet = new HashSet<DependencyArtifactDescriptor>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IvyNodeUsage$Depender ivyNodeUsage$Depender = (IvyNodeUsage$Depender)iterator.next();
            DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray = IvyNodeUsage$Depender.access$100(ivyNodeUsage$Depender).getDependencyArtifacts(IvyNodeUsage$Depender.access$000(ivyNodeUsage$Depender));
            hashSet.addAll(Arrays.asList(dependencyArtifactDescriptorArray));
        }
        return hashSet;
    }

    protected final Set getDependencyIncludesSet(String string) {
        Collection collection = (Collection)this.dependers.get(string);
        if (collection == null) {
            return null;
        }
        HashSet<IncludeRule> hashSet = new HashSet<IncludeRule>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IvyNodeUsage$Depender ivyNodeUsage$Depender = (IvyNodeUsage$Depender)iterator.next();
            IncludeRule[] includeRuleArray = IvyNodeUsage$Depender.access$100(ivyNodeUsage$Depender).getIncludeRules(IvyNodeUsage$Depender.access$000(ivyNodeUsage$Depender));
            if (includeRuleArray == null || includeRuleArray.length == 0) {
                return null;
            }
            hashSet.addAll(Arrays.asList(includeRuleArray));
        }
        return hashSet;
    }

    protected final void blacklist(IvyNodeBlacklist ivyNodeBlacklist) {
        this.blacklisted.put(ivyNodeBlacklist.getRootModuleConf(), ivyNodeBlacklist);
    }

    protected final boolean isBlacklisted(String string) {
        return this.blacklisted.containsKey(string);
    }

    protected final IvyNodeBlacklist getBlacklistData(String string) {
        return (IvyNodeBlacklist)this.blacklisted.get(string);
    }

    protected final IvyNode getNode() {
        return this.node;
    }

    public final boolean hasTransitiveDepender(String string) {
        Set set = (Set)this.dependers.get(string);
        if (set == null) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!IvyNodeUsage$Depender.access$100((IvyNodeUsage$Depender)iterator.next()).isTransitive()) continue;
            return true;
        }
        return false;
    }

    public IvyNodeUsage() {
    }

    public static boolean unboxToBoolean(Object object) {
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        if (object == null) {
            return '\u0000';
        }
        return ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        if (object == null) {
            return 0;
        }
        return (Byte)object;
    }

    public static short unboxToShort(Object object) {
        if (object == null) {
            return 0;
        }
        return (Short)object;
    }

    public static int unboxToInt(Object object) {
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public static long unboxToLong(Object object) {
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public static float unboxToFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    private static int eqTypeCode(Number number) {
        if (number instanceof Integer || number instanceof Byte) {
            return 3;
        }
        if (number instanceof Long) {
            return 4;
        }
        if (number instanceof Double) {
            return 6;
        }
        if (number instanceof Short) {
            return 3;
        }
        if (number instanceof Float) {
            return 5;
        }
        return 7;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        Object object3 = object2;
        Object object4 = object;
        if (object4 instanceof Number) {
            return IvyNodeUsage.equalsNumObject((Number)object4, object3);
        }
        if (object4 instanceof Character) {
            return IvyNodeUsage.equalsCharObject((Character)object4, object3);
        }
        if (object4 == null) {
            return object3 == null;
        }
        return object4.equals(object3);
    }

    public static boolean equalsNumObject(Number number, Object object) {
        if (object instanceof Number) {
            Number number2 = (Number)object;
            Number number3 = number;
            int n = IvyNodeUsage.eqTypeCode(number3);
            int n2 = IvyNodeUsage.eqTypeCode(number2);
            switch (n2 > n ? n2 : n) {
                case 3: {
                    return number3.intValue() == number2.intValue();
                }
                case 4: {
                    return number3.longValue() == number2.longValue();
                }
                case 5: {
                    return number3.floatValue() == number2.floatValue();
                }
                case 6: {
                    return number3.doubleValue() == number2.doubleValue();
                }
            }
            if (number2 instanceof ScalaNumber && !(number3 instanceof ScalaNumber)) {
                return number2.equals(number3);
            }
            if (number3 == null) {
                return number2 == null;
            }
            return number3.equals(number2);
        }
        if (object instanceof Character) {
            return IvyNodeUsage.equalsNumChar(number, (Character)object);
        }
        if (number == null) {
            return object == null;
        }
        return number.equals(object);
    }

    public static boolean equalsCharObject(Character c, Object object) {
        if (object instanceof Character) {
            return c.charValue() == ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return IvyNodeUsage.equalsNumChar((Number)object, c);
        }
        if (c == null) {
            return object == null;
        }
        return c.equals(object);
    }

    private static boolean equalsNumChar(Number number, Character c) {
        char c2 = c.charValue();
        switch (IvyNodeUsage.eqTypeCode(number)) {
            case 3: {
                return number.intValue() == c2;
            }
            case 4: {
                return number.longValue() == (long)c2;
            }
            case 5: {
                return number.floatValue() == (float)c2;
            }
            case 6: {
                return number.doubleValue() == (double)c2;
            }
        }
        if (number == null) {
            return c == null;
        }
        return number.equals(c);
    }

    public static int hashFromNumber(Number number) {
        if (number instanceof Long) {
            Long l = (Long)number;
            int n = l.intValue();
            if ((long)n == l) {
                return n;
            }
            return l.hashCode();
        }
        if (number instanceof Double) {
            double d;
            Double d2 = (Double)number;
            int n = d2.intValue();
            if ((double)n == (d = d2.doubleValue())) {
                return n;
            }
            long l = d2.longValue();
            if ((double)l == d) {
                return Long.valueOf(l).hashCode();
            }
            return d2.hashCode();
        }
        if (number instanceof Float) {
            float f;
            Float f2 = (Float)number;
            int n = f2.intValue();
            if ((float)n == (f = f2.floatValue())) {
                return n;
            }
            long l = f2.longValue();
            if ((float)l == f) {
                return Long.valueOf(l).hashCode();
            }
            return f2.hashCode();
        }
        return number.hashCode();
    }
}

