package jp.sf.amateras.mirage.example.page;

import static jp.sf.amateras.mirage.test.MirageTestContext.*;
import static org.mockito.Mockito.*;

import java.lang.reflect.ParameterizedType;

import jp.sf.amateras.mirage.test.MockSqlManager;

import org.apache.click.MockContext;
import org.junit.Before;

public abstract class AbstractPageTest<T extends AbstractPage> {

	protected T page;

	@Before
	public void setUp() throws Exception {
		MockContext.initContext();
		initMirageTestContext();

		ParameterizedType type = (ParameterizedType) getClass().getGenericSuperclass();

		@SuppressWarnings("unchecked")
		Class<T> pageType = (Class<T>) type.getActualTypeArguments()[0];

		page = spy(pageType.newInstance());
		when(page.getSqlManager()).thenReturn(new MockSqlManager());
	}

}
