/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.NormalRelativeUrlResolver;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.cache.DefaultResolutionCacheManager;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.settings.IvySettings$1;
import org.apache.ivy.core.settings.IvySettings$2;
import org.apache.ivy.core.settings.IvySettings$3;
import org.apache.ivy.core.settings.IvySettings$4;
import org.apache.ivy.core.settings.IvySettings$ModuleSettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.core.settings.IvyVariableContainerImpl;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.core.settings.XmlSettingsParser;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.ErrorCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.circular.WarnCircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestCompatibleConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictManager;
import org.apache.ivy.plugins.latest.LatestLexicographicStrategy;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.latest.LatestTimeStrategy;
import org.apache.ivy.plugins.lock.ArtifactLockStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.lock.NoLockStrategy;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.matcher.RegexpPatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.report.LogReportOutputter;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.version.ChainVersionMatcher;
import org.apache.ivy.plugins.version.ExactVersionMatcher;
import org.apache.ivy.plugins.version.LatestVersionMatcher;
import org.apache.ivy.plugins.version.SubVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.plugins.version.VersionRangeMatcher;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.url.URLHandlerRegistry;
import scala.Array$$anon$2;
import scala.collection.mutable.GrowingBuilder;

public class IvySettings
implements ResolveEngineSettings,
RetrieveEngineSettings,
SortEngineSettings,
ParserSettings,
ResolverSettings {
    private Map typeDefs = new HashMap();
    private Map resolversMap = new HashMap();
    private DependencyResolver defaultResolver;
    private DependencyResolver dictatorResolver = null;
    private String defaultResolverName;
    private File defaultCache;
    private String defaultBranch = null;
    private boolean checkUpToDate = true;
    private ModuleRules moduleSettings = new ModuleRules();
    private Map conflictsManager = new HashMap();
    private Map latestStrategies = new HashMap();
    private Map lockStrategies = new HashMap();
    private Map namespaces = new HashMap();
    private Map matchers = new HashMap();
    private Map reportOutputters = new HashMap();
    private Map versionMatchers = new HashMap();
    private Map circularDependencyStrategies = new HashMap();
    private Map repositoryCacheManagers = new HashMap();
    private List triggers;
    private IvyVariableContainer variableContainer;
    private boolean validate;
    private LatestStrategy defaultLatestStrategy;
    private LockStrategy defaultLockStrategy;
    private ConflictManager defaultConflictManager;
    private CircularDependencyStrategy circularDependencyStrategy;
    private RepositoryCacheManager defaultRepositoryCacheManager;
    private ResolutionCacheManager resolutionCacheManager;
    private List listingIgnore;
    private boolean repositoriesConfigured;
    private boolean useRemoteConfig;
    private File defaultUserDir;
    private File baseDir;
    private List classpathURLs;
    private ClassLoader classloader;
    private Boolean debugConflictResolution;
    private VersionMatcher versionMatcher;
    private StatusManager statusManager;
    private Boolean debugLocking;
    private String defaultCacheIvyPattern;
    private String defaultCacheArtifactPattern;
    private boolean defaultUseOrigin;
    private String defaultResolveMode;
    private static Class class$org$apache$ivy$core$settings$IvySettings;
    private static Class class$org$apache$ivy$core$settings$XmlSettingsParser;
    private static Class class$org$apache$ivy$Ivy;

    public IvySettings() {
        this(new IvyVariableContainerImpl());
    }

    private IvySettings(IvyVariableContainer ivyVariableContainer) {
        Object object;
        new HashMap();
        this.triggers = new ArrayList();
        this.variableContainer = new IvyVariableContainerImpl();
        this.validate = true;
        this.defaultLatestStrategy = null;
        this.defaultLockStrategy = null;
        this.defaultConflictManager = null;
        this.circularDependencyStrategy = null;
        this.defaultRepositoryCacheManager = null;
        this.resolutionCacheManager = null;
        this.listingIgnore = new ArrayList();
        this.useRemoteConfig = false;
        this.baseDir = new File(".").getAbsoluteFile();
        this.classpathURLs = new ArrayList();
        this.defaultResolveMode = "default";
        Object object2 = ivyVariableContainer;
        this.variableContainer = object2;
        String string = IvySettings.getSettingsURL("ivysettings.xml").toExternalForm();
        this.setVariable("ivy.default.settings.dir", string.substring(0, string.length() - "ivysettings.xml".length() - 1), true);
        String string2 = this.baseDir.getAbsolutePath();
        object2 = "ivy.basedir";
        this.setVariable("ivy.basedir", string2, true);
        this.setDeprecatedVariable("ivy.default.conf.dir", "ivy.default.settings.dir");
        String string3 = System.getProperty("ivy.typedef.files");
        if (string3 != null) {
            object = string3.split("\\,");
            for (int i = 0; i < ((String[])object).length; ++i) {
                try {
                    this.typeDefs$4cd65faa(new FileInputStream(GrowingBuilder.checkAbsolute(object[i].trim(), "ivy.typedef.files")));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Message.warn("typedefs file not found: " + object[i].trim());
                    continue;
                }
                catch (IOException iOException) {
                    Message.warn("problem with typedef file: " + object[i].trim() + ": " + iOException.getMessage());
                }
            }
        } else {
            try {
                this.typeDefs$4cd65faa(IvySettings.getSettingsURL("typedef.properties").openStream());
            }
            catch (IOException iOException) {
                Message.warn("impossible to load default type defs");
            }
        }
        object = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", (LatestStrategy)object);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addLockStrategy("no-lock", new NoLockStrategy());
        IvySettings ivySettings = this;
        if (ivySettings.debugLocking == null) {
            string = ivySettings.getVariable("ivy.log.locking");
            ivySettings.debugLocking = string != null && Boolean.valueOf(string) != false;
        }
        this.addLockStrategy("artifact-lock", new ArtifactLockStrategy(ivySettings.debugLocking));
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-compatible", new LatestCompatibleConflictManager("latest-compatible", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.INSTANCE);
        this.addMatcher(RegexpPatternMatcher.INSTANCE);
        this.addMatcher(ExactOrRegexpPatternMatcher.INSTANCE);
        try {
            Field field = (class$org$apache$ivy$core$settings$IvySettings == null ? (class$org$apache$ivy$core$settings$IvySettings = IvySettings.class$("org.apache.ivy.core.settings.IvySettings")) : class$org$apache$ivy$core$settings$IvySettings).getClassLoader().loadClass("org.apache.ivy.plugins.matcher.GlobPatternMatcher").getField("INSTANCE");
            this.addMatcher((PatternMatcher)field.get(null));
        }
        catch (Exception exception) {
            Message.info("impossible to define glob matcher: org.apache.ivy.plugins.matcher.GlobPatternMatcher was not found.");
        }
        this.addReportOutputter(new LogReportOutputter());
        this.addReportOutputter(new XmlReportOutputter());
        ivySettings = this;
        ivySettings.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        ivySettings.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        ivySettings.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
        this.listingIgnore.add(".cvsignore");
        this.listingIgnore.add("CVS");
        this.listingIgnore.add(".svn");
        this.listingIgnore.add("maven-metadata.xml");
        this.listingIgnore.add("maven-metadata.xml.md5");
        this.listingIgnore.add("maven-metadata.xml.sha1");
        ivySettings = this;
        try {
            Properties properties = System.getProperties();
            ivySettings.addAllVariables(properties, true);
            return;
        }
        catch (AccessControlException accessControlException) {
            Message.verbose("access denied to getting all system properties: they won't be available as Ivy variables.\nset " + accessControlException.getPermission() + " permission if you want to access them");
            return;
        }
    }

    public final void configureRepositories(boolean bl) {
        if (!this.repositoriesConfigured) {
            Properties properties;
            block9: {
                Object object;
                properties = new Properties();
                boolean bl2 = false;
                if (this.useRemoteConfig && bl) {
                    try {
                        object = new URL("http://ant.apache.org/ivy/repository.properties");
                        Message.verbose("configuring repositories with " + object);
                        properties.load(URLHandlerRegistry.getDefault().openStream((URL)object));
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        Message.verbose("unable to use remote repository configuration: " + exception.getMessage());
                        properties = new Properties();
                    }
                }
                if (!bl2) {
                    object = null;
                    try {
                        object = IvySettings.getSettingsURL("repository.properties").openStream();
                        properties.load((InputStream)object);
                    }
                    catch (IOException iOException) {
                        Message.error("unable to use internal repository configuration: " + iOException.getMessage());
                        if (object == null) break block9;
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.addAllVariables(properties, false);
            this.repositoriesConfigured = true;
        }
    }

    private void typeDefs$4cd65faa(InputStream inputStream) {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.typeDefs(properties, true);
            return;
        }
        finally {
            inputStream.close();
        }
    }

    private void typeDefs(Properties properties, boolean bl) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.typeDef(string, properties.getProperty(string), true);
        }
    }

    public final void load(URL uRL) {
        Message.info(":: loading settings :: url = " + uRL);
        long l = System.currentTimeMillis();
        this.setSettingsVariables(uRL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(GrowingBuilder.checkAbsolute(this.getVariable("ivy.default.ivy.user.dir"), "ivy.default.ivy.user.dir"));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.loadProperties(IvySettings.getSettingsURL("ivy.properties"), false);
        new XmlSettingsParser(this).parse(uRL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("settings loaded (" + (System.currentTimeMillis() - l) + "ms)");
        this.dumpSettings();
    }

    public static URL getDefaultSettingsURL() {
        return IvySettings.getSettingsURL("ivysettings.xml");
    }

    private static URL getSettingsURL(String string) {
        return (class$org$apache$ivy$core$settings$XmlSettingsParser == null ? (class$org$apache$ivy$core$settings$XmlSettingsParser = IvySettings.class$("org.apache.ivy.core.settings.XmlSettingsParser")) : class$org$apache$ivy$core$settings$XmlSettingsParser).getResource(string);
    }

    public final void setSettingsVariables(File file2) {
        try {
            String string = new File(file2.getAbsolutePath()).getParent();
            String string2 = "ivy.settings.dir";
            this.setVariable("ivy.settings.dir", string, true);
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            string = file2.getAbsolutePath();
            string2 = "ivy.settings.file";
            this.setVariable("ivy.settings.file", string, true);
            this.setDeprecatedVariable("ivy.conf.file", "ivy.settings.file");
            string = file2.toURI().toURL().toExternalForm();
            string2 = "ivy.settings.url";
            this.setVariable("ivy.settings.url", string, true);
            this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
            return;
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("given file cannot be transformed to url: " + file2);
            illegalArgumentException.initCause(malformedURLException);
            throw illegalArgumentException;
        }
    }

    private void setDeprecatedVariable(String string, String string2) {
        String string3 = this.getVariable(string2);
        String string4 = string;
        this.setVariable(string4, string3, true);
    }

    public final void setSettingsVariables(URL uRL) {
        String string;
        String string2 = string = uRL.toExternalForm();
        String string3 = "ivy.settings.url";
        this.setVariable("ivy.settings.url", string2, true);
        this.setDeprecatedVariable("ivy.conf.url", "ivy.settings.url");
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = "ivy.settings.dir";
            this.setVariable("ivy.settings.dir", string2, true);
            this.setDeprecatedVariable("ivy.conf.dir", "ivy.settings.dir");
            return;
        }
        Message.warn("settings url does not contain any slash (/): ivy.settings.dir variable not set");
    }

    private void dumpSettings() {
        Iterator<Object> iterator;
        DependencyResolver dependencyResolver;
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        StringBuffer stringBuffer = new StringBuffer().append("\tdefault resolver: ");
        IvySettings ivySettings = this;
        if (ivySettings.dictatorResolver != null) {
            dependencyResolver = ivySettings.dictatorResolver;
        } else {
            if (ivySettings.defaultResolver == null) {
                ivySettings.defaultResolver = (DependencyResolver)ivySettings.resolversMap.get(ivySettings.defaultResolverName);
            }
            dependencyResolver = ivySettings.defaultResolver;
        }
        Message.verbose(stringBuffer.append(dependencyResolver).toString());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.validate);
        Message.debug("\tcheck up2date: " + this.checkUpToDate);
        if (!this.classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this.classpathURLs.size() + " custom classpath urls:");
            iterator = this.classpathURLs.iterator();
            while (iterator.hasNext()) {
                Message.debug("\t\t" + iterator.next());
            }
        }
        Message.verbose("\t-- " + this.resolversMap.size() + " resolvers:");
        iterator = this.resolversMap.values().iterator();
        while (iterator.hasNext()) {
            ((DependencyResolver)iterator.next()).dumpSettings();
        }
        Message.debug("\tmodule settings:");
        this.moduleSettings.dump("\t\t");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void loadProperties(URL uRL, boolean bl) {
        InputStream inputStream = uRL.openStream();
        IvySettings ivySettings = this;
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            ivySettings.addAllVariables(properties, bl);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void setVariable(String string, String string2) {
        this.setVariable(string, string2, true);
    }

    public final void setVariable(String string, String string2, boolean bl) {
        this.variableContainer.setVariable(string, string2, bl);
    }

    private void addAllVariables(Map map2, boolean bl) {
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map2.get(string);
            this.setVariable(string, string2, bl);
        }
    }

    public final String substitute(String string) {
        return IvyPatternHelper.substituteVariables(string, this.variableContainer);
    }

    public final IvyVariableContainer getVariables() {
        return this.variableContainer;
    }

    public final Class typeDef(String string, String string2, boolean bl) {
        Class clazz = this.classForName(string2, bl);
        if (clazz != null) {
            this.typeDefs.put(string, clazz);
        }
        return clazz;
    }

    private Class classForName(String string, boolean bl) {
        try {
            IvySettings ivySettings = this;
            if (ivySettings.classloader == null) {
                ivySettings.classloader = ivySettings.classpathURLs.isEmpty() ? (class$org$apache$ivy$Ivy == null ? (class$org$apache$ivy$Ivy = IvySettings.class$("org.apache.ivy.Ivy")) : class$org$apache$ivy$Ivy).getClassLoader() : new URLClassLoader(ivySettings.classpathURLs.toArray(new URL[ivySettings.classpathURLs.size()]), (class$org$apache$ivy$Ivy == null ? (class$org$apache$ivy$Ivy = IvySettings.class$("org.apache.ivy.Ivy")) : class$org$apache$ivy$Ivy).getClassLoader());
            }
            return ivySettings.classloader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                Message.info("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + string + " in " + this.classpathURLs + " nor Ivy classloader");
        }
    }

    public final void addClasspathURL(URL uRL) {
        this.classpathURLs.add(uRL);
        this.classloader = null;
    }

    public final Map getTypeDefs() {
        return this.typeDefs;
    }

    public final void addResolver(DependencyResolver dependencyResolver) {
        if (dependencyResolver == null) {
            throw new NullPointerException("null resolver");
        }
        this.init(dependencyResolver);
        this.resolversMap.put(dependencyResolver.getName(), dependencyResolver);
        if (dependencyResolver instanceof ChainResolver) {
            Iterator iterator = ((ChainResolver)dependencyResolver).getResolvers().iterator();
            while (iterator.hasNext()) {
                DependencyResolver dependencyResolver2 = (DependencyResolver)iterator.next();
                this.addResolver(dependencyResolver2);
            }
            return;
        }
    }

    public final void setDefaultCache(File file2) {
        this.setVariable("ivy.cache.dir", file2.getAbsolutePath(), false);
        this.defaultCache = file2;
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.defaultCache);
        }
    }

    public final void setDefaultResolver(String string) {
        this.checkResolverName(string);
        if (string != null && !string.equals(this.defaultResolverName)) {
            this.defaultResolver = null;
        }
        this.defaultResolverName = string;
    }

    private void checkResolverName(String string) {
        if (string != null && !this.resolversMap.containsKey(string)) {
            throw new IllegalArgumentException("no resolver found called " + string + ": check your settings");
        }
    }

    public final void addModuleConfiguration(Map map2, PatternMatcher patternMatcher, String string, String string2, String string3, String string4) {
        this.checkResolverName(string);
        this.moduleSettings.defineRule(new MapMatcher(map2, patternMatcher), new IvySettings$ModuleSettings(string, string2, string3, string4));
    }

    public final File resolveFile(String string) {
        return FileUtil.resolveFile(this.baseDir, string);
    }

    public final void setBaseDir(File file2) {
        this.baseDir = file2.getAbsoluteFile();
        String string = this.baseDir.getAbsolutePath();
        String string2 = "ivy.basedir";
        this.setVariable("ivy.basedir", string, true);
        this.setVariable("basedir", this.baseDir.getAbsolutePath(), false);
    }

    public final File getDefaultIvyUserDir() {
        if (this.defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                this.setDefaultIvyUserDir(GrowingBuilder.checkAbsolute(this.getVariable("ivy.home"), "ivy.home"));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this.defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy2"));
                Message.verbose("no default ivy user dir defined: set to " + this.defaultUserDir);
            }
        }
        return this.defaultUserDir;
    }

    public final void setDefaultIvyUserDir(File file2) {
        this.defaultUserDir = file2;
        String string = this.defaultUserDir.getAbsolutePath();
        String string2 = "ivy.default.ivy.user.dir";
        this.setVariable("ivy.default.ivy.user.dir", string, true);
        string = this.defaultUserDir.getAbsolutePath();
        string2 = "ivy.home";
        this.setVariable("ivy.home", string, true);
    }

    private File getDefaultCache() {
        if (this.defaultCache == null) {
            String string = this.getVariable("ivy.cache.dir");
            if (string != null) {
                this.defaultCache = GrowingBuilder.checkAbsolute(string, "ivy.cache.dir");
            } else {
                this.setDefaultCache(new File(this.getDefaultIvyUserDir(), "cache"));
                Message.verbose("no default cache defined: set to " + this.defaultCache);
            }
        }
        return this.defaultCache;
    }

    public final void setDefaultRepositoryCacheBasedir(String string) {
        this.setVariable("ivy.cache.repository", string, true);
        if (this.defaultRepositoryCacheManager != null && "default-cache".equals(this.defaultRepositoryCacheManager.getName()) && this.defaultRepositoryCacheManager instanceof DefaultRepositoryCacheManager) {
            ((DefaultRepositoryCacheManager)this.defaultRepositoryCacheManager).setBasedir(this.getDefaultRepositoryCacheBasedir());
        }
    }

    public final void setDefaultResolutionCacheBasedir(String string) {
        this.setVariable("ivy.cache.resolution", string, true);
        if (this.resolutionCacheManager != null && this.resolutionCacheManager instanceof DefaultResolutionCacheManager) {
            ((DefaultResolutionCacheManager)this.resolutionCacheManager).setBasedir(this.getDefaultResolutionCacheBasedir());
        }
    }

    public final File getDefaultRepositoryCacheBasedir() {
        String string = this.getVariable("ivy.cache.repository");
        if (string != null) {
            return GrowingBuilder.checkAbsolute(string, "ivy.cache.repository");
        }
        return this.getDefaultCache();
    }

    private File getDefaultResolutionCacheBasedir() {
        String string = this.getVariable("ivy.cache.resolution");
        if (string != null) {
            return GrowingBuilder.checkAbsolute(string, "ivy.cache.resolution");
        }
        return this.getDefaultCache();
    }

    public final void setDictatorResolver(DependencyResolver dependencyResolver) {
        this.dictatorResolver = dependencyResolver;
    }

    public final DependencyResolver getResolver(ModuleRevisionId moduleRevisionId) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        IvySettings ivySettings = this;
        IvySettings$ModuleSettings ivySettings$ModuleSettings = (IvySettings$ModuleSettings)ivySettings.moduleSettings.getRule(moduleRevisionId2, (Filter)new IvySettings$1());
        String string = ivySettings$ModuleSettings == null ? ivySettings.defaultResolverName : ivySettings$ModuleSettings.getResolverName();
        return this.getResolver(string);
    }

    public final DependencyResolver getResolver(String string) {
        if (this.dictatorResolver != null) {
            return this.dictatorResolver;
        }
        DependencyResolver dependencyResolver = (DependencyResolver)this.resolversMap.get(string);
        if (dependencyResolver == null) {
            Message.error("unknown resolver " + string);
        }
        return dependencyResolver;
    }

    public final String getDefaultBranch(ModuleId moduleId) {
        IvySettings$ModuleSettings ivySettings$ModuleSettings = (IvySettings$ModuleSettings)this.moduleSettings.getRule(moduleId, (Filter)new IvySettings$2());
        if (ivySettings$ModuleSettings == null) {
            return this.defaultBranch;
        }
        return ivySettings$ModuleSettings.getBranch();
    }

    public final void setDefaultBranch(String string) {
        this.defaultBranch = string;
    }

    public final ConflictManager getConflictManager(ModuleId moduleId) {
        IvySettings$ModuleSettings ivySettings$ModuleSettings = (IvySettings$ModuleSettings)this.moduleSettings.getRule(moduleId, (Filter)new IvySettings$3());
        if (ivySettings$ModuleSettings == null) {
            return this.getDefaultConflictManager();
        }
        ConflictManager conflictManager = this.getConflictManager(ivySettings$ModuleSettings.getConflictManager());
        if (conflictManager == null) {
            throw new IllegalStateException("ivy badly configured: unknown conflict manager " + ivySettings$ModuleSettings.getConflictManager());
        }
        return conflictManager;
    }

    public final String getResolveMode(ModuleId moduleId) {
        IvySettings$ModuleSettings ivySettings$ModuleSettings = (IvySettings$ModuleSettings)this.moduleSettings.getRule(moduleId, (Filter)new IvySettings$4());
        if (ivySettings$ModuleSettings == null) {
            return this.defaultResolveMode;
        }
        return ivySettings$ModuleSettings.getResolveMode();
    }

    public final void setDefaultResolveMode(String string) {
        this.defaultResolveMode = string;
    }

    public final ConflictManager getConflictManager(String string) {
        if ("default".equals(string)) {
            return this.getDefaultConflictManager();
        }
        return (ConflictManager)this.conflictsManager.get(string);
    }

    private void addConflictManager(String string, ConflictManager conflictManager) {
        this.init(conflictManager);
        this.conflictsManager.put(string, conflictManager);
    }

    public final LatestStrategy getLatestStrategy(String string) {
        if ("default".equals(string)) {
            return this.getDefaultLatestStrategy();
        }
        return (LatestStrategy)this.latestStrategies.get(string);
    }

    private void addLatestStrategy(String string, LatestStrategy latestStrategy) {
        this.init(latestStrategy);
        this.latestStrategies.put(string, latestStrategy);
    }

    public final LockStrategy getLockStrategy(String string) {
        if ("default".equals(string)) {
            return this.getDefaultLockStrategy();
        }
        return (LockStrategy)this.lockStrategies.get(string);
    }

    private void addLockStrategy(String string, LockStrategy lockStrategy) {
        this.init(lockStrategy);
        this.lockStrategies.put(string, lockStrategy);
    }

    public final Namespace getNamespace(String string) {
        if ("system".equals(string)) {
            return Namespace.SYSTEM_NAMESPACE;
        }
        return (Namespace)this.namespaces.get(string);
    }

    public final Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public final PatternMatcher getMatcher(String string) {
        return (PatternMatcher)this.matchers.get(string);
    }

    private void addMatcher(PatternMatcher patternMatcher) {
        this.init(patternMatcher);
        this.matchers.put(patternMatcher.getName(), patternMatcher);
    }

    public final RepositoryCacheManager getRepositoryCacheManager(String string) {
        return (RepositoryCacheManager)this.repositoryCacheManagers.get(string);
    }

    public final void addRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.init(repositoryCacheManager);
        this.repositoryCacheManagers.put(repositoryCacheManager.getName(), repositoryCacheManager);
    }

    public final RepositoryCacheManager[] getRepositoryCacheManagers() {
        return this.repositoryCacheManagers.values().toArray(new RepositoryCacheManager[this.repositoryCacheManagers.size()]);
    }

    private void addReportOutputter(ReportOutputter reportOutputter) {
        this.init(reportOutputter);
        this.reportOutputters.put(reportOutputter.getName(), reportOutputter);
    }

    public final ReportOutputter[] getReportOutputters() {
        return this.reportOutputters.values().toArray(new ReportOutputter[this.reportOutputters.size()]);
    }

    private void addVersionMatcher(VersionMatcher versionMatcher) {
        this.init(versionMatcher);
        this.versionMatchers.put(versionMatcher.getName(), versionMatcher);
        if (this.versionMatcher == null) {
            this.versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this.versionMatcher instanceof ChainVersionMatcher) {
            ((ChainVersionMatcher)this.versionMatcher).add(versionMatcher);
        }
    }

    public final VersionMatcher getVersionMatcher() {
        if (this.versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this.versionMatcher;
    }

    public final void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    public final CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this.circularDependencyStrategy == null) {
            this.circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this.circularDependencyStrategy;
    }

    public final CircularDependencyStrategy getCircularDependencyStrategy(String string) {
        if ("default".equals(string)) {
            string = "warn";
        }
        return (CircularDependencyStrategy)this.circularDependencyStrategies.get(string);
    }

    public final void setCircularDependencyStrategy(CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDependencyStrategy = circularDependencyStrategy;
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy circularDependencyStrategy) {
        this.circularDependencyStrategies.put(circularDependencyStrategy.getName(), circularDependencyStrategy);
    }

    public final StatusManager getStatusManager() {
        if (this.statusManager == null) {
            this.statusManager = new StatusManager(new Status[]{new Status("release", false), new Status("milestone", false), new Status("integration", true)}, "integration");
        }
        return this.statusManager;
    }

    public final void setStatusManager(StatusManager statusManager) {
        this.statusManager = statusManager;
    }

    public final void filterIgnore(Collection collection) {
        collection.removeAll(this.listingIgnore);
    }

    public final boolean isCheckUpToDate() {
        return this.checkUpToDate;
    }

    public final void setCheckUpToDate(boolean bl) {
        this.checkUpToDate = bl;
    }

    public final void setValidate(boolean bl) {
        this.validate = bl;
    }

    public final String getVariable(String string) {
        return this.variableContainer.getVariable(string);
    }

    private ConflictManager getDefaultConflictManager() {
        if (this.defaultConflictManager == null) {
            this.defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
            ((LatestConflictManager)this.defaultConflictManager).setSettings(this);
        }
        return this.defaultConflictManager;
    }

    public final void setDefaultConflictManager(ConflictManager conflictManager) {
        this.defaultConflictManager = conflictManager;
    }

    public final LatestStrategy getDefaultLatestStrategy() {
        if (this.defaultLatestStrategy == null) {
            this.defaultLatestStrategy = new LatestRevisionStrategy();
        }
        return this.defaultLatestStrategy;
    }

    public final void setDefaultLatestStrategy(LatestStrategy latestStrategy) {
        this.defaultLatestStrategy = latestStrategy;
    }

    public final LockStrategy getDefaultLockStrategy() {
        if (this.defaultLockStrategy == null) {
            this.defaultLockStrategy = new NoLockStrategy();
        }
        return this.defaultLockStrategy;
    }

    public final void setDefaultLockStrategy(LockStrategy lockStrategy) {
        this.defaultLockStrategy = lockStrategy;
    }

    public final RepositoryCacheManager getDefaultRepositoryCacheManager() {
        if (this.defaultRepositoryCacheManager == null) {
            this.defaultRepositoryCacheManager = new DefaultRepositoryCacheManager("default-cache", this, this.getDefaultRepositoryCacheBasedir());
            this.addRepositoryCacheManager(this.defaultRepositoryCacheManager);
        }
        return this.defaultRepositoryCacheManager;
    }

    public final void setDefaultRepositoryCacheManager(RepositoryCacheManager repositoryCacheManager) {
        this.defaultRepositoryCacheManager = repositoryCacheManager;
    }

    public final ResolutionCacheManager getResolutionCacheManager() {
        if (this.resolutionCacheManager == null) {
            this.resolutionCacheManager = new DefaultResolutionCacheManager(this.getDefaultResolutionCacheBasedir());
        }
        return this.resolutionCacheManager;
    }

    public final List getTriggers() {
        return this.triggers;
    }

    public final void setUseRemoteConfig(boolean bl) {
        this.useRemoteConfig = bl;
    }

    public final boolean logModulesInUse() {
        String string = this.getVariable("ivy.log.modules.in.use");
        return string == null || Boolean.valueOf(string) != false;
    }

    public final boolean logModuleWhenFound() {
        String string = this.getVariable("ivy.log.module.when.found");
        return string == null || Boolean.valueOf(string) != false;
    }

    public final boolean logResolvedRevision() {
        String string = this.getVariable("ivy.log.resolved.revision");
        return string == null || Boolean.valueOf(string) != false;
    }

    public final boolean debugConflictResolution() {
        if (this.debugConflictResolution == null) {
            String string = this.getVariable("ivy.log.conflict.resolution");
            this.debugConflictResolution = string != null && Boolean.valueOf(string) != false;
        }
        return this.debugConflictResolution;
    }

    private void init(Object object) {
        if (object instanceof IvySettingsAware) {
            ((IvySettingsAware)object).setSettings(this);
            return;
        }
        if (object instanceof DependencyResolver) {
            ((DependencyResolver)object).setSettings(this);
        }
    }

    public final Collection getResolvers() {
        return this.resolversMap.values();
    }

    public final IvyVariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    public final void setVariableContainer(IvyVariableContainer ivyVariableContainer) {
        this.variableContainer = ivyVariableContainer;
    }

    public final RelativeUrlResolver getRelativeUrlResolver() {
        return new NormalRelativeUrlResolver();
    }

    public final void setDefaultCacheIvyPattern(String string) {
        Array$$anon$2.checkCachePattern(string);
        this.defaultCacheIvyPattern = string;
    }

    public final String getDefaultCacheIvyPattern() {
        return this.defaultCacheIvyPattern;
    }

    public final void setDefaultCacheArtifactPattern(String string) {
        Array$$anon$2.checkCachePattern(string);
        this.defaultCacheArtifactPattern = string;
    }

    public final String getDefaultCacheArtifactPattern() {
        return this.defaultCacheArtifactPattern;
    }

    public final void setDefaultUseOrigin(boolean bl) {
        this.defaultUseOrigin = bl;
    }

    public final boolean isDefaultUseOrigin() {
        return this.defaultUseOrigin;
    }

    public final void validate() {
        IvySettings.validateAll(this.resolversMap.values());
        IvySettings.validateAll(this.conflictsManager.values());
        IvySettings.validateAll(this.latestStrategies.values());
        IvySettings.validateAll(this.lockStrategies.values());
        IvySettings.validateAll(this.repositoryCacheManagers.values());
        IvySettings.validateAll(this.reportOutputters.values());
        IvySettings.validateAll(this.circularDependencyStrategies.values());
        IvySettings.validateAll(this.versionMatchers.values());
        IvySettings.validateAll(this.namespaces.values());
    }

    private static void validateAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Validatable)) continue;
            ((Validatable)e).validate();
        }
    }

    public final Namespace getContextNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    private static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

