/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime;

public class BoxesRunTime {
    private static int charLowBound;
    private static int charUpBound;
    private static Character[] charCache;
    private static int byteLowBound;
    private static int byteUpBound;
    private static Byte[] byteCache;
    private static int shortLowBound;
    private static int shortUpBound;
    private static Short[] shortCache;
    private static int intLowBound;
    private static int intUpBound;
    private static Integer[] intCache;
    private static int longLowBound;
    private static int longUpBound;
    private static Long[] longCache;

    private static int typeCode(Object object) {
        if (object instanceof Integer) {
            return 3;
        }
        if (object instanceof Character) {
            return 0;
        }
        if (object instanceof Long) {
            return 4;
        }
        if (object instanceof Double) {
            return 6;
        }
        if (object instanceof Float) {
            return 5;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Short) {
            return 2;
        }
        return 7;
    }

    public static Boolean boxToBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Character boxToCharacter(char c) {
        if (c >= charLowBound && c <= charUpBound) {
            return charCache[c - charLowBound];
        }
        return new Character(c);
    }

    public static Byte boxToByte(byte by) {
        if (by >= byteLowBound && by <= byteUpBound) {
            return byteCache[by - byteLowBound];
        }
        return new Byte(by);
    }

    public static Short boxToShort(short s) {
        if (s >= shortLowBound && s <= shortUpBound) {
            return shortCache[s - shortLowBound];
        }
        return new Short(s);
    }

    public static Integer boxToInteger(int n) {
        if (n >= intLowBound && n <= intUpBound) {
            return intCache[n - intLowBound];
        }
        return new Integer(n);
    }

    public static Long boxToLong(long l) {
        if (l >= (long)longLowBound && l <= (long)longUpBound) {
            return longCache[(int)l - longLowBound];
        }
        return new Long(l);
    }

    public static Float boxToFloat(float f) {
        return new Float(f);
    }

    public static Double boxToDouble(double d) {
        return new Double(d);
    }

    public static boolean unboxToBoolean(Object object) {
        return object == null ? false : (Boolean)object;
    }

    public static char unboxToChar(Object object) {
        return object == null ? (char)'\u0000' : ((Character)object).charValue();
    }

    public static byte unboxToByte(Object object) {
        return object == null ? (byte)0 : (Byte)object;
    }

    public static short unboxToShort(Object object) {
        return object == null ? (short)0 : (Short)object;
    }

    public static int unboxToInt(Object object) {
        return object == null ? 0 : (Integer)object;
    }

    public static long unboxToLong(Object object) {
        return object == null ? 0L : (Long)object;
    }

    public static float unboxToFloat(Object object) {
        return object == null ? 0.0f : ((Float)object).floatValue();
    }

    public static double unboxToDouble(Object object) {
        return object == null ? 0.0 : (Double)object;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (object instanceof Number || object instanceof Character || object2 instanceof Number || object2 instanceof Character) {
            int n;
            int n2;
            int n3 = BoxesRunTime.typeCode(object);
            int n4 = n2 = n3 < (n = BoxesRunTime.typeCode(object2)) ? n : n3;
            if (n2 <= 3) {
                int n5 = n3 == 0 ? ((Character)object).charValue() : ((Number)object).intValue();
                int n6 = n == 0 ? ((Character)object2).charValue() : ((Number)object2).intValue();
                return n5 == n6;
            }
            if (n2 <= 4) {
                long l = n3 == 0 ? (long)((Character)object).charValue() : ((Number)object).longValue();
                long l2 = n == 0 ? (long)((Character)object2).charValue() : ((Number)object2).longValue();
                return l == l2;
            }
            if (n2 <= 5) {
                float f = n3 == 0 ? (float)((Character)object).charValue() : ((Number)object).floatValue();
                float f2 = n == 0 ? (float)((Character)object2).charValue() : ((Number)object2).floatValue();
                return f == f2;
            }
            if (n2 <= 6) {
                double d = n3 == 0 ? (double)((Character)object).charValue() : ((Number)object).doubleValue();
                double d2 = n == 0 ? (double)((Character)object2).charValue() : ((Number)object2).doubleValue();
                return d == d2;
            }
            return object2.equals(object);
        }
        return false;
    }

    static {
        int n;
        charLowBound = 0;
        charUpBound = 255;
        charCache = new Character[charUpBound - charLowBound + 1];
        byteLowBound = -128;
        byteUpBound = 127;
        byteCache = new Byte[byteUpBound - byteLowBound + 1];
        shortLowBound = -128;
        shortUpBound = 127;
        shortCache = new Short[shortUpBound - shortLowBound + 1];
        intLowBound = -128;
        intUpBound = 1024;
        intCache = new Integer[intUpBound - intLowBound + 1];
        longLowBound = -128;
        longUpBound = 1024;
        longCache = new Long[longUpBound - longLowBound + 1];
        for (n = 0; n <= charUpBound - charLowBound; ++n) {
            BoxesRunTime.charCache[n] = new Character((char)(n + charLowBound));
        }
        for (n = 0; n <= byteUpBound - byteLowBound; ++n) {
            BoxesRunTime.byteCache[n] = new Byte((byte)(n + byteLowBound));
        }
        for (n = 0; n <= shortUpBound - shortLowBound; ++n) {
            BoxesRunTime.shortCache[n] = new Short((short)(n + shortLowBound));
        }
        for (n = 0; n <= intUpBound - intLowBound; ++n) {
            BoxesRunTime.intCache[n] = new Integer(n + intLowBound);
        }
        for (n = 0; n <= longUpBound - longLowBound; ++n) {
            BoxesRunTime.longCache[n] = new Long(n + longLowBound);
        }
    }
}

