/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.ivy.Ivy;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.HttpClientHandler$1;
import org.apache.ivy.util.url.HttpClientHandler$HttpClientHelper;
import org.apache.ivy.util.url.HttpClientHandler$HttpClientHelper2x;
import org.apache.ivy.util.url.HttpClientHandler$HttpClientHelper3x;
import org.apache.ivy.util.url.HttpClientHandler$IvyCredentialsProvider;
import org.apache.ivy.util.url.URLHandler$URLInfo;

public class HttpClientHandler
extends AbstractURLHandler {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private int proxyPort;
    private String proxyHost = null;
    private String proxyUserName = null;
    private String proxyPasswd = null;
    private HttpClientHandler$HttpClientHelper httpClientHelper;
    private static HttpClient httpClient;
    private static Class class$org$apache$commons$httpclient$HttpMethodBase;

    public HttpClientHandler() {
        HttpClientHandler httpClientHandler = this;
        this.proxyHost = System.getProperty("http.proxyHost");
        if (httpClientHandler.useProxy()) {
            httpClientHandler.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            httpClientHandler.proxyUserName = System.getProperty("http.proxyUser");
            httpClientHandler.proxyPasswd = System.getProperty("http.proxyPassword");
            Message.verbose("proxy configured: host=" + httpClientHandler.proxyHost + " port=" + httpClientHandler.proxyPort + " user=" + httpClientHandler.proxyUserName);
            return;
        }
        Message.verbose("no proxy configured");
    }

    public final InputStream openStream(URL uRL) {
        GetMethod getMethod = this.doGet(uRL, 0);
        if (!HttpClientHandler.checkStatusCode(uRL, (HttpMethodBase)getMethod)) {
            getMethod.releaseConnection();
            throw new IOException("The HTTP response code for " + uRL + " did not indicate a success." + " See log for more detail.");
        }
        Header header = getMethod.getResponseHeader("Content-Encoding");
        return HttpClientHandler.getDecodingInputStream(header == null ? null : header.getValue(), getMethod.getResponseBodyAsStream());
    }

    public final void download(URL uRL, File file2, CopyProgressListener copyProgressListener) {
        GetMethod getMethod = this.doGet(uRL, 0);
        try {
            if (!HttpClientHandler.checkStatusCode(uRL, (HttpMethodBase)getMethod)) {
                throw new IOException("The HTTP response code for " + uRL + " did not indicate a success." + " See log for more detail.");
            }
            Header header = getMethod.getResponseHeader("Content-Encoding");
            FileUtil.copy(HttpClientHandler.getDecodingInputStream(header == null ? null : header.getValue(), getMethod.getResponseBodyAsStream()), file2, copyProgressListener);
            file2.setLastModified(HttpClientHandler.getLastModified((HttpMethodBase)getMethod));
            return;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public final URLHandler$URLInfo getURLInfo(URL uRL) {
        return this.getURLInfo$57a0216e(uRL);
    }

    private URLHandler$URLInfo getURLInfo$57a0216e(URL uRL) {
        GetMethod getMethod = null;
        try {
            URL uRL2;
            if (HttpClientHandler.getRequestMethod() == 2) {
                uRL2 = uRL;
                HttpClientHandler httpClientHandler = this;
                HttpClient httpClient = httpClientHandler.getClient$7afc3ea1();
                httpClient.setTimeout(0);
                HeadMethod headMethod = new HeadMethod(HttpClientHandler.normalizeToString(uRL2));
                headMethod.setDoAuthentication(CredentialsStore.hasCredentials(uRL2.getHost()) || httpClientHandler.useProxyAuthentication());
                httpClient.executeMethod((HttpMethod)headMethod);
                getMethod = headMethod;
            } else {
                getMethod = this.doGet(uRL, 0);
            }
            if (HttpClientHandler.checkStatusCode(uRL, (HttpMethodBase)getMethod)) {
                uRL2 = getMethod;
                URLHandler$URLInfo uRLHandler$URLInfo = new URLHandler$URLInfo(true, this.getHttpClientHelper().getResponseContentLength((HttpMethodBase)uRL2), HttpClientHandler.getLastModified((HttpMethodBase)getMethod));
                return uRLHandler$URLInfo;
            }
        }
        catch (HttpException httpException) {
            Message.error("HttpClientHandler: " + httpException.getMessage() + ":" + httpException.getReasonCode() + "=" + httpException.getReason() + " url=" + uRL);
        }
        catch (UnknownHostException unknownHostException) {
            Message.warn("Host " + unknownHostException.getMessage() + " not found. url=" + uRL);
            Message.info("You probably access the destination server through a proxy server that is not well configured.");
        }
        catch (IOException iOException) {
            Message.error("HttpClientHandler: " + iOException.getMessage() + " url=" + uRL);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return UNAVAILABLE;
    }

    private static boolean checkStatusCode(URL uRL, HttpMethodBase httpMethodBase) {
        int n = httpMethodBase.getStatusCode();
        if (n == 200) {
            return true;
        }
        Message.debug("HTTP response status: " + n + " url=" + uRL);
        if (n == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(n).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + httpMethodBase.getStatusText() + " url=" + uRL);
        } else if (String.valueOf(n).startsWith("5")) {
            Message.error("SERVER ERROR: " + httpMethodBase.getStatusText() + " url=" + uRL);
        }
        return false;
    }

    private static long getLastModified(HttpMethodBase httpMethodBase) {
        Header header = httpMethodBase.getResponseHeader("last-modified");
        if (header != null) {
            String string = header.getValue();
            try {
                return LAST_MODIFIED_FORMAT.parse(string).getTime();
            }
            catch (ParseException parseException) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    private HttpClientHandler$HttpClientHelper getHttpClientHelper() {
        if (this.httpClientHelper == null) {
            try {
                (class$org$apache$commons$httpclient$HttpMethodBase == null ? (class$org$apache$commons$httpclient$HttpMethodBase = HttpClientHandler.class$("org.apache.commons.httpclient.HttpMethodBase")) : class$org$apache$commons$httpclient$HttpMethodBase).getMethod("getResponseContentLength", new Class[0]);
                this.httpClientHelper = new HttpClientHandler$HttpClientHelper3x();
                Message.verbose("using commons httpclient 3.x helper");
            }
            catch (SecurityException securityException) {
                Message.verbose("unable to get access to getResponseContentLength of commons-httpclient HeadMethod. Please use commons-httpclient 3.0 or use ivy with sufficient security permissions.");
                Message.verbose("exception: " + securityException.getMessage());
                this.httpClientHelper = new HttpClientHandler$HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.httpClientHelper = new HttpClientHandler$HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
        }
        return this.httpClientHelper;
    }

    private GetMethod doGet(URL uRL, int n) {
        HttpClient httpClient = this.getClient$7afc3ea1();
        httpClient.setTimeout(0);
        GetMethod getMethod = new GetMethod(HttpClientHandler.normalizeToString(uRL));
        getMethod.setDoAuthentication(CredentialsStore.hasCredentials(uRL.getHost()) || this.useProxyAuthentication());
        getMethod.setRequestHeader("Accept-Encoding", "gzip,deflate");
        httpClient.executeMethod((HttpMethod)getMethod);
        return getMethod;
    }

    private HttpClient getClient$7afc3ea1() {
        if (httpClient == null) {
            MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
            Runtime.getRuntime().addShutdownHook(new Thread(new HttpClientHandler$1(multiThreadedHttpConnectionManager)));
            ArrayList<String> arrayList = new ArrayList<String>(3);
            arrayList.add("Digest");
            arrayList.add("Basic");
            arrayList.add("NTLM");
            httpClient.getParams().setParameter("http.auth.scheme-priority", arrayList);
            if (this.useProxy()) {
                httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
                if (this.useProxyAuthentication()) {
                    String string;
                    String string2;
                    HttpState httpState = httpClient.getState();
                    AuthScope authScope = new AuthScope(this.proxyHost, this.proxyPort, AuthScope.ANY_REALM);
                    String string3 = this.proxyPasswd;
                    String string4 = this.proxyUserName;
                    int n = string4.indexOf(92);
                    if (n >= 0) {
                        string2 = string4.substring(n + 1);
                        string = string4.substring(0, n);
                    } else {
                        string2 = string4;
                        string = System.getProperty("http.auth.ntlm.domain", "");
                    }
                    httpState.setProxyCredentials(authScope, (Credentials)new NTCredentials(string2, string3, HostUtil.getLocalHostName(), string));
                }
            }
            httpClient.getParams().setParameter("http.useragent", (Object)("Apache Ivy/" + Ivy.getIvyVersion()));
            httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)new HttpClientHandler$IvyCredentialsProvider());
        }
        return httpClient;
    }

    private boolean useProxy() {
        return this.proxyHost != null && this.proxyHost.trim().length() > 0;
    }

    private boolean useProxyAuthentication() {
        return this.proxyUserName != null && this.proxyUserName.trim().length() > 0;
    }

    private static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

