/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jline.SimpleCompletor;

public class ClassNameCompletor
extends SimpleCompletor {
    static /* synthetic */ Class class$jline$ClassNameCompletor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ClassNameCompletor() throws IOException {
        this((SimpleCompletor.SimpleCompletorFilter)null);
    }

    public ClassNameCompletor(SimpleCompletor.SimpleCompletorFilter filter) throws IOException {
        super(ClassNameCompletor.getClassNames(), filter);
        this.setDelimiter(".");
    }

    public static String[] getClassNames() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = (class$jline$ClassNameCompletor == null ? (class$jline$ClassNameCompletor = ClassNameCompletor.class$("jline.ClassNameCompletor")) : class$jline$ClassNameCompletor).getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
        }
        Class[] systemClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClassNameCompletor.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ClassNameCompletor.class$("javax.swing.JFrame")) : class$javax$swing$JFrame};
        for (int i = 0; i < systemClasses.length; ++i) {
            URLConnection uc;
            URL classURL = systemClasses[i].getResource("/" + systemClasses[i].getName().replace('.', '/') + ".class");
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes = new HashSet<String>();
        Iterator i = urls.iterator();
        while (i.hasNext()) {
            URL url = (URL)i.next();
            File file2 = new File(url.getFile());
            if (file2.isDirectory()) {
                Set files = ClassNameCompletor.getClassFiles(file2.getAbsolutePath(), new HashSet(), file2, new int[]{200});
                classes.addAll(files);
                continue;
            }
            if (file2 == null || !file2.isFile()) continue;
            JarFile jf = new JarFile(file2);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String name;
                JarEntry entry = e.nextElement();
                if (entry == null || !(name = entry.getName()).endsWith(".class")) continue;
                classes.add(name);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        Iterator i2 = classes.iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            classNames.add(name.replace('/', '.').substring(0, name.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Set getClassFiles(String root, Set holder, File directory, int[] maxDirectories) {
        int n = maxDirectories[0];
        maxDirectories[0] = n - 1;
        if (n < 0) {
            return holder;
        }
        File[] files = directory.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String name = files[i].getAbsolutePath();
            if (!name.startsWith(root)) continue;
            if (files[i].isDirectory()) {
                ClassNameCompletor.getClassFiles(root, holder, files[i], maxDirectories);
                continue;
            }
            if (!files[i].getName().endsWith(".class")) continue;
            holder.add(files[i].getAbsolutePath().substring(root.length() + 1));
        }
        return holder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

