/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ArgDefAware;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerNotRegisteredRuntimeException;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.servlet.SingletonS2ContainerInitializer;
import org.seasar.framework.container.util.SmartDeployUtil;
import org.seasar.framework.env.Env;
import org.seasar.framework.util.DriverManagerUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;

public class S2ContainerServlet
extends HttpServlet {
    private static final long serialVersionUID = 407266935204779128L;
    public static final String CONFIG_PATH_KEY = "configPath";
    public static final String DEBUG_KEY = "debug";
    public static final String COMMAND = "command";
    public static final String RESTART = "restart";
    public static final String LIST = "list";
    public static final String PATH = "path";
    private static final String MODE_BEGIN = "<strong><font color='#DC143C'>";
    private static final String MODE_END = "</font></strong>";
    private static S2ContainerServlet instance;
    private boolean debug;

    public S2ContainerServlet() {
        instance = this;
    }

    public static S2ContainerServlet getInstance() {
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public void init() {
        String configPath = null;
        String debugStr = null;
        ServletConfig servletConfig = this.getServletConfig();
        if (servletConfig != null) {
            configPath = servletConfig.getInitParameter(CONFIG_PATH_KEY);
            debugStr = servletConfig.getInitParameter(DEBUG_KEY);
        }
        if (!StringUtil.isEmpty(debugStr)) {
            this.debug = Boolean.valueOf(debugStr);
        }
        this.initializeContainer(configPath);
    }

    protected void initializeContainer(String configPath) {
        SingletonS2ContainerInitializer initializer = new SingletonS2ContainerInitializer();
        initializer.setConfigPath(configPath);
        initializer.setApplication(this.getServletContext());
        initializer.initialize();
    }

    public void destroy() {
        SingletonS2ContainerFactory.destroy();
        DriverManagerUtil.deregisterAllDrivers();
        try {
            Class<?> clazz = Class.forName("org.seasar.extension.timer.TimeoutManager");
            Method getInstance = clazz.getMethod("getInstance", null);
            Object instance = getInstance.invoke(null, null);
            Method stop = clazz.getMethod("stop", Long.TYPE);
            stop.invoke(instance, new Integer(1000));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getParameter(COMMAND);
        if (this.debug && command != null && RESTART.equalsIgnoreCase(command)) {
            this.destroy();
            this.init();
            response.setContentType("text/plain; charset=UTF-8");
            response.getWriter().write("S2ContainerServlet is restarted.");
        } else if (this.debug && LIST.equalsIgnoreCase(command)) {
            response.setContentType("text/html; charset=UTF-8");
            this.list(request, response);
        } else {
            response.setContentType("text/plain; charset=UTF-8");
            response.getWriter().write("S2ContainerServlet is running.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void list(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String path = request.getParameter(PATH);
        S2Container container = this.getContainer(path);
        if (container == null) {
            out.write("S2Container[" + this.escape(path) + "] is not found.");
            return;
        }
        out.write("<html><head><title>Seasar2 Component List</title></head><body>");
        try {
            out.write("<h1>S2Container</h1>");
            this.printSmartDeploy(container, out);
            out.write("<ul>");
            try {
                String envValue;
                out.write("<li>path : <code>" + this.escape(container.getPath()) + "</code></li>");
                String nameSpace = container.getNamespace();
                if (!StringUtil.isEmpty(nameSpace)) {
                    out.write("<li>namespace : <code>" + this.escape(nameSpace) + "</code></li>");
                }
                if (!StringUtil.isEmpty(envValue = Env.getValue())) {
                    out.write("<li>env : <code>" + this.escape(envValue) + "</code></li>");
                }
            }
            finally {
                out.write("</ul>");
            }
            this.listInclude(container, request, out);
            this.listComponent(container, out);
        }
        finally {
            out.write("</body></html>");
        }
    }

    protected S2Container getContainer(String path) {
        S2Container root = SingletonS2ContainerFactory.getContainer();
        try {
            return StringUtil.isEmpty(path) ? root : root.getDescendant(path);
        }
        catch (ContainerNotRegisteredRuntimeException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSmartDeploy(S2Container container, PrintWriter out) {
        out.write("<p>S2Container is working under ");
        try {
            if (SmartDeployUtil.isHotdeployMode(container)) {
                out.write("<strong><font color='#DC143C'>HOT deploy</font></strong>");
            } else if (SmartDeployUtil.isWarmdeployMode(container)) {
                out.write("<strong><font color='#DC143C'>WARM deploy</font></strong>");
            } else if (SmartDeployUtil.isCooldeployMode(container)) {
                out.write("<strong><font color='#DC143C'>COOL deploy</font></strong>");
            } else {
                out.write("normal");
            }
        }
        finally {
            out.write(" mode.</p>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listInclude(S2Container container, HttpServletRequest request, PrintWriter out) throws IOException {
        if (container.getChildSize() == 0) {
            return;
        }
        out.write("<h2>Includes</h2>");
        out.write("<p><ul>");
        try {
            String requestUri = request.getRequestURI();
            String queryString = "?command=list&path=";
            for (int i = 0; i < container.getChildSize(); ++i) {
                S2Container child = container.getChild(i);
                String path = child.getPath();
                out.write("<li><a href='" + requestUri + "?command=list&path=" + URLUtil.encode(path, "UTF-8") + "'><code>" + path + "</code></a></li>");
            }
        }
        finally {
            out.write("</ul></p>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listComponent(S2Container container, PrintWriter out) throws IOException {
        if (container.getComponentDefSize() == 0) {
            return;
        }
        out.write("<h2>Components</h2>");
        out.write("<p><ul>");
        try {
            for (int i = 0; i < container.getComponentDefSize(); ++i) {
                ComponentDef cd = container.getComponentDef(i);
                this.printComponent(cd, out);
            }
        }
        finally {
            out.write("</ul></p>");
        }
    }

    private void printComponent(ComponentDef cd, PrintWriter out) throws IOException {
        String expr;
        String name = cd.getComponentName();
        Class clazz = cd.getComponentClass();
        out.write("<li style='list-style-type: square'><code><strong>" + (name != null ? this.escape(name) : "-") + " [" + (clazz != null ? this.escape(clazz.getName()) : "-") + "]</strong></code>");
        out.write("<ul>");
        out.write("<li style='list-style-type: circle'>instance : <code>" + this.escape(cd.getInstanceDef().getName()) + "</code></li>");
        out.write("<li style='list-style-type: circle'>autoBinding : <code>" + this.escape(cd.getAutoBindingDef().getName()) + "</code></li>");
        Expression expression = cd.getExpression();
        String string = expr = expression != null ? expression.toString() : "";
        if (!StringUtil.isEmpty(expr)) {
            out.write("<li style='list-style-type: circle'>ognl : <code>" + this.escape(expr) + "</code></li>");
        }
        this.printArg(cd, out);
        this.printAspect(cd, out);
        this.printProperty(cd, out);
        this.printInitMethod(cd, out);
        this.printDestroyMethod(cd, out);
        try {
            Object component = cd.getComponent();
            out.write("<li style='list-style-type: circle'>toString : <pre style='border-style: solid; border-width: 1'>" + this.escape(component.toString()) + "</pre></li>");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        out.write("</ul>");
    }

    private void printArg(ArgDefAware cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getArgDefSize(); ++i) {
            ComponentDef child;
            String expr;
            out.write("<li style='list-style-type: circle'>arg<ul>");
            ArgDef ad = cd.getArgDef(i);
            Expression expression = ad.getExpression();
            String string = expr = expression != null ? expression.toString() : "";
            if (!StringUtil.isEmpty(expr)) {
                out.write("<li style='list-style-type: circle'>ognl : <code>" + this.escape(expr) + "</code></li>");
            }
            if ((child = this.getChildComponentDef(ad)) != null) {
                this.printComponent(child, out);
            }
            out.write("</ul></li>");
        }
    }

    private void printAspect(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getAspectDefSize(); ++i) {
            ComponentDef child;
            Expression expression;
            String expr;
            String[] pointCuts;
            out.write("<li style='list-style-type: circle'>aspect<ul>");
            AspectDef ad = cd.getAspectDef(i);
            PointcutImpl pc = (PointcutImpl)ad.getPointcut();
            if (pc != null && (pointCuts = pc.getMethodNames()) != null && pointCuts.length > 0) {
                out.write("<li style='list-style-type: circle'>pointcut<ul>");
                for (int j = 0; j < pointCuts.length; ++j) {
                    out.write("<li style='list-style-type: circle'><code>" + this.escape(pointCuts[j]) + "</code></li>");
                }
                out.write("</ul></li>");
            }
            String string = expr = (expression = ad.getExpression()) != null ? expression.toString() : "";
            if (!StringUtil.isEmpty(expr)) {
                out.write("<li style='list-style-type: circle'>ognl : <code>" + this.escape(expr) + "</code></li>");
            }
            if ((child = this.getChildComponentDef(ad)) != null) {
                this.printComponent(child, out);
            }
            out.write("</ul></li>");
        }
    }

    private void printProperty(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getPropertyDefSize(); ++i) {
            ComponentDef child;
            String expr;
            out.write("<li style='list-style-type: circle'>property<ul>");
            PropertyDef pd = cd.getPropertyDef(i);
            out.write("<li style='list-style-type: circle'>name : <code>" + this.escape(pd.getPropertyName()) + "</code></li>");
            Expression expression = pd.getExpression();
            String string = expr = expression != null ? expression.toString() : "";
            if (!StringUtil.isEmpty(expr)) {
                out.write("<li style='list-style-type: circle'>ognl : <code>" + this.escape(expr) + "</code></li>");
            }
            if ((child = this.getChildComponentDef(pd)) != null) {
                this.printComponent(child, out);
            }
            out.write("</ul></li>");
        }
    }

    private void printInitMethod(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getInitMethodDefSize(); ++i) {
            out.write("<li style='list-style-type: circle'>initMethod<ul>");
            this.printMethod(cd.getInitMethodDef(i), out);
            out.write("</ul></li>");
        }
    }

    private void printDestroyMethod(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getDestroyMethodDefSize(); ++i) {
            out.write("<li style='list-style-type: circle'>destroyMethod<ul>");
            this.printMethod(cd.getDestroyMethodDef(i), out);
            out.write("</ul></li>");
        }
    }

    private void printMethod(MethodDef md, PrintWriter out) throws IOException {
        ComponentDef child;
        String expr;
        out.write("<li style='list-style-type: circle'>name : <code>" + this.escape(md.getMethodName()) + "</code></li>");
        Expression expression = md.getExpression();
        String string = expr = expression != null ? expression.toString() : "";
        if (!StringUtil.isEmpty(expr)) {
            out.write("<li style='list-style-type: circle'>ognl : <code>" + this.escape(expr) + "</code></li>");
        }
        if ((child = this.getChildComponentDef(md)) != null) {
            this.printComponent(child, out);
        }
    }

    private ComponentDef getChildComponentDef(Object o) {
        try {
            Field f = ArgDefImpl.class.getDeclaredField("childComponentDef");
            f.setAccessible(true);
            return (ComponentDef)f.get(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String escape(String text) {
        if (text == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer(text.length() * 4);
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return new String(buf);
    }
}

